/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.ManagementScope;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.config.ManagementScopeData;
import java.util.ArrayList;
import javax.management.ObjectName;

public class ManagementScopeHelper {
    private static TraceComponent tc = Tr.register(ManagementScopeHelper.class, "SSL", "com.ibm.ws.ssl.commands.ManagementScope");
    private static String[] outbound_endpoints = new String[]{"IIOP", "HTTP", "SIP", "BUS_CLIENT", "BUS_TO_WEBSPHERE_MQ", "BUS_TO_BUS", "LDAP", "ADMIN_IIOP", "ADMIN_SOAP", "CLIENT_TO_WEBSPHERE_MQ", "ADMIN_IPC"};

    public static boolean validScopeName(Session session, ConfigService cs, String scope) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validScopeName ");
        }
        String fullScope = scope;
        boolean valid = true;
        Object pattern = null;
        ObjectName cell = null;
        String cellName = null;
        ManagementScopeData mgmScopeData = new ManagementScopeData(fullScope);
        String scopeType = mgmScopeData.getScopeType();
        String nodeGroup = mgmScopeData.getNodeGroupName();
        String node = mgmScopeData.getNodeName();
        String server = mgmScopeData.getProcessName();
        String endpoint = mgmScopeData.getEndPointName();
        String cluster = mgmScopeData.getClusterName();
        String scopeCellName = mgmScopeData.getCellName();
        if (mgmScopeData != null) {
            block30: {
                if (scopeType.equalsIgnoreCase("endpoint") && (server == null || node == null)) {
                    valid = false;
                    return valid;
                }
                if (scopeType.equalsIgnoreCase("server") && node == null) {
                    valid = false;
                    return valid;
                }
                try {
                    cell = cs.resolve(session, "Cell=")[0];
                    if (cell != null) {
                        cellName = (String)cs.getAttribute(session, cell, "name");
                    }
                }
                catch (Exception e) {
                    if (!tc.isDebugEnabled()) break block30;
                    Tr.debug(tc, "Exception while getting the cell: " + e.getMessage());
                }
            }
            if (scopeCellName != null) {
                if (cellName.equalsIgnoreCase(scopeCellName)) {
                    if (nodeGroup != null && !ManagementScopeHelper.getScopeData(session, cs, "NodeGroup", nodeGroup)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Not a valid nodegroup name in: " + scope);
                        }
                        valid = false;
                    }
                    if (node != null) {
                        if (!ManagementScopeHelper.getScopeData(session, cs, "Node", node)) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Not a valid node name in: " + scope);
                            }
                            valid = false;
                        } else if (server != null) {
                            if (!ManagementScopeHelper.getServer(session, cs, node, server)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Not a valid server name in: " + scope);
                                }
                                valid = false;
                            } else if (endpoint != null && !ManagementScopeHelper.getEndpoint(session, cs, node, endpoint)) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Not a valid endpoint name in: " + scope);
                                }
                                valid = false;
                            }
                        }
                    }
                    if (cluster != null && !ManagementScopeHelper.getScopeData(session, cs, "ServerCluster", cluster)) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Not a valid cluster name in: " + scope);
                        }
                        valid = false;
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not a valid cell name in: " + scope);
                    }
                    valid = false;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No cell in scope: " + scope);
                }
                valid = false;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not a valid scope format in " + scope);
            }
            valid = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validScopeName");
        }
        return valid;
    }

    private static boolean getScopeData(Session session, ConfigService cs, String name, String value) {
        boolean found;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getScopeData ");
            }
            found = false;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name :" + name + " and value:" + value);
            }
            ObjectName[] scopeData = null;
            try {
                scopeData = cs.resolve(session, name + "=" + value);
                if (scopeData[0] != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ScopeData is : " + scopeData[0]);
                    }
                    found = true;
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ScopeData is not found.");
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, value + " for " + name + " was not found");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getScopeData");
        }
        return found;
    }

    private static boolean getServer(Session session, ConfigService cs, String nodeName, String server) {
        boolean found;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getServer ");
            }
            ObjectName node = null;
            found = false;
            try {
                ObjectName[] match = cs.resolve(session, "Node=" + nodeName);
                node = match[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "node", node);
                }
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, "Server");
                ObjectName[] servers = cs.queryConfigObjects(session, node, pattern, null);
                for (int i = 0; i < servers.length; ++i) {
                    String serverName = (String)cs.getAttribute(session, servers[i], "name");
                    if (!serverName.equalsIgnoreCase(server)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "serverName: " + server + " found.");
                    }
                    found = true;
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug(tc, "Exception in getServer: " + e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getServer");
        }
        return found;
    }

    private static boolean getEndpoint(Session session, ConfigService cs, String nodeName, String ep) {
        boolean found;
        block13: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getEndpoint ");
            }
            ObjectName node = null;
            found = false;
            try {
                int i;
                ObjectName[] match = cs.resolve(session, "Node=" + nodeName);
                node = match[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "node", node);
                }
                ObjectName[] serverEntry = cs.queryConfigObjects(session, node, ConfigServiceHelper.createObjectName(null, "ServerEntry"), null);
                for (i = 0; i < serverEntry.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ServerEntry", serverEntry[i]);
                    }
                    ArrayList endPoint = (ArrayList)cs.getAttribute(session, serverEntry[i], "specialEndpoints", false);
                    for (int j = 0; j < endPoint.size(); ++j) {
                        ObjectName specialEndPoint = (ObjectName)endPoint.get(j);
                        String endPointName = (String)cs.getAttribute(session, specialEndPoint, "endPointName");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "EndPoint is", endPointName);
                        }
                        if (!endPointName.equalsIgnoreCase(ep)) continue;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getEndpoint");
                        }
                        found = true;
                        return found;
                    }
                }
                if (!found) {
                    for (i = 0; i < outbound_endpoints.length; ++i) {
                        if (!outbound_endpoints[i].equalsIgnoreCase(ep)) continue;
                        if (tc.isEntryEnabled()) {
                            Tr.exit(tc, "getEndpoint");
                        }
                        found = true;
                        return found;
                    }
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "Exception in getEndpoint: " + e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEndpoint");
        }
        return found;
    }

    public static boolean checkScopeType(String scopeType) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkScopeType ");
        }
        if (scopeType.equalsIgnoreCase("Cell") || scopeType.equalsIgnoreCase("Server") || scopeType.equalsIgnoreCase("NodeGroup") || scopeType.equalsIgnoreCase("Cluster") || scopeType.equalsIgnoreCase("Node") || scopeType.equalsIgnoreCase("EndPoint")) {
            return true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkScopeType");
        }
        return false;
    }
}

