/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.ManagementScope;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.ManagementScopeData;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateManagementScope
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateManagementScope.class, "SSL", "com.ibm.ws.ssl.commands");
    private String scopeName = null;
    private String scopeType = null;

    public CreateManagementScope(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateManagementScope(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            ManagementScopeData scopeData;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            this.scopeType = (String)this.getParameter(CommandConstants.SCOPE_TYPE);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scopeName: " + this.scopeName);
                Tr.debug(tc, "scopeType: " + this.scopeType);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Use default cell scopeName: " + this.scopeName);
                }
            } else if (!ManagementScopeHelper.validScopeName(session, cs, this.scopeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                }
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                throw new CommandValidationException(msg);
            }
            if (this.scopeType == null) {
                scopeData = new ManagementScopeData(this.scopeName);
                this.scopeType = scopeData.getScopeType();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Use default cell scopeType: " + this.scopeType);
                }
            } else {
                if (!ManagementScopeHelper.checkScopeType(this.scopeType)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not a valid management scope type: " + this.scopeType);
                    }
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.ManagementScope.type.not.valid.CWPKI0607E", new Object[]{this.scopeType}, "The following management scope type is not valid: " + this.scopeName);
                    throw new CommandValidationException(msg);
                }
                scopeData = new ManagementScopeData(this.scopeName);
                String typeFromScopeName = scopeData.getScopeType();
                if (!this.scopeType.equalsIgnoreCase(typeFromScopeName)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not a valid management scope type: " + this.scopeType);
                    }
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.MangementScope.not.type.CWPKI0608E", new Object[]{this.scopeName, this.scopeType}, "The following management scope type is not valid: " + this.scopeName);
                    throw new CommandValidationException(msg);
                }
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.SCOPE_NAME, this.scopeName);
            boolean scopeNameFound = commandHelper.exists(cs, session, security2, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
            if (scopeNameFound) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.ManagementScope.already.exists.CWPKI0609E", new Object[]{this.scopeName}, "Management scope " + this.scopeName + " already exists.");
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.createManagementScope.validate", "144", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            AttributeList attrList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SCOPE_NAME, this.scopeName);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SCOPE_TYPE, this.scopeType);
            ObjectName managementScope = cs.createConfigData(session, security2, CommandConstants.MANAGEMENT_SCOPES, null, attrList);
            if (managementScope != null) {
                result.setResult(managementScope);
            }
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

