/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.KeySetGroup;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ModifyKeySetGroup
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ModifyKeySetGroup.class, "ModifyKeySetGroup", "com.ibm.ws.ssl.commands");
    private String keySetGroupName = null;
    private Boolean autoGenerate = null;
    private String keySetObjNames = null;
    private String wsScheduleName = null;
    private String scopeName = null;
    private ObjectName keySetGroupObjName = null;
    private List keySetObjNameList = null;
    private ObjectName wsScheduleObjName = null;
    private ObjectName scopeObjName = null;

    public ModifyKeySetGroup(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ModifyKeySetGroup(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.keySetGroupName = (String)this.getParameter(CommandConstants.NAME);
            this.autoGenerate = (Boolean)this.getParameter(CommandConstants.AUTO_GENERATE);
            this.wsScheduleName = (String)this.getParameter(CommandConstants.WS_SCHEDULE_NAME);
            this.keySetObjNames = (String)this.getParameter(CommandConstants.KEY_SET_OBJECT_NAMES);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "name: " + this.keySetGroupName);
                Tr.debug(tc, "autoGenerate: " + (this.autoGenerate == null ? "null" : this.autoGenerate.toString()));
                Tr.debug(tc, "wsScheduleName: " + this.wsScheduleName);
                Tr.debug(tc, "keySetObjNames: " + this.keySetObjNames);
                Tr.debug(tc, "scopeName: " + this.scopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keySetGroupName);
            this.keySetGroupObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_SET_GROUPS, queryAttrs, this.scopeName);
            queryAttrs.clear();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.SCOPE_NAME, this.scopeName);
            this.scopeObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
            if (this.wsScheduleName != null) {
                queryAttrs.clear();
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.wsScheduleName);
                this.wsScheduleObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.WS_SCHEDULES, queryAttrs, null);
            }
            if (this.keySetObjNames != null) {
                String[] keySets = this.keySetObjNames.split(":");
                this.keySetObjNameList = new ArrayList();
                for (int i = 0; i < keySets.length; ++i) {
                    ObjectName keySetObjName;
                    if (keySets[i] == null) continue;
                    String id = keySets[i];
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "keySets[i]: " + keySets[i]);
                    }
                    if (keySets[i].indexOf("(") != -1 && keySets[i].indexOf(")") != -1) {
                        id = keySets[i].substring(keySets[i].indexOf("(") + 1, keySets[i].indexOf(")"));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "id: " + id);
                        }
                    }
                    if ((keySetObjName = commandHelper.getObjectWithinScope(cs, session, "KeySet", id, this.scopeName)) == null) continue;
                    this.keySetObjNameList.add(keySetObjName);
                }
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.modifyKeySetGroup.validate", "207", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            AttributeList attrList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.NAME, this.keySetGroupName);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName);
            if (this.autoGenerate != null) {
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.AUTO_GENERATE, this.autoGenerate);
            }
            if (this.wsScheduleObjName != null) {
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.WS_SCHEDULE, this.wsScheduleObjName);
            }
            if (this.keySetObjNameList != null) {
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.KEY_SET, this.keySetObjNameList);
            }
            cs.setAttributes(session, this.keySetGroupObjName, attrList);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

