/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.KeySet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.crypto.KeyPair;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.websphere.models.config.ipc.ssl.KeySet;
import com.ibm.ws.crypto.config.KeyReference;
import com.ibm.ws.crypto.config.WSKeyPairReference;
import com.ibm.ws.crypto.config.WSKeyReference;
import com.ibm.ws.crypto.config.WSKeySet;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.WSKeyStoreRemotable;
import java.io.Serializable;
import java.security.Key;
import java.util.HashMap;
import java.util.List;
import java.util.TreeSet;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class GenerateKeyForKeySet
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(GenerateKeyForKeySet.class, "SSL", "com.ibm.ws.ssl.commands");
    private String keySetName = null;
    private String scopeName = null;
    private Boolean saveConfig = Boolean.FALSE;
    ObjectName keySetObjName = null;
    KeySet keySet = null;
    WSKeySet wsKeySet = null;

    public GenerateKeyForKeySet(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public GenerateKeyForKeySet(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.keySetName = (String)this.getParameter(CommandConstants.KEY_SET_NAME);
            this.scopeName = (String)this.getParameter(CommandConstants.KEY_SET_SCOPE);
            this.saveConfig = (Boolean)this.getParameter(CommandConstants.KEY_SET_SAVE_CONFIG);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keySetName: " + this.keySetName);
                Tr.debug(tc, "scopeName: " + this.scopeName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Default cell scopeName: " + this.scopeName);
                }
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keySetName);
            this.keySetObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_SETS, queryAttrs, this.scopeName);
            if (this.keySetObjName == null) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.not.found.CWPKI0600E", new Object[]{this.keySetName, this.scopeName}, this.keySetName + " does not exist within management scope " + this.scopeName);
                throw new CommandValidationException(msg);
            }
            this.keySet = (KeySet)MOFUtil.convertToEObject((Session)session, (ObjectName)this.keySetObjName);
            this.wsKeySet = new WSKeySet(this.keySet, session);
            String keyGenerationClass = this.keySet.getKeyGenerationClass();
            if (keyGenerationClass == null) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.generate.key.class.CWPKI0635E", "Cannot generate keys since the key generator class is not configured.");
                throw new CommandValidationException(msg);
            }
            boolean keyStoreIsReadOnly = this.keySet.getKeyStore().isReadOnly();
            if (keyStoreIsReadOnly) {
                String msg = "Cannot generate keys since KeyStore \"" + this.keySet.getKeyStore().getName() + "\" is marked read-only.";
                throw new CommandValidationException(msg);
            }
            queryAttrs.clear();
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.getKeySet.validate", "132");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration:", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        CommandHelper commandHelper = new CommandHelper();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            String aliasPrefix = this.wsKeySet.getAliasPrefix();
            int maxKeyReferences = this.wsKeySet.getMaxKeyReferences();
            boolean deleteOldKeys = this.wsKeySet.getDeleteOldKeys();
            int current_version = 0;
            int next_version = 0;
            KeyReference latestKeyReference = this.wsKeySet.getLatestKeyReference();
            if (latestKeyReference != null) {
                current_version = latestKeyReference.getVersion();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Current key version: " + current_version);
                }
                next_version = ++current_version;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Next key version: " + next_version);
                }
            } else {
                next_version = 1;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Next key version: " + next_version);
                }
            }
            TreeSet keyRefSet = this.wsKeySet.getKeyReferenceTreeSet();
            int total_keys = keyRefSet.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Total keys: " + total_keys);
            }
            while (total_keys >= maxKeyReferences) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Total keys > max keys.");
                }
                KeyReference oldestKeyReference = this.wsKeySet.getOldestKeyReference();
                String oldestAlias = oldestKeyReference.getKeyAlias();
                int oldestVersion = oldestKeyReference.getVersion();
                List keyReferences = (List)cs.getAttribute(session, this.keySetObjName, CommandConstants.KEY_REFERENCE);
                for (AttributeList keyReference : keyReferences) {
                    WSKeyStoreRemotable wksr;
                    Integer versionInt = (Integer)ConfigServiceHelper.getAttributeValue(keyReference, CommandConstants.VERSION);
                    if (versionInt != oldestVersion) continue;
                    AttributeList queryAttrs = new AttributeList();
                    ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.KEY_ALIAS, oldestAlias);
                    ObjectName keyReferenceObjName = commandHelper.getObjectName(cs, session, this.keySetObjName, CommandConstants.KEY_REFERENCE, queryAttrs, null);
                    if (keyReferenceObjName == null) break;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Deleting KeyReference for version " + versionInt);
                    }
                    cs.deleteConfigData(session, keyReferenceObjName);
                    if (!deleteOldKeys) break;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Deleting keys from KeyStore.");
                    }
                    if ((wksr = new WSKeyStoreRemotable(this.wsKeySet.getWSKeyStore())) != null && !this.wsKeySet.getIsKeyPair()) {
                        String method2 = "deleteEntry";
                        Object[] parms = new Object[]{oldestAlias};
                        wksr.invokeKeyStoreCommand(method2, parms);
                        break;
                    }
                    if (wksr == null) break;
                    boolean removed = false;
                    String method3 = "containsAlias";
                    Object[] parms = new Object[]{oldestAlias + "_public"};
                    Object[] exists = wksr.invokeKeyStoreCommand(method3, parms);
                    if (((Boolean)exists[0]).booleanValue()) {
                        method3 = "deleteEntry";
                        parms = new Object[]{oldestAlias + "_public"};
                        wksr.invokeKeyStoreCommand(method3, parms);
                        removed = true;
                    }
                    if (((Boolean)(exists = wksr.invokeKeyStoreCommand(method3 = "containsAlias", parms = new Object[]{oldestAlias + "_private"}))[0]).booleanValue()) {
                        method3 = "deleteEntry";
                        parms = new Object[]{oldestAlias + "_private"};
                        wksr.invokeKeyStoreCommand(method3, parms);
                        removed = true;
                    }
                    if (removed || !((Boolean)(exists = wksr.invokeKeyStoreCommand(method3 = "containsAlias", parms = new Object[]{oldestAlias}))[0]).booleanValue()) break;
                    method3 = "deleteEntry";
                    parms = new Object[]{oldestAlias};
                    wksr.invokeKeyStoreCommand(method3, parms);
                    removed = true;
                    break;
                }
                this.wsKeySet.removeOldestReference();
                total_keys = keyRefSet.size();
            }
            AttributeList attrList = new AttributeList();
            String nextAlias = aliasPrefix + "_" + next_version;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Next alias: " + nextAlias);
            }
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.VERSION, new Integer(next_version));
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.KEY_ALIAS, nextAlias);
            ObjectName keyReference = cs.createConfigData(session, this.keySetObjName, CommandConstants.KEY_REFERENCE, null, attrList);
            com.ibm.websphere.models.config.ipc.ssl.KeyReference keyRef = (com.ibm.websphere.models.config.ipc.ssl.KeyReference)MOFUtil.convertToEObject((Session)session, (ObjectName)keyReference);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "KeyReference: " + keyRef);
            }
            KeyReference newReference = null;
            HashMap<String, Serializable> keyResult = new HashMap<String, Serializable>();
            if (this.wsKeySet.getIsKeyPair()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating a KeyPair.");
                }
                newReference = new WSKeyPairReference(keyRef, this.wsKeySet, this.wsKeySet.getWSKeyStore());
                KeyPair keyPair = ((WSKeyPairReference)newReference).getKeyPair();
                keyResult.put(nextAlias, keyPair);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating a Key.");
                }
                newReference = new WSKeyReference(keyRef, this.wsKeySet, this.wsKeySet.getWSKeyStore());
                Key key = ((WSKeyReference)newReference).getKey();
                keyResult.put(nextAlias, key);
            }
            if (this.saveConfig != null && this.saveConfig.booleanValue()) {
                cs.save(session, true);
            }
            result.setResult(keyResult);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.GenerateKeyForKeySet.beforeStepsExecuted", "379", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception occurred.", new Object[]{e});
            }
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

