/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.KeySet;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.ManagementScopeData;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateKeySet
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateKeySet.class, "SSL", "com.ibm.ws.ssl.commands.CreateKeySet");
    private String keySetName = null;
    private String aliasPrefix = null;
    private String password = null;
    private Integer maxKeyReferences = null;
    private String keyStoreName = null;
    private String keyStoreScopeName = null;
    private String scopeName = null;
    private Boolean isKeyPair = null;
    private Boolean deleteOldKeys = null;
    private String keyGenerationClass = null;
    private ObjectName keyStoreObjName = null;
    private ObjectName scopeObjName = null;
    private boolean createMgmScope = false;

    public CreateKeySet(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateKeySet(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "validate");
            }
            super.validate();
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName security2 = null;
            try {
                ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
                ObjectName matches = cs.resolve(session, "Cell=")[0];
                if (matches != null) {
                    security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
                }
                this.keySetName = (String)this.getParameter(CommandConstants.NAME);
                this.aliasPrefix = (String)this.getParameter(CommandConstants.ALIAS_PREFIX);
                this.password = (String)this.getParameter(CommandConstants.PASSWORD);
                this.maxKeyReferences = (Integer)this.getParameter(CommandConstants.MAX_KEY_REFERENCES);
                this.deleteOldKeys = (Boolean)this.getParameter(CommandConstants.DELETE_OLD_KEYS);
                this.keyGenerationClass = (String)this.getParameter(CommandConstants.KEY_GENERATION_CLASS);
                this.keyStoreName = (String)this.getParameter(CommandConstants.KEY_STORE_NAME);
                this.keyStoreScopeName = (String)this.getParameter(CommandConstants.KEY_STORE_SCOPE_NAME);
                this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
                this.isKeyPair = (Boolean)this.getParameter(CommandConstants.IS_KEY_PAIR);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "keySetName: " + this.keySetName);
                    Tr.debug(tc, "scopeName: " + this.scopeName);
                    Tr.debug(tc, "aliasPrefix: " + this.aliasPrefix);
                    Tr.debug(tc, "password: " + this.password);
                    Tr.debug(tc, "maxKeyReferences: " + this.maxKeyReferences);
                    Tr.debug(tc, "deleteOldKeys: " + (this.deleteOldKeys == null ? "null" : this.deleteOldKeys.toString()));
                    Tr.debug(tc, "keyGenerationClass: " + this.keyGenerationClass);
                    Tr.debug(tc, "keyStoreName: " + this.keyStoreName);
                    Tr.debug(tc, "keyStoreScopeName: " + this.keyStoreScopeName);
                    Tr.debug(tc, "isKeyPair: " + (this.isKeyPair == null ? "null" : this.isKeyPair.toString()));
                }
                CommandHelper commandHelper = new CommandHelper();
                if (this.scopeName == null) {
                    this.scopeName = commandHelper.defaultCellScope(matches);
                } else if (!ManagementScopeHelper.validScopeName(session, cs, this.scopeName)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                    }
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                    throw new CommandValidationException(msg);
                }
                if (this.keyStoreScopeName == null) {
                    this.keyStoreScopeName = commandHelper.defaultCellScope(matches);
                }
                AttributeList queryAttrs = new AttributeList();
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keySetName);
                boolean keySetNameFound = commandHelper.exists(cs, session, security2, CommandConstants.KEY_SETS, queryAttrs, this.scopeName);
                if (keySetNameFound) {
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.already.exists.CWPKI0601E", new Object[]{this.keySetName, this.scopeName}, this.keySetName + " in the management scope " + this.scopeName + " already exists.");
                    throw new CommandValidationException(msg);
                }
                queryAttrs.clear();
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.SCOPE_NAME, this.scopeName);
                boolean mgmScopeNameFound = commandHelper.exists(cs, session, security2, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
                if (!mgmScopeNameFound) {
                    this.createMgmScope = true;
                } else {
                    this.scopeObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
                }
                if (this.keyStoreName == null) break block19;
                queryAttrs.clear();
                ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keyStoreName);
                this.keyStoreObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.KEY_STORES, queryAttrs, this.keyStoreScopeName);
                AttributeList attrList = cs.getAttributes(session, this.keyStoreObjName, null, true);
                if (attrList != null) {
                    boolean inScope = commandHelper.withInScope(cs, session, attrList, this.scopeName);
                    if (!inScope) {
                        String msg = TraceNLSHelper.getInstance().getString("ssl.command.createKeyManager.CWPKI0605E", "Key store is not within Key set management scope.");
                        throw new CommandValidationException(msg);
                    }
                    break block19;
                }
                String msg = "Attribute list for KeyStore is null.";
                throw new CommandValidationException(msg);
            }
            catch (ConfigServiceException e) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error getting configuration:", e.getMessage());
                }
                throw new CommandValidationException(e.getMessage());
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.createKeySet.validate", "217");
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "Error getting configuration:", e.getMessage());
                }
                throw new CommandValidationException(e.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        ObjectName security2 = null;
        try {
            ObjectName keySet;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            AttributeList attrList = new AttributeList();
            if (this.createMgmScope) {
                ManagementScopeData scopeData = new ManagementScopeData(this.scopeName);
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SCOPE_NAME, this.scopeName);
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SCOPE_TYPE, scopeData.getScopeType());
                this.scopeObjName = cs.createConfigData(session, security2, CommandConstants.MANAGEMENT_SCOPES, null, attrList);
            }
            attrList.clear();
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.NAME, this.keySetName);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.ALIAS_PREFIX, this.aliasPrefix);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.PASSWORD, this.password);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.MAX_KEY_REFERENCES, this.maxKeyReferences);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.DELETE_OLD_KEYS, this.deleteOldKeys);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.KEY_GENERATION_CLASS, this.keyGenerationClass);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.MANAGEMENT_SCOPE, this.scopeObjName);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.IS_KEY_PAIR, this.isKeyPair);
            if (this.keyStoreObjName != null) {
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.KEY_STORE, this.keyStoreObjName);
            }
            if ((keySet = cs.createConfigData(session, security2, CommandConstants.KEY_SETS, null, attrList)) != null) {
                result.setResult(keySet);
            }
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

