/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.KeyManager;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListKeyManagers
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListKeyManagers.class, "SSL", "com.ibm.ws.ssl.commands");
    private String scopeName = null;
    private Boolean displayObjectName = null;
    private Boolean allScopes = null;

    public ListKeyManagers(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListKeyManagers(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
        this.displayObjectName = (Boolean)this.getParameter(CommandConstants.DISPLAY_OBJECT_NAME);
        this.allScopes = (Boolean)this.getParameter(CommandConstants.ALL);
        if (this.allScopes == null) {
            this.allScopes = Boolean.FALSE;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scopeName: " + this.scopeName);
            Tr.debug(tc, "displayObjectName: " + this.displayObjectName);
            Tr.debug(tc, "allScope: " + this.allScopes);
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        ArrayList<Serializable> listKeyManager = new ArrayList<Serializable>();
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            security2 = cs.resolve(session, "Cell=:Security=")[0];
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null && !this.allScopes.booleanValue()) {
                this.scopeName = commandHelper.defaultScope();
            } else if (this.allScopes.booleanValue()) {
                this.scopeName = null;
            }
            String[] displayAttrs = new String[]{CommandConstants.NAME, CommandConstants.MANAGEMENT_SCOPE};
            List keyManagers = (List)cs.getAttribute(session, security2, CommandConstants.KEY_MANAGERS);
            for (AttributeList keyManager : keyManagers) {
                ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(keyManager), null);
                if (matches.length == 1) {
                    if (this.scopeName != null) {
                        boolean inScope = commandHelper.withInScope(cs, session, keyManager, this.scopeName);
                        if (!inScope) continue;
                        if (this.displayObjectName != null && this.displayObjectName.equals(Boolean.TRUE)) {
                            listKeyManager.add(matches[0]);
                            continue;
                        }
                        listKeyManager.add(commandHelper.getDisplayAttrs(cs, session, matches, keyManager, displayAttrs));
                        continue;
                    }
                    if (this.displayObjectName != null && this.displayObjectName.equals(Boolean.TRUE)) {
                        listKeyManager.add(matches[0]);
                        continue;
                    }
                    listKeyManager.add(commandHelper.getDisplayAttrs(cs, session, matches, keyManager, displayAttrs));
                    continue;
                }
                throw new InvalidParameterValueException(this.getName(), CommandConstants.KEY_MANAGERS, keyManager);
            }
            result.setResult(listKeyManager);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

