/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.KeyManager;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.ManagementScope.ManagementScopeHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import com.ibm.ws.ssl.config.ManagementScopeData;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateKeyManager
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateKeyManager.class, "SSL", "com.ibm.ws.ssl.commands.KeyManager");
    private String keyManagerName = null;
    private String provider = null;
    private String algorithm = null;
    private String keyManagerClass = null;
    private String scopeName = null;
    private ObjectName mgmScopeObjName = null;
    private boolean createMgmScope = false;

    public CreateKeyManager(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateKeyManager(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        boolean keyManagerNameFound = false;
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.keyManagerName = (String)this.getParameter(CommandConstants.NAME);
            this.provider = (String)this.getParameter(CommandConstants.PROVIDER);
            this.algorithm = (String)this.getParameter(CommandConstants.ALGORITHM);
            this.keyManagerClass = (String)this.getParameter(CommandConstants.KEY_MANAGER_CLASS);
            this.scopeName = (String)this.getParameter(CommandConstants.SCOPE_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "keyManagerName: " + this.keyManagerName);
                Tr.debug(tc, "scopeName: " + this.scopeName);
            }
            if ((this.provider == null || this.algorithm == null) && this.keyManagerClass == null || (this.provider != null || this.algorithm != null) && this.keyManagerClass != null) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.createKeyManager.CWPKI0603E", "Specify either provider/algorithm or keyManagerClass.");
                throw new CommandValidationException(msg);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.scopeName == null) {
                this.scopeName = commandHelper.defaultCellScope(matches);
            } else if (!ManagementScopeHelper.validScopeName(session, cs, this.scopeName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a valid management scope name: " + this.scopeName);
                }
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.scope.not.valid.CWPKI0604E", new Object[]{this.scopeName}, "The following Management scope is not valid: " + this.scopeName);
                throw new CommandValidationException(msg);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.keyManagerName);
            keyManagerNameFound = commandHelper.exists(cs, session, security2, CommandConstants.KEY_MANAGERS, queryAttrs, this.scopeName);
            if (keyManagerNameFound) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.object.already.exists.CWPKI0601E", new Object[]{this.keyManagerName, this.scopeName}, this.keyManagerName + " in the management scope " + this.scopeName + " already exists.");
                throw new CommandValidationException(msg);
            }
            queryAttrs.clear();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.SCOPE_NAME, this.scopeName);
            boolean mgmScopeNameFound = commandHelper.exists(cs, session, security2, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
            if (!mgmScopeNameFound) {
                this.createMgmScope = true;
            } else {
                this.mgmScopeObjName = commandHelper.getObjectName(cs, session, security2, CommandConstants.MANAGEMENT_SCOPES, queryAttrs, null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "mgmScopeObjName: " + this.mgmScopeObjName);
                }
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.createKeyManager.validate", "178", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            AttributeList attrList = new AttributeList();
            if (this.createMgmScope) {
                ManagementScopeData scopeData = new ManagementScopeData(this.scopeName);
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SCOPE_NAME, this.scopeName);
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.SCOPE_TYPE, scopeData.getScopeType());
                this.mgmScopeObjName = cs.createConfigData(session, security2, CommandConstants.MANAGEMENT_SCOPES, null, attrList);
                attrList.clear();
            }
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.NAME, this.keyManagerName);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.PROVIDER, this.provider);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.ALGORITHM, this.algorithm);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.KEY_MANAGER_CLASS, this.keyManagerClass);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.MANAGEMENT_SCOPE, this.mgmScopeObjName);
            ObjectName keyManager = cs.createConfigData(session, security2, CommandConstants.KEY_MANAGERS, null, attrList);
            if (keyManager != null) {
                result.setResult(keyManager);
            }
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

