/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.DescriptiveProp;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class ListDescriptiveProps
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(ListDescriptiveProps.class, "SSL", "com.ibm.ws.ssl.commands");
    private String parentDataType = null;
    private String parentClassName = null;
    private String parentScopeName = null;
    private Boolean displayObjectName = null;
    private String descPropDataType = null;
    private ObjectName parentObjName = null;

    public ListDescriptiveProps(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public ListDescriptiveProps(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.parentDataType = (String)this.getParameter(CommandConstants.PARENT_DATA_TYPE);
            this.parentClassName = (String)this.getParameter(CommandConstants.PARENT_CLASS_NAME);
            this.parentScopeName = (String)this.getParameter(CommandConstants.PARENT_SCOPE_NAME);
            this.displayObjectName = (Boolean)this.getParameter(CommandConstants.DISPLAY_OBJECT_NAME);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parentDataType:           " + this.parentDataType);
                Tr.debug(tc, "parentClassName:          " + this.parentClassName);
                Tr.debug(tc, "parentScopeName:          " + this.parentScopeName);
                Tr.debug(tc, "displayObjectName:        " + this.displayObjectName);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.parentDataType == null) {
                String msg = "The data type of the parent is empty or blank";
                throw new CommandValidationException(msg);
            }
            this.descPropDataType = commandHelper.childDataType(this.parentDataType);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "descPropDataType: " + this.descPropDataType);
            }
            if (this.parentScopeName == null) {
                this.parentScopeName = commandHelper.defaultCellScope(matches);
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.parentClassName);
            this.parentObjName = this.parentDataType.equals(CommandConstants.SECURITY) ? security2 : commandHelper.getObjectName(cs, session, security2, this.parentDataType, queryAttrs, this.parentScopeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parentObjName : " + this.parentObjName);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException(e, "com.ibm.ws.ssl.commands.listSSLConfigProperties.validate", "164");
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            CommandHelper commandHelper = new CommandHelper();
            ArrayList<Serializable> descPropList = new ArrayList<Serializable>();
            AttributeList attrs = cs.getAttributes(session, this.parentObjName, null, true);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "attrs : " + attrs);
            }
            List descProperties = (List)ConfigServiceHelper.getAttributeValue(attrs, this.descPropDataType);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "descProperties : " + descProperties);
            }
            for (AttributeList descProperty : descProperties) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "descProperty : " + descProperty);
                }
                ObjectName[] matches = cs.queryConfigObjects(session, null, ConfigServiceHelper.createObjectName(descProperty), null);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "matches[0] : " + matches[0]);
                }
                if (matches.length == 1) {
                    if (this.displayObjectName != null && this.displayObjectName.equals(Boolean.TRUE)) {
                        descPropList.add(matches[0]);
                        continue;
                    }
                    String[] displayAttrs = new String[]{CommandConstants.NAME, CommandConstants.VALUE, CommandConstants.TYPE};
                    descPropList.add(commandHelper.getDisplayAttrs(cs, session, matches, descProperty, displayAttrs));
                    continue;
                }
                throw new InvalidParameterValueException(this.getName(), CommandConstants.PROPERTIES, descProperty);
            }
            result.setResult(descPropList);
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

