/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.DescriptiveProp;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConfigServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.commands.utils.CommandHelper;
import com.ibm.ws.ssl.commands.utils.TraceNLSHelper;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CreateDescriptiveProp
extends AbstractTaskCommand {
    private static TraceComponent tc = Tr.register(CreateDescriptiveProp.class, "SSL", "com.ibm.ws.ssl.commands");
    private String parentDataType = null;
    private String parentClassName = null;
    private String parentScopeName = null;
    private String name = null;
    private String value = null;
    private String type = null;
    private String displayNameKey = null;
    private String nlsRangeKey = null;
    private String hoverHelpKey = null;
    private String range = null;
    private Boolean inclusive = null;
    private Boolean firstClass = null;
    private ObjectName parentObjName = null;
    private String descPropDataType = null;

    public CreateDescriptiveProp(TaskCommandMetadata inMetadata) throws CommandNotFoundException {
        super(inMetadata);
    }

    public CreateDescriptiveProp(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
    }

    public void validate() throws CommandValidationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validate");
        }
        boolean keyManagerNameFound = false;
        super.validate();
        ConfigService cs = ConfigServiceFactory.getConfigService();
        Session session = this.getConfigSession();
        ObjectName security2 = null;
        try {
            ObjectName descPropObj;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ObjectName matches = cs.resolve(session, "Cell=")[0];
            if (matches != null) {
                security2 = cs.queryConfigObjects(session, matches, pattern, null)[0];
            }
            this.parentDataType = (String)this.getParameter(CommandConstants.PARENT_DATA_TYPE);
            this.parentClassName = (String)this.getParameter(CommandConstants.PARENT_CLASS_NAME);
            this.parentScopeName = (String)this.getParameter(CommandConstants.PARENT_SCOPE_NAME);
            this.name = (String)this.getParameter(CommandConstants.NAME);
            this.value = (String)this.getParameter(CommandConstants.VALUE);
            this.type = (String)this.getParameter(CommandConstants.TYPE);
            this.displayNameKey = (String)this.getParameter(CommandConstants.DISPLAY_NAME_KEY);
            this.nlsRangeKey = (String)this.getParameter(CommandConstants.NLS_RANGE_KEY);
            this.hoverHelpKey = (String)this.getParameter(CommandConstants.HOVER_HELP_KEY);
            this.range = (String)this.getParameter(CommandConstants.RANGE);
            this.inclusive = (Boolean)this.getParameter(CommandConstants.INCLUSIVE);
            this.firstClass = (Boolean)this.getParameter(CommandConstants.FIRST_CLASS);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parentDataType:   " + this.parentDataType);
                Tr.debug(tc, "parentClassName:  " + this.parentClassName);
                Tr.debug(tc, "parentScopeName:  " + this.parentScopeName);
                Tr.debug(tc, "name:             " + this.name);
                Tr.debug(tc, "value:            " + this.value);
                Tr.debug(tc, "type:             " + this.type);
                Tr.debug(tc, "displayNameKey:   " + this.displayNameKey);
                Tr.debug(tc, "nlsRangeKey:      " + this.nlsRangeKey);
                Tr.debug(tc, "hoverHelpKey:     " + this.hoverHelpKey);
                Tr.debug(tc, "range:            " + this.range);
                Tr.debug(tc, "inclusive:        " + this.inclusive);
                Tr.debug(tc, "firstClass:       " + this.firstClass);
            }
            CommandHelper commandHelper = new CommandHelper();
            if (this.parentDataType == null) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.descriptive.prop.parentDataType.CWPKI0638E", "The data type of the parent is empty or blank.");
                throw new CommandValidationException(msg);
            }
            this.descPropDataType = commandHelper.childDataType(this.parentDataType);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "descPropDataType: " + this.descPropDataType);
            }
            if (this.parentClassName == null) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.descriptive.prop.className.CWPKI0639E", "The class name of the parent is empty or blank");
                throw new CommandValidationException(msg);
            }
            if (this.parentScopeName == null) {
                this.parentScopeName = commandHelper.defaultCellScope(matches);
            }
            if (this.name == null) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.descriptive.prop.name.CWPKI0640E", "The name of the descriptive property is empty or blank");
                throw new CommandValidationException(msg);
            }
            if (this.value == null) {
                String msg = "The value of the descriptive property is empty or blank";
                throw new CommandValidationException(msg);
            }
            if (this.type == null) {
                String msg = TraceNLSHelper.getInstance().getString("ssl.command.descriptive.prop.type.CWPKI0641E", "The type of the descriptive property is not valid");
                throw new CommandValidationException(msg);
            }
            if (!commandHelper.contains(CommandConstants.DESC_PROPERTY_TYPES, this.type)) {
                String msg = "The type of the descriptive property is not valid";
                throw new CommandValidationException(msg);
            }
            if (this.type.equalsIgnoreCase("INT") || this.type.equalsIgnoreCase("INTEGER")) {
                try {
                    Integer val = Integer.valueOf(this.value);
                }
                catch (NumberFormatException e) {
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.command.value.not.integer.CWPKI0668E", new Object[]{this.value, this.type}, "\"" + this.value + "\" is not of type \"" + this.type + "\".");
                    throw new CommandValidationException(msg);
                }
            }
            AttributeList queryAttrs = new AttributeList();
            ConfigServiceHelper.setAttributeValue(queryAttrs, CommandConstants.NAME, this.parentClassName);
            this.parentObjName = commandHelper.getObjectName(cs, session, security2, this.parentDataType, queryAttrs, this.parentScopeName);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "parentObjName: " + this.parentObjName);
            }
            if ((descPropObj = commandHelper.getDescPropObj(cs, session, this.parentObjName, this.descPropDataType, CommandConstants.NAME, this.name)) != null) {
                String msg = "The " + this.descPropDataType + " named " + this.name + " beneath the " + this.parentDataType + " named " + this.parentClassName + " already exist.";
                throw new CommandValidationException(msg);
            }
        }
        catch (ConfigServiceException e) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.ssl.commands.CreateDescriptiveProp.validate", "241", this);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "Error getting configuration: ", e.getMessage());
            }
            throw new CommandValidationException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validate");
        }
    }

    protected void beforeStepsExecuted() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "beforeStepsExecuted");
        }
        super.beforeStepsExecuted();
        ObjectName security2 = null;
        TaskCommandResultImpl result = (TaskCommandResultImpl)this.getTaskCommandResult();
        if (!result.isSuccessful()) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "beforeStepsExecuted");
            }
            return;
        }
        try {
            ObjectName descPropObj;
            ObjectName pattern = ConfigServiceHelper.createObjectName(null, CommandConstants.SECURITY);
            ConfigService cs = ConfigServiceFactory.getConfigService();
            Session session = this.getConfigSession();
            ObjectName cell = cs.resolve(session, "Cell=")[0];
            if (cell != null) {
                security2 = cs.queryConfigObjects(session, cell, pattern, null)[0];
            }
            AttributeList attrList = new AttributeList();
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.NAME, this.name);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.VALUE, this.value);
            ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.TYPE, this.type);
            if (this.displayNameKey != null) {
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.DISPLAY_NAME_KEY, this.displayNameKey);
            }
            if (this.nlsRangeKey != null) {
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.NLS_RANGE_KEY, this.nlsRangeKey);
            }
            if (this.hoverHelpKey != null) {
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.HOVER_HELP_KEY, this.hoverHelpKey);
            }
            if (this.range != null) {
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.RANGE, this.range);
            }
            if (this.inclusive != null) {
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.INCLUSIVE, this.inclusive);
            }
            if (this.firstClass != null) {
                ConfigServiceHelper.setAttributeValue(attrList, CommandConstants.FIRST_CLASS, this.firstClass);
            }
            if ((descPropObj = cs.createConfigData(session, this.parentObjName, this.descPropDataType, null, attrList)) != null) {
                result.setResult(descPropObj);
            }
        }
        catch (Exception e) {
            result.setException(new CommandException(e, e.getMessage()));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "beforeStepsExecuted");
        }
    }
}

