/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.commands.CAClients;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.ws.ssl.commands.personalCertificates.PersonalCertificateHelper;
import com.ibm.ws.ssl.commands.utils.CommandConstants;
import com.ibm.ws.ssl.model.KeyStoreInfo;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.ObjectName;

public class CAClientHelper {
    private static TraceComponent tc = Tr.register(PersonalCertificateHelper.class, "SSL", "com.ibm.ws.ssl.commands.CAClients");

    public static HashMap getCustomAttrs(ConfigService cs, Session session, ObjectName caClientObj, String certAlias, KeyStoreInfo ksInfo) throws Exception {
        AttributeList attributeList;
        String password;
        String userName;
        Integer port;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCustomAttrs");
        }
        HashMap<String, Object> customAttrs = new HashMap<String, Object>();
        String host = (String)cs.getAttribute(session, caClientObj, CommandConstants.HOST);
        if (host != null) {
            customAttrs.put("CAHostname", host);
        }
        if ((port = (Integer)cs.getAttribute(session, caClientObj, CommandConstants.PORT)) != null) {
            customAttrs.put("CAPort", port);
        }
        if ((userName = (String)cs.getAttribute(session, caClientObj, CommandConstants.CACLIENT_USERID)) != null) {
            customAttrs.put("AuthenticationID", userName);
        }
        if ((password = (String)cs.getAttribute(session, caClientObj, CommandConstants.PASSWORD)) != null) {
            customAttrs.put("AuthenticationPWD", password.getBytes());
        }
        if (certAlias != null) {
            customAttrs.put("CertificateAlias", certAlias);
        }
        if (ksInfo.getName() != null) {
            customAttrs.put("KeyStoreAlias", ksInfo.getName());
        }
        if (ksInfo.getLocation() != null) {
            customAttrs.put("KeyStore", ksInfo.getLocation());
        }
        if (ksInfo.getType() != null) {
            customAttrs.put("KeyStoreType", ksInfo.getType());
        }
        if (ksInfo.getPassword() != null) {
            customAttrs.put("KeyStorePassword", ksInfo.getPassword().getBytes());
        }
        if ((attributeList = cs.getAttributes(session, caClientObj, new String[]{"properties"}, false)) != null) {
            List props = (List)((Attribute)attributeList.get(0)).getValue();
            for (ObjectName property : props) {
                String propName = (String)cs.getAttribute(session, property, "name");
                String value = (String)cs.getAttribute(session, property, "value");
                if (propName == null || value == null) continue;
                customAttrs.put(propName, value);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCustomAttrs");
        }
        return customAttrs;
    }

    public static byte[] getCertReqBytes(String certReqFile) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCertReqBytes");
        }
        FileInputStream fis = null;
        byte[] certReqBytes = null;
        fis = new FileInputStream(certReqFile);
        certReqBytes = new byte[fis.available()];
        fis.read(certReqBytes);
        CertificationRequest certReq = new CertificationRequest(certReqFile, true);
        certReqBytes = certReq.encode();
        if (fis != null) {
            fis.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCertReqBytes");
        }
        return certReqBytes;
    }
}

