/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ssl.ca;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.security.certclient.PkEeCertReq10Factory;
import com.ibm.security.certclient.PkEeFactory;
import com.ibm.security.certclient.PkEeReqTransaction;
import com.ibm.security.certclient.PkEeRevokeFactory;
import com.ibm.security.certclient.PkEeTransaction;
import com.ibm.security.certclient.base.PkException;
import com.ibm.security.pkcs10.CertificationRequest;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ssl.config.KeyStoreManager;
import com.ibm.ws.ssl.core.TraceNLSHelper;
import com.ibm.wsspi.ssl.WSPKIClient;
import com.ibm.wsspi.ssl.WSPKIException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import javax.security.auth.x500.X500Principal;

public final class CMPClientImpl
implements WSPKIClient {
    private static TraceComponent tc = Tr.register(CMPClientImpl.class, "SSL", "com.ibm.ws.ssl.ca");
    private static final String USER_INSTALL_ROOT = System.getProperty("user.install.root");
    private String BYTE_ENCODING = "UTF8";
    private String host = null;
    private int port = 0;
    private String userName = null;
    private byte[] password = null;

    public void init(HashMap initAttrs) throws WSPKIException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", new Object[]{initAttrs, this});
        }
        Object o = null;
        o = initAttrs.get("CAHostname");
        if (o == null || !(o instanceof String)) {
            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.cmp.impl.invalid.attribute", new Object[]{"CAHostname", "java.lang.String"}, "Attribute \"CAHostname\" is missing or of an incorrect type.  Correct type is \"java.lang.String\"");
            Tr.error(tc, msg);
            throw new WSPKIException(msg);
        }
        this.host = o;
        o = initAttrs.get("CAPort");
        if (o == null || !(o instanceof Integer)) {
            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.cmp.impl.invalid.attribute", new Object[]{"CAPort", "java.lang.Integer"}, "Attribute \"CAPort\" is missing or of an incorrect type.  Correct type is \"java.lang.Integer\"");
            Tr.error(tc, msg);
            throw new WSPKIException(msg);
        }
        this.port = o;
        o = initAttrs.get("AuthenticationID");
        if (o == null || !(o instanceof String)) {
            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.cmp.impl.invalid.attribute", new Object[]{"AuthenticationID", "java.lang.String"}, "Attribute \"AuthenticationID\" is missing or of an incorrect type.  Correct type is \"java.lang.String\"");
            Tr.error(tc, msg);
            throw new WSPKIException(msg);
        }
        this.userName = o;
        o = initAttrs.get("AuthenticationPWD");
        if (o == null || !(o instanceof byte[])) {
            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.cmp.impl.invalid.attribute", new Object[]{"AuthenticationPWD", "java.lang.String"}, "Attribute \"AuthenticationPWD\" is missing or of an incorrect type.  Correct type is \"java.lang.String\"");
            Tr.error(tc, msg);
            throw new WSPKIException(msg);
        }
        this.password = o;
        PkEeFactory.setCaDn((String)this.host);
        PkEeFactory.setCaPort((int)this.port);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    /*
     * Loose catch block
     */
    public X509Certificate[] requestCertificate(byte[] certReq, X500Principal subjectDN, byte[] revocationPassword, HashMap extAttrs) throws WSPKIException {
        File certReqFile;
        File iaFile;
        String certReqFilePath;
        String iaFilePath;
        X509Certificate[] certChain;
        block29: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "createCertificate", new Object[]{certReq, subjectDN, revocationPassword, extAttrs, this});
            }
            certChain = null;
            iaFilePath = null;
            certReqFilePath = null;
            iaFile = null;
            certReqFile = null;
            if (subjectDN != null) {
                PkEeFactory.setCA_DN((String)subjectDN.getName());
            }
            if (certReq == null) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.cmp.impl.invalid.certificate.request", null, "The certificate request is null");
                Tr.error(tc, msg);
                throw new WSPKIException(msg);
            }
            if (revocationPassword == null) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.cmp.impl.invalid.revocation.password", null, "The revocation password for this certificate request is null");
                Tr.error(tc, msg);
                throw new WSPKIException(msg);
            }
            OutputStreamWriter iaWriter = null;
            iaFile = this.createTemporaryFile("iaFile", null);
            if (iaFile != null) {
                iaFilePath = iaFile.getAbsolutePath();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Creating temporary initial authentication file \"" + iaFilePath + "\".");
            }
            iaWriter = new OutputStreamWriter(new FileOutputStream(iaFile));
            iaWriter.write(this.userName);
            iaWriter.write(10);
            iaWriter.write(new String(this.password, this.BYTE_ENCODING));
            try {
                iaWriter.close();
            }
            catch (IOException e) {
                Tr.error(tc, "ssl.ca.cmp.impl.general.error", new Object[]{e});
            }
            break block29;
            catch (IOException ioe) {
                try {
                    String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.cmp.impl.tempfile.error", new Object[]{iaFilePath}, "Unable to create temporary file \"" + iaFilePath + "\"");
                    Tr.error(tc, msg);
                    throw new WSPKIException(msg, ioe);
                }
                catch (Throwable throwable) {
                    try {
                        iaWriter.close();
                    }
                    catch (IOException e) {
                        Tr.error(tc, "ssl.ca.cmp.impl.general.error", new Object[]{e});
                    }
                    throw throwable;
                }
            }
        }
        try {
            certReqFile = this.createTemporaryFile("certReq", null);
            if (certReqFile != null) {
                certReqFilePath = certReqFile.getAbsolutePath();
            }
            CertificationRequest certReq1 = new CertificationRequest(certReq);
            certReq1.writeBASE64(certReqFilePath);
        }
        catch (IOException ioe) {
            String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.cmp.impl.tempfile.error", new Object[]{certReqFilePath}, "Unable to create temporary file \"" + certReqFilePath + "\"");
            FFDCFilter.processException((Throwable)ioe, "com.ibm.ws.ssl.ca.CMPClientImpl.createCertificate", "243", this);
            Tr.error(tc, "ssl.ca.cmp.impl.tempfile.error", new Object[]{certReqFilePath});
            throw new WSPKIException(msg, ioe);
        }
        try {
            PkEeReqTransaction crt = PkEeCertReq10Factory.newCertRequestPKCS10((String)certReqFilePath, (String)iaFilePath, (String)new String(revocationPassword));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Certificate request generated.");
            }
            crt.actionRequest();
            certChain = crt.getCertificateChain();
        }
        catch (PkException pke) {
            FFDCFilter.processException((Throwable)pke, "com.ibm.ws.ssl.ca.CMPClientImpl.createCertificate", "265", this);
            Tr.error(tc, "ssl.ca.cmp.impl.create.error", new Object[]{pke});
            throw new WSPKIException(pke.getMessage() == null ? pke.getWrappedException().getMessage() : pke.getMessage(), pke);
        }
        finally {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Deleting temporary iaFile: " + iaFile.getName());
            }
            if (iaFile != null) {
                iaFile.delete();
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Deleting temporary certificate request file: " + certReqFile.getName());
            }
            if (certReqFile != null) {
                certReqFile.delete();
            }
            PkEeFactory.setCA_DN((String)"");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCert", certChain);
        }
        return certChain;
    }

    public X509Certificate[] queryCertificate(byte[] certReq, HashMap extAttrs) throws WSPKIException {
        Tr.error(tc, "ssl.ca.cmp.impl.action.not.supported", "query");
        throw new WSPKIException(TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.cmp.impl.action.not.supported", new Object[]{"query"}, "Action \"query\" not supported by this implementation"));
    }

    public void revokeCertificate(X509Certificate[] certificateChain, byte[] revocationPassword, String revocationReason, HashMap extAttrs) throws WSPKIException {
        block17: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "revokeCertificate", new Object[]{certificateChain, revocationPassword, revocationReason, extAttrs, this});
            }
            X509Certificate cert = null;
            File tempKeyStoreFile = null;
            String certificateAlias = "toBeRevoked";
            String keyStorePath = null;
            String keyStoreAlias = "revocationKeyStore";
            String keyStoreType = "PKCS12";
            String keyStorePassword = "WebAS";
            if (certificateChain == null || certificateChain[0] == null) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.cmp.impl.invalid.certificate.chain", null, "The certificate chain is null.");
                throw new WSPKIException(msg);
            }
            if (revocationPassword == null) {
                String msg = TraceNLSHelper.getInstance().getFormattedMessage("ssl.ca.cmp.impl.invalid.revocation.password", null, "The revocation password for this certificate request is null");
                throw new WSPKIException(msg);
            }
            if (revocationReason == null) {
                revocationReason = "unspecified";
            }
            cert = certificateChain[0];
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating temporary keystore file and storing certificate to be revoked.");
                }
                tempKeyStoreFile = this.createTemporaryFile("certKS", null);
                keyStorePath = tempKeyStoreFile.getAbsolutePath();
                tempKeyStoreFile.delete();
                KeyStore keyStore = KeyStoreManager.getInstance().getKeyStore(keyStoreAlias, keyStoreType, "JCEKS", keyStorePath, keyStorePassword, null, true, null);
                PkEeFactory.setKeystoreFilename((String)tempKeyStoreFile.getCanonicalPath());
                PkEeFactory.setKeystorePwd((char[])new String(keyStorePassword).toCharArray());
                PkEeFactory.setKeyStoreType((String)keyStoreType);
                if (keyStore != null) {
                    keyStore.load(null, keyStorePassword.toCharArray());
                    keyStore.setCertificateEntry(certificateAlias, certificateChain[0]);
                    FileOutputStream fos = new FileOutputStream(keyStorePath);
                    keyStore.store(fos, keyStorePassword.toCharArray());
                    if (fos != null) {
                        fos.close();
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Successfully stored certificate to be revoked in temporary keystore: " + keyStorePath);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Revoking Certificate\n Owner: " + cert.getSubjectDN().getName() + ", Issuer: " + cert.getIssuerDN() + ", Serial Number: " + cert.getSerialNumber());
                    }
                    PkEeTransaction rev = PkEeRevokeFactory.newRevoke((String)certificateAlias, (String)keyStorePassword, (String)revocationReason, (String)new String(revocationPassword, this.BYTE_ENCODING));
                    rev.actionRequest();
                    break block17;
                }
                throw new KeyStoreException("Unable to revoke certificate, keyStore is null.");
            }
            catch (PkException pke) {
                FFDCFilter.processException((Throwable)pke, "com.ibm.ws.ssl.ca.CMPClientImpl.revokeCertificate", "419", this);
                Tr.error(tc, "ssl.ca.cmp.impl.revoke.error", new Object[]{pke});
                throw new WSPKIException(pke.getMessage() == null ? pke.getWrappedException().getMessage() : pke.getMessage(), pke);
            }
            catch (Exception e) {
                throw new WSPKIException(e);
            }
            finally {
                if (tempKeyStoreFile.exists()) {
                    tempKeyStoreFile.delete();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "revokeCertificate");
        }
    }

    private File createTemporaryFile(String prefix, String suffix) throws IOException {
        File dir;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTemporaryFile");
        }
        File tempFile = File.createTempFile(prefix, suffix, (dir = new File(USER_INSTALL_ROOT + File.separator + "temp")).exists() ? dir : null);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTemporaryFile");
        }
        return tempFile;
    }
}

