/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.serverindex.NamedEndPoint;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.wst.common.internal.emf.utilities.EtoolsCopyUtility;

public class ServerIndexUtil {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(ServerIndexUtil.class);
    private static int NEW_ENTRY = 1;
    private static int MODIFIED_ENTRY = 2;
    private static int NOT_MODIFIED_ENTRY = 3;
    private static int DELETED_ENTRY = 4;
    private static String PROCESSED = "p";

    private void showDeployedApps(List serverEntries, String docName) {
        for (int i = 0; i < serverEntries.size(); ++i) {
            ServerEntry srvEntry = (ServerEntry)serverEntries.get(i);
            if (!srvEntry.getServerName().equals("server1")) continue;
            EList deployedApps = srvEntry.getDeployedApplications();
            Tr.debug(tc, "\n " + docName + ":\t" + deployedApps);
        }
    }

    public boolean mergeDocuments(ServerIndex origDoc, ServerIndex localDoc, ServerIndex currentDoc) {
        int i;
        boolean conflict = false;
        EList origServers = origDoc.getServerEntries();
        EList localServers = localDoc.getServerEntries();
        EList currentServers = currentDoc.getServerEntries();
        int origSize = origServers.size();
        int localSize = localServers.size();
        int currentSize = currentServers.size();
        ServerEntry origServerEntry = null;
        ServerEntry currentServerEntry = null;
        ServerEntry localServerEntry = null;
        String origServerName = null;
        String currentServerName = null;
        String localServerName = null;
        String serverType = null;
        HashMap<String, ServerEntryDelta> currentEntryTable = new HashMap<String, ServerEntryDelta>();
        ServerEntryDelta delta = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Checking for hostname change conflict:");
        }
        if (!currentDoc.getHostName().equals(origDoc.getHostName()) && !localDoc.getHostName().equals(origDoc.getHostName())) {
            conflict = true;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "CONFLICT! - Hostname was modified on local and current.");
            }
        }
        if (!conflict) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Building original/current delta list:");
            }
            for (i = 0; i < currentSize; ++i) {
                currentServerEntry = (ServerEntry)currentServers.get(i);
                currentServerName = currentServerEntry.getServerName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing...currentServerName[" + i + "]=" + currentServerName);
                }
                delta = new ServerEntryDelta(i, NEW_ENTRY);
                currentEntryTable.put(currentServerName, delta);
                if (serverType != null || !currentServerEntry.getServerType().equals("DEPLOYMENT_MANAGER") && !currentServerEntry.getServerType().equals("NODE_AGENT")) continue;
                serverType = currentServerEntry.getServerType();
            }
        }
        if (!conflict) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Comparing original/current entries:");
            }
            for (i = 0; i < origSize; ++i) {
                origServerEntry = (ServerEntry)origServers.get(i);
                origServerName = origServerEntry.getServerName();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Processing...origServerName[" + i + "]=" + origServerName);
                }
                if ((delta = (ServerEntryDelta)currentEntryTable.get(origServerName)) != null) {
                    if (this.equalsServerEntry((ServerEntry)currentServers.get(delta.getIndex()), origServerEntry)) {
                        delta.setStatus(NOT_MODIFIED_ENTRY);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Entry was not modified on current.");
                        continue;
                    }
                    delta.setStatus(MODIFIED_ENTRY);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Entry has been modified on current.");
                    continue;
                }
                delta = new ServerEntryDelta(0, DELETED_ENTRY);
                currentEntryTable.put(origServerName, delta);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Entry has been deleted on current.");
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Comparing local and original/current entries:");
            }
        }
        int count = origSize;
        boolean done = false;
        int index = 0;
        for (int i2 = 0; i2 < localSize && !conflict; ++i2) {
            localServerEntry = (ServerEntry)localServers.get(i2);
            localServerName = localServerEntry.getServerName();
            done = false;
            for (index = 0; index < origSize && !done; ++index) {
                origServerEntry = (ServerEntry)origServers.get(index);
                origServerName = origServerEntry.getServerName();
                if (!localServerName.equals(origServerName)) continue;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Checking for changes to server[" + origServerName + "]");
                }
                --count;
                origServerEntry.setServerType(PROCESSED);
                boolean localChanged = !this.equalsServerEntry(localServerEntry, origServerEntry);
                List[] localAppChanged = this.getDeltaApplications(localServerEntry, origServerEntry);
                if (localChanged || localAppChanged != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Entry was modified on local.");
                    }
                    if ((delta = (ServerEntryDelta)currentEntryTable.get(localServerName)) != null) {
                        int status = delta.getStatus();
                        if (status == MODIFIED_ENTRY && localChanged || status == DELETED_ENTRY || status == NEW_ENTRY) {
                            conflict = true;
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "CONFLICT! - Entry was modified on local and current.");
                            }
                        } else {
                            ServerEntry targetServerEntry;
                            int slot = delta.getIndex();
                            currentServerEntry = (ServerEntry)currentServers.get(slot);
                            List[] currentAppChanged = this.getDeltaApplications(currentServerEntry, origServerEntry);
                            if (localChanged) {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Local server entry NOT equal to original server entry, localChanged = " + localChanged);
                                }
                                targetServerEntry = (ServerEntry)EtoolsCopyUtility.createCopy(localServerEntry);
                                conflict = this.mergeApplChange(currentAppChanged, localAppChanged, targetServerEntry);
                            } else {
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Local server entry equal to original server entry, localChanged = " + localChanged);
                                }
                                targetServerEntry = currentServerEntry;
                                conflict = this.mergeApplChange(localAppChanged, currentAppChanged, targetServerEntry);
                            }
                            if (!conflict) {
                                if (tc.isDebugEnabled()) {
                                    if (localChanged) {
                                        Tr.debug(tc, "Local entry changed(other than applicaton, so overwrite the server entry with the local one(with merged application.");
                                    } else {
                                        Tr.debug(tc, "Current entry changed(other than applicaton, so merge the local applicaiton to currentserver entry.");
                                    }
                                }
                                currentServers.remove(slot);
                                currentServers.add(slot, targetServerEntry);
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Entry was modified on local and not current - merge.");
                            }
                        }
                    } else {
                        conflict = true;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "CONFLICT! - Entry was modified on local and deleted on current.");
                        }
                    }
                }
                done = true;
            }
            if (done) continue;
            delta = (ServerEntryDelta)currentEntryTable.get(localServerName);
            if (delta == null) {
                currentServers.add(localServerEntry);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Entry was new on local - merge.");
                continue;
            }
            conflict = true;
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "CONFLICT! - Entry was new on local and new on current.");
        }
        if (count != 0 && !conflict) {
            for (index = 0; index < origSize && !conflict; ++index) {
                origServerEntry = (ServerEntry)origServers.get(index);
                if (origServerEntry.getServerType().equals(PROCESSED) || (delta = (ServerEntryDelta)currentEntryTable.get(origServerName = origServerEntry.getServerName())) == null) continue;
                int status = delta.getStatus();
                if (status == MODIFIED_ENTRY) {
                    conflict = true;
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "CONFLICT! - Entry was deleted on local and modified on current.");
                    continue;
                }
                int slot = delta.getIndex();
                currentServers.remove(slot);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Entry was deleted on local and not modified on current.");
            }
        }
        if (!conflict) {
            this.refactorDistinguishedEndpoints(currentDoc, serverType);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning - documents merged=" + !conflict);
        }
        return !conflict;
    }

    private boolean equalsServerEntry(ServerEntry se1, ServerEntry se2) {
        boolean equal = true;
        if (se1.getServerDisplayName() != null && se2.getServerDisplayName() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServerDisplayName is " + se1.getServerDisplayName() + " and " + se2.getServerDisplayName());
            }
            if (!se1.getServerDisplayName().equals(se2.getServerDisplayName())) {
                equal = false;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ServerDisplayName is null");
            }
            if (se1.getServerDisplayName() != null || se2.getServerDisplayName() != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Only One of the ServerDisplayName is null");
                }
                equal = false;
            }
        }
        if (equal && !se1.getServerName().equals(se2.getServerName())) {
            equal = false;
        }
        int count = 0;
        int i = 0;
        if (equal) {
            EList specialEndpoints1 = se1.getSpecialEndpoints();
            EList specialEndpoints2 = se2.getSpecialEndpoints();
            count = specialEndpoints2.size();
            for (i = 0; i < specialEndpoints1.size(); ++i) {
                NamedEndPoint namedEndpoint1 = (NamedEndPoint)specialEndpoints1.get(i);
                String namedEndpointName1 = namedEndpoint1.getEndPointName();
                EndPoint endpoint1 = namedEndpoint1.getEndPoint();
                String host1 = endpoint1.getHost();
                int port1 = endpoint1.getPort();
                boolean done = false;
                for (int j = 0; j < specialEndpoints2.size() && !done; ++j) {
                    NamedEndPoint namedEndpoint2 = (NamedEndPoint)specialEndpoints2.get(j);
                    String namedEndpointName2 = namedEndpoint2.getEndPointName();
                    if (!namedEndpointName1.equals(namedEndpointName2)) continue;
                    EndPoint endpoint2 = namedEndpoint2.getEndPoint();
                    String host2 = endpoint2.getHost();
                    int port2 = endpoint2.getPort();
                    if (!host1.equals(host2) || port1 != port2) continue;
                    --count;
                    done = true;
                }
            }
            if (count != 0) {
                equal = false;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Returning - equal=" + equal);
        }
        return equal;
    }

    private List[] getDeltaApplications(ServerEntry se1, ServerEntry se2) {
        List[] result = new List[2];
        result[0] = new ArrayList(se1.getDeployedApplications());
        result[0].removeAll(se2.getDeployedApplications());
        result[1] = new ArrayList(se2.getDeployedApplications());
        result[1].removeAll(se1.getDeployedApplications());
        if (result[0].size() == 0 && result[1].size() == 0) {
            return null;
        }
        return result;
    }

    private boolean mergeApplChange(List[] localApplChanged, List[] currentApplChanged, ServerEntry se1) {
        if (tc.isDebugEnabled()) {
            if (localApplChanged != null) {
                Tr.debug(tc, "Changed apps:  Add: " + localApplChanged[0] + ", Remove: " + localApplChanged[1]);
            }
            if (currentApplChanged != null) {
                Tr.debug(tc, "Conflict apps: Add: " + currentApplChanged[0] + ", Remove: " + currentApplChanged[1]);
            }
            Tr.debug(tc, "ServerEntry: " + se1);
        }
        if (localApplChanged == null) {
            return false;
        }
        boolean conflict = false;
        if (currentApplChanged != null) {
            for (int i = 0; i < 2 && !conflict; ++i) {
                for (int j = 0; j < localApplChanged[i].size() && !conflict; ++j) {
                    String applName = (String)localApplChanged[i].get(j);
                    conflict = currentApplChanged[0].contains(applName) || currentApplChanged[1].contains(applName);
                }
            }
        }
        if (!conflict) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Merge applications without conflict.");
            }
            se1.getDeployedApplications().addAll(localApplChanged[0]);
            se1.getDeployedApplications().removeAll(localApplChanged[1]);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Can not merge applications as there is conflict.");
        }
        return conflict;
    }

    private void refactorDistinguishedEndpoints(ServerIndex serverIndex, String serverType) {
        EList servers = serverIndex.getServerEntries();
        EList endPointRefs = serverIndex.getEndPointRefs();
        endPointRefs.clear();
        boolean done = false;
        for (int i = 0; i < servers.size() && !done; ++i) {
            String name;
            NamedEndPoint namedEndpoint;
            int e;
            ServerEntry serverEntry = (ServerEntry)servers.get(i);
            if (!serverEntry.getServerType().equals(serverType)) continue;
            EList endpoints = serverEntry.getSpecialEndpoints();
            if (serverType.equals("DEPLOYMENT_MANAGER")) {
                for (e = 0; e < endpoints.size(); ++e) {
                    namedEndpoint = (NamedEndPoint)endpoints.get(e);
                    name = namedEndpoint.getEndPointName();
                    if (!name.equals("BOOTSTRAP_ADDRESS") && !name.equals("CELL_DISCOVERY_ADDRESS") && !name.equals("CELL_MULTICAST_DISCOVERY_ADDRESS") && !name.equals("ORB_LISTENER_ADDRESS")) continue;
                    endPointRefs.add(namedEndpoint);
                }
            } else if (serverType.equals("NODE_AGENT")) {
                for (e = 0; e < endpoints.size(); ++e) {
                    namedEndpoint = (NamedEndPoint)endpoints.get(e);
                    name = namedEndpoint.getEndPointName();
                    if (!name.equals("NODE_DISCOVERY_ADDRESS") && !name.equals("NODE_MULTICAST_DISCOVERY_ADDRESS") && !name.equals("ORB_LISTENER_ADDRESS")) continue;
                    endPointRefs.add(namedEndpoint);
                }
            }
            done = true;
        }
    }

    class ServerEntryDelta {
        private int index;
        private int status;

        public ServerEntryDelta(int _index, int _status) {
            this.index = _index;
            this.status = _status;
        }

        public int getIndex() {
            return this.index;
        }

        public int getStatus() {
            return this.status;
        }

        public void setIndex(int val) {
            this.index = val;
        }

        public void setStatus(int val) {
            this.status = val;
        }
    }
}

