/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.template.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.metadata.RepositoryContextType;
import com.ibm.ws.sm.workspace.template.Template;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TemplateImpl
implements Template {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(TemplateImpl.class);
    private RepositoryContext templateContext;
    private List variables = null;
    private List fileNames = null;
    private HashMap contentMap = new HashMap();

    public TemplateImpl(RepositoryContext templateContext) {
        this.templateContext = templateContext;
    }

    public RepositoryContextType getType() {
        return this.templateContext.getType();
    }

    public String getName() {
        return this.templateContext.getName();
    }

    public RepositoryContext getContext() {
        return this.templateContext;
    }

    public List getVariables() throws WorkSpaceException {
        if (this.variables == null) {
            this.init();
        }
        return this.variables;
    }

    private void init() throws WorkSpaceException {
        Tr.entry(tc, "init");
        this.variables = new ArrayList();
        List files = this.templateContext.getAllList(false);
        for (int i = 0; i < files.size(); ++i) {
            List tList;
            WorkSpaceFile file = (WorkSpaceFile)files.get(i);
            if (file.getType() == null || (tList = this.collect(file)).size() <= 0) continue;
            this.variables.removeAll(tList);
            this.variables.addAll(tList);
        }
        Tr.exit(tc, "init");
    }

    public List getFiles() throws WorkSpaceException {
        if (this.fileNames == null) {
            this.fileNames = new ArrayList();
            List files = this.templateContext.getAllList(false);
            for (int i = 0; i < files.size(); ++i) {
                WorkSpaceFile file = (WorkSpaceFile)files.get(i);
                this.fileNames.add(file.getName());
            }
        }
        if (tc.isDebugEnabled() && this.fileNames.isEmpty()) {
            Tr.debug(tc, "file names list is empty in context: " + this.templateContext.getName());
        }
        return this.fileNames;
    }

    private List collect(WorkSpaceFile file) throws WorkSpaceException {
        return this.collect(this.getContent(file.getName()));
    }

    String getContent(String uri) throws WorkSpaceException {
        return new String(this.getContentBytes(uri));
    }

    byte[] getContentBytes(String uri) throws WorkSpaceException {
        Tr.entry(tc, "getContentBytes", new Object[]{uri});
        byte[] buffer = null;
        try {
            InputStream is = this.getContext().getInputStream(uri);
            int len = is.available();
            buffer = new byte[len];
            is.read(buffer, 0, len);
            is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Tr.exit(tc, "getContentBytes");
        return buffer;
    }

    private List collect(String contents) throws WorkSpaceException {
        Tr.entry(tc, "collect");
        ArrayList<String> list = new ArrayList<String>();
        int length = contents.length();
        StringBuffer token = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            char c = contents.charAt(i);
            if (c == '$') {
                if (i + 3 >= length) break;
                if (contents.charAt(++i) != '{') continue;
                token.append("${");
                continue;
            }
            if (c == '}') {
                if (token.length() == 0) continue;
                token.append("}");
                String tokenStr = token.toString();
                if (!list.contains(tokenStr)) {
                    list.add(tokenStr);
                }
                token = new StringBuffer();
                continue;
            }
            if (token.length() <= 0) continue;
            token.append(c);
        }
        Tr.exit(tc, "collect");
        return list;
    }
}

