/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.migration;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.impl.WorkSpaceResourceSet;
import com.ibm.ws.sm.workspace.migration.MOFContext;
import com.ibm.ws.sm.workspace.migration.WSURIConverter;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.Resource;

public final class WSResourceSetImpl
extends WASResourceSetImpl
implements WorkSpaceResourceSet {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(WSResourceSetImpl.class);
    private RepositoryContext context;
    private boolean adapterNotifierOn = true;

    public WSResourceSetImpl(MOFContext context) {
        this.context = (RepositoryContext)context;
    }

    public RepositoryContext getContext() {
        return this.context;
    }

    public Notifier getTarget() {
        return this;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return true;
    }

    public synchronized void notifyChanged(Notification msg) {
        if (this.adapterNotifierOn) {
            try {
                int eventType = msg.getEventType();
                if (eventType == 3) {
                    Resource resource = (Resource)msg.getNewValue();
                    String fileName = resource.getURI().toFileString();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "notify ADD:" + fileName);
                    }
                    if (fileName != null) {
                        this.context.notifyChanged(0, fileName);
                    }
                }
            }
            catch (WorkSpaceException e) {
                e.printStackTrace();
            }
        }
    }

    public void setAdapterNotifier(boolean on) {
        this.adapterNotifierOn = on;
    }

    public void release(String name) {
        URI uri = URI.createURI(name);
        Resource resource = null;
        try {
            resource = this.getResource(uri, false);
        }
        catch (NullPointerException npe) {
            // empty catch block
        }
        if (resource != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Releasing resource = " + name + " for " + this.context.getURI());
            }
            this.getResources().remove(resource);
        }
    }

    public void refreshPath() {
        WSURIConverter uric = new WSURIConverter(this.context);
        this.setURIConverter(uric);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getResource(URI uri, boolean loadOnDemand) {
        String scheme;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getResource: " + uri + ", loadOnDemand: " + loadOnDemand);
        }
        if ((scheme = uri.scheme()) != null && scheme.equals("java")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getResource: java URI:" + uri);
            }
            return null;
        }
        if (!loadOnDemand) {
            return super.getResource(uri, loadOnDemand);
        }
        try {
            String uriString = uri.toString();
            RepositoryContext newContext = this.context.findContext(uriString);
            if (newContext != null && newContext != this.context) {
                String newContextURI = newContext.getURI();
                String contextURI = this.context.getURI();
                int offset = newContextURI.length() - contextURI.length();
                if (contextURI.length() == 0) {
                    ++offset;
                }
                String newURI = uriString.substring(offset);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "old context: " + contextURI + ", old uri: " + uriString);
                    Tr.debug(tc, "new context: " + newContextURI + ", new uri: " + newURI);
                }
                return newContext.getResourceSet().getResource(URI.createURI(newURI), loadOnDemand);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Try to load local: " + this.context.getURI() + ", file: " + uri);
            }
            Resource resource = null;
            InputStream resFile = null;
            try {
                resFile = this.getURIConverter().createInputStream(uri);
                resource = super.getResource(uri, loadOnDemand);
                if (uri.toString().equals("serverindex.xml.current") || uri.toString().equals("serverindex.xml")) {
                    if (tc.isDebugEnabled()) {
                        this.dumpServerindexFile(resFile, uri);
                        this.showDeployedApps(resource, uri.toString() + " 1st Try");
                    }
                    resource.unload();
                    resource = super.getResource(uri, loadOnDemand);
                    if (tc.isDebugEnabled()) {
                        this.showDeployedApps(resource, uri.toString() + " 2nd Try");
                    }
                }
            }
            catch (IOException e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got IOException in getResource(), so check for parent context. " + e);
                }
            }
            finally {
                try {
                    if (resFile != null) {
                        resFile.close();
                    }
                }
                catch (IOException e) {}
            }
            if (resource != null) {
                return resource;
            }
            if (this.context.getParent() != null) {
                return this.context.getParent().getResourceSet().getResource(uri, loadOnDemand);
            }
            return null;
        }
        catch (WorkSpaceException e) {
            throw new WrappedException(e);
        }
    }

    private void dumpServerindexFile(InputStream resFile, URI uri) throws IOException {
        byte[] buf = new byte[2048];
        int bytesRead = resFile.read(buf);
        String str = new String(buf);
        Tr.debug(tc, uri + ":\n" + str);
    }

    private void showDeployedApps(Resource resource, String docName) {
        ServerIndex si = (ServerIndex)resource.getContents().iterator().next();
        EList serverEntries = si.getServerEntries();
        for (int i = 0; i < serverEntries.size(); ++i) {
            ServerEntry srvEntry = (ServerEntry)serverEntries.get(i);
            EList deployedApps = srvEntry.getDeployedApplications();
            Tr.debug(tc, "\n Context: " + this.context.getPath() + "\n docName: " + docName + ", Server: " + srvEntry.getServerName() + "\n    Apps: " + deployedApps + "\n");
        }
    }
}

