/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.config.ModelMgr;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceManager;
import com.ibm.ws.sm.workspace.WorkSpaceRepositoryAdapter;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.impl.WorkSpaceManagerMBean;
import com.ibm.ws.sm.workspace.impl.WorkSpaceMasterRepositoryAdapter;
import com.ibm.ws.sm.workspace.impl.WorkSpaceMessage;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaDataFactory;
import com.ibm.wsspi.configarchive.DefaultFileAccessor;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class WorkSpaceManagerImpl
implements WorkSpaceManager,
WorkSpaceMessage {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(WorkSpaceManagerImpl.class);
    private Map workspaces = Collections.synchronizedMap(new HashMap());
    private Object removeWorkSpacesLock = new Object();
    private boolean init = false;
    private ClassLoader classLoader = null;
    private WorkSpaceManagerMBean mbean = WorkSpaceManagerMBean.getInstance();
    boolean _selfCorrection = true;
    private String profileKey = null;

    public WorkSpaceManagerImpl() {
    }

    public WorkSpaceManagerImpl(String profileKey) {
        this.profileKey = profileKey;
    }

    private String getProperty(Properties prop, String key) {
        String result = prop.getProperty(key);
        if (result == null) {
            result = System.getProperty(key);
        }
        return result;
    }

    private WorkSpaceImpl createWorkSpace(Properties prop) throws WorkSpaceException {
        boolean selfCorrection;
        WorkSpaceRepositoryAdapter repositoryAdapter;
        String id = this.getProperty(prop, "workspace.user.id");
        String disableCleanup = this.getProperty(prop, "workspace.cleanup.disable");
        String sessionId = this.getProperty(prop, "workspace.session.id");
        String userRoot = this.getProperty(prop, "workspace.user.root");
        String path = this.getProperty(prop, "workspace.root");
        String metaDataPath = this.getProperty(prop, "workspace.metadata.root");
        String repositoryAdapterName = this.getProperty(prop, "workspace.repository.adapter");
        FileAccessor fa = (FileAccessor)prop.get("workspace.file.accessor");
        String callerInfo = "Call stack info of createWorkSpace(prop):\n" + this.getCallStack();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, callerInfo);
        }
        ModelMgr.initialize("ws-server");
        WorkSpaceImpl result = new WorkSpaceImpl(id);
        this.workspaces.put(id, result);
        if (path != null) {
            result.setPath(path);
        } else if (userRoot != null) {
            result.setUserRoot(userRoot);
        }
        if (fa == null) {
            File f = new File(result.getPath());
            fa = new DefaultFileAccessor(f);
        }
        if (disableCleanup != null && disableCleanup.equals("true")) {
            result.setDisableCleanup();
        }
        if (fa != null) {
            result.setFileAccessor(fa);
        }
        if (metaDataPath != null) {
            result.setMetaData(RepositoryMetaDataFactory.getFactory().getMetaData(metaDataPath));
        }
        if (repositoryAdapterName == null) {
            repositoryAdapterName = "com.ibm.ws.sm.workspace.impl.WorkSpaceMasterRepositoryAdapter";
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Create workspace ... \n\t WorkspaceUserPath: " + result.getUserPath() + "\n\t WorkspacePath ...: " + result.getPath() + "\n\t repositoryAdapter: " + repositoryAdapterName);
        }
        try {
            repositoryAdapter = (WorkSpaceRepositoryAdapter)this.getInstanceOfType(repositoryAdapterName);
        }
        catch (Exception e) {
            throw WorkSpaceLogger.createException(tc, "WKSP0019E Error getting repository adapter {0} --{1}", new Object[]{repositoryAdapterName, e}, e);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "profileKey", this.profileKey);
        }
        if (this.profileKey != null) {
            prop.setProperty("location", "profilekey");
            prop.setProperty("profileKey", this.profileKey);
        }
        repositoryAdapter.initialize(prop);
        if (repositoryAdapter instanceof WorkSpaceMasterRepositoryAdapter && (selfCorrection = ((WorkSpaceMasterRepositoryAdapter)repositoryAdapter).isSelfCorrection()) != this._selfCorrection) {
            this._selfCorrection = selfCorrection;
            WorkSpaceLogger.logAudit(tc, "WKSP0500I Workspace configuration consistency check is {0}.", selfCorrection);
        }
        result.setRepositoryAdapter(repositoryAdapter);
        result.setCallerInfo(callerInfo);
        result.setSessionId(sessionId);
        result.restore();
        WorkSpaceManagerImpl workSpaceManagerImpl = this;
        if (workSpaceManagerImpl.mbean.isActive()) {
            this.mbean.workSpaceCreated(result);
        }
        return result;
    }

    public WorkSpace getWorkSpace(String id) throws WorkSpaceException {
        return this.getWorkSpace(id, null);
    }

    public WorkSpace getWorkSpace(String id, String sessionId) throws WorkSpaceException {
        Properties prop = new Properties();
        if (id != null) {
            prop.setProperty("workspace.user.id", id);
        }
        if (sessionId != null) {
            prop.setProperty("workspace.session.id", sessionId);
        }
        return this.getWorkSpace(prop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkSpace createUniqueWorkSpace(Properties prop) throws WorkSpaceException {
        String id = prop.getProperty("workspace.user.id");
        String sessionId = prop.getProperty("workspace.session.id");
        boolean debugEnable = tc.isDebugEnabled();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWorkSpace, UserID: " + id + ", SessionID: " + sessionId);
        }
        WorkSpaceImpl result = null;
        Map map = this.workspaces;
        synchronized (map) {
            result = (WorkSpaceImpl)this.workspaces.get(id);
            if (result == null) {
                result = this.createWorkSpace(prop);
            } else if (!result.isValid()) {
                if (debugEnable) {
                    Tr.debug(tc, "WorkSpace is previously released.");
                }
                result = this.createWorkSpace(prop);
            } else if (!result.ofSession(sessionId) && sessionId != null) {
                if (debugEnable) {
                    Tr.debug(tc, "WorkSpace is not previously released.");
                }
                result.unsetSessionId();
                result = this.createWorkSpace(prop);
            } else {
                if (debugEnable) {
                    Tr.debug(tc, "The same sessionId share the same WorkSpace.");
                }
                result = null;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWorkSpace, WS: " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkSpace getWorkSpace(Properties prop) throws WorkSpaceException {
        String id = prop.getProperty("workspace.user.id");
        String sessionId = prop.getProperty("workspace.session.id");
        boolean debugEnable = tc.isDebugEnabled();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getWorkSpace, UserID: " + id + ", SessionID: " + sessionId);
        }
        WorkSpaceImpl result = null;
        Map map = this.workspaces;
        synchronized (map) {
            result = (WorkSpaceImpl)this.workspaces.get(id);
            if (result == null) {
                result = this.createWorkSpace(prop);
            } else if (!result.isValid()) {
                if (debugEnable) {
                    Tr.debug(tc, "WorkSpace is previously released.");
                }
                result = this.createWorkSpace(prop);
            } else if (!result.ofSession(sessionId) && sessionId != null) {
                if (debugEnable) {
                    Tr.debug(tc, "WorkSpace is not previously released.");
                }
                result.unsetSessionId();
                result = this.createWorkSpace(prop);
            } else if (debugEnable) {
                Tr.debug(tc, "The same sessionId share the same WorkSpace.");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getWorkSpace, WS: " + result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseWorkSpace(String id, String sessionId) throws WorkSpaceException {
        WorkSpaceImpl ws = null;
        Map map = this.workspaces;
        synchronized (map) {
            ws = (WorkSpaceImpl)this.workspaces.get(id);
        }
        if (ws != null && ws.isValid()) {
            if (ws.ofSession(sessionId)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "releaseWorkSpace, UserID: " + id + ", SessionID: " + sessionId);
                }
                ws.unsetSessionId();
                map = this.workspaces;
                synchronized (map) {
                    this.workspaces.remove(id);
                }
                WorkSpaceManagerImpl workSpaceManagerImpl = this;
                if (workSpaceManagerImpl.mbean.isActive()) {
                    this.mbean.workSpaceRemoved(id);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "releaseWorkSpace, Wrong SessionID: " + sessionId);
            }
        }
    }

    public void releaseWorkSpace(String id) throws WorkSpaceException {
        this.releaseWorkSpace(id, null);
    }

    public void removeWorkSpace(String id) throws WorkSpaceException {
        this.removeWorkSpace(id, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeWorkSpace(String id, String sessionId) throws WorkSpaceException {
        WorkSpaceImpl ws = null;
        Object object = this.removeWorkSpacesLock;
        synchronized (object) {
            ws = (WorkSpaceImpl)this.workspaces.get(id);
        }
        if (ws != null) {
            if (ws.ofSession(sessionId)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "removeWorkSpace, UserID: " + id + ", SessionID: " + sessionId);
                }
                ws.remove();
                ws.unsetSessionId();
                object = this.workspaces;
                synchronized (object) {
                    this.workspaces.remove(id);
                }
                WorkSpaceManagerImpl workSpaceManagerImpl = this;
                if (workSpaceManagerImpl.mbean.isActive()) {
                    this.mbean.workSpaceRemoved(id);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removeWorkSpace, Wrong SessionID: " + sessionId);
            }
        }
    }

    private ClassLoader getClassLoader() {
        if (this.classLoader == null) {
            this.classLoader = ExtClassLoader.getInstance();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getClassLoader, extClassLoader: " + this.classLoader);
            }
        }
        if (this.classLoader == null) {
            this.classLoader = Thread.currentThread().getContextClassLoader();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getClassLoader, contextClassLoader: " + this.classLoader);
            }
        }
        if (this.classLoader == null) {
            this.classLoader = this.getClass().getClassLoader();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getClassLoader, classLoader: " + this.classLoader);
            }
        }
        return this.classLoader;
    }

    Class getClassOfType(String className) throws Exception {
        Object c = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getClassOfType, className: " + className);
        }
        try {
            return Class.forName(className);
        }
        catch (Exception e) {
            return Class.forName(className, true, this.getClassLoader());
        }
    }

    private Object getInstanceOfType(String className) throws Exception {
        Class c = this.getClassOfType(className);
        return c.newInstance();
    }

    private String getCallStack() {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        String callStack = "";
        for (int i = 0; i < ste.length; ++i) {
            callStack = callStack + "    " + ste[i] + "\n";
        }
        return callStack;
    }
}

