/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.WorkSpaceAccessDeniedException;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.impl.WorkSpaceConstant;
import java.text.MessageFormat;
import java.util.ResourceBundle;

public class WorkSpaceLogger
implements WorkSpaceConstant {
    public static void logAudit(TraceComponent tc, String str, Object[] params) {
        String key = WorkSpaceLogger.getKey(str);
        Tr.audit(tc, key, params);
    }

    static void logAudit(TraceComponent tc, String str, boolean selfCorrection) {
        String WSINFO_BUNDLE = "com.ibm.ws.sm.workspace.impl.workspaceText";
        String key = WorkSpaceLogger.getKey(str);
        String status = selfCorrection ? "WKSP2000.Enabled" : "WKSP2000.Disabled";
        String param = "";
        try {
            param = MessageFormat.format(ResourceBundle.getBundle(WSINFO_BUNDLE).getString(status), null);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Got unexpected exception when translate text of status: " + status, e);
            }
            param = selfCorrection ? "ENABLED" : "DISABLED";
        }
        Tr.audit(tc, key, param);
    }

    public static WorkSpaceException createException(TraceComponent tc, String str) {
        return WorkSpaceLogger.createException(tc, str, null, null);
    }

    public static WorkSpaceException createException(TraceComponent tc, String str, Object[] params) {
        return WorkSpaceLogger.createException(tc, str, params, null);
    }

    public static WorkSpaceException createException(TraceComponent tc, String str, Object[] params, Throwable e) {
        String key = WorkSpaceLogger.getKey(str);
        String message = params == null ? str : MessageFormat.format(str, params);
        WorkSpaceException out = e == null ? new WorkSpaceException(message) : new WorkSpaceException(message, e);
        Tr.error(tc, key, params);
        if (e != null && e.getMessage() != null) {
            Tr.error(tc, e.getMessage());
        }
        return out;
    }

    static WorkSpaceException createAccessDeniedException(TraceComponent tc, String str, Object[] params, Throwable e) {
        String key = WorkSpaceLogger.getKey(str);
        String message = params == null ? str : MessageFormat.format(str, params);
        WorkSpaceAccessDeniedException out = e == null ? new WorkSpaceAccessDeniedException(message) : new WorkSpaceAccessDeniedException(message, e);
        Tr.error(tc, key, params);
        if (e != null && e.getMessage() != null) {
            Tr.error(tc, e.getMessage());
        }
        return out;
    }

    public static WorkSpaceException createException(TraceComponent tc, String key, Throwable e) {
        WorkSpaceException out = new WorkSpaceException(key, e);
        Tr.error(tc, key, new Object[]{e});
        Tr.error(tc, e.getMessage());
        return out;
    }

    private static String getKey(String str) {
        return str.substring(0, 8);
    }

    public static final TraceComponent registerTC(Class aClass) {
        return Tr.register(aClass, "WorkSpace", "com.ibm.ws.sm.workspace.impl.workspaceNLS");
    }
}

