/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpaceException;
import com.ibm.ws.sm.workspace.WorkSpaceFile;
import com.ibm.ws.sm.workspace.impl.RepositoryContextImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceConstant;
import com.ibm.ws.sm.workspace.impl.WorkSpaceImpl;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.impl.WorkSpacePersistentObjectImpl;
import com.ibm.ws.sm.workspace.metadata.RepositoryDocumentType;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.util.Enumeration;

public final class WorkSpaceFileImpl
implements WorkSpaceFile,
WorkSpaceConstant {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(WorkSpaceFileImpl.class);
    private RepositoryContext context;
    private RepositoryDocumentType type = null;
    private FileAccessor fa = null;
    private WorkSpacePersistentObjectImpl data;

    WorkSpaceFileImpl(RepositoryContext context, String name) {
        this.context = context;
        this.data = new WorkSpacePersistentObjectImpl(name);
        WorkSpaceImpl ws = (WorkSpaceImpl)context.getWorkSpace();
        this.fa = ws.getFileAccessor();
    }

    public RepositoryContext getContext() {
        return this.context;
    }

    public String getFileName() {
        return this.getName().replace('/', FILE_SEPERATOR_CHAR);
    }

    public String getName() {
        return this.data.getName();
    }

    public String getPath() {
        StringBuffer path = new StringBuffer(this.context.getPath());
        path.append(FILE_SEPERATOR);
        path.append(this.getFileName());
        return path.toString();
    }

    public Integer getState() {
        return this.data.getState();
    }

    public String getURI() {
        StringBuffer uri = new StringBuffer(this.context.getURI());
        if (uri.length() > 0) {
            uri.append('/');
        }
        uri.append(this.getName());
        return uri.toString();
    }

    public RepositoryDocumentType getType() {
        if (this.type == null) {
            this.type = this.context.getType().getChildDocumentType(this.getName());
        }
        return this.type;
    }

    public String getProperty(String name) {
        return this.data.getProperty(name);
    }

    public void setProperty(String name, String value) throws WorkSpaceException {
        this.data.setProperty(name, value);
        ((RepositoryContextImpl)this.context).save(false, false);
    }

    public Enumeration getPropertyNames() {
        return this.data.getPropertyNames();
    }

    public String removeProperty(String name) throws WorkSpaceException {
        String value = this.data.removeProperty(name);
        ((RepositoryContextImpl)this.context).save(false, false);
        return value;
    }

    void restore(String token) throws WorkSpaceException {
        this.data.restore(token);
    }

    public String getPersistData() {
        return this.data.getPersistData();
    }

    void setState(Integer state) {
        this.data.setState(state);
    }

    public String toString() {
        return this.getURI();
    }
}

