/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.sm.workspace.impl.RepositoryContextAdapter;
import com.ibm.ws.sm.workspace.impl.RepositoryContextPluggable;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.ws.sm.workspace.metadata.RepositoryMetaData;
import java.util.HashMap;

public class RepositoryContextAdapterManager {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(RepositoryContextAdapterManager.class);
    private static ClassLoader classLoader = null;
    private static RepositoryContextAdapterManager manager = null;
    private HashMap maps;

    public static RepositoryContextAdapterManager getManager() {
        if (manager == null) {
            manager = new RepositoryContextAdapterManager();
        }
        return manager;
    }

    public RepositoryContextAdapter getAdapter(RepositoryContextPluggable context) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAdapter, Context: " + context);
        }
        this.initMap(context.getWorkSpace().getMetaData());
        String adapterName = (String)this.maps.get(context.getType());
        RepositoryContextAdapter adapter = null;
        if (adapterName != null) {
            adapter = this.createAdapter(adapterName);
        }
        if (adapter == null) {
            adapter = this.getDefaultAdapter();
        }
        adapter.setContext(context);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAdapter, Context: " + context + ", Adapter: " + adapter);
        }
        return adapter;
    }

    private void initMap(RepositoryMetaData metaData) {
        if (this.maps == null) {
            this.maps = new HashMap();
        }
    }

    private RepositoryContextAdapter getDefaultAdapter() {
        return new RepositoryContextAdapter();
    }

    private RepositoryContextAdapter createAdapter(String adapterName) {
        try {
            return (RepositoryContextAdapter)this.getInstanceOfType(adapterName);
        }
        catch (Exception e) {
            Tr.debug(tc, "unable to instantiate adapter class", e);
            return null;
        }
    }

    private ClassLoader getClassLoader() {
        if (classLoader == null) {
            classLoader = ExtClassLoader.getInstance();
        }
        if (classLoader == null) {
            classLoader = Thread.currentThread().getContextClassLoader();
        }
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
        }
        return classLoader;
    }

    Class getClassOfType(String className) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getClassOfType", new Object[]{className});
        }
        Class<?> c = null;
        c = Class.forName(className, true, this.getClassLoader());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getClassOfType");
        }
        return c;
    }

    private Object getInstanceOfType(String className) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstanceOfType", new Object[]{className});
        }
        Class c = this.getClassOfType(className);
        Object o = c.newInstance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstanceOfType", o);
        }
        return o;
    }
}

