/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sm.workspace.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sm.workspace.impl.WorkSpaceConstant;
import com.ibm.ws.sm.workspace.impl.WorkSpaceLogger;
import com.ibm.wsspi.configarchive.DefaultFileAccessor;
import com.ibm.wsspi.configarchive.FileAccessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class FileAccessorUtil {
    private static TraceComponent tc = WorkSpaceLogger.registerTC(FileAccessorUtil.class);
    public static final int FOLDER = 0;
    public static final int DOCUMENT = 1;
    public static final int BOTH = 2;
    public static final int FULL = -1;
    public static final int SELF = 0;
    public static final int ONE = 1;
    private static String needTrace = null;
    private static final String[] listType = new String[]{"FOLDER", "DOCUMENT", "BOTH"};

    public static void deleteTree(FileAccessor fa, String uri) {
        if (tc.isEntryEnabled() && needTrace == null) {
            Tr.entry(tc, "deleteTree \"" + uri + "\"");
            needTrace = uri;
        }
        List f = null;
        try {
            f = fa.listFolders(uri);
        }
        catch (Exception e) {
            f = new ArrayList();
        }
        Object[] lst = f.toArray();
        for (int i = 0; i < lst.length; ++i) {
            FileAccessorUtil.deleteTree(fa, (String)lst[i]);
        }
        try {
            f = fa.listFiles(uri);
        }
        catch (Exception e) {
            f = new ArrayList();
        }
        lst = f.toArray();
        for (int i = 0; i < lst.length; ++i) {
            FileAccessorUtil.delete(fa, (String)lst[i]);
        }
        FileAccessorUtil.delete(fa, uri);
        if (uri.equals(needTrace)) {
            needTrace = null;
        }
        if (tc.isEntryEnabled() && needTrace == null) {
            Tr.exit(tc, "deleteTree \"" + uri + "\"");
        }
    }

    public static void delete(FileAccessor fa, String uri) {
        try {
            fa.delete(uri);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "  delete " + uri);
        }
    }

    public static List listFiles(FileAccessor fa, String uri, int type, int depth) {
        ArrayList result = new ArrayList();
        FileAccessorUtil.listFiles(fa, uri, type, depth, result);
        return result;
    }

    private static void listFiles(FileAccessor fa, String uri, int type, int depth, List result) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listFiles (URI: " + uri + ", Type: " + listType[type] + ", Depth: " + depth + ")");
        }
        if (depth == 0) {
            try {
                if (fa.exists(uri)) {
                    result.add(uri);
                }
            }
            catch (Exception e) {
                String msg = "";
                if (fa instanceof DefaultFileAccessor) {
                    DefaultFileAccessor dfa = (DefaultFileAccessor)fa;
                    msg = "listFiles (" + dfa.getRootDir().getPath() + File.separator + uri + ") failed with unexpected exception, " + e;
                } else {
                    msg = "listFiles (" + uri + ") failed with unexpected exception, " + e;
                }
                FFDCFilter.processException(e, "com.ibm.ws.sm.workspace.impl.FileAccessorUtil.listFiles", "115");
                Tr.warning(tc, msg);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "listFiles");
            }
            return;
        }
        List f = null;
        Object[] lst = null;
        if (type == 1 || type == 2) {
            try {
                f = fa.listFiles(uri);
            }
            catch (Exception e) {
                f = new ArrayList();
            }
            lst = f.toArray();
            for (int i = 0; i < lst.length; ++i) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding " + lst[i]);
                }
                result.add(lst[i]);
            }
        }
        f = null;
        try {
            f = fa.listFolders(uri);
        }
        catch (Exception e) {
            f = new ArrayList();
        }
        lst = f.toArray();
        for (int i = 0; i < lst.length; ++i) {
            if (type == 2 || type == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding " + lst[i]);
                }
                result.add(lst[i]);
            }
            if (depth == 1) continue;
            FileAccessorUtil.listFiles(fa, (String)lst[i], type, depth == -1 ? -1 : depth - 1, result);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listFiles", result);
        }
    }

    public static void makeDir(FileAccessor fa, String dir) throws IOException {
        try {
            fa.makeDir(dir);
        }
        catch (IOException e) {
            String msg = "";
            if (fa instanceof DefaultFileAccessor) {
                DefaultFileAccessor dfa = (DefaultFileAccessor)fa;
                msg = "makeDir (" + dfa.getRootDir().getPath() + File.separator + dir + ") failed with unexpected exception, " + e;
            } else {
                msg = "makeDir (" + dir + ") failed with unexpected exception, " + e;
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.sm.workspace.impl.FileAccessorUtil.makeDir", "165", new Object[]{msg});
            throw e;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "makeDir " + dir + " complete.");
        }
    }

    private static String getCallStack() {
        StackTraceElement[] ste = new Throwable().getStackTrace();
        String callStack = "";
        for (int i = 0; i < ste.length; ++i) {
            callStack = callStack + "    " + ste[i] + "\n";
        }
        return callStack;
    }

    public static boolean exist(FileAccessor fa, String uri) {
        boolean ret = false;
        try {
            ret = fa.exists(uri);
        }
        catch (Exception e) {
            ret = false;
        }
        if (!(!tc.isDebugEnabled() || ret && uri.startsWith(".workspace_"))) {
            Tr.debug(tc, "  exist [" + (ret ? "1" : "0") + "] \"" + uri + "\"");
        }
        return ret;
    }

    public static void copyFile(FileAccessor fa, String inputFileName, String outputFileName) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "copyFile (" + inputFileName + " " + outputFileName + ")");
        }
        InputStream is = fa.load(inputFileName);
        fa.save(outputFileName, is);
        if (is instanceof FileInputStream) {
            is.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "copyFile");
        }
    }

    public static String convertToURI(String name) throws IOException {
        return name;
    }

    public static InputStream getInputStream(FileAccessor fa, String uri) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInputStream (" + uri + ")");
        }
        InputStream is = fa.load(uri);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInputStream");
        }
        return is;
    }

    public static OutputStream getOutputStream(FileAccessor fa, String uri) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOutputStream (" + uri + ")");
        }
        OutputStream os2 = fa.getOutputStream(uri);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOutputStream", os2);
        }
        return os2;
    }

    public static void deleteUserPath(FileAccessor fa, String uri) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteUserPath (" + uri + ")");
        }
        try {
            if (fa instanceof DefaultFileAccessor) {
                DefaultFileAccessor dfa = (DefaultFileAccessor)fa;
                File rootDir = dfa.getRootDir();
                String rootPath = rootDir.getPath();
                String userPath = rootPath.substring(0, rootPath.lastIndexOf(File.separatorChar));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "UserPath ", userPath);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "RootPath ", rootPath);
                }
                if (userPath.equals(uri.replace('/', WorkSpaceConstant.FILE_SEPERATOR_CHAR))) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "deletingUserPath ", userPath);
                    }
                    dfa.deleteRootDir();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteUserPath");
        }
    }

    public static void createNewFile(FileAccessor fa, String uri) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNewFile (" + uri + ")");
        }
        try {
            if (fa instanceof DefaultFileAccessor) {
                DefaultFileAccessor dfa = (DefaultFileAccessor)fa;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Creating new file");
                }
                dfa.createNewFile(uri);
            }
        }
        catch (IOException e) {
            String msg = "";
            if (fa instanceof DefaultFileAccessor) {
                DefaultFileAccessor dfa = (DefaultFileAccessor)fa;
                msg = "createNewFile (" + dfa.getRootDir().getPath() + File.separator + uri + ") failed with unexpected exception, " + e;
            } else {
                msg = "createNewFile (" + uri + ") failed with unexpected exception, " + e;
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.sm.workspace.impl.FileAccessorUtil.createNewFile", "260", new Object[]{msg});
            throw e;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createNewFile");
        }
    }

    public static long getLength(FileAccessor fa, String uri) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLength (" + uri + ")");
        }
        long l = 1L;
        try {
            if (fa instanceof DefaultFileAccessor) {
                DefaultFileAccessor dfa = (DefaultFileAccessor)fa;
                l = dfa.getLength(uri);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLength return " + l);
        }
        return l;
    }

    public static String getFullPath(FileAccessor fa, String uri) {
        String fullPath = uri;
        if (fa instanceof DefaultFileAccessor) {
            DefaultFileAccessor dfa = (DefaultFileAccessor)fa;
            fullPath = dfa.getFullPath(uri);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getFullPath return " + fullPath);
        }
        return fullPath;
    }
}

