/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.zOS.threadid;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.csi.EJBComponentMetaData;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.j2c.WSLoginLocalOSExtension;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.zOS.NativeConfiguration;
import com.ibm.ws.security.zOS.PlatformCredentialManager;
import com.ibm.ws.security.zOS.SAFServiceResult;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.ws.util.WSThreadLocal;
import com.ibm.ws.webcontainer.metadata.WebComponentMetaData;
import com.ibm.ws.webcontainer.metadata.WebModuleMetaDataImpl;
import java.util.Iterator;
import javax.security.auth.Subject;

public final class ThreadIdentityManager
implements WSLoginLocalOSExtension {
    private static final TraceComponent tc = Tr.register(ThreadIdentityManager.class, "Security", "com.ibm.ejs.resources.security");
    private static final ThreadLocal _threadIdentity = new WSThreadLocal(){

        protected Object initialValue() {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "_threadIdentity.initialValue");
            }
            PlatformCredential cred = PlatformCredentialManager.instance().createServerCredential();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_threadIdentity.initialValue", cred);
            }
            return cred;
        }

        public String toString() {
            return this.get().toString();
        }
    };
    private static final ThreadLocal _appSyncData = new WSThreadLocal(){

        protected Object initialValue() {
            return new Boolean(false);
        }
    };
    private static ThreadIdentityManager _instance;
    private ComponentMetaDataAccessorImpl _cmda = null;
    private PlatformCredentialManager _platformCredManager;

    public static ThreadIdentityManager getThreadIdentityManager() {
        if (_instance == null) {
            _instance = new ThreadIdentityManager();
        }
        return _instance;
    }

    private ThreadIdentityManager() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        this._platformCredManager = PlatformCredentialManager.instance();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public boolean isSyncToThreadEnabled() {
        return NativeConfiguration.getConfig().isConnectionManagementThreadIdentityEnabled();
    }

    public boolean isApplicationSyncToOSThreadEnabled() {
        return NativeConfiguration.getConfig().isApplicationSyncToThreadEnabled();
    }

    public boolean isThreadLocalApplicationSyncEnabled() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isThreadLocalApplicationSyncEnabled");
        }
        Boolean enabled = (Boolean)_appSyncData.get();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isThreadLocalApplicationSyncEnabled", enabled);
        }
        return enabled;
    }

    public void setThreadLocalApplicationSyncEnabled(boolean syncEnabled) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setThreadLocalApplicationSyncEnabled", new Boolean(syncEnabled));
        }
        _appSyncData.set(new Boolean(syncEnabled));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setThreadLocalApplicationSyncEnabled");
        }
    }

    public Subject getLocalOSInvocationSubject() throws IllegalStateException {
        Subject subject;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getLocalOSInvocationSubject");
            }
            if ((subject = this.getInvocationSubject()) == null) {
                try {
                    ContextManager contextManager = ContextManagerFactory.getInstance();
                    subject = contextManager.getServerSubject();
                }
                catch (WSSecurityException wse) {
                    if (!tc.isDebugEnabled()) break block5;
                    Tr.debug(tc, "Unable to get server subject", wse);
                }
            }
        }
        subject = this.extractJ2CSubject(subject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalOSInvocationSubject", subject);
        }
        return subject;
    }

    public Subject getLocalOSOwnSubject() {
        Subject serverSubject;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getLocalOSOwnSubject");
            }
            serverSubject = null;
            ContextManager contextManager = ContextManagerFactory.getInstance();
            if (this.isSyncToThreadEnabled()) {
                try {
                    serverSubject = this.extractJ2CSubject(contextManager.getInvocationSubject());
                }
                catch (Exception ge) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getLocalOSOwnSubject", ge);
                    }
                    break block9;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Connection management sync to thread is disabled, just getting the server subject.");
            }
            try {
                serverSubject = contextManager.getServerSubject();
                serverSubject = this.extractJ2CSubject(serverSubject);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "getLocalOSOwnSubject", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalOSOwnSubject", serverSubject);
        }
        return serverSubject;
    }

    public Subject getLocalOSServerSubject() {
        Subject serverSubject;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getLocalOSServerSubject");
            }
            serverSubject = null;
            ContextManager contextManager = ContextManagerFactory.getInstance();
            try {
                serverSubject = contextManager.getServerSubject();
                serverSubject = this.extractJ2CSubject(serverSubject);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "getLocalOSServerSubject", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalOSServerSubject", serverSubject);
        }
        return serverSubject;
    }

    public Subject getLocalOSPlatformCredSubject() {
        Subject serverSubject;
        block4: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getLocalOSPlatformCredSubject");
            }
            serverSubject = null;
            try {
                serverSubject = ContextManagerFactory.getInstance().getServerSubject();
                serverSubject = this.extractPlatformCredSubject(serverSubject);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block4;
                Tr.debug(tc, "getLocalOSPlatformCredSubject", e);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLocalOSPlatformCredSubject", serverSubject);
        }
        return serverSubject;
    }

    private Subject extractJ2CSubject(Subject j2eeSubject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractJ2CSubject", j2eeSubject);
        }
        Subject j2cSubject = null;
        if (j2eeSubject != null) {
            PlatformCredential platformCred = this.getPlatformCredentialFromSubject(j2eeSubject);
            if (platformCred == null) {
                platformCred = this._platformCredManager.createDefaultCredential();
            }
            j2cSubject = platformCred.getJ2CSubject();
        } else {
            PlatformCredential serverCred = this._platformCredManager.createServerCredential();
            j2cSubject = serverCred.getJ2CSubject();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractJ2CSubject", j2cSubject);
        }
        return j2cSubject;
    }

    private Subject extractPlatformCredSubject(Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractPlatformCredSubject", subject);
        }
        Subject platformCredSubject = null;
        if (subject != null) {
            PlatformCredential platformCred = this.getPlatformCredentialFromSubject(subject);
            if (platformCred == null) {
                platformCred = this._platformCredManager.createDefaultCredential();
            }
            platformCredSubject = platformCred.getPlatformCredSubject();
        } else {
            PlatformCredential serverCred = this._platformCredManager.createServerCredential();
            platformCredSubject = serverCred.getPlatformCredSubject();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractPlatformCredSubject", platformCredSubject);
        }
        return platformCredSubject;
    }

    public Object setLocalOSThreadID(Subject subject) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLocalOSThreadID", subject);
        }
        Object threadIdentityToken = this.setLocalOSThreadID(subject, this.isSyncToThreadEnabled() || this.isApplicationSyncToOSThreadEnabled());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLocalOSThreadID", threadIdentityToken);
        }
        return threadIdentityToken;
    }

    public Object setAppLocalOSThreadID(Subject subject) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setAppLocalOSThreadID", subject);
        }
        Object threadIdentityToken = this.setLocalOSThreadID(subject, this.isApplicationSyncToOSThreadEnabled());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setAppLocalOSThreadID", threadIdentityToken);
        }
        return threadIdentityToken;
    }

    public void restoreLocalOSThreadID(Object credObj) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreLocalOSThreadID", credObj);
        }
        this.restoreLocalOSThreadID(credObj, this.isSyncToThreadEnabled() || this.isApplicationSyncToOSThreadEnabled());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreLocalOSThreadID");
        }
    }

    public void restoreAppLocalOSThreadID(Object credObj) throws IllegalStateException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreAppLocalOSThreadID", credObj);
        }
        this.restoreLocalOSThreadID(credObj, this.isApplicationSyncToOSThreadEnabled());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreAppLocalOSThreadID");
        }
    }

    private Object setLocalOSThreadID(Subject subject, boolean syncEnabled) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLocalOSThreadID", new Object[]{subject, new Boolean(syncEnabled)});
        }
        PlatformCredential currentCred = (PlatformCredential)_threadIdentity.get();
        if (syncEnabled) {
            PlatformCredential targetCred = null;
            if (subject != null) {
                targetCred = this.getPlatformCredentialFromSubject(subject);
            }
            this.setThreadSecurityEnvironment(targetCred);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLocalOSThreadID", currentCred);
        }
        return currentCred;
    }

    private void restoreLocalOSThreadID(Object credObj, boolean syncEnabled) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "restoreLocalOSThreadID", new Object[]{credObj, new Boolean(syncEnabled)});
        }
        if (syncEnabled) {
            PlatformCredential targetCred = (PlatformCredential)credObj;
            this.setThreadSecurityEnvironment(targetCred);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "restoreLocalOSThreadID");
        }
    }

    private boolean setThreadSecurityEnvironment(PlatformCredential targetCred) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setThreadSecurityEnvironment", targetCred);
        }
        boolean success = false;
        int returnCode = -1;
        PlatformCredential currentCred = (PlatformCredential)_threadIdentity.get();
        if (targetCred == null) {
            targetCred = this._platformCredManager.createServerCredential();
        }
        returnCode = currentCred.equals(targetCred) ? 0 : (targetCred.getCredentialType() == PlatformCredential.SERVER ? ThreadIdentityManager.ntv_setThreadSecurityEnvironment(null) : ThreadIdentityManager.ntv_setThreadSecurityEnvironment(targetCred));
        boolean bl = success = returnCode == 0;
        if (success) {
            _threadIdentity.set(targetCred);
        } else if (returnCode == 44) {
            _threadIdentity.set(null);
            Tr.info(tc, "security.zos.saf.threadid.sync.not.allowed.info", new Object[]{targetCred.getUserId()});
        } else {
            Tr.error(tc, "security.zos.saf.threadid.sync.error", new Object[]{targetCred.getUserId(), SAFServiceResult.getSafServiceResult()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setThreadSecurityEnvironment", new Boolean(success));
        }
        return success;
    }

    private PlatformCredential getPlatformCredentialFromSubject(Subject subject) {
        PlatformCredential platformCred;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getPlatformCredentialFromSubject", subject);
            }
            platformCred = null;
            Iterator<PlatformCredential> privateCreds = subject.getPrivateCredentials(PlatformCredential.class).iterator();
            if (privateCreds.hasNext()) {
                platformCred = privateCreds.next();
            }
            if (platformCred == null) {
                WSCredential wsCred = null;
                Iterator<WSCredential> publicCreds = subject.getPublicCredentials(WSCredential.class).iterator();
                if (publicCreds.hasNext()) {
                    wsCred = publicCreds.next();
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "WSCredential", wsCred);
                }
                if (wsCred != null) {
                    try {
                        platformCred = (PlatformCredential)wsCred.get("com.ibm.ws.security.zos.PlatformCredential");
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block10;
                        Tr.debug(tc, "Unexpected exception acquiring platform cred", e);
                    }
                }
            }
        }
        if (platformCred == null) {
            platformCred = this._platformCredManager.createDefaultCredential();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPlatformCredentialFromSubject", platformCred);
        }
        return platformCred;
    }

    private Subject getInvocationSubject() {
        Subject subject;
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getInvocationSubject");
            }
            subject = null;
            try {
                ContextManager contextManager;
                if (SecurityObjectLocator.getSecurityConfig().getBoolean("appEnabled") && (subject = (contextManager = ContextManagerFactory.getInstance()).getInvocationSubject()) == null) {
                    subject = contextManager.getCallerSubject();
                }
            }
            catch (WSSecurityException se) {
                if (!tc.isEventEnabled()) break block5;
                Tr.event(tc, "Exception acquring invocation subject", se);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInvocationSubject", subject);
        }
        return subject;
    }

    public boolean getAppSyncEnabledFromComponentMetaData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppSyncEnabledFromComponentMetaData");
        }
        boolean enabled = false;
        if (this.isApplicationSyncToOSThreadEnabled()) {
            ComponentMetaData cmd = this.getMetaDataAccessor().getComponentMetaData();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "current meta data", cmd);
            }
            if (cmd != null) {
                if (cmd instanceof EJBComponentMetaData) {
                    EJBComponentMetaData ecmd = (EJBComponentMetaData)cmd;
                    enabled = ecmd.isApplicationSyncToOSThreadEnabled();
                } else if (cmd instanceof WebComponentMetaData) {
                    WebComponentMetaData wcmd = (WebComponentMetaData)cmd;
                    WebModuleMetaDataImpl wmmd = (WebModuleMetaDataImpl)wcmd.getModuleMetaData();
                    enabled = wmmd.getWebAppConfig().isSyncToThreadEnabled();
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unknown component metadata", cmd);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppSyncEnabledFromComponentMetaData", new Boolean(enabled));
        }
        return enabled;
    }

    private ComponentMetaDataAccessorImpl getMetaDataAccessor() {
        if (this._cmda == null) {
            this._cmda = ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor();
        }
        return this._cmda;
    }

    public String toString() {
        return super.toString() + ";_syncEnabled=" + this.isSyncToThreadEnabled() + ",_appSyncEnabled=" + this.isApplicationSyncToOSThreadEnabled() + ",_threadIdentity=" + _threadIdentity;
    }

    private static native int ntv_setThreadSecurityEnvironment(PlatformCredential var0);
}

