/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.zOS.authz;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.SAFRoleMapper;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.zOS.authz.SAFRoleMapperImpl;
import java.util.HashMap;
import java.util.Properties;

public class SAFRoleMapperFactory {
    private static final TraceComponent tc = Tr.register(SAFRoleMapperFactory.class, "Security", "com.ibm.ejs.resources.security");
    private static HashMap _cache = new HashMap();

    public static synchronized SAFRoleMapper getSAFRoleMapper() {
        String domainId;
        SAFRoleMapper cachedObject;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSAFRoleMapper");
        }
        if ((cachedObject = (SAFRoleMapper)_cache.get(domainId = SecurityObjectLocator.getSecurityConfigManager().getDomainId())) == null) {
            ContextManager ctxMgr = ContextManagerFactory.getInstance();
            String mapperClassName = ctxMgr.getProperty("com.ibm.websphere.security.SAF.RoleMapper", null);
            Properties context = SAFRoleMapperFactory.getRoleMapperContext();
            if (mapperClassName != null && mapperClassName.length() > 0) {
                try {
                    cachedObject = (SAFRoleMapper)Class.forName(mapperClassName).newInstance();
                    cachedObject.initialize(context);
                    Tr.audit(tc, "security.zos.saf.role.mapper.loaded", new Object[]{mapperClassName});
                }
                catch (Throwable t) {
                    Tr.error(tc, "security.zos.saf.role.mapper.exception", new Object[]{mapperClassName, t});
                    cachedObject = null;
                }
            }
            if (cachedObject == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getSAFRoleMapper role mapper is null, newing up a SAFRoleMapperImpl", cachedObject);
                }
                cachedObject = new SAFRoleMapperImpl();
                cachedObject.initialize(context);
            }
            _cache.put(domainId, cachedObject);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getSAFRoleMapper role mapper found in cache");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSAFRoleMapper", cachedObject);
        }
        return cachedObject;
    }

    public static void releaseSAFRoleMapper() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseSAFRoleMapper");
        }
        String domainId = SecurityObjectLocator.getSecurityConfigManager().getDomainId();
        _cache.remove(domainId);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseSAFRoleMapper");
        }
    }

    private static Properties getRoleMapperContext() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRoleMapperContext");
        }
        Properties context = new Properties();
        String value = null;
        value = SecurityObjectLocator.getAdminData().getString("cellname");
        context.setProperty("CELL_NAME", value == null ? "" : value);
        value = SecurityObjectLocator.getAdminData().getString("cell.short.name");
        context.setProperty("SHORT_CELL_NAME", value == null ? "" : value);
        value = SecurityObjectLocator.getAdminData().getString("shortservername");
        context.setProperty("SERVER_NAME", value == null ? "" : value);
        value = SecurityObjectLocator.getAdminData().getString("server.short.name");
        context.setProperty("SHORT_SERVER_NAME", value == null ? "" : value);
        value = SecurityObjectLocator.getSecurityConfig().getProperty("security.zOS.domainName");
        if (value != null) {
            context.setProperty("DOMAIN_NAME", value);
        }
        if ((value = SecurityObjectLocator.getSecurityConfig().getProperty("security.zOS.domainType")) != null) {
            context.setProperty("DOMAIN_TYPE", value);
        }
        if ((value = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.security.SAF.profilePrefix")) != null) {
            context.setProperty("PROFILE_PREFIX", value);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRoleMapperContext", context);
        }
        return context;
    }
}

