/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.zOS.authz;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;

public final class SAFAuthorizationOptions {
    public static final TraceComponent tc = Tr.register(SAFAuthorizationOptions.class, "Security", "com.ibm.ejs.resources.security");
    public static final LogOption NONE = new LogOption("NONE", 1);
    public static final LogOption ASIS = new LogOption("ASIS", 2);
    public static final LogOption NOFAIL = new LogOption("NOFAIL", 3);
    private LogOption _logOption = ASIS;
    private boolean _suppressMessages = false;
    private boolean _fastauth = false;
    private String _className = null;
    private String _applId = null;

    public SAFAuthorizationOptions() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public SAFAuthorizationOptions(String className, boolean useFastauth) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{className, new Boolean(useFastauth)});
        }
        this.setResourceClass(className);
        this.setUseFastauth(useFastauth);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public void setMessageSuppression(boolean suppressMessages) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setMessageSuppression", new Boolean(suppressMessages));
        }
        this._suppressMessages = suppressMessages;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setMessageSuppression");
        }
    }

    public boolean getMessageSuppression() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMessageSuppression");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMessageSuppression", new Boolean(this._suppressMessages));
        }
        return this._suppressMessages;
    }

    public void setLogOption(LogOption logOption) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLogOption", logOption);
        }
        this._logOption = logOption;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLogOption");
        }
    }

    public LogOption getLogOption() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getLogOption");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getLogOption", this._logOption);
        }
        return this._logOption;
    }

    public void setResourceClass(String className) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setResourceClass", className);
        }
        this._className = className;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setResourceClass");
        }
    }

    public String getResourceClass() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceClass");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceClass", this._className);
        }
        return this._className;
    }

    public void setApplicationId(String applicationId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setApplicationId", applicationId);
        }
        this._applId = applicationId;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setApplicationId");
        }
    }

    public String getApplicationId() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplicationId");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplicationId", this._applId);
        }
        return this._applId;
    }

    public void setUseFastauth(boolean useFastauth) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setUseFastauth", new Boolean(useFastauth));
        }
        this._fastauth = useFastauth;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setUseFastauth");
        }
    }

    public boolean getUseFastauth() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUseFastauth");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUseFastauth", new Boolean(this._fastauth));
        }
        return this._fastauth;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append("\n          RACROUTE REQUEST=");
        sb.append(this._fastauth ? "FASTAUTH" : "AUTH");
        sb.append("\n                CLASS=").append(this._className);
        sb.append("\n                LOG=").append(this._logOption);
        sb.append("\n                MSGSUPP=");
        sb.append(this._suppressMessages ? "YES" : "NO");
        sb.append("\n                APPL=").append(this._applId);
        return sb.toString();
    }

    public static final class LogOption {
        private String _name;
        private int _value;

        LogOption(String optionName, int optionValue) {
            this._name = optionName;
            this._value = optionValue;
        }

        int getValue() {
            return this._value;
        }

        public String toString() {
            return this._name;
        }

        public int hashCode() {
            return this._value;
        }
    }
}

