/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.zOS;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.auth.AuthenticationFailedException;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.security.auth.Cache;
import com.ibm.ws.security.auth.CacheEvictionListener;
import com.ibm.ws.security.auth.CacheException;
import com.ibm.ws.security.auth.PlatformCredential;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.auth.WSPasswordCheckFailedException;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.util.AccessController;
import com.ibm.ws.security.zOS.SAFCredentialTokenImpl;
import com.ibm.ws.security.zOS.SAFServiceResult;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Set;
import javax.security.auth.Subject;

public final class PlatformCredentialManager {
    public static final String DEFAULT_UNAUTHENTICATED_AUDIT_STRING = "WebSphere Default/Unauthenticated Login";
    private static final String DEFAULT_PASSWORD_AUDIT_STRING = "WebSphere Userid/Password Login";
    private static final String DEFAULT_CERTIFICATE_AUDIT_STRING = "WebSphere Certificate Login";
    private static final String DEFAULT_AUTHORIZED_CREATE_AUDIT_STRING = "WebSphere Authorized Login";
    private static final String DEFAULT_SERVER_AUDIT_STRING = "WebSphere Server Identity";
    private static final TraceComponent tc = Tr.register(PlatformCredentialManager.class, "Security", "com.ibm.ejs.resources.security");
    private static final PlatformCredentialManager _instance = new PlatformCredentialManager();
    private Cache _cache;

    public static PlatformCredentialManager instance() {
        return _instance;
    }

    private PlatformCredentialManager() {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>");
        }
        int initialSize = 100;
        long timeout = 300000L;
        int entryLimit = 5000;
        this._cache = new Cache(initialSize, timeout, entryLimit, new CacheEvictionCallback());
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public PlatformCredential createPasswordCredential(String userId, String password) throws PasswordCheckFailedException {
        return this.createPasswordCredential(userId, password, DEFAULT_PASSWORD_AUDIT_STRING);
    }

    public PlatformCredential createCertificateCredential(X509Certificate[] certChain) throws CertificateMapFailedException {
        return this.createCertificateCredential(certChain, DEFAULT_CERTIFICATE_AUDIT_STRING);
    }

    public PlatformCredential createCredential(String userId) {
        return this.createCredential(userId, DEFAULT_AUTHORIZED_CREATE_AUDIT_STRING);
    }

    public PlatformCredential createDefaultCredential() {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "createDefaultCredential");
        }
        PlatformCredential pc = new PlatformCredential();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "createDefaultCredential", pc);
        }
        return pc;
    }

    public PlatformCredential createPasswordCredential(String userId, String password, String auditString) throws PasswordCheckFailedException {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "createPasswordCredential", new Object[]{userId, password != null ? "****" : null, auditString});
        }
        PlatformCredential pc = new PlatformCredential(PlatformCredential.BASIC, userId, auditString);
        try {
            this.authenticateCredential(pc, password);
        }
        catch (PasswordCheckFailedException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new PasswordCheckFailedException();
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "createPasswordCredential", pc);
        }
        return pc;
    }

    public PlatformCredential createCertificateCredential(X509Certificate[] certChain, String auditString) throws CertificateMapFailedException {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "createCertificateCredential", new Object[]{certChain, auditString});
        }
        PlatformCredential pc = new PlatformCredential(certChain, auditString);
        try {
            this.authenticateCredential(pc, null);
        }
        catch (Throwable t) {
            throw new CertificateMapFailedException();
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "createCertificateCredential", pc);
        }
        return pc;
    }

    public PlatformCredential createRoleCredential(String appName, String roleName, String profile) {
        PlatformCredential pc;
        boolean isAnyTracingEnabled;
        block6: {
            isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
            if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                Tr.entry(tc, "createRoleCredential", new Object[]{appName, roleName, profile});
            }
            String auditString = this.createRoleAuditString(appName, roleName, profile);
            pc = new PlatformCredential(PlatformCredential.ROLE, profile, auditString);
            try {
                SAFCredentialTokenImpl token = this.getCredentialToken(pc);
                if (token != null) {
                    pc.setMvsUserId(token.getMvsUserId());
                } else {
                    pc = null;
                }
            }
            catch (CredentialDestroyedException cde) {
                if (!isAnyTracingEnabled || !tc.isEntryEnabled()) break block6;
                Tr.debug(tc, "Credential destroyed", cde);
            }
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "createRoleCredential", pc);
        }
        return pc;
    }

    public PlatformCredential createCredential(String userId, String auditString) {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "createCredential", new Object[]{userId, auditString});
        }
        PlatformCredential pc = new PlatformCredential(PlatformCredential.ASSERTED, userId, auditString);
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "createCredential", pc);
        }
        return pc;
    }

    public PlatformCredential createServerCredential() {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "createServerCredential");
        }
        String serverUserId = System.getProperty("user.name");
        String auditString = DEFAULT_SERVER_AUDIT_STRING;
        PlatformCredential pc = new PlatformCredential(PlatformCredential.SERVER, serverUserId, DEFAULT_SERVER_AUDIT_STRING);
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "createServerCredential", pc);
        }
        return pc;
    }

    private String createRoleAuditString(String appName, String roleName, String profile) {
        StringBuffer sb = new StringBuffer("WebSphere Role Delegation:");
        sb.append(" Application=").append(appName);
        sb.append(",Role=").append(roleName);
        sb.append(",Profile=").append(profile);
        return sb.toString();
    }

    public String getKeyFromCredential(PlatformCredential cred) {
        String key;
        boolean isAnyTracingEnabled;
        block6: {
            isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
            if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                Tr.entry(tc, "getKeyFromCredential", cred);
            }
            key = null;
            try {
                SAFCredentialTokenImpl token = this.getCredentialToken(cred);
                if (token == null) {
                    if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                        Tr.debug(tc, "Unable to get native credential token from PlatFormCredential");
                    }
                    throw new IllegalArgumentException("Unable to get native credential token from PlatFormCredential");
                }
                key = token.getAsString();
                this._cache.insert(key, cred);
            }
            catch (CredentialDestroyedException cde) {
                if (!isAnyTracingEnabled || !tc.isEntryEnabled()) break block6;
                Tr.debug(tc, "Credential already destroyed", cde);
            }
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "getKeyFromCredential", key);
        }
        return key;
    }

    public PlatformCredential getCredentialFromKey(String credTokenKey) {
        PlatformCredential pc;
        boolean isAnyTracingEnabled;
        block4: {
            isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
            if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                Tr.entry(tc, "getCredentialFromKey", credTokenKey);
            }
            pc = null;
            try {
                pc = (PlatformCredential)this._cache.get(credTokenKey);
            }
            catch (CacheException ce) {
                if (!isAnyTracingEnabled || !tc.isEntryEnabled()) break block4;
                Tr.debug(tc, "Unexpected cache exception", ce);
            }
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "getCredentialFromKey", pc);
        }
        return pc;
    }

    public byte[] createUtoken(PlatformCredential pc) {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "createUtoken", pc);
        }
        byte[] utoken = this.ntv_createUtoken(pc);
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "createUtoken", utoken);
        }
        return utoken;
    }

    public String mapKerbPrincipal(String kerbPrincipal) {
        String userId;
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "mapKerbPrincipal", kerbPrincipal);
        }
        if (kerbPrincipal == null || kerbPrincipal.length() == 0) {
            if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit(tc, "The kerberos principal passed in is either null or an empty string, returning a null userid.");
            }
            return null;
        }
        if (kerbPrincipal.indexOf("@") != -1) {
            String myRealm = kerbPrincipal.substring(kerbPrincipal.indexOf("@") + 1);
            String myPrincipal = kerbPrincipal.substring(0, kerbPrincipal.indexOf("@"));
            SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
            String defaultRealm = security2.getActiveAuthMechanism().getString("krb5Realm");
            kerbPrincipal = myRealm.equals(defaultRealm) ? myPrincipal : "/.../" + myRealm.toUpperCase() + "/" + myPrincipal.toUpperCase();
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.debug(tc, "Going to call the native mapKerbPrincipal, the effective principal is: " + kerbPrincipal);
        }
        if ((userId = this.ntv_mapKerbPrincipal(kerbPrincipal)) == null || userId.length() == 0) {
            Tr.warning(tc, "security.zos.saf.authen.kerb.map.failed.warning", new Object[]{kerbPrincipal, SAFServiceResult.getSafServiceResult()});
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "mapKerbPrincipal", userId);
        }
        return userId;
    }

    private synchronized SAFCredentialTokenImpl getCredentialToken(PlatformCredential pc) throws CredentialDestroyedException {
        SAFCredentialTokenImpl credToken;
        boolean isAnyTracingEnabled;
        block5: {
            isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
            if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                Tr.entry(tc, "getCredentialToken", pc);
            }
            credToken = null;
            try {
                credToken = (SAFCredentialTokenImpl)this._cache.get(pc);
            }
            catch (CacheException ce) {
                if (!isAnyTracingEnabled || !tc.isEntryEnabled()) break block5;
                Tr.debug(tc, "Unexpected cache exception", ce);
            }
        }
        if (credToken == null) {
            credToken = this.refreshCredential(pc);
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "getCredentialToken", credToken);
        }
        return credToken;
    }

    private synchronized SAFCredentialTokenImpl refreshCredential(PlatformCredential pc) throws CredentialDestroyedException {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "refreshCredential", pc);
        }
        if (pc.getCredentialType() == PlatformCredential.BASIC && !pc.isAuthenticated()) {
            throw new CredentialDestroyedException();
        }
        SAFCredentialTokenImpl cachedToken = null;
        SAFCredentialTokenImpl credToken = null;
        String APPLName = this.getAPPLName();
        try {
            cachedToken = (SAFCredentialTokenImpl)this._cache.get(pc);
        }
        catch (Exception e) {
            if (tc.isEventEnabled()) {
                Tr.event(tc, "Cache failure", e);
            }
            cachedToken = null;
        }
        if (cachedToken != null) {
            credToken = cachedToken;
        } else if (pc.getCredentialType() == PlatformCredential.DEFAULT) {
            credToken = this.ntv_createCredentialToken(pc, pc.getUserId(), pc.getAuditString(), null, APPLName);
        } else if (pc.getCredentialType() == PlatformCredential.BASIC) {
            credToken = this.ntv_createCredentialToken(pc, pc.getUserId(), pc.getAuditString(), null, APPLName);
        } else if (pc.getCredentialType() == PlatformCredential.ASSERTED) {
            credToken = this.ntv_createCredentialToken(pc, pc.getUserId(), pc.getAuditString(), null, APPLName);
        } else if (pc.getCredentialType() == PlatformCredential.ROLE) {
            credToken = this.ntv_createRoleCredentialToken(pc, pc.getRoleProfile(), pc.getAuditString(), APPLName);
            if (credToken != null) {
                credToken.setMvsUserId(pc.getUserId());
            }
        } else if (pc.getCredentialType() == PlatformCredential.SERVER) {
            credToken = this.ntv_createServerCredentialToken(pc);
        } else if (pc.getCredentialType() == PlatformCredential.CERTIFICATE) {
            byte[] encodedCert = this.getEncodedCertificate(pc);
            credToken = this.ntv_createCertificateCredentialToken(pc, encodedCert, encodedCert.length, pc.getAuditString(), APPLName);
        } else {
            throw new IllegalArgumentException();
        }
        if (cachedToken == null && credToken != null) {
            this._cache.insert(pc, credToken);
        } else if (credToken == null) {
            Tr.error(tc, "security.zos.saf.authen.refresh.failed.error", new Object[]{pc.getUserId(), SAFServiceResult.getSafServiceResult()});
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "refreshCredential", credToken);
        }
        return credToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SAFCredentialTokenImpl authenticateCredential(PlatformCredential pc, String password) throws AuthenticationFailedException, PasswordCheckFailedException {
        byte[] encodedCert;
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "authenticateCredential", new Object[]{pc, password != null ? "****" : null});
        }
        SAFCredentialTokenImpl credToken = null;
        String APPLName = this.getAPPLName();
        if (pc.getCredentialType() == PlatformCredential.BASIC) {
            credToken = this.ntv_createCredentialToken(pc, pc.getUserId(), pc.getAuditString(), password, APPLName);
            if (credToken == null) {
                SAFServiceResult result = SAFServiceResult.getSafServiceResult();
                Tr.info(tc, "security.zos.saf.authen.pw.check.failed.info", new Object[]{pc.getUserId(), result});
                if (result.getReturnCode() == 8) {
                    WSPasswordCheckFailedException ex = null;
                    switch (result.getReasonCode()) {
                        case 16: {
                            ex = new WSPasswordCheckFailedException(true, false);
                            break;
                        }
                        case 20: {
                            ex = new WSPasswordCheckFailedException(false, true);
                            break;
                        }
                    }
                    if (ex != null) {
                        throw new PasswordCheckFailedException(ex);
                    }
                }
            }
        } else if (pc.getCredentialType() == PlatformCredential.CERTIFICATE && (credToken = this.ntv_createCertificateCredentialToken(pc, encodedCert = this.getEncodedCertificate(pc), encodedCert.length, pc.getAuditString(), APPLName)) == null) {
            X509Certificate cert = pc.getCertificateChain()[0];
            Tr.info(tc, "security.zos.saf.authen.cert.map.failed.info", new Object[]{cert.getIssuerX500Principal().getName(), cert.getSubjectX500Principal().getName(), SAFServiceResult.getSafServiceResult()});
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.debug(tc, "Updated PlatformCredential", pc);
        }
        if (credToken == null) {
            throw new AuthenticationFailedException();
        }
        PlatformCredentialManager platformCredentialManager = this;
        synchronized (platformCredentialManager) {
            SAFCredentialTokenImpl cachedToken;
            block21: {
                cachedToken = null;
                try {
                    cachedToken = (SAFCredentialTokenImpl)this._cache.get(pc);
                }
                catch (CacheException ce) {
                    if (!isAnyTracingEnabled || !tc.isEntryEnabled()) break block21;
                    Tr.debug(tc, "Unexpected cache exception", ce);
                }
            }
            if (cachedToken == null) {
                this._cache.insert(pc, credToken);
            } else {
                this.destroyCredential(credToken);
                credToken = cachedToken;
            }
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "authenticateCredential", credToken);
        }
        return credToken;
    }

    void destroyCredential(SAFCredentialTokenImpl credToken) {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "destroyCredential", credToken);
        }
        this.ntv_destroyCredential(credToken);
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "destroyCredential");
        }
    }

    private byte[] getEncodedCertificate(PlatformCredential pc) {
        byte[] encodedCert;
        boolean isAnyTracingEnabled;
        block4: {
            isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
            if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                Tr.entry(tc, "getEncodedCertificate", pc);
            }
            encodedCert = null;
            try {
                X509Certificate cert = pc.getCertificateChain()[0];
                encodedCert = cert.getEncoded();
            }
            catch (CertificateEncodingException cee) {
                if (!isAnyTracingEnabled || !tc.isEntryEnabled()) break block4;
                Tr.debug(tc, "Unable to get certificate data", cee);
            }
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "getEncodedCertificate", encodedCert);
        }
        return encodedCert;
    }

    public PlatformCredential getPlatformCredentialFromSubject(Subject subject) {
        PlatformCredential pc;
        boolean isAnyTracingEnabled;
        block5: {
            isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
            if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                Tr.entry(tc, "getPlatformCredentialFromSubject", subject);
            }
            pc = null;
            if (subject != null) {
                try {
                    GetPlatformCredentialAction gpca = new GetPlatformCredentialAction(subject);
                    pc = (PlatformCredential)AccessController.doPrivileged(gpca);
                }
                catch (PrivilegedActionException pae) {
                    if (!isAnyTracingEnabled || !tc.isEntryEnabled()) break block5;
                    Tr.debug(tc, "Unable to get platform cred", pae);
                }
            }
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "getPlatformCredentialFromSubject", pc);
        }
        return pc;
    }

    private String getAPPLName() {
        boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.entry(tc, "getAPPLName");
        }
        String APPLName = null;
        String useAPPLprofile = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.security.SAF.useAPPLprofile");
        if ("true".equalsIgnoreCase(useAPPLprofile)) {
            APPLName = SecurityObjectLocator.getSecurityConfig().getSAFProfilePrefix();
            if (APPLName == null || APPLName.equalsIgnoreCase("")) {
                APPLName = "CBS390";
            }
        } else if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.debug(tc, "The APPLName will not be used for RACF authorization because the useAPPLprofile property is set to false.");
        }
        if (isAnyTracingEnabled && tc.isEntryEnabled()) {
            Tr.exit(tc, "getAPPLName", APPLName);
        }
        return APPLName;
    }

    private native SAFCredentialTokenImpl ntv_createCredentialToken(PlatformCredential var1, String var2, String var3, String var4, String var5);

    private native SAFCredentialTokenImpl ntv_createCertificateCredentialToken(PlatformCredential var1, byte[] var2, int var3, String var4, String var5);

    private native SAFCredentialTokenImpl ntv_createRoleCredentialToken(PlatformCredential var1, String var2, String var3, String var4);

    private native SAFCredentialTokenImpl ntv_createServerCredentialToken(PlatformCredential var1);

    private native byte[] ntv_createUtoken(PlatformCredential var1);

    private native String ntv_mapKerbPrincipal(String var1);

    private native void ntv_destroyCredential(SAFCredentialTokenImpl var1);

    private static final class GetPlatformCredentialAction
    implements PrivilegedExceptionAction {
        final Subject _subject;

        GetPlatformCredentialAction(Subject subject) {
            this._subject = subject;
        }

        public Object run() throws Exception {
            PlatformCredential pc = null;
            Set<PlatformCredential> creds = this._subject.getPrivateCredentials(PlatformCredential.class);
            if (!creds.isEmpty()) {
                pc = creds.iterator().next();
            } else {
                WSCredential cred = SubjectHelper.getWSCredentialFromSubject(this._subject);
                if (cred != null) {
                    pc = (PlatformCredential)cred.get("com.ibm.ws.security.zos.PlatformCredential");
                }
            }
            return pc;
        }
    }

    private static final class CacheEvictionCallback
    implements CacheEvictionListener {
        CacheEvictionCallback() {
        }

        public void evicted(List victimList) {
            boolean isAnyTracingEnabled = TraceComponent.isAnyTracingEnabled();
            if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                Tr.entry(tc, "evicted", victimList);
            }
            for (Object o : victimList) {
                if (!(o instanceof SAFCredentialTokenImpl)) continue;
                _instance.destroyCredential((SAFCredentialTokenImpl)o);
            }
            if (isAnyTracingEnabled && tc.isEntryEnabled()) {
                Tr.exit(tc, "evicted");
            }
        }
    }
}

