/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.util.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import javax.security.auth.Subject;

public class WebSecurityContext {
    private Subject invokedSubject = null;
    private Subject receivedSubject = null;
    private Map propagationTokens = null;
    private Object syncToThreadToken = null;
    private boolean appSyncToOSThread = false;
    private boolean pushedSecurityContext = false;
    private boolean pushedAdminContext = false;
    private static final TraceComponent tc = Tr.register(WebSecurityContext.class, "Security", null);

    public WebSecurityContext(Subject iSubject, Subject rSubject, Map propTokens) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{WebSecurityContext.getPrivTraceData(iSubject), WebSecurityContext.getPrivTraceData(rSubject), WebSecurityContext.getPrivTraceData(propTokens)});
        }
        this.invokedSubject = iSubject;
        this.receivedSubject = rSubject;
        this.propagationTokens = propTokens;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public WebSecurityContext(Subject iSubject, Subject rSubject, Map propTokens, Object inSyncToThreadToken, boolean appSync) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", new Object[]{WebSecurityContext.getPrivTraceData(iSubject), WebSecurityContext.getPrivTraceData(rSubject), WebSecurityContext.getPrivTraceData(propTokens), inSyncToThreadToken, new Boolean(appSync)});
        }
        this.invokedSubject = iSubject;
        this.receivedSubject = rSubject;
        this.propagationTokens = propTokens;
        this.syncToThreadToken = inSyncToThreadToken;
        this.appSyncToOSThread = appSync;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public boolean getPushedSecurityContext() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting pushed security value \"" + this.pushedSecurityContext + "\" for: " + this);
        }
        return this.pushedSecurityContext;
    }

    public void setPushedSecurityContext(boolean pushed) {
        this.pushedSecurityContext = pushed;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting pushed security to \"" + this.pushedSecurityContext + "\" for: " + this);
        }
    }

    public void clearPushedSecurityContext() {
        this.pushedSecurityContext = false;
    }

    public boolean getPushedAdminContext() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Getting pushed admin value \"" + this.pushedAdminContext + "\" for: " + this);
        }
        return this.pushedAdminContext;
    }

    public void setPushedAdminContext(boolean pushed) {
        this.pushedAdminContext = pushed;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Setting pushed admin to \"" + this.pushedAdminContext + "\" for: " + this);
        }
    }

    public void clearPushedAdminContext() {
        this.pushedAdminContext = false;
    }

    public Subject getInvokedSubject() {
        return this.invokedSubject;
    }

    public Subject getReceivedSubject() {
        return this.receivedSubject;
    }

    public Map getPropagationTokens() {
        return this.propagationTokens;
    }

    public Object getSyncToThreadToken() {
        return this.syncToThreadToken;
    }

    public void setSyncToThreadToken(Object token) {
        this.syncToThreadToken = token;
    }

    public boolean isAppSyncToOSThreadEnabled() {
        return this.appSyncToOSThread;
    }

    public void setAppSyncToOSThreadEnabled(boolean value) {
        this.appSyncToOSThread = value;
    }

    private static String getPrivTraceData(Object o) {
        String rtn = null;
        final Object fObj = o;
        if (o != null) {
            try {
                rtn = (String)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        return fObj.toString();
                    }
                });
            }
            catch (Exception e) {
                rtn = "Exception in toString: " + e.getMessage();
            }
        }
        return rtn;
    }
}

