/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.TrustAssociationInterceptor;
import com.ibm.websphere.security.WebSphereBaseTrustAssociationInterceptor;
import com.ibm.websphere.security.WebTrustAssociationException;
import com.ibm.websphere.security.WebTrustAssociationFailedException;
import com.ibm.websphere.security.WebTrustAssociationUserException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.tai.NegotiateTrustAssociationInterceptor;
import com.ibm.wsspi.security.tai.TAIPrincipal;
import com.ibm.wsspi.security.tai.TAIResult;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

final class TAIWrapper {
    private TrustAssociationInterceptor tai = null;
    private NegotiateTrustAssociationInterceptor taiV2 = null;
    private com.ibm.wsspi.security.tai.TrustAssociationInterceptor taiV3 = null;
    private String name;
    private static final TraceComponent tc = Tr.register(TAIWrapper.class, null, "com.ibm.ejs.resources.security");

    TAIWrapper(Object t) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "TAIWrapper(" + t + ")");
        }
        if (t == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "TrustAssociationInterceptor is null");
            }
            throw new NullPointerException("TrustAssociationInterceptor is null");
        }
        if (t instanceof com.ibm.wsspi.security.tai.TrustAssociationInterceptor) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trust association type: com.ibm.wsspi.security.tai.TrustAssociationInterceptor");
            }
            this.taiV3 = (com.ibm.wsspi.security.tai.TrustAssociationInterceptor)t;
            this.setName(this.taiV3.getType());
        } else if (t instanceof NegotiateTrustAssociationInterceptor) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trust association type: com.ibm.wsspi.security.tai.NegotiateTrustAssociationInterceptor");
            }
            this.taiV2 = (NegotiateTrustAssociationInterceptor)t;
            if (t instanceof WebSphereBaseTrustAssociationInterceptor) {
                this.setName(((WebSphereBaseTrustAssociationInterceptor)t).getType());
            } else {
                this.setName(this.getClassName());
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Trust association type: com.ibm.websphere.security.TrustAssociationInterceptor");
            }
            this.tai = (TrustAssociationInterceptor)t;
            if (t instanceof WebSphereBaseTrustAssociationInterceptor) {
                this.setName(((WebSphereBaseTrustAssociationInterceptor)t).getType());
            } else {
                this.setName(this.getClassName());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "TAIWrapper(" + t + ")");
        }
    }

    TAIResult negotiateAndValidateEstablishedTrust(HttpServletRequest req, HttpServletResponse res) throws WebTrustAssociationFailedException, WebTrustAssociationUserException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "negotiateAndValidateEstablishedTrust()");
        }
        TAIResult taiResult = null;
        if (this.taiV3 != null) {
            taiResult = this.taiV3.negotiateValidateandEstablishTrust(req, res);
        } else if (this.taiV2 != null) {
            int result = this.taiV2.negotiateAndValidateEstablishedTrust(req, res);
            if (result == 200) {
                Subject subject = this.taiV2.getSubject();
                if (subject != null) {
                    String principal = this.getTAIUsernameFromSubjectPrincipal(subject);
                    if (principal != null && (principal = principal.trim()).length() == 0) {
                        principal = null;
                    }
                    if (principal == null) {
                        principal = this.taiV2.getAuthenticatedUsername(req);
                    }
                    taiResult = TAIResult.create(result, principal, subject);
                } else {
                    taiResult = TAIResult.create(result, this.taiV2.getAuthenticatedUsername(req));
                }
            } else {
                taiResult = TAIResult.create(result);
            }
        } else {
            this.tai.validateEstablishedTrust(req);
            taiResult = TAIResult.create(200, this.tai.getAuthenticatedUsername(req));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "negotiateAndValidateEstablishedTrust(): status code = " + taiResult.getStatus());
        }
        return taiResult;
    }

    boolean isTargetInterceptor(HttpServletRequest req) throws WebTrustAssociationException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isTargetInterceptor()");
        }
        boolean result = false;
        result = this.taiV3 != null ? this.taiV3.isTargetInterceptor(req) : (this.taiV2 != null ? this.taiV2.isTargetInterceptor(req) : this.tai.isTargetInterceptor(req));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isTargetInterceptor(): " + this.name + " returning " + result);
        }
        return result;
    }

    void cleanup() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        if (this.taiV3 != null) {
            this.taiV3.cleanup();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.name + " is cleaned up");
            }
        } else if (this.taiV2 != null) {
            if (this.taiV2 instanceof WebSphereBaseTrustAssociationInterceptor) {
                ((WebSphereBaseTrustAssociationInterceptor)((Object)this.taiV2)).cleanup();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, this.name + " is cleaned up");
                }
            }
        } else if (this.tai instanceof WebSphereBaseTrustAssociationInterceptor) {
            ((WebSphereBaseTrustAssociationInterceptor)((Object)this.tai)).cleanup();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.name + " is cleaned up");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }

    String getName() {
        return this.name;
    }

    private void setName(String n) {
        if (n != null && (n = n.trim()).length() != 0) {
            this.name = n;
        }
        if (this.name == null) {
            this.name = this.getClassName();
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Trust association class name: " + this.name);
        }
    }

    protected String getClassName() {
        String r = null;
        if (this.taiV3 != null) {
            r = this.taiV3.getClass().getName();
        } else if (this.taiV2 != null) {
            r = this.taiV2.getClass().getName();
        } else if (this.tai != null) {
            r = this.tai.getClass().getName();
        }
        return r;
    }

    private String getTAIUsernameFromSubjectPrincipal(final Subject in_subject) throws WebTrustAssociationFailedException {
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTAIUsernameFromSubjectPrincipal");
        }
        String ta_username = null;
        if (in_subject != null) {
            try {
                ta_username = (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws WebTrustAssociationFailedException {
                        Set<Principal> pSet = in_subject.getPrincipals();
                        Object[] pArray = null;
                        if (pSet.size() > 0) {
                            pArray = pSet.toArray();
                        }
                        if (pArray != null && pArray.length == 1) {
                            if (pArray[0] instanceof Principal) {
                                return ((Principal)pArray[0]).getName();
                            }
                            Tr.error(tc, "security.web.ta.invalidprincipal");
                            return null;
                        }
                        if (pArray != null) {
                            String username = null;
                            for (int i = 0; i < pArray.length; ++i) {
                                if (!(pArray[i] instanceof TAIPrincipal)) continue;
                                if (username == null) {
                                    username = ((Principal)pArray[i]).getName();
                                    continue;
                                }
                                Tr.error(tc, "security.web.ta.invalidprincipal");
                                throw new WebTrustAssociationFailedException("More than one com.ibm.wsspi.security.tai.TAIPrincipal in the Subject");
                            }
                            if (username == null) {
                                Tr.error(tc, "security.web.ta.invalidprincipal");
                            }
                            return username;
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.web.TAIWrapper.getTAIUsernameFromSubjectPrincipal", "328", this);
                throw (WebTrustAssociationFailedException)e.getException();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getTAIUsernameFromSubjectPrincipal: " + ta_username);
        }
        return ta_username;
    }
}

