/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.exception.RuntimeError;
import com.ibm.ws.exception.RuntimeWarning;
import com.ibm.ws.portletcontainer.om.security.PortletApplication;
import com.ibm.ws.portletcontainer.om.security.PortletDefinition;
import com.ibm.ws.portletcontainer.util.PortletModelHelper;
import com.ibm.ws.runtime.deploy.DeployedObject;
import com.ibm.ws.runtime.metadata.MetaData;
import com.ibm.ws.runtime.metadata.MetaDataEvent;
import com.ibm.ws.runtime.metadata.MetaDataListener;
import com.ibm.ws.security.web.SecurityMetaData;
import com.ibm.ws.security.web.WebAttributes;
import com.ibm.wsspi.webcontainer.metadata.WebComponentMetaData;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import com.ibm.wsspi.webcontainer.servlet.IServletConfig;
import com.ibm.wsspi.webcontainer.webapp.WebAppConfig;
import java.util.List;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class SecurityMetaDataListener
implements MetaDataListener {
    private static TraceComponent tc = Tr.register(SecurityMetaDataListener.class);

    public void metaDataCreated(MetaDataEvent mde) throws RuntimeWarning, RuntimeError {
        MetaData metaData;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "metaDataCreated: " + mde);
        }
        if ((metaData = mde.getMetaData()) instanceof WebModuleMetaData) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WebModuleMetaData " + metaData);
            }
            DeployedObject dobj = mde.getDeployedObject();
            WebApp webModuleDD = (WebApp)dobj.getDeploymentDescriptor();
            WebAppConfig config = ((WebModuleMetaData)metaData).getConfiguration();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "webModuleDD " + webModuleDD);
                Tr.debug(tc, "config " + config);
            }
            this.populateSecurityModuleMetaData(webModuleDD, config);
        } else if (metaData instanceof WebComponentMetaData) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WebComponentMetaData " + metaData);
            }
            DeployedObject dobj = mde.getDeployedObject();
            IServletConfig config = ((WebComponentMetaData)metaData).getServletConfig();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "config " + config);
            }
            WebApp webapp = (WebApp)dobj.getDeploymentDescriptor();
            Servlet servlet = webapp.getServletNamed(config.getServletName());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "servlet " + servlet);
            }
            PortletApplication portletApp = null;
            PortletDefinition portlet = null;
            if (servlet == null && (portletApp = PortletModelHelper.getPortletApplication((DeployedObject)dobj)) != null) {
                String portletName = config.getServletName();
                portlet = PortletModelHelper.getPortletNamed((PortletApplication)portletApp, (String)portletName);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Portlet " + portlet);
                }
            }
            if (servlet != null || portlet != null) {
                this.populateSecurityComponentMetaData(servlet, portlet, config);
            }
        }
    }

    private void populateSecurityModuleMetaData(WebApp webModuleDD, WebAppConfig config) {
        WebAttributes webAttrs = null;
        SecurityMetaData securityMetadata = new SecurityMetaData();
        webAttrs = new WebAttributes(webModuleDD);
        WebModuleMetaData wmmd = config.getMetaData();
        securityMetadata.setWebAttributes(webAttrs);
        wmmd.setSecurityMetaData((Object)securityMetadata);
    }

    private void populateSecurityComponentMetaData(Servlet servlet, PortletDefinition portlet, IServletConfig config) {
        List rolerefs = null;
        String servlet_name = "";
        SecurityMetaData securityMetadata = new SecurityMetaData();
        rolerefs = servlet != null ? servlet.getSecurityRoleRefs() : portlet.getSecurityRoleRefs();
        servlet_name = config.getServletName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "rolerefs = " + rolerefs + " name = " + servlet_name);
        }
        WebComponentMetaData wcmd = config.getMetaData();
        securityMetadata.setSecurityRoleRefs(rolerefs);
        securityMetadata.setServletName(servlet_name);
        wcmd.setSecurityMetaData((Object)securityMetadata);
    }

    public void metaDataDestroyed(MetaDataEvent mde) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "metaDataDestroyed: " + mde);
        }
    }
}

