/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.web;

import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.common.auth.util.CredentialsHelper;
import com.ibm.ws.security.common.auth.util.Util;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.server.LTPAConfigException;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import com.ibm.wsspi.security.auth.callback.WSServletRequestCallback;
import com.ibm.wsspi.security.auth.callback.WSServletResponseCallback;
import com.ibm.wsspi.security.auth.callback.WSTokenHolderCallback;
import com.ibm.wsspi.security.token.WSSecurityPropagationHelper;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class AuthenLoginModule
implements LoginModule {
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private WSPrincipal principal;
    private WSCredential credential;
    private UserRegistry registry;
    protected boolean debug = false;
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final TraceComponent tc = Tr.register(AuthenLoginModule.class, null, "com.ibm.ejs.resources.security");

    public AuthenLoginModule() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AuthenLoginModule()");
            Tr.exit(tc, "AuthenLoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + sharedState.toString() + "\", options = \"" + options.toString() + "\")");
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        ContextManager contextManager = ContextManagerFactory.getInstance();
        if (contextManager != null) {
            this.registry = contextManager.getRegistry(contextManager.getDefaultRealm());
            contextManager.clearRootException();
        }
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "WSLoginModuleImpl initialized");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    public boolean login() throws LoginException {
        byte[] tmpCred;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "login()");
        }
        this.succeeded = false;
        if (this.commitSucceeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "The login module is in funny state, cleanup before starting a new login process.");
            }
            this.cleanup();
        }
        ContextManager contextManager = ContextManagerFactory.getInstance();
        Callback[] callbacks = null;
        if (!this.sharedState.containsKey("Callback")) {
            if (this.callbackHandler == null) {
                WSLoginFailedException e = new WSLoginFailedException("No CallbackHandler available to gather authentication information from the user.");
                contextManager.setRootException(e);
                throw e;
            }
            callbacks = new Callback[]{new NameCallback("Username: "), new PasswordCallback("Password: ", false), new WSCredTokenCallbackImpl("Credential Token: "), new WSServletRequestCallback("HttpServletRequest: "), new WSServletResponseCallback("HttpServletResponse: "), new WSAppContextCallback("ApplicationContextCallback: "), new WSTokenHolderCallback("Authz Token List: ")};
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.AuthenLoginModule.login", "232", this);
                Tr.error(tc, "security.jaas.callBackHandlerIOException", new Object[]{this.getClass().getName(), e});
                contextManager.setRootException(e);
                throw new WSLoginFailedException("IOException: " + e.getMessage(), e);
            }
            catch (UnsupportedCallbackException uce) {
                FFDCFilter.processException((Throwable)uce, "com.ibm.ws.security.web.AuthenLoginModule.login", "238", this);
                Tr.error(tc, "security.jaas.callBackHandlerException", new Object[]{this.getClass().getName(), uce.getCallback().toString(), uce});
                contextManager.setRootException(uce);
                throw new WSLoginFailedException(uce.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user" + uce.getMessage(), uce);
            }
            this.sharedState.put("Callback", callbacks);
        } else {
            callbacks = (Callback[])this.sharedState.get("Callback");
        }
        String uid = null;
        String realm = null;
        char[] password = null;
        byte[] credToken = null;
        List authzTokenList = null;
        uid = ((NameCallback)callbacks[0]).getName();
        char[] tmp = ((PasswordCallback)callbacks[1]).getPassword();
        if (tmp != null) {
            password = new char[tmp.length];
            System.arraycopy(tmp, 0, password, 0, tmp.length);
            ((PasswordCallback)callbacks[1]).clearPassword();
        }
        if ((tmpCred = ((WSCredTokenCallbackImpl)callbacks[2]).getCredToken()) != null) {
            credToken = CredentialsHelper.copyCredToken(tmpCred);
        }
        authzTokenList = ((WSTokenHolderCallback)callbacks[6]).getTokenHolderList();
        Hashtable customProperties = (Hashtable)this.sharedState.get("com.ibm.wsspi.security.cred.propertiesObject");
        if (customProperties == null) {
            try {
                final Subject subjectPriv = this.subject;
                customProperties = (Hashtable)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                        Object[] list_public = subjectPriv.getPublicCredentials().toArray();
                        if (AuthenLoginModule.this.debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking for custom properties in public cred list.");
                        }
                        for (int i = 0; i < list_public.length; ++i) {
                            if (AuthenLoginModule.this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Object[" + i + "] in public list: " + list_public[i]);
                            }
                            if (!(list_public[i] instanceof Hashtable ? ((Hashtable)list_public[i]).get("com.ibm.wsspi.security.cred.uniqueId") != null : list_public[i] instanceof HashMap && ((HashMap)list_public[i]).get("com.ibm.wsspi.security.cred.uniqueId") != null)) continue;
                            return list_public[i];
                        }
                        Object[] list_private = subjectPriv.getPrivateCredentials().toArray();
                        if (AuthenLoginModule.this.debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking for custom properties in private cred list.");
                        }
                        for (int i = 0; i < list_private.length; ++i) {
                            if (AuthenLoginModule.this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Object[" + i + "] in private list: " + list_private[i]);
                            }
                            if (!(list_private[i] instanceof Hashtable ? ((Hashtable)list_private[i]).get("com.ibm.wsspi.security.cred.uniqueId") != null : list_private[i] instanceof HashMap && ((HashMap)list_private[i]).get("com.ibm.wsspi.security.cred.uniqueId") != null)) continue;
                            return list_private[i];
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "334", this);
                contextManager.setRootException(e.getException());
                throw new WSLoginFailedException(e.getException().getMessage(), e.getException());
            }
            if (customProperties != null) {
                this.sharedState.put("com.ibm.wsspi.security.cred.propertiesObject", customProperties);
            }
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "uid = " + uid);
            Tr.debug(tc, "realm = " + realm);
            Tr.debug(tc, "password = " + (password == null ? "<null>" : "XXXXXXXX"));
            Tr.debug(tc, "cred token = " + Util.toString(credToken));
            Tr.debug(tc, "authz token list = " + authzTokenList);
            Tr.debug(tc, "custom properties = " + customProperties);
        }
        if (customProperties != null) {
            this.succeeded = true;
            if (this.debug || tc.isEntryEnabled()) {
                Tr.debug(tc, "Custom login module passing in group information.  Handling login outside this login module.");
                Tr.exit(tc, "login()");
            }
            return this.succeeded;
        }
        if ((WSSecurityPropagationHelper.getInstance().isRMIInboundPropagationEnabled() || WSSecurityPropagationHelper.getInstance().isRMIOutboundPropagationEnabled()) && authzTokenList != null && (credToken != null || uid != null)) {
            this.succeeded = true;
            if (this.debug || tc.isEntryEnabled()) {
                Tr.debug(tc, "Security attribute propagation data has been received.  Handling login outside this login module.");
                Tr.exit(tc, "login()");
            }
            return this.succeeded;
        }
        if (uid == null && password == null && credToken == null) {
            WSLoginFailedException e = new WSLoginFailedException("No authentication data.");
            contextManager.setRootException(e);
            throw e;
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Successfully gathered authentication information");
        }
        LTPAServerObject ltpaServer = null;
        try {
            ltpaServer = LTPAServerObject.getLTPAServer();
        }
        catch (LTPAConfigException lce) {
            FFDCFilter.processException((Throwable)lce, "com.ibm.ws.security.web.AuthenLoginModule.initialize", "406", this);
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "ERROR: Failed to get the LTPA server object.");
            }
            WSLoginFailedException e = new WSLoginFailedException("Exception getting LTPAServerObject", lce);
            throw e;
        }
        if (uid != null && password != null) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Using uid and password for authentication");
                StringBuffer buf = new StringBuffer("Authenticating \"");
                buf.append(realm).append('/').append(uid).append("\"");
                Tr.debug(tc, buf.toString());
            }
            String passwd = new String(password);
            BasicAuthData ba = new BasicAuthData(uid, passwd);
            try {
                this.credential = ltpaServer.authenticate(ba);
            }
            catch (WSLoginFailedException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.AuthenLoginModule.login", "428", this);
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.exit(tc, "login()", new Object[]{e});
                }
                contextManager.setRootException(e);
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.AuthenLoginModule.login", "435", this);
                if (this.debug || tc.isEntryEnabled()) {
                    Tr.exit(tc, "login()", new Object[]{e});
                }
                contextManager.setRootException(e);
                throw new WSLoginFailedException(e.getMessage(), e);
            }
        } else if (uid != null) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(tc, "Expecting : " + MAP_CREDENTIAL.toString());
                }
                sm.checkPermission(MAP_CREDENTIAL);
            }
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Using uid to mapCredential");
                StringBuffer buf = new StringBuffer("Authenticating \"");
                buf.append(realm).append('/').append(uid).append("\"");
                Tr.debug(tc, buf.toString());
            }
            try {
                if (SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getBoolean("com.ibm.websphere.security.registry.UseTAM") && !RegistryUtil.checkValidUserifTAM(uid, this.registry)) {
                    throw new WSLoginFailedException("User is not valid in Access Manager");
                }
                WSCredential mapCred = this.registry.createCredential(uid);
                this.credential = ltpaServer.createLTPAToken(mapCred);
            }
            catch (TokenCreationFailedException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.AuthenLoginModule.login", "480", this);
                Tr.debug(tc, "Using uid to mapCredential");
                contextManager.setRootException(e);
                throw new WSLoginFailedException(e.getMessage(), e);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.AuthenLoginModule.login", "487", this);
                contextManager.setRootException(e);
                throw new WSLoginFailedException(e.getMessage(), e);
            }
        } else if (credToken != null) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Using credential token for authentication");
            }
            try {
                this.credential = ltpaServer.validate(credToken);
            }
            catch (WSLoginFailedException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.AuthenLoginModule.login", "504", this);
                contextManager.setRootException(e);
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.AuthenLoginModule.login", "510", this);
                contextManager.setRootException(e);
                throw new WSLoginFailedException(e.getMessage(), e);
            }
        } else {
            WSLoginFailedException e = new WSLoginFailedException("AuthenLoginModule: No authentication data");
            contextManager.setRootException(e);
            throw e;
        }
        if (this.credential == null) {
            WSLoginFailedException e = new WSLoginFailedException("AuthenLoginModule: Credential returned from SAS authentication is null");
            contextManager.setRootException(e);
            throw e;
        }
        Object securityName = null;
        try {
            this.principal = ContextManagerFactory.getInstance().createPrincipal(this.credential);
        }
        catch (WSSecurityException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "WSSecurityException caught creating a new principal.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.AuthenLoginModule.login", "533", this);
            contextManager.setRootException(e);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        this.sharedState.put("WSPrincipal", this.principal);
        this.sharedState.put("WSCredential", this.credential);
        this.succeeded = true;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "login()");
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        boolean bRet = false;
        if (!this.succeeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Do not commit because of authentication failed.");
            }
            bRet = false;
        } else {
            if (!this.commitSucceeded) {
                ContextManager contextManager = ContextManagerFactory.getInstance();
                this.principal = (WSPrincipal)this.sharedState.get("WSPrincipal");
                if (this.principal == null) {
                    WSLoginFailedException e = new WSLoginFailedException("AuthenLoginModule: WSPrincipal is null in commit (phase 2) stage");
                    contextManager.setRootException(e);
                    throw e;
                }
                this.credential = (WSCredential)this.sharedState.get("WSCredential");
                if (this.credential == null) {
                    WSLoginFailedException e = new WSLoginFailedException("AuthenLoginModule: WSCredential is null in commit (phase 2) stage");
                    contextManager.setRootException(e);
                    throw e;
                }
                try {
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Start committing the changes to the Subject ...");
                    }
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                                if (!AuthenLoginModule.this.subject.getPrincipals().contains(AuthenLoginModule.this.principal)) {
                                    AuthenLoginModule.this.subject.getPrincipals().add(AuthenLoginModule.this.principal);
                                }
                                if (!AuthenLoginModule.this.subject.getPublicCredentials().contains(AuthenLoginModule.this.credential)) {
                                    AuthenLoginModule.this.credential.set("wssecurity.identity_name", "ClientAuthenticationToken");
                                    AuthenLoginModule.this.credential.set("wssecurity.identity_value", StringBytesConversion.getConvertedBytes(AuthenLoginModule.this.credential.getRealmSecurityName()));
                                    AuthenLoginModule.this.subject.getPublicCredentials().add(AuthenLoginModule.this.credential);
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.web.AuthenLoginModule.commit", "669", this);
                        contextManager.setRootException(e.getException());
                        throw new WSLoginFailedException(e.getException().getMessage(), e.getException());
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Change committed!");
                    }
                    this.commitSucceeded = true;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.AuthenLoginModule.commit", "679", this);
                    Tr.error(tc, "security.jaas.LoginModuleCommitError", new Object[]{this.getClass().getName(), e});
                    this.cleanup();
                    this.commitSucceeded = false;
                }
            } else if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "It has been committed prior this call, nothing is done.");
            }
            bRet = this.commitSucceeded;
        }
        this.cleanupSharedState();
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return bRet;
    }

    public boolean abort() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }

    private void cleanup() {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing WSPrinciapl, WSCredential, and CORBA Credentials from the Subject.");
            Tr.debug(tc, "Start removing ...");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    if (AuthenLoginModule.this.principal != null && AuthenLoginModule.this.subject.getPrincipals().contains(AuthenLoginModule.this.principal)) {
                        AuthenLoginModule.this.subject.getPrincipals().remove(AuthenLoginModule.this.principal);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.AuthenLoginModule.run", "790", this);
                    Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), e});
                }
                try {
                    if (AuthenLoginModule.this.credential != null && AuthenLoginModule.this.subject.getPublicCredentials().contains(AuthenLoginModule.this.credential)) {
                        AuthenLoginModule.this.subject.getPublicCredentials().remove(AuthenLoginModule.this.credential);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.web.AuthenLoginModule.run", "801", this);
                    Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), e});
                }
                if (AuthenLoginModule.this.credential == null) {
                    // empty if block
                }
                return null;
            }
        });
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        this.principal = null;
        this.credential = null;
        this.cleanupSharedState();
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }

    private void cleanupSharedState() {
        WSPrincipal tempPrincipal;
        WSCredential tempCredential;
        Callback[] tempCallbacks;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupSharedState()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing Callbacks, WSPrincipal, and WSCredential from the shared state.");
        }
        if ((tempCallbacks = (Callback[])this.sharedState.get("Callback")) != null) {
            this.sharedState.remove("Callback");
        }
        if ((tempCredential = (WSCredential)this.sharedState.get("WSCredential")) != null) {
            this.sharedState.remove("WSCredential");
        }
        if ((tempPrincipal = (WSPrincipal)this.sharedState.get("WSPrincipal")) != null) {
            this.sharedState.remove("WSPrincipal");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupSharedState()");
        }
    }
}

