/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.properties.Property;
import com.ibm.websphere.models.config.security.Security;
import org.eclipse.emf.common.util.EList;

public class SecurityMerge {
    private static final TraceComponent tc = Tr.register(SecurityMerge.class, null, "com.ibm.ejs.resources.security");

    public static Security merge(Security cellSecurity, Security serverSecurity) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "merge");
        }
        if (serverSecurity == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AppSvr security does not exist. Using cell security.");
            }
            return cellSecurity;
        }
        Tr.info(tc, "security.merge.proceeding");
        if (serverSecurity.isSetEnabled() && !serverSecurity.isEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "security disabled in the AppServer.");
            }
            cellSecurity.setEnabled(false);
        }
        if (cellSecurity.isSetEnabled() && cellSecurity.isEnabled() && !cellSecurity.isAppEnabled() && serverSecurity.isSetAppEnabled() && serverSecurity.isAppEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "application security enabled in the AppServer.");
            }
            cellSecurity.setAppEnabled(true);
        }
        if (serverSecurity.isSetAppEnabled() && !serverSecurity.isAppEnabled()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "application security disabled in the AppServer.");
            }
            cellSecurity.setAppEnabled(false);
        }
        if (serverSecurity.isSetUseDomainQualifiedUserNames()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using AppSvr's UseDomainQualifiedUserNames.");
            }
            cellSecurity.setUseDomainQualifiedUserNames(serverSecurity.isUseDomainQualifiedUserNames());
        }
        if (serverSecurity.isSetCacheTimeout()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using AppSvr's CacheTimeout.");
            }
            cellSecurity.setCacheTimeout(serverSecurity.getCacheTimeout());
        }
        if (serverSecurity.isSetIssuePermissionWarning()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using AppSvr's IssuePermissionWarning.");
            }
            cellSecurity.setIssuePermissionWarning(serverSecurity.isIssuePermissionWarning());
        }
        if (serverSecurity.isSetEnforceJava2Security()) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using AppSvr's EnforceJava2Security flag.");
            }
            cellSecurity.setEnforceJava2Security(serverSecurity.isEnforceJava2Security());
        }
        if (serverSecurity.getCSI() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using AppSvr's CSI configuration.");
            }
            cellSecurity.setCSI(serverSecurity.getCSI());
        }
        if (serverSecurity.getIBM() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Using AppSvr's SAS configuration.");
            }
            cellSecurity.setIBM(serverSecurity.getIBM());
        }
        try {
            if (serverSecurity.isSetEnforceFineGrainedJCASecurity()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Using AppSvr's EnforceFineGrainedJCASecurity.");
                }
                cellSecurity.setEnforceFineGrainedJCASecurity(serverSecurity.isEnforceFineGrainedJCASecurity());
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (serverSecurity.getProperties() != null) {
            EList serverPropList = serverSecurity.getProperties();
            for (Property prop : serverPropList) {
                if (prop == null) continue;
                String key = prop.getName();
                String value = prop.getValue();
                EList cellPropList = cellSecurity.getProperties();
                if (key == null || value == null || cellPropList == null) continue;
                for (Property cellProp : cellPropList) {
                    if (!key.equals(cellProp.getName())) continue;
                    cellProp.setValue(value);
                }
            }
        }
        return cellSecurity;
    }
}

