/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ffdc.Manager;
import com.ibm.websphere.models.config.security.LDAPUserRegistry;
import java.lang.reflect.Method;
import java.util.Properties;

public class SecurityConfigUtil {
    private static TraceComponent tc = Tr.register(SecurityConfigUtil.class, "Security", "com.ibm.ejs.resources.security");

    public static Properties setLDAPProperties(LDAPUserRegistry reg) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setLDAPProperties");
        }
        Properties props = null;
        try {
            Class<?> secConfigUtils = Class.forName("com.ibm.ws.security.util.SecurityConfigurationUtilities");
            Method setLDAPPropertiesMethod = secConfigUtils.getMethod("setLDAPProperties", LDAPUserRegistry.class);
            Object obj = setLDAPPropertiesMethod.invoke(null, reg);
            if (obj instanceof Properties) {
                props = (Properties)obj;
            }
        }
        catch (Exception e) {
            Tr.debug(tc, "An exception occurred in setting LDAP properties", e);
            Manager.Ffdc.log(e, SecurityConfigUtil.class, "com.ibm.ws.security.util.SecurityConfigUtil.setLDAPProperties", "46");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setLDAPProperties");
        }
        return props;
    }
}

