/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ws.security.util.ResponseFilePasswordParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class ResponseFilePasswordEncoder {
    private String responseFileName;
    private ArrayList<String> passwordKeysList;
    private boolean createBackup = false;

    public ResponseFilePasswordEncoder(String fileName) {
        this.responseFileName = fileName;
    }

    private void buildPasswordKeysList(String passwordKeys) {
        this.passwordKeysList = new ArrayList();
        StringTokenizer tokenizer = new StringTokenizer(passwordKeys, ",");
        String token = null;
        while (tokenizer.hasMoreTokens()) {
            token = tokenizer.nextToken().trim();
            this.passwordKeysList.add(token);
        }
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 2 && args.length != 3) {
            System.out.println("USAGE: ResponseFilePasswordEncoder file_name password_keys_list [-Backup/-noBackup]");
            System.exit(1);
        }
        String fileName = args[0].trim();
        ResponseFilePasswordEncoder passwordEncoder = new ResponseFilePasswordEncoder(fileName);
        String passwordKeys = args[1].trim();
        passwordEncoder.buildPasswordKeysList(passwordKeys);
        if (args.length == 3) {
            if (args[2].trim().equals("-Backup")) {
                passwordEncoder.setCreateBackup(true);
            } else if (!args[2].trim().equals("-noBackup")) {
                System.out.println("USAGE: ResponseFilePasswordEncoder file_name password_keys_list [-Backup/-noBackup]");
                System.exit(1);
            }
        }
        passwordEncoder.process();
    }

    public void setCreateBackup(boolean flag) {
        this.createBackup = flag;
    }

    private void createBackup(File responseFile) {
        File backupFile = new File(responseFile.toString() + ".bak");
        try {
            FileInputStream originalFileIS = new FileInputStream(responseFile);
            FileOutputStream backupFileOS = new FileOutputStream(backupFile);
            int originalFileLength = originalFileIS.available();
            byte[] temp_buffer = new byte[originalFileLength];
            originalFileIS.read(temp_buffer, 0, originalFileLength);
            backupFileOS.write(temp_buffer, 0, temp_buffer.length);
            originalFileIS.close();
            backupFileOS.close();
        }
        catch (FileNotFoundException e) {
            System.out.println("ERROR:  File not found");
            e.printStackTrace();
            System.exit(1);
        }
        catch (IOException eio) {
            System.out.println("File i/o error");
            eio.printStackTrace();
            System.exit(1);
        }
        if (!backupFile.exists()) {
            System.out.println("ERROR:  cannot create backup file == " + backupFile.toString());
            System.exit(1);
        } else {
            System.out.println("NOTE:  Backup file " + backupFile.toString() + " contains unencoded passwords");
        }
    }

    private boolean containsPasswordKey(String line) {
        if (this.passwordKeysList != null) {
            for (int i = 0; i < this.passwordKeysList.size(); ++i) {
                if (!line.contains(this.passwordKeysList.get(i)) || line.startsWith("#")) continue;
                return true;
            }
        }
        return false;
    }

    public void process() throws IOException {
        StringBuffer contents = new StringBuffer();
        File responseFile = new File(this.responseFileName);
        if (!responseFile.isAbsolute()) {
            responseFile = new File(responseFile.getAbsolutePath());
        }
        if (!responseFile.exists()) {
            System.out.println("ERROR: invalid target file = " + responseFile.toString());
            System.exit(1);
        }
        if (this.createBackup) {
            this.createBackup(responseFile);
        }
        BufferedReader reader = new BufferedReader(new FileReader(responseFile));
        try {
            String line = null;
            ResponseFilePasswordParser parser2 = null;
            String passwordToBeEncoded = null;
            String encodedPassword = null;
            while ((line = reader.readLine()) != null) {
                if (this.containsPasswordKey(line) && (passwordToBeEncoded = (parser2 = new ResponseFilePasswordParser(line)).getPasswordToEncode()) != null && passwordToBeEncoded.trim().length() != 0) {
                    encodedPassword = this.encode(passwordToBeEncoded);
                    System.out.println("password to be encoded: " + line);
                    line = line.replaceFirst(passwordToBeEncoded, encodedPassword);
                    System.out.println("encoded password: " + line);
                }
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            reader.close();
        }
        if (!responseFile.delete()) {
            System.out.println("Failed to delete response file");
        }
        this.writeEncodedResponseFile(contents);
    }

    private void writeEncodedResponseFile(StringBuffer contents) throws IOException {
        File responseFile = new File(this.responseFileName);
        BufferedWriter writer = new BufferedWriter(new FileWriter(responseFile));
        writer.write(contents.toString());
        writer.close();
    }

    private String encode(String password) {
        String encodedPassword = PasswordUtil.passwordEncode(password);
        return encodedPassword;
    }
}

