/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import java.util.Vector;

public class RegExp {
    static final char[] NOT = new char[2];
    static final Integer ANY = new Integer(0);
    static final Integer STAR = new Integer(1);
    Object[] expr;
    private boolean caseInsensitive = false;

    public RegExp(String s) {
        this.init(s);
    }

    public RegExp(String s, boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
        if (this.caseInsensitive) {
            s = s.toLowerCase();
        }
        this.init(s);
    }

    public boolean match(String s) {
        if (this.caseInsensitive) {
            s = s.toLowerCase();
        }
        return this.match(s, 0, s.length(), 0);
    }

    private void init(String s) {
        Vector<Object> vector = new Vector<Object>();
        int i = s.length();
        StringBuffer stringbuffer = null;
        Object obj = null;
        for (int j = 0; j < i; ++j) {
            char c = s.charAt(j);
            switch (c) {
                case '?': {
                    obj = ANY;
                    break;
                }
                case '*': {
                    obj = STAR;
                    break;
                }
                case '[': {
                    int k = ++j;
                    Vector<char[]> vector1 = new Vector<char[]>();
                    while (j < i) {
                        c = s.charAt(j);
                        if (j == k && c == '^') {
                            vector1.addElement(NOT);
                        } else {
                            if (c == '\\') {
                                if (j + 1 < i) {
                                    c = s.charAt(++j);
                                }
                            } else if (c == ']') break;
                            char c1 = c;
                            if (j + 2 < i && s.charAt(j + 1) == '-') {
                                c1 = s.charAt(j += 2);
                            }
                            char[] ac1 = new char[]{c, c1};
                            vector1.addElement(ac1);
                        }
                        ++j;
                    }
                    char[][] ac = new char[vector1.size()][];
                    vector1.copyInto((Object[])ac);
                    obj = ac;
                    break;
                }
                case '\\': {
                    if (j + 1 >= i) break;
                    c = s.charAt(++j);
                }
            }
            if (obj != null) {
                if (stringbuffer != null) {
                    vector.addElement(stringbuffer.toString());
                    stringbuffer = null;
                }
                vector.addElement(obj);
                obj = null;
                continue;
            }
            if (stringbuffer == null) {
                stringbuffer = new StringBuffer();
            }
            stringbuffer.append(c);
        }
        if (stringbuffer != null) {
            vector.addElement(stringbuffer.toString());
        }
        this.expr = new Object[vector.size()];
        vector.copyInto(this.expr);
    }

    private boolean match(String s, int i, int j) {
        return this.match(s, i, j, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean match(String s, int i, int j, int k) {
        while (true) {
            block13: {
                int k1;
                char[][] ac;
                char c;
                block22: {
                    block21: {
                        block16: {
                            block17: {
                                block14: {
                                    Object obj;
                                    block19: {
                                        block20: {
                                            block18: {
                                                block15: {
                                                    if (k >= this.expr.length) break block14;
                                                    obj = this.expr[k];
                                                    if (obj != STAR) break block15;
                                                    if (++k >= this.expr.length) {
                                                        return true;
                                                    }
                                                    if (!(this.expr[k] instanceof String)) break block16;
                                                    break block17;
                                                }
                                                if (obj != ANY) break block18;
                                                if (++i > j) {
                                                    return false;
                                                }
                                                break block13;
                                            }
                                            if (!(obj instanceof char[][])) break block19;
                                            if (i >= j) {
                                                return false;
                                            }
                                            c = s.charAt(i++);
                                            ac = (char[][])obj;
                                            if (ac[0] != NOT) break block20;
                                            break block21;
                                        }
                                        k1 = 0;
                                        break block22;
                                    }
                                    if (obj instanceof String) {
                                        String s2 = (String)obj;
                                        int i1 = s2.length();
                                        if (!s.regionMatches(i, s2, 0, i1)) {
                                            return false;
                                        }
                                        i += i1;
                                    }
                                    break block13;
                                }
                                if (i != j) return false;
                                return true;
                            }
                            String s1 = (String)this.expr[k++];
                            int l = s1.length();
                            while ((i = s.indexOf(s1, i)) >= 0) {
                                if (this.match(s, i + l, j, k)) {
                                    return true;
                                }
                                ++i;
                            }
                            return false;
                        }
                        while (i < j) {
                            if (this.match(s, i, j, k)) {
                                return true;
                            }
                            ++i;
                        }
                        return false;
                    }
                    for (int j1 = 1; j1 < ac.length; ++j1) {
                        if (ac[j1][0] > c || c > ac[j1][1]) continue;
                        return false;
                    }
                    break block13;
                }
                while (k1 < ac.length) {
                    if (ac[k1][0] > c || c > ac[k1][1]) {
                        ++k1;
                        continue;
                    }
                    break block13;
                }
                return false;
            }
            ++k;
        }
    }

    public static void main(String[] args) {
        int i;
        String s = args[0];
        if (s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            s = s.substring(1, s.length() - 1);
        }
        System.err.println("Expr " + s);
        System.err.println("Case sensitive expression:");
        RegExp regexp = new RegExp(s);
        for (i = 1; i < args.length; ++i) {
            System.err.println((regexp.match(args[i]) ? "+ " : "- ") + args[i]);
        }
        System.err.println("Case sensitive expression:");
        regexp = new RegExp(s, false);
        for (i = 1; i < args.length; ++i) {
            System.err.println((regexp.match(args[i]) ? "+ " : "- ") + args[i]);
        }
        System.err.println("Case insensitive expression:");
        regexp = new RegExp(s, true);
        for (i = 1; i < args.length; ++i) {
            System.err.println((regexp.match(args[i]) ? "+ " : "- ") + args[i]);
        }
    }
}

