/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.ISecurityUtilityImpl.InvalidPasswordEncodingException;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ffdc.Manager;
import com.ibm.ws.security.util.SASPropFile;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class PropFilePasswordEncoder {
    public static void main(String[] args) {
        File f;
        if (args.length != 2 && args.length != 3 || args[0] == null || args[1] == null || args.length == 3 && (args[2] == null || args[2].compareToIgnoreCase("-Backup") != 0 && args[2].compareToIgnoreCase("-noBackup") != 0)) {
            System.out.println("USAGE:  PropFilePasswordEncoder file_name password_properties_list [-Backup/-noBackup]");
            System.out.println("        PropFilePasswordEncoder file_name -SAS [-Backup/-noBackup]");
            System.exit(1);
        }
        String file_name = args[0].trim();
        String pwd_prop_list = args[1].trim();
        if (file_name.length() == 0 || pwd_prop_list.length() == 0) {
            System.out.println("USAGE:  PropFilePasswordEncoder file_name password_properties_list [-Backup/-noBackup]");
            System.out.println("        PropFilePasswordEncoder file_name -SAS [-Backup/-noBackup]");
            System.exit(1);
        }
        if (!(f = new File(file_name)).isAbsolute()) {
            f = new File(f.getAbsolutePath());
        }
        if (!f.exists()) {
            System.out.println("ERROR:  invalid target file == " + f.toString());
            System.exit(1);
        }
        Properties p = null;
        ArrayList<String> list = null;
        FileInputStream fis = null;
        boolean props_modified = false;
        boolean createBackup = false;
        if (args.length == 3 && args[2].compareToIgnoreCase("-Backup") == 0) {
            createBackup = true;
        } else if (args.length == 3 && args[2].compareToIgnoreCase("-noBackup") == 0) {
            createBackup = false;
        } else {
            String propBackup = System.getProperty("com.ibm.websphere.security.util.createBackup");
            if (propBackup != null && propBackup.equalsIgnoreCase("true")) {
                createBackup = true;
            }
        }
        if (pwd_prop_list.equalsIgnoreCase("-SAS")) {
            p = new Properties();
            try {
                fis = new FileInputStream(f);
                p.load(fis);
                fis.close();
            }
            catch (IOException e) {
                Manager.Ffdc.log(e, PropFilePasswordEncoder.class, "com.ibm.ws.security.util.PropFilePasswordEncoder.main", "126");
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException e2) {
                        Manager.Ffdc.log(e2, PropFilePasswordEncoder.class, "com.ibm.ws.security.util.PropFilePasswordEncoder.main", "135");
                    }
                }
                System.out.println("ERROR:  cannot load properties from target file == " + f.toString());
                System.exit(1);
            }
            try {
                props_modified = SASPropFile.encodePropPasswords(p);
            }
            catch (InvalidPasswordEncodingException e) {
                Manager.Ffdc.log((Throwable)((Object)e), PropFilePasswordEncoder.class, "com.ibm.ws.security.util.PropFilePasswordEncoder.main", "151");
                System.out.println("ERROR:  invalid password encoding exception");
                System.exit(1);
            }
        } else {
            if (pwd_prop_list == null || pwd_prop_list.length() == 0) {
                System.out.println("ERROR:  password properties list is null or empty");
                System.exit(1);
            }
            InputStreamReader isr = null;
            BufferedReader in = null;
            list = new ArrayList<String>();
            try {
                fis = new FileInputStream(f);
                isr = new InputStreamReader(fis);
                in = new BufferedReader(isr);
                String line = in.readLine();
                while (line != null) {
                    list.add(line);
                    line = in.readLine();
                }
                in.close();
                in = null;
                isr.close();
                isr = null;
                fis.close();
                fis = null;
            }
            catch (IOException e) {
                Manager.Ffdc.log(e, PropFilePasswordEncoder.class, "com.ibm.ws.security.util.PropFilePasswordEncoder.main", "188");
                try {
                    if (in != null) {
                        in.close();
                    }
                    if (isr != null) {
                        isr.close();
                    }
                    if (fis != null) {
                        fis.close();
                    }
                }
                catch (IOException e2) {
                    Manager.Ffdc.log(e2, PropFilePasswordEncoder.class, "com.ibm.ws.security.util.PropFilePasswordEncoder.main", "200");
                }
                System.out.println("ERROR:  cannot load properties from target file == " + f.toString());
                System.exit(1);
            }
            boolean props_found = false;
            StringTokenizer tokenList = new StringTokenizer(pwd_prop_list, ",");
            while (tokenList.hasMoreTokens()) {
                String token = tokenList.nextToken();
                if (token == null) continue;
                String property = token.trim();
                for (int j = 0; j < list.size(); ++j) {
                    String key;
                    int index;
                    String item = ((String)list.get(j)).trim();
                    if (item.startsWith("#") && item.length() == 0 || (index = item.indexOf(61)) == -1 || !(key = item.substring(0, index).trim()).equals(token)) continue;
                    String decoded_password = item.substring(index + 1).trim();
                    props_found = true;
                    if (decoded_password.length() <= 0) continue;
                    String encoded_password = PasswordUtil.passwordEncode(decoded_password);
                    if (encoded_password == null) {
                        System.out.println("ERROR:  invalid password encoding exception");
                        System.exit(1);
                    }
                    if (encoded_password.equals(decoded_password)) continue;
                    props_modified = true;
                    list.set(j, key + "=" + encoded_password);
                }
            }
            if (!props_found) {
                System.out.println("ERROR:  no password properties in specified list were found in target file");
                System.exit(1);
            }
        }
        if (!props_modified) {
            System.out.println("NOTE:  all specified passwords already encoded in target file == " + f.toString());
            System.exit(0);
        }
        if (createBackup) {
            File bf = new File(f.toString() + ".bak");
            try {
                FileInputStream originalFileIS = new FileInputStream(f);
                FileOutputStream backupFileOS = new FileOutputStream(bf);
                int originalFileLength = originalFileIS.available();
                byte[] temp_buffer = new byte[originalFileLength];
                originalFileIS.read(temp_buffer, 0, originalFileLength);
                backupFileOS.write(temp_buffer, 0, temp_buffer.length);
                originalFileIS.close();
                backupFileOS.close();
            }
            catch (FileNotFoundException e) {
                System.out.println("ERROR:  File not found");
                e.printStackTrace();
                System.exit(1);
            }
            catch (IOException eio) {
                System.out.println("File i/o error");
                eio.printStackTrace();
                System.exit(1);
            }
            if (!bf.exists()) {
                System.out.println("ERROR:  cannot create backup file == " + bf.toString());
                System.exit(1);
            } else {
                System.out.println("NOTE:  Backup file " + bf.toString() + " contains unencoded passwords");
            }
        }
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        BufferedWriter bw = null;
        try {
            fos = new FileOutputStream(f);
            if (pwd_prop_list.equalsIgnoreCase("-SAS")) {
                SASPropFile.saveConfig(p, fos);
            } else {
                osw = new OutputStreamWriter(fos);
                bw = new BufferedWriter(osw);
                if (list != null) {
                    for (int i = 0; i < list.size(); ++i) {
                        bw.write((String)list.get(i) + "\n");
                    }
                }
                bw.close();
                bw = null;
                osw.close();
                osw = null;
            }
            fos.close();
            fos = null;
        }
        catch (IOException e) {
            Manager.Ffdc.log(e, PropFilePasswordEncoder.class, "com.ibm.ws.security.util.PropFilePasswordEncoder.main", "338");
            try {
                if (bw != null) {
                    bw.close();
                }
                if (osw != null) {
                    osw.close();
                }
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException e2) {
                Manager.Ffdc.log(e2, PropFilePasswordEncoder.class, "com.ibm.ws.security.util.PropFilePasswordEncoder.main", "350");
            }
            System.out.println("ERROR:  cannot save properties to target file == " + f.toString());
            System.exit(1);
        }
        System.exit(0);
    }
}

