/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.util;

import com.ibm.ISecurityUtilityImpl.InvalidPasswordEncodingException;
import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.models.config.channelservice.Chain;
import com.ibm.websphere.models.config.channelservice.TransportChannel;
import com.ibm.websphere.models.config.channelservice.TransportChannelService;
import com.ibm.websphere.models.config.channelservice.channels.ORBInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.SSLInboundChannel;
import com.ibm.websphere.models.config.channelservice.channels.TCPInboundChannel;
import com.ibm.websphere.models.config.ipc.EndPoint;
import com.ibm.websphere.models.config.process.Server;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.runtime.service.EndPointMgr;
import com.ibm.ws.security.config.AuthMechanismConfig;
import com.ibm.ws.security.config.CSIv2Config;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.UserRegistryConfig;
import com.ibm.ws.security.util.ConfigUtils;
import com.ibm.ws.util.PlatformHelperFactory;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import org.eclipse.emf.common.util.EList;

public class ORBUtils {
    private static final TraceComponent tc = Tr.register(ORBUtils.class, null, "com.ibm.ejs.resources.security");

    private static void dumpORBProps(Properties orbProps) {
        if (tc.isDebugEnabled()) {
            Enumeration<?> e = orbProps.propertyNames();
            while (e.hasMoreElements()) {
                String logMethod = "dumpORBProps";
                String key = (String)e.nextElement();
                if (key == null) continue;
                String value = orbProps.getProperty(key);
                if (key.indexOf("Password") != -1 || key.indexOf("password") != -1) {
                    Tr.debug(tc, logMethod + ": " + key + " = " + ConfigUtils.mask(value));
                    continue;
                }
                Tr.debug(tc, logMethod + ": " + key + " = " + value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void populateORBProperties(SecurityConfig security2, Properties orbProps, EndPointMgr endPointMgr, Server server) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "populateORBProperties");
        }
        Class<ORBUtils> clazz = ORBUtils.class;
        synchronized (ORBUtils.class) {
            try {
                ORBUtils.refresh(security2, orbProps, endPointMgr, server);
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.util.ORBUtils.populateORBProperties", "499");
                Tr.error(tc, "security.orbutils.registryattrs", new Object[]{e});
                Tr.debug(tc, "Exception: ", new Object[]{e});
            }
            ORBUtils.dumpORBProps(orbProps);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "populateORBProperties");
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private static synchronized void refresh(SecurityConfig security2, Properties orbProps, EndPointMgr endPointMgr, Server server) throws RemoteException, IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "refresh");
        }
        boolean securityEnabled = security2.getBoolean("enabled");
        orbProps.put("com.ibm.CORBA.securityEnabled", String.valueOf(securityEnabled));
        String curVal = String.valueOf(security2.getBoolean("appEnabled"));
        orbProps.put("com.ibm.CORBA.serverSecurityEnabled", curVal);
        orbProps.put("com.ibm.CORBA.processIsServer", "true");
        curVal = security2.getProperty("com.ibm.ws.security.CommTrace.ExcludeServiceContexts");
        if (curVal != null) {
            orbProps.put("com.ibm.ws.security.CommTrace.ExcludeServiceContexts", curVal);
        }
        if (securityEnabled) {
            String authztableprop;
            Boolean boolVal;
            AuthMechanismConfig aam = security2.getActiveAuthMechanism();
            UserRegistryConfig aur = security2.getActiveUserRegistry();
            curVal = aam.getType();
            if (curVal != null) {
                orbProps.put("com.ibm.CORBA.authenticationTarget", curVal);
            }
            if ((curVal = aur.getString("serverId")) == null) {
                curVal = "";
            }
            orbProps.put("com.ibm.CORBA.loginUserid", curVal);
            orbProps.put("com.ibm.CORBA.principalName", aur.getPrincipalName());
            curVal = SecurityObjectLocator.getAdminData().getString("process.serverName");
            if (curVal != null) {
                orbProps.put("com.ibm.CSI.CellNodeServer", curVal);
            }
            if ((curVal = security2.getProperty("com.ibm.CSI.rmiOutboundPropagationEnabled")) != null) {
                orbProps.put("com.ibm.CSI.rmiOutboundPropagationEnabled", curVal);
            }
            if ((curVal = security2.getProperty("com.ibm.CSI.rmiOutboundLoginEnabled")) != null) {
                orbProps.put("com.ibm.CSI.rmiOutboundLoginEnabled", curVal);
            }
            if ((curVal = security2.getProperty("com.ibm.CSI.rmiInboundMappingEnabled")) != null) {
                orbProps.put("com.ibm.CSI.rmiInboundMappingEnabled", curVal);
            }
            if ((curVal = security2.getProperty("com.ibm.CSI.rmiOutboundMappingEnabled")) != null) {
                orbProps.put("com.ibm.CSI.rmiOutboundMappingEnabled", curVal);
            }
            if ((curVal = security2.getProperty("com.ibm.CSI.rmiInboundMappingConfig")) != null) {
                orbProps.put("com.ibm.CSI.rmiInboundMappingConfig", curVal);
            }
            if ((curVal = security2.getProperty("com.ibm.CSI.rmiInboundPropagationEnabled")) != null) {
                orbProps.put("com.ibm.CSI.rmiInboundPropagationEnabled", curVal);
            }
            if ((curVal = security2.getProperty("com.ibm.ws.security.webInboundPropagationEnabled")) != null) {
                orbProps.put("com.ibm.ws.security.webInboundPropagationEnabled", curVal);
            }
            if ((curVal = security2.getProperty("com.ibm.ws.security.ssoInteropModeEnabled")) != null) {
                orbProps.put("com.ibm.ws.security.ssoInteropModeEnabled", curVal);
            }
            if ((curVal = security2.getProperty("com.ibm.CSI.rmiInboundLoginConfig")) != null) {
                orbProps.put("com.ibm.CSI.rmiInboundLoginConfig", curVal);
            }
            if ((curVal = security2.getProperty("com.ibm.ws.security.webInboundLoginConfig")) != null) {
                orbProps.put("com.ibm.ws.security.webInboundLoginConfig", curVal);
            }
            if ((curVal = security2.getProperty("com.ibm.CSI.rmiOutboundLoginConfig")) != null) {
                orbProps.put("com.ibm.CSI.rmiOutboundLoginConfig", curVal);
            }
            if ((curVal = security2.getOutboundTrustedAuthenticationRealm().getRealmList()) != null && curVal != "") {
                orbProps.put("com.ibm.CSI.supportedTargetRealms", curVal);
            }
            if ((curVal = security2.getProperty("com.ibm.ws.security.webChallengeIfCustomSubjectNotFound")) != null) {
                orbProps.put("com.ibm.ws.security.webChallengeIfCustomSubjectNotFound", curVal);
            }
            if ((curVal = security2.getProperty("com.ibm.ws.security.webPropagationTransport")) != null) {
                orbProps.put("com.ibm.ws.security.webPropagationTransport", curVal);
            }
            if ((curVal = security2.getProperty("com.ibm.ws.security.propagationExcludeList")) != null) {
                orbProps.put("com.ibm.ws.security.propagationExcludeList", curVal);
            }
            if ((curVal = security2.getProperty("com.ibm.websphere.security.krb.allowLTPAAuth")) != null) {
                orbProps.put("com.ibm.websphere.security.krb.allowLTPAAuth", curVal);
            }
            if ((curVal = security2.getProperty("com.ibm.ws.security.includeRunAsChangesInCallerList")) != null) {
                orbProps.put("com.ibm.ws.security.includeRunAsChangesInCallerList", curVal);
            }
            if ((curVal = security2.getProperty("com.ibm.ws.security.createTokenSubjectForAsynchLogin")) != null) {
                orbProps.put("com.ibm.ws.security.createTokenSubjectForAsynchLogin", curVal);
            }
            if ((curVal = security2.getProperty("com.ibm.ws.security.assertLDAPShortName")) != null) {
                orbProps.put("com.ibm.ws.security.assertLDAPShortName", curVal);
            }
            if ((curVal = SecurityObjectLocator.getAdminData().getString("com.ibm.ws.security.internalServerId")) != null) {
                orbProps.put("com.ibm.ws.security.internalServerId", curVal);
            }
            if ((curVal = security2.getProperty("com.ibm.CSI.authenticateSpecialMethods")) != null) {
                orbProps.put("com.ibm.CSI.authenticateSpecialMethods", curVal);
            }
            if ((boolVal = Boolean.valueOf(aur.getBoolean("useRegistryServerId"))) == null || boolVal.booleanValue()) {
                orbProps.put("com.ibm.ws.security.isUseRegistryServerId", "true");
            } else {
                orbProps.put("com.ibm.ws.security.isUseRegistryServerId", "false");
            }
            curVal = SecurityObjectLocator.getAdminData().getString("com.ibm.ws.security.processType");
            if (curVal != null) {
                orbProps.put("com.ibm.ws.security.processType", curVal);
            }
            curVal = aur.getDecodedString("serverPassword");
            curVal = ConfigUtils.variableMapExpand(curVal);
            try {
                if (curVal != null && curVal instanceof String) {
                    curVal = PasswordUtil.encode(curVal);
                }
            }
            catch (InvalidPasswordEncodingException e) {
                FFDCFilter.processException((Throwable)((Object)e), "com.ibm.ws.security.util.ORBUtils.refresh", "665");
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.util.ORBUtils.refresh", "669");
                Tr.error(tc, "security.sas.encode.error", new Object[]{curVal, "com.ibm.CORBA.loginPassword"});
            }
            if (curVal != null) {
                orbProps.put("com.ibm.CORBA.loginPassword", curVal);
            }
            if (aam.getType().equals("CUSTOM")) {
                curVal = aam.getString("OID");
                if (curVal != null) {
                    orbProps.put("com.ibm.CSI.WSSecurityContextCustomOID", curVal);
                }
                if ((curVal = aam.getString("authContextImplClass")) != null) {
                    orbProps.put("com.ibm.CSI.WSSecurityContextCustomClass", curVal);
                }
            }
            if ((curVal = aam.getString("OID")) != null) {
                orbProps.put("com.ibm.CSI.WSSecurityContextActiveOID", curVal);
            }
            if ((curVal = aam.getString("authContextImplClass")) != null) {
                orbProps.put("com.ibm.CSI.WSSecurityContextActiveClass", curVal);
            }
            if ((curVal = String.valueOf(aam.getBoolean("isCredentialForwardable"))) != null) {
                orbProps.put("com.ibm.CSI.WSSecurityContextActiveForwardable", curVal);
            }
            if ((curVal = aam.getString("authConfig")) != null) {
                orbProps.put("com.ibm.CSI.authMechAuthAlias", curVal);
            } else {
                curVal = security2.getProperty("com.ibm.ws.security.defaultLoginConfig");
                if (curVal != null) {
                    orbProps.put("com.ibm.CSI.authMechAuthAlias", curVal);
                }
            }
            curVal = aur.getType();
            if (curVal != null) {
                orbProps.put("com.ibm.CSI.activeUserRegistry", curVal);
            }
            if ((authztableprop = security2.getProperty("com.ibm.websphere.security.authorizationTable")) != null && !authztableprop.equals("")) {
                orbProps.put("com.ibm.websphere.security.authorizationTable", authztableprop);
            }
            orbProps.put("com.ibm.ws.orb.transport.ConnectionInterceptorName", "com.ibm.ISecurityLocalObjectBaseL13Impl.SecurityConnectionInterceptor");
            ORBUtils.setCSIValues(security2, server, orbProps, endPointMgr);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "refresh");
        }
    }

    private static void setCSIValues(SecurityConfig security2, Server server, Properties orbProps, EndPointMgr endPointMgr) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setCSIValues: " + security2);
        }
        String curVal = null;
        CSIv2Config csiv2 = SecurityObjectLocator.getCSIv2Config();
        if (csiv2 == null) {
            return;
        }
        orbProps.put("com.ibm.CSI.claimStateful", String.valueOf(csiv2.getBoolean("com.ibm.CSI.claimStateful")));
        orbProps.put("com.ibm.CSI.claimIdentityAssertionSupported", String.valueOf(csiv2.getBoolean("com.ibm.CSI.claimIdentityAssertionSupported")));
        curVal = csiv2.getString("com.ibm.CSI.trustedPrincipalList");
        if (curVal != null) {
            orbProps.put("com.ibm.CSI.trustedPrincipalList", curVal);
        }
        orbProps.put("com.ibm.CSI.claimClientAuthenticationSupported", String.valueOf(csiv2.getBoolean("com.ibm.CSI.claimClientAuthenticationSupported")));
        orbProps.put("com.ibm.CSI.claimClientAuthenticationRequired", String.valueOf(csiv2.getBoolean("com.ibm.CSI.claimClientAuthenticationRequired")));
        boolean foundChains = false;
        if (server != null) {
            foundChains = ORBUtils.setCSIInboundTranportFromChannelFramework(server, orbProps, endPointMgr);
        }
        if (server == null || !foundChains) {
            orbProps.put("com.ibm.CSI.claimTransportAssocSSLTLSSupported", String.valueOf(csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSSupported")));
            orbProps.put("com.ibm.CSI.claimTLClientAuthenticationSupported", String.valueOf(csiv2.getBoolean("com.ibm.CSI.claimTLClientAuthenticationSupported")));
            orbProps.put("com.ibm.CSI.claimMessageIntegritySupported", String.valueOf(csiv2.getBoolean("com.ibm.CSI.claimMessageIntegritySupported")));
            orbProps.put("com.ibm.CSI.claimMessageConfidentialitySupported", String.valueOf(csiv2.getBoolean("com.ibm.CSI.claimMessageConfidentialitySupported")));
            orbProps.put("com.ibm.CSI.claimTransportAssocSSLTLSRequired", String.valueOf(csiv2.getBoolean("com.ibm.CSI.claimTransportAssocSSLTLSRequired")));
            orbProps.put("com.ibm.CSI.claimTLClientAuthenticationRequired", String.valueOf(csiv2.getBoolean("com.ibm.CSI.claimTLClientAuthenticationRequired")));
            orbProps.put("com.ibm.CSI.claimMessageIntegrityRequired", String.valueOf(csiv2.getBoolean("com.ibm.CSI.claimMessageIntegrityRequired")));
            orbProps.put("com.ibm.CSI.claimMessageConfidentialityRequired", String.valueOf(csiv2.getBoolean("com.ibm.CSI.claimMessageConfidentialityRequired")));
            curVal = csiv2.getString("com.ibm.ssl.csi.inbound.alias");
            if (curVal != null && curVal.length() > 0) {
                orbProps.put("com.ibm.ssl.csi.inbound.alias", curVal);
            }
            if (!PlatformHelperFactory.getPlatformHelper().isZOS()) {
                orbProps.put("com.ibm.CSI.SSLPort", String.valueOf(csiv2.getInteger("com.ibm.CSI.SSLPort")));
                orbProps.put("com.ibm.CSI.ClientCertSSLPort", String.valueOf(csiv2.getInteger("com.ibm.CSI.ClientCertSSLPort")));
            }
        }
        orbProps.put("com.ibm.CSI.performStateful", String.valueOf(csiv2.getBoolean("com.ibm.CSI.performStateful")));
        orbProps.put("com.ibm.CORBA.sessionGCinterval", String.valueOf(csiv2.getInteger("com.ibm.CORBA.sessionGCinterval")));
        orbProps.put("com.ibm.CORBA.sessionGCdiscardunused", String.valueOf(csiv2.getInteger("com.ibm.CORBA.sessionGCdiscardunused")));
        orbProps.put("com.ibm.CSI.performIdentityAssertionSupported", String.valueOf(csiv2.getBoolean("com.ibm.CSI.performIdentityAssertionSupported")));
        orbProps.put("com.ibm.CSI.performIdentityAssertionRequired", String.valueOf(csiv2.getBoolean("com.ibm.CSI.performIdentityAssertionRequired")));
        curVal = csiv2.getString("com.ibm.CSI.alternateIdentityAssertionPerformTrustedId");
        if (curVal != null && curVal.length() > 0) {
            orbProps.put("com.ibm.CSI.alternateIdentityAssertionPerformTrustedId", curVal);
        }
        if ((curVal = csiv2.getString("com.ibm.CSI.alternateIdentityAssertionPerformTrustedPassword")) != null && curVal.length() > 0) {
            orbProps.put("com.ibm.CSI.alternateIdentityAssertionPerformTrustedPassword", curVal);
        }
        orbProps.put("com.ibm.CSI.performClientAuthenticationSupported", String.valueOf(csiv2.getBoolean("com.ibm.CSI.performClientAuthenticationSupported")));
        orbProps.put("com.ibm.CSI.performClientAuthenticationRequired", String.valueOf(csiv2.getBoolean("com.ibm.CSI.performClientAuthenticationRequired")));
        orbProps.put("com.ibm.CORBA.authenticationRetryCount", String.valueOf(csiv2.getInteger("com.ibm.CORBA.authenticationRetryCount")));
        orbProps.put("com.ibm.CORBA.authenticationRetryEnabled", String.valueOf(csiv2.getBoolean("com.ibm.CORBA.authenticationRetryEnabled")));
        orbProps.put("com.ibm.CSI.performTransportAssocSSLTLSSupported", String.valueOf(csiv2.getBoolean("com.ibm.CSI.performTransportAssocSSLTLSSupported")));
        orbProps.put("com.ibm.CSI.performTLClientAuthenticationSupported", String.valueOf(csiv2.getBoolean("com.ibm.CSI.performTLClientAuthenticationSupported")));
        orbProps.put("com.ibm.CSI.performMessageIntegritySupported", String.valueOf(csiv2.getBoolean("com.ibm.CSI.performMessageIntegritySupported")));
        orbProps.put("com.ibm.CSI.performMessageConfidentialitySupported", String.valueOf(csiv2.getBoolean("com.ibm.CSI.performMessageConfidentialitySupported")));
        orbProps.put("com.ibm.CSI.performTransportAssocSSLTLSRequired", String.valueOf(csiv2.getBoolean("com.ibm.CSI.performTLClientAuthenticationRequired")));
        orbProps.put("com.ibm.CSI.performTLClientAuthenticationRequired", String.valueOf(csiv2.getBoolean("com.ibm.CSI.performTLClientAuthenticationRequired")));
        orbProps.put("com.ibm.CSI.performMessageIntegrityRequired", String.valueOf(csiv2.getBoolean("com.ibm.CSI.performMessageIntegrityRequired")));
        orbProps.put("com.ibm.CSI.performMessageConfidentialityRequired", String.valueOf(csiv2.getBoolean("com.ibm.CSI.performMessageConfidentialityRequired")));
        curVal = csiv2.getString("com.ibm.ssl.csi.outbound.alias");
        if (curVal != null && curVal.length() != 0) {
            orbProps.put("com.ibm.ssl.csi.outbound.alias", curVal);
        }
        orbProps.put("com.ibm.CORBA.loginTimeout", String.valueOf(csiv2.getInteger("com.ibm.CORBA.loginTimeout")));
        curVal = security2.getString("com.ibm.CORBA.delegateCredentials");
        if (curVal == null || curVal.equals("")) {
            curVal = "methoddefined";
        }
        orbProps.put("com.ibm.CORBA.delegateCredentials", curVal);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCSIValues");
        }
    }

    private static boolean setCSIInboundTranportFromChannelFramework(Server server, Properties orbProps, EndPointMgr endPointMgr) {
        ArrayList<Properties> insecureTransportList;
        ArrayList<Properties> secureTransportList;
        block35: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "setCSIInboundTranportFromChannelFramework: " + server);
            }
            secureTransportList = new ArrayList<Properties>();
            insecureTransportList = new ArrayList<Properties>();
            try {
                EList comps = server.getServices();
                if (comps != null && comps.size() > 0) {
                    TransportChannelService tcs = null;
                    Class<TransportChannelService> type = TransportChannelService.class;
                    for (Object obj : comps) {
                        if (!type.isInstance(obj)) continue;
                        tcs = (TransportChannelService)obj;
                        break;
                    }
                    if (tcs != null) {
                        EList chains = tcs.getChains();
                        if (chains != null && chains.size() > 0) {
                            for (Chain chain : chains) {
                                EList channels;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Looking at chain: " + chain.getName());
                                }
                                if ((channels = chain.getTransportChannels()) == null || channels.size() <= 0) continue;
                                ORBInboundChannel orbInboundChannel = null;
                                SSLInboundChannel sslInboundChannel = null;
                                TCPInboundChannel tcpInboundChannel = null;
                                Class<ORBInboundChannel> type_orb = ORBInboundChannel.class;
                                Class<SSLInboundChannel> type_ssl = SSLInboundChannel.class;
                                Class<TCPInboundChannel> type_tcp = TCPInboundChannel.class;
                                for (Object obj : channels) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Looking at channel: " + ((TransportChannel)obj).getName());
                                    }
                                    if (type_orb.isInstance(obj)) {
                                        orbInboundChannel = (ORBInboundChannel)obj;
                                    }
                                    if (type_ssl.isInstance(obj)) {
                                        sslInboundChannel = (SSLInboundChannel)obj;
                                    }
                                    if (!type_tcp.isInstance(obj)) continue;
                                    tcpInboundChannel = (TCPInboundChannel)obj;
                                }
                                String endPointName = null;
                                String port = null;
                                if (orbInboundChannel != null && tcpInboundChannel != null) {
                                    EndPoint endPoint;
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found ORB TCP endpoint: " + tcpInboundChannel.getEndPointName());
                                    }
                                    if ((endPoint = endPointMgr.getNodeEndPoints("@").getServerEndPoints("@").getEndPoint(tcpInboundChannel.getEndPointName())) != null) {
                                        port = Integer.toString(endPoint.getPort());
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, "Found ORB port: " + port);
                                        }
                                    }
                                }
                                if (orbInboundChannel != null && tcpInboundChannel != null && sslInboundChannel == null) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Found ORB TCP chain: " + chain.getName());
                                    }
                                    endPointName = tcpInboundChannel.getEndPointName();
                                    Properties transportProps = new Properties();
                                    if (port != null) {
                                        transportProps.setProperty("com.ibm.CORBA.ListenerPort", port);
                                    }
                                    transportProps.setProperty("ChainName", chain.getName());
                                    if (endPointName != null) {
                                        transportProps.setProperty("EndPointName", endPointName);
                                    }
                                    insecureTransportList.add(transportProps);
                                }
                                if (orbInboundChannel == null || sslInboundChannel == null || tcpInboundChannel == null) continue;
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "Found ORB SSL chain: " + chain.getName());
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "ORB SSL config: " + sslInboundChannel.getSslConfigAlias());
                                }
                                String sslConfig = sslInboundChannel.getSslConfigAlias();
                                try {
                                    endPointName = tcpInboundChannel.getEndPointName();
                                    HashMap<String, String> connectionInfo = new HashMap<String, String>();
                                    connectionInfo.put("com.ibm.ssl.direction", "inbound");
                                    connectionInfo.put("com.ibm.ssl.endPointName", endPointName);
                                    Properties sslProps = JSSEHelper.getInstance().getProperties(sslConfig, connectionInfo, null);
                                    if (sslProps == null) continue;
                                    Properties sslPropsCopy = new Properties(sslProps);
                                    if (port != null) {
                                        sslPropsCopy.setProperty("com.ibm.CSI.SSLPort", port);
                                    }
                                    sslPropsCopy.setProperty("ChainName", chain.getName());
                                    if (endPointName != null) {
                                        sslPropsCopy.setProperty("EndPointName", endPointName);
                                    }
                                    secureTransportList.add(sslPropsCopy);
                                }
                                catch (SSLException e) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Exception occurred in setCSIInboundTranportFromChannelFramework: ", new Object[]{e});
                                    }
                                    FFDCFilter.processException(e, "com.ibm.ws.security.util.ORBUtils.setCSIInboundTranportFromChannelFramework", "1265");
                                }
                            }
                            SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
                            security2.setObject("iiop.insecure.transports", insecureTransportList);
                            security2.setObject("iiop.secure.transports", secureTransportList);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "No Chains found in TransportChannelService in server.xml.");
                        }
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "No TransportChannelService found in server.xml.");
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "No Services found in server.xml.");
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block35;
                Tr.debug(tc, "Exception getting http transports: ", new Object[]{e.toString()});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setCSIInboundTranportFromChannelFramework");
        }
        return secureTransportList.size() != 0 || insecureTransportList.size() != 0;
    }
}

