/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.stat.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.stat.SecurityAuthorizationModule;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import com.ibm.wsspi.pmi.stat.SPITimeStatistic;

public class SecurityAuthorizationModuleImpl
extends StatisticActions
implements SecurityAuthorizationModule {
    private static final String template = "/com/ibm/ws/security/stat/SecurityAuthorizationStats.xml";
    private static StatsGroup statsGroup;
    private StatsInstance saStatsInstance;
    private static SecurityAuthorizationModuleImpl authModuleInstance;
    private SPITimeStatistic webAuthTime;
    private SPITimeStatistic ejbAuthTime;
    private SPITimeStatistic adminAuthTime;
    private SPITimeStatistic jaccAuthTime;
    private static final TraceComponent tc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SecurityAuthorizationModuleImpl(String saName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SecurityAuthorizationModuleImpl", saName);
        }
        try {
            try {
                this.saStatsInstance = StatsFactory.createStatsInstance(saName, template, null, (StatisticActions)this);
            }
            catch (StatsFactoryException sfe) {
                Tr.error(tc, "Failed to load PMI Module for Authorization " + saName);
                Object var4_3 = null;
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "SecurityAuthorizationModuleImpl", this);
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "SecurityAuthorizationModuleImpl", this);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "SecurityAuthorizationModuleImpl", this);
    }

    public static SecurityAuthorizationModuleImpl getInstance(String saName) {
        if (authModuleInstance == null) {
            authModuleInstance = new SecurityAuthorizationModuleImpl(saName);
        }
        return authModuleInstance;
    }

    public void statisticCreated(SPIStatistic stat) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "statisticCreated", new Object[]{stat, this});
        }
        int id = stat.getId();
        switch (id) {
            case 1: {
                this.webAuthTime = (SPITimeStatistic)stat;
                break;
            }
            case 2: {
                this.ejbAuthTime = (SPITimeStatistic)stat;
                break;
            }
            case 3: {
                this.adminAuthTime = (SPITimeStatistic)stat;
                break;
            }
            case 4: {
                this.jaccAuthTime = (SPITimeStatistic)stat;
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Invalid statistic id: " + stat.getId());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "statisticCreated");
        }
    }

    public void onWebAuthTime(long elapsedTime) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthorizationModule received an onWebAuthTime event");
        }
        if (this.webAuthTime != null) {
            this.webAuthTime.add(elapsedTime);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authorization statistic webAuthTime is null");
        }
    }

    public void onEJBAuthTime(long elapsedTime) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthorizationModule received an onEJBAuthTime event");
        }
        if (this.ejbAuthTime != null) {
            this.ejbAuthTime.add(elapsedTime);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authorization statistic ejbAuthTime is null");
        }
    }

    public void onAdminAuthTime(long elapsedTime) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthorizationModule received an onAdminAuthTime event");
        }
        if (this.adminAuthTime != null) {
            this.adminAuthTime.add(elapsedTime);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authorization statistic adminAuthTime is null");
        }
    }

    public void onJACCAuthTime(long elapsedTime) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthorizationModule received an onJACCAuthTime event");
        }
        if (this.jaccAuthTime != null) {
            this.jaccAuthTime.add(elapsedTime);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authorization statistic jaccAuthTime is null");
        }
    }

    static {
        authModuleInstance = null;
        tc = Tr.register(SecurityAuthorizationModuleImpl.class, "Security", "com.ibm.ejs.resources.security");
    }
}

