/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.stat.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.stat.SecurityAuthenticationModule;
import com.ibm.wsspi.pmi.factory.StatisticActions;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import com.ibm.wsspi.pmi.stat.SPITimeStatistic;

public class SecurityAuthenticationModuleImpl
extends StatisticActions
implements SecurityAuthenticationModule {
    private static final String template = "/com/ibm/ws/security/stat/SecurityAuthenticationStats.xml";
    private static StatsGroup statsGroup;
    private static StatsInstance saStatsInstance;
    private static SecurityAuthenticationModuleImpl authModuleInstance;
    private SPICountStatistic webAuthCount;
    private SPICountStatistic taiCount;
    private SPICountStatistic idAssertionCount;
    private SPICountStatistic basicAuthCount;
    private SPICountStatistic tokenAuthCount;
    private SPICountStatistic jaasIDAssertionCount;
    private SPICountStatistic jaasBasicAuthCount;
    private SPICountStatistic jaasTokenAuthCount;
    private SPICountStatistic rmiAuthCount;
    private SPITimeStatistic webAuthTime;
    private SPITimeStatistic taiTime;
    private SPITimeStatistic idAssertionTime;
    private SPITimeStatistic basicAuthTime;
    private SPITimeStatistic tokenAuthTime;
    private SPITimeStatistic jaasIDAssertionTime;
    private SPITimeStatistic jaasBasicAuthTime;
    private SPITimeStatistic jaasTokenAuthTime;
    private SPITimeStatistic rmiAuthTime;
    private SPITimeStatistic credCreationTime;
    private static final TraceComponent tc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private SecurityAuthenticationModuleImpl(String saName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "SecurityAuthenticationModuleImpl", saName);
        }
        try {
            try {
                saStatsInstance = StatsFactory.createStatsInstance(saName, template, null, (StatisticActions)this);
            }
            catch (StatsFactoryException sfe) {
                Tr.error(tc, "Failed to load PMI Module for Authentication " + saName);
                Object var4_3 = null;
                if (!tc.isEntryEnabled()) return;
                Tr.exit(tc, "SecurityAuthenticationModuleImpl", this);
                return;
            }
            Object var4_2 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!tc.isEntryEnabled()) throw throwable;
            Tr.exit(tc, "SecurityAuthenticationModuleImpl", this);
            throw throwable;
        }
        if (!tc.isEntryEnabled()) return;
        Tr.exit(tc, "SecurityAuthenticationModuleImpl", this);
    }

    public static SecurityAuthenticationModuleImpl getInstance(String saName) {
        if (authModuleInstance == null) {
            authModuleInstance = new SecurityAuthenticationModuleImpl(saName);
        }
        return authModuleInstance;
    }

    public void statisticCreated(SPIStatistic stat) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "statisticCreated", new Object[]{stat, this});
        }
        int id = stat.getId();
        switch (id) {
            case 1: {
                this.webAuthCount = (SPICountStatistic)stat;
                break;
            }
            case 2: {
                this.taiCount = (SPICountStatistic)stat;
                break;
            }
            case 3: {
                this.idAssertionCount = (SPICountStatistic)stat;
                break;
            }
            case 4: {
                this.basicAuthCount = (SPICountStatistic)stat;
                break;
            }
            case 5: {
                this.tokenAuthCount = (SPICountStatistic)stat;
                break;
            }
            case 6: {
                this.jaasIDAssertionCount = (SPICountStatistic)stat;
                break;
            }
            case 7: {
                this.jaasBasicAuthCount = (SPICountStatistic)stat;
                break;
            }
            case 8: {
                this.jaasTokenAuthCount = (SPICountStatistic)stat;
                break;
            }
            case 9: {
                this.rmiAuthCount = (SPICountStatistic)stat;
                break;
            }
            case 10: {
                this.webAuthTime = (SPITimeStatistic)stat;
                break;
            }
            case 11: {
                this.taiTime = (SPITimeStatistic)stat;
                break;
            }
            case 12: {
                this.idAssertionTime = (SPITimeStatistic)stat;
                break;
            }
            case 13: {
                this.basicAuthTime = (SPITimeStatistic)stat;
                break;
            }
            case 14: {
                this.tokenAuthTime = (SPITimeStatistic)stat;
                break;
            }
            case 15: {
                this.jaasIDAssertionTime = (SPITimeStatistic)stat;
                break;
            }
            case 16: {
                this.jaasBasicAuthTime = (SPITimeStatistic)stat;
                break;
            }
            case 17: {
                this.jaasTokenAuthTime = (SPITimeStatistic)stat;
                break;
            }
            case 18: {
                this.rmiAuthTime = (SPITimeStatistic)stat;
                break;
            }
            case 19: {
                this.credCreationTime = (SPITimeStatistic)stat;
                break;
            }
            default: {
                if (!tc.isDebugEnabled()) break;
                Tr.debug(tc, "Invalid statistic id: " + stat.getId());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "statisticCreated");
        }
    }

    public void onWebAuthCount() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthenticationModule received an onWebAuthCount event");
        }
        if (this.webAuthCount != null) {
            this.webAuthCount.increment();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authentication statistic webAuthCount is null");
        }
    }

    public void onTAICount() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthenticationModule received an onTAICount event");
        }
        if (this.taiCount != null) {
            this.taiCount.increment();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authentication statistic taiCount is null");
        }
    }

    public void onIDAssertionCount() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthenticationModule received an onIDAssertionCount event");
        }
        if (this.idAssertionCount != null) {
            this.idAssertionCount.increment();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authentication statistic idAssertionCount is null");
        }
    }

    public void onBasicAuthCount() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthenticationModule received an onBasicAuthCount event");
        }
        if (this.basicAuthCount != null) {
            this.basicAuthCount.increment();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authentication statistic basicAuthCount is null");
        }
    }

    public void onTokenAuthCount() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthenticationModule received an onTokenAuthCount event");
        }
        if (this.tokenAuthCount != null) {
            this.tokenAuthCount.increment();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authentication statistic tokenAuthCount is null");
        }
    }

    public void onJAASIDAssertionCount() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthenticationModule received an onJAASIDAssertionCount event");
        }
        if (this.jaasIDAssertionCount != null) {
            this.jaasIDAssertionCount.increment();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authentication statistic jaasIDAssertionCount is null");
        }
    }

    public void onJAASBasicAuthCount() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthenticationModule received an onJAASBasicAuthCount event");
        }
        if (this.jaasBasicAuthCount != null) {
            this.jaasBasicAuthCount.increment();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authentication statistic jaasBasicAuthCount is null");
        }
    }

    public void onJAASTokenAuthCount() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthenticationModule received an onJAASTokenAuthCount event");
        }
        if (this.jaasTokenAuthCount != null) {
            this.jaasTokenAuthCount.increment();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authentication statistic jaasTokenAuthCount is null");
        }
    }

    public void onRMIAuthCount() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthenticationModule received an onRMIAuthCount event");
        }
        if (this.rmiAuthCount != null) {
            this.rmiAuthCount.increment();
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authentication statistic rmiAuthCount is null");
        }
    }

    public void onWebAuthTime(long elapsedTime) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthenticationModule received an onWebAuthTime event");
        }
        if (this.webAuthTime != null) {
            this.webAuthTime.add(elapsedTime);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authentication statistic webAuthTime is null");
        }
    }

    public void onTAITime(long elapsedTime) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthenticationModule received an onTAITime event");
        }
        if (this.taiTime != null) {
            this.taiTime.add(elapsedTime);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authentication statistic taiTime is null");
        }
    }

    public void onIDAssertionTime(long elapsedTime) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthenticationModule received an onBasicAuthTime event");
        }
        if (this.idAssertionTime != null) {
            this.idAssertionTime.add(elapsedTime);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authentication statistic idAssertionTime is null");
        }
    }

    public void onBasicAuthTime(long elapsedTime) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthenticationModule received an onBasicAuthTime event");
        }
        if (this.basicAuthTime != null) {
            this.basicAuthTime.add(elapsedTime);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authentication statistic basicAuthTime is null");
        }
    }

    public void onTokenAuthTime(long elapsedTime) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthenticationModule received an onTokenAuthTime event");
        }
        if (this.tokenAuthTime != null) {
            this.tokenAuthTime.add(elapsedTime);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authentication statistic tokenAuthTime is null");
        }
    }

    public void onJAASIDAssertionTime(long elapsedTime) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthenticationModule received an onJAASIDAssertionTime event");
        }
        if (this.jaasIDAssertionTime != null) {
            this.jaasIDAssertionTime.add(elapsedTime);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authentication statistic jaasIDAssertionTime is null");
        }
    }

    public void onJAASBasicAuthTime(long elapsedTime) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthenticationModule received an onJAASBasicAuthTime event");
        }
        if (this.jaasBasicAuthTime != null) {
            this.jaasBasicAuthTime.add(elapsedTime);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authentication statistic jaasBasicAuthTime is null");
        }
    }

    public void onJAASTokenAuthTime(long elapsedTime) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthenticationModule received an onJAASTokenAuthTime event");
        }
        if (this.jaasTokenAuthTime != null) {
            this.jaasTokenAuthTime.add(elapsedTime);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authentication statistic jaasTokenAuthTime is null");
        }
    }

    public void onRMIAuthTime(long elapsedTime) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthenticationModule received an onRMIAuthTime event");
        }
        if (this.rmiAuthTime != null) {
            this.rmiAuthTime.add(elapsedTime);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authentication statistic rmiAuthTime is null");
        }
    }

    public void onCredentialCreationTime(long elapsedTime) {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "SecurityAuthenticationModule received an onCredentialCreationTime event");
        }
        if (this.credCreationTime != null) {
            this.credCreationTime.add(elapsedTime);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Security Authentication statistic credCreationTime is null");
        }
    }

    static {
        authModuleInstance = null;
        tc = Tr.register(SecurityAuthenticationModuleImpl.class, "Security", "com.ibm.ejs.resources.security");
    }
}

