/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.spnego.AllServerConfigs;
import com.ibm.ws.security.spnego.Context;
import com.ibm.ws.security.spnego.ServerConfig;
import com.ibm.ws.security.spnego.ServerCredential;
import com.ibm.ws.security.spnego.TAIConfigurationException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;

public class ServerCredentialsFactory {
    private static GSSManager gssMgr;
    private static Map serverCredentials;
    private static final String ME;
    private static final Logger logger;

    public static boolean initializeServer(ServerConfig serverConfig) throws TAIConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "initializeServer");
        }
        String serverName = serverConfig.getHostName();
        boolean success = false;
        try {
            ServerCredential credential = new ServerCredential(serverConfig);
            serverCredentials.put(serverName, credential);
            logger.logp(Level.INFO, ME, "initializeServer", "security.spnego.spn.init.success", new Object[]{serverName});
            success = true;
        }
        catch (GSSException e) {
            FFDCFilter.processException(e, "com.ibm.ws.security.spnego.ServerCredentialsFactory.initializeServer", "68");
            logger.logp(Level.SEVERE, ME, "initializeServer", "security.spnego.spn.init.failed", new Object[]{serverConfig.getServerName()});
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "initializeServer");
        }
        return success;
    }

    public static synchronized void initializeServerCreds(AllServerConfigs config) throws TAIConfigurationException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "initializeServerCreds");
        }
        int successCount = 0;
        if (config == null) {
            logger.logp(Level.SEVERE, ME, "initializeServerCreds", "security.spnego.unexpected.condition", "AllServerConfigs is null.");
            throw new TAIConfigurationException("initializeServerCreds: config=null");
        }
        if (serverCredentials == null || serverCredentials.isEmpty() || config.isReloadEnabled()) {
            ServerCredentialsFactory.initialize();
            if (logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, ME, "initializeServerCreds", "Initialize server credentials for each service principal name.");
            }
            Enumeration elem = config.getServerConfigs().elements();
            while (elem.hasMoreElements()) {
                ServerConfig serverConfig = (ServerConfig)elem.nextElement();
                if (!ServerCredentialsFactory.initializeServer(serverConfig)) continue;
                ++successCount;
            }
            if (successCount < 1) {
                logger.logp(Level.SEVERE, ME, "initializeServerCreds", "security.spnego.allspns.init.failed");
                throw new TAIConfigurationException("initializeServerCreds: no credentials successfully created.");
            }
        } else if (logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, ME, "initializeServerCreds", "Server credentials already initialized.");
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "initializeServerCreds");
        }
    }

    public static void initialize() {
        gssMgr = GSSManager.getInstance();
    }

    public static Context createContext(String serverName) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "createContext", serverName);
        }
        Context result = null;
        ServerCredential credential = (ServerCredential)serverCredentials.get(serverName);
        GSSCredential gssCred = credential.getGssCred();
        result = new Context(gssCred);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "createContext");
        }
        return result;
    }

    public static boolean hasServerCredentialsFor(String serverName) {
        boolean result = serverCredentials.containsKey(serverName);
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "hasServerCredentialsFor", serverName);
            logger.exiting(ME, "hasServerCredentialsFor", Boolean.toString(result));
        }
        return result;
    }

    public static GSSManager getMgr() {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "getMgr");
            logger.exiting(ME, "getMgr", gssMgr);
        }
        return gssMgr;
    }

    static {
        serverCredentials = new HashMap(16);
        ME = ServerCredentialsFactory.class.getName();
        logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
    }
}

