/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.wsspi.security.spnego.SpnegoTAIFilter;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class HTTPHeaderFilter
implements SpnegoTAIFilter {
    private static final String ME = HTTPHeaderFilter.class.getName();
    private static final Logger logger = Logger.getLogger(ME, "com.ibm.ws.security.spnego.resources.TAIMsgs");
    private boolean processAll = false;
    protected static final int _filterconditionSize = 32;
    protected static Vector filterCondition;

    public boolean init(String s1) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "init", s1);
        }
        boolean result = HTTPHeaderFilter.isValid(s1);
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "init", Boolean.toString(result));
        }
        return result;
    }

    public static boolean isValid(String s1) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "isValid", s1);
        }
        boolean result = true;
        if (s1 == null) {
            logger.logp(Level.SEVERE, ME, "isValid", "security.spnego.filter.init.null.string");
            result = false;
        } else {
            filterCondition = new Vector(32);
            StringTokenizer st1 = new StringTokenizer(s1, ";");
            StringTokenizer st2 = null;
            String s2 = null;
            String[] s3 = new String[3];
            while (st1.hasMoreElements()) {
                s2 = st1.nextToken();
                st2 = new StringTokenizer(s2, "^=!<>%");
                if (s2 == null || st2.countTokens() < 2) {
                    logger.logp(Level.SEVERE, ME, "isValid", "security.spnego.malformed.filter.condition", new Object[]{s1, s2, s3});
                    result = false;
                    break;
                }
                filterCondition.add(new String[3]);
                s3 = (String[])filterCondition.lastElement();
                s3[0] = st2.nextToken();
                s3[2] = st2.nextToken();
                if (s2 == null) {
                    logger.logp(Level.SEVERE, ME, "isValid", "security.spnego.malformed.filter.condition", new Object[]{s1, s2, s3});
                    result = false;
                    break;
                }
                s3[1] = s2.substring(s3[0].length(), s2.length() - s3[2].length()).trim();
                if (!(s3[1].equals("==") || s3[1].equals("!=") || s3[1].equals("^=") || s3[1].equals("%=") || s3[1].equals("<") || s3[1].equals(">"))) {
                    logger.logp(Level.SEVERE, ME, "isValid", "security.spnego.malformed.filter.operator", new Object[]{s3[1]});
                    result = false;
                    break;
                }
                logger.logp(Level.FINER, ME, "isValid", "Adding " + s3[0] + " " + s3[1] + " " + s3[2]);
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "isValid", Boolean.toString(result));
        }
        return result;
    }

    public boolean isAccepted(HttpServletRequest req) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "isAccepted");
        }
        boolean isAccepted = true;
        String reason = "TAI will intercept request.";
        if (this.processAll) {
            reason = "processAll is true, therefore we always intercept.";
        } else {
            String[] s1 = new String[3];
            String HTTPheader = null;
            for (int i = 0; i < filterCondition.size(); ++i) {
                s1 = (String[])filterCondition.elementAt(i);
                HTTPheader = req.getHeader(s1[0]);
                if (HTTPheader == null) {
                    if (s1[0].equals("remote-address")) {
                        HTTPheader = req.getRemoteAddr();
                        if (logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, ME, "isAccepted", "HTTPheader obtained from 'remote-address' " + HTTPheader);
                        }
                    } else if (s1[0].equals("request-url")) {
                        String url = req.getRequestURL().toString();
                        String q = req.getQueryString();
                        HTTPheader = q != null && q.length() > 0 ? url + '?' + q : url;
                        if (logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, ME, "isAccepted", "HTTPheader obtained from 'request-url' " + HTTPheader);
                        }
                    } else {
                        reason = "No HTTPheader found, and no 'remote-address' or 'request-url' rule used - do not Intercept.";
                        isAccepted = false;
                        break;
                    }
                }
                if (s1[1].equals("!=")) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "isAccepted", "Processing !=" + s1[2] + " - " + HTTPheader);
                    }
                    if (HTTPheader.indexOf(s1[2]) < 0) continue;
                    reason = "Found match, so do not intercept.";
                    isAccepted = false;
                    break;
                }
                if (s1[1].equals("==")) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "isAccepted", "Processing ==" + s1[2] + " - " + HTTPheader);
                    }
                    if (HTTPheader.equals(s1[2])) continue;
                    reason = "Did not find a match, so do not intercept.";
                    isAccepted = false;
                    break;
                }
                if (s1[1].equals("^=")) {
                    String clause;
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "isAccepted", "Processing ^=" + s1[2] + " - " + HTTPheader);
                    }
                    boolean oneOfMatch = false;
                    int nextOr = s1[2].indexOf("|");
                    int lastOr = 0;
                    String string = clause = nextOr == -1 ? s1[2] : s1[2].substring(0, nextOr);
                    while (!oneOfMatch && clause != null) {
                        if (HTTPheader.indexOf(clause) >= 0) {
                            oneOfMatch = true;
                        }
                        if (nextOr == -1) {
                            clause = null;
                            continue;
                        }
                        lastOr = nextOr + 1;
                        clause = (nextOr = s1[2].indexOf("|", lastOr)) == -1 ? s1[2].substring(lastOr) : s1[2].substring(lastOr, nextOr);
                    }
                    if (oneOfMatch) continue;
                    reason = "Did not find a match, so do not intercept";
                    isAccepted = false;
                    break;
                }
                if (s1[1].equals("%=")) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "isAccepted", "Processing %=" + s1[2] + " - " + HTTPheader);
                    }
                    if (HTTPheader.indexOf(s1[2]) >= 0) continue;
                    reason = "Did not find a match, so do not intercept.";
                    isAccepted = false;
                    break;
                }
                if (s1[1].equals(">")) {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, ME, "isAccepted", "Processing >" + s1[2] + " - " + HTTPheader);
                    }
                    if (HTTPheader.compareTo(s1[2]) > 0) continue;
                    reason = "Value is < needed, so do not intercept.";
                    isAccepted = false;
                    break;
                }
                if (!s1[1].equals("<")) continue;
                if (logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, ME, "isAccepted", "Processing <" + s1[2] + " - " + HTTPheader);
                }
                if (HTTPheader.compareTo(s1[2]) < 0) continue;
                reason = "Value is > needed, so do not intercept";
                isAccepted = false;
                break;
            }
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "isAccepted", isAccepted + " " + reason);
        }
        return isAccepted;
    }

    public void setProcessAll(boolean b) {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(ME, "setProcessAll", Boolean.toString(b));
        }
        this.processAll = b;
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(ME, "setProcessAll");
        }
    }
}

