/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.server.lm;

import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.GSSFactory;
import com.ibm.ISecurityLocalObjectCSIv2UtilityImpl.OID;
import com.ibm.ISecurityUtilityImpl.CSIUtil;
import com.ibm.ISecurityUtilityImpl.StringBytesConversion;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.WebSphereRuntimePermission;
import com.ibm.websphere.security.auth.CredentialDestroyedException;
import com.ibm.websphere.security.auth.TokenCreationFailedException;
import com.ibm.websphere.security.auth.WSLoginFailedException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.websphere.security.auth.callback.WSAuthMechOidCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSCredTokenCallbackImpl;
import com.ibm.websphere.security.auth.callback.WSRealmNameCallbackImpl;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.BasicAuthData;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.common.auth.util.CredentialsHelper;
import com.ibm.ws.security.common.auth.util.Util;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.config.SingleSignonConfig;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.ltpa.LTPAServerObject;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.server.LTPAConfigException;
import com.ibm.ws.security.server.SecurityServerImpl;
import com.ibm.ws.security.token.WSCredentialTokenMapper;
import com.ibm.ws.security.util.AccessController;
import com.ibm.wsspi.security.auth.callback.WSAppContextCallback;
import com.ibm.wsspi.security.auth.callback.WSServletRequestCallback;
import com.ibm.wsspi.security.auth.callback.WSServletResponseCallback;
import com.ibm.wsspi.security.auth.callback.WSTokenHolderCallback;
import com.ibm.wsspi.security.auth.callback.WSX509CertificateChainCallback;
import com.ibm.wsspi.security.token.AuthenticationToken;
import com.ibm.wsspi.security.token.AuthorizationToken;
import com.ibm.wsspi.security.token.SingleSignonToken;
import java.io.IOException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Hashtable;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.CredentialExpiredException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;

public class ltpaLoginModule
implements LoginModule {
    private String LTPA_OID = "oid:1.3.18.0.2.30.2";
    private String authMechOid = null;
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private WSPrincipal principal;
    private WSCredential credential;
    private UserRegistry registry;
    protected boolean debug = false;
    private LTPAServerObject ltpaServer;
    private static final WebSphereRuntimePermission MAP_CREDENTIAL = new WebSphereRuntimePermission("mapCredential");
    private static final TraceComponent tc = Tr.register(ltpaLoginModule.class, null, "com.ibm.ejs.resources.security");

    public ltpaLoginModule() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ltpaLoginModule()");
            Tr.exit(tc, "ltpaLoginModule()");
        }
    }

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize(subject = \"" + subject.toString() + "\", callbackHandler = \"" + callbackHandler.toString() + "\", sharedState = \"" + sharedState.toString() + "\", options = \"" + options.toString() + "\")");
        }
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        ContextManager contextManager = ContextManagerFactory.getInstance();
        if (contextManager.isCellSecurityEnabled()) {
            block6: {
                try {
                    this.ltpaServer = LTPAServerObject.getLTPAServer();
                }
                catch (LTPAConfigException e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.ltpaLoginModule.initialize", "166", this);
                    if (!this.debug && !tc.isDebugEnabled()) break block6;
                    Tr.debug(tc, "ERROR: Failed to get the LTPA server object.");
                }
            }
            this.registry = SecurityServerImpl.getRegistryImpl(contextManager.getDefaultRealm());
            contextManager.clearRootException();
        }
        this.debug = "true".equalsIgnoreCase((String)this.options.get("debug"));
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "WSLoginModuleImpl initialized");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize(subject, callbackHandler, sharedState, options)");
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean login() throws LoginException {
        if (this.debug || ltpaLoginModule.tc.isEntryEnabled()) {
            Tr.entry(ltpaLoginModule.tc, "login()");
        }
        if (!(contextManager = ContextManagerFactory.getInstance()).isCellSecurityEnabled()) {
            try {
                Tr.warning(ltpaLoginModule.tc, "security.disabled.during.login");
                if (ltpaLoginModule.tc.isDebugEnabled()) {
                    Thread.dumpStack();
                }
                unAuthSubject = SubjectHelper.createUnauthenticatedSubject();
                this.credential = SubjectHelper.getWSCredentialFromSubject(unAuthSubject);
                this.principal = SubjectHelper.createPrincipal(this.credential);
            }
            catch (Exception e) {
                if (ltpaLoginModule.tc.isDebugEnabled()) {
                    Tr.debug(ltpaLoginModule.tc, "Exception creating principal.", new Object[]{e});
                }
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "247", this);
                throw new WSLoginFailedException(e.getMessage(), e);
            }
            this.sharedState.put("WSPrincipal", this.principal);
            this.sharedState.put("WSCredential", this.credential);
            this.succeeded = true;
            if (this.debug || ltpaLoginModule.tc.isEntryEnabled()) {
                Tr.exit(ltpaLoginModule.tc, "login(security disabled)");
            }
            return this.succeeded;
        }
        security = SecurityObjectLocator.getSecurityConfig();
        this.succeeded = false;
        if (this.commitSucceeded) {
            if (this.debug || ltpaLoginModule.tc.isDebugEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "The login module is in funny state, cleanup before starting a new login process.");
            }
            this.cleanup();
        }
        nameCallback = null;
        passwordCallback = null;
        wsCredTokenCallback = null;
        wsServletRequestCallback = null;
        wsServletResponseCallback = null;
        wsAppContextCallback = null;
        wsTokenHolderCallback = null;
        wsRealmNameCallback = null;
        wsX509CertificateCallback = null;
        wsAuthMechOidCallback = null;
        callbacks = null;
        if (!this.sharedState.containsKey("Callback")) {
            if (this.callbackHandler == null) {
                e = new WSLoginFailedException("No CallbackHandler available to gather authentication information from the user.");
                contextManager.setRootException(e);
                throw e;
            }
            callbacks = new Callback[10];
            nameCallback = new NameCallback("Username: ");
            callbacks[0] = nameCallback;
            passwordCallback = new PasswordCallback("Password: ", false);
            callbacks[1] = passwordCallback;
            wsCredTokenCallback = new WSCredTokenCallbackImpl("Credential Token: ");
            callbacks[2] = wsCredTokenCallback;
            wsServletRequestCallback = new WSServletRequestCallback("HttpServletRequest: ");
            callbacks[3] = wsServletRequestCallback;
            wsServletResponseCallback = new WSServletResponseCallback("HttpServletResponse: ");
            callbacks[4] = wsServletResponseCallback;
            wsAppContextCallback = new WSAppContextCallback("ApplicationContextCallback: ");
            callbacks[5] = wsAppContextCallback;
            wsTokenHolderCallback = new WSTokenHolderCallback("Authz Token List: ");
            callbacks[6] = wsTokenHolderCallback;
            wsRealmNameCallback = new WSRealmNameCallbackImpl("Realm Name", contextManager.getDefaultRealm());
            callbacks[7] = wsRealmNameCallback;
            wsX509CertificateCallback = new WSX509CertificateChainCallback("X509Certificate[]: ");
            callbacks[8] = wsX509CertificateCallback;
            wsAuthMechOidCallback = new WSAuthMechOidCallbackImpl("AuthMechOid: ");
            callbacks[9] = wsAuthMechOidCallback;
            try {
                this.callbackHandler.handle(callbacks);
            }
            catch (IOException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "235", this);
                Tr.error(ltpaLoginModule.tc, "security.jaas.callBackHandlerIOException", new Object[]{this.getClass().getName(), e});
                contextManager.setRootException(e);
                throw new WSLoginFailedException("IOException: " + e.getMessage(), e);
            }
            catch (UnsupportedCallbackException uce) {
                FFDCFilter.processException((Throwable)uce, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "242", this);
                Tr.error(ltpaLoginModule.tc, "security.jaas.callBackHandlerException", new Object[]{this.getClass().getName(), uce.getCallback().toString(), uce});
                contextManager.setRootException(uce);
                throw new WSLoginFailedException(uce.getCallback().toString() + " not supported by CallbackHandler to gather authentication information " + "from the user" + uce.getMessage(), uce);
            }
            this.sharedState.put("Callback", callbacks);
        } else {
            callbacks = (Callback[])this.sharedState.get("Callback");
            for (i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] == null) continue;
                if (callbacks[i] instanceof NameCallback) {
                    nameCallback = (NameCallback)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    passwordCallback = (PasswordCallback)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof WSCredTokenCallbackImpl) {
                    wsCredTokenCallback = (WSCredTokenCallbackImpl)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof WSServletRequestCallback) {
                    wsServletRequestCallback = (WSServletRequestCallback)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof WSServletResponseCallback) {
                    wsServletResponseCallback = (WSServletResponseCallback)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof WSAppContextCallback) {
                    wsAppContextCallback = (WSAppContextCallback)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof WSTokenHolderCallback) {
                    wsTokenHolderCallback = (WSTokenHolderCallback)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof WSRealmNameCallbackImpl) {
                    wsRealmNameCallback = (WSRealmNameCallbackImpl)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof WSX509CertificateChainCallback) {
                    wsX509CertificateCallback = (WSX509CertificateChainCallback)callbacks[i];
                    continue;
                }
                if (callbacks[i] instanceof WSAuthMechOidCallbackImpl) {
                    wsAuthMechOidCallback = (WSAuthMechOidCallbackImpl)callbacks[i];
                    continue;
                }
                if (!this.debug && !ltpaLoginModule.tc.isDebugEnabled()) continue;
                Tr.debug(ltpaLoginModule.tc, "The following callback was ignored: " + callbacks[i].getClass().getName());
            }
        }
        uid = null;
        realm = null;
        password = null;
        credToken = null;
        authzTokenList = null;
        certChain = null;
        isHTTPRequest = false;
        if (nameCallback != null) {
            uid = nameCallback.getName();
        }
        if (wsRealmNameCallback != null) {
            realm = wsRealmNameCallback.getRealmName();
        }
        if (wsAuthMechOidCallback != null) {
            this.authMechOid = wsAuthMechOidCallback.getAuthMechOid();
        }
        if (realm == null) {
            if (this.debug || ltpaLoginModule.tc.isDebugEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "realm from threadLocal is = " + realm);
            }
            realm = SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getString("realm");
        }
        this.registry = SecurityServerImpl.getRegistryImpl();
        if (passwordCallback != null && (tmp = passwordCallback.getPassword()) != null && tmp.length != 0) {
            password = new char[tmp.length];
            System.arraycopy(tmp, 0, password, 0, tmp.length);
        }
        if (wsCredTokenCallback != null && (tmpCred = wsCredTokenCallback.getCredToken()) != null) {
            credToken = CredentialsHelper.copyCredToken(tmpCred);
            if (this.authMechOid == null || this.authMechOid.length() == 0) {
                try {
                    this.authMechOid = GSSFactory.getMechOIDFromGSSToken(credToken);
                    if (ltpaLoginModule.tc.isDebugEnabled()) {
                        Tr.debug(ltpaLoginModule.tc, "authMechOid pass in is null, get authMechOid from the credToken: " + this.authMechOid);
                    }
                }
                catch (Exception e) {
                    parms = new Object[]{ltpaLoginModule.class, "credToken"};
                    throw new WSLoginFailedException("Get authMechOid from the credToken exception - " + e.getMessage(), e);
                }
            }
        }
        if (this.authMechOid == null) {
            this.authMechOid = this.LTPA_OID;
        }
        if (wsTokenHolderCallback != null) {
            authzTokenList = wsTokenHolderCallback.getTokenHolderList();
        }
        if (wsServletRequestCallback != null) {
            v0 = isHTTPRequest = wsServletRequestCallback.getHttpServletRequest() != null;
        }
        if (wsX509CertificateCallback != null) {
            certChain = wsX509CertificateCallback.getX509CertificateChain();
        }
        if ((customProperties = (Hashtable)this.sharedState.get("com.ibm.wsspi.security.cred.propertiesObject")) == null) {
            try {
                subjectPriv = this.subject;
                customProperties = (Hashtable)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws CredentialDestroyedException, CredentialExpiredException {
                        Object[] list_public = subjectPriv.getPublicCredentials().toArray();
                        if (ltpaLoginModule.this.debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking for custom properties in public cred list.");
                        }
                        for (int i = 0; i < list_public.length; ++i) {
                            if (ltpaLoginModule.this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Object[" + i + "] in public list: " + list_public[i]);
                            }
                            if (!(list_public[i] instanceof Hashtable) || ((Hashtable)list_public[i]).get("com.ibm.wsspi.security.cred.uniqueId") == null && ((Hashtable)list_public[i]).get("com.ibm.wsspi.security.cred.userId") == null) continue;
                            return list_public[i];
                        }
                        Object[] list_private = subjectPriv.getPrivateCredentials().toArray();
                        if (ltpaLoginModule.this.debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Looking for custom properties in private cred list.");
                        }
                        for (int i = 0; i < list_private.length; ++i) {
                            if (ltpaLoginModule.this.debug || tc.isDebugEnabled()) {
                                Tr.debug(tc, "Object[" + i + "] in private list: " + list_private[i]);
                            }
                            if (!(list_private[i] instanceof Hashtable) || ((Hashtable)list_private[i]).get("com.ibm.wsspi.security.cred.uniqueId") == null && ((Hashtable)list_private[i]).get("com.ibm.wsspi.security.cred.userId") == null) continue;
                            return list_private[i];
                        }
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "334", this);
                contextManager.setRootException(e.getException());
                throw new WSLoginFailedException(e.getException().getMessage(), e.getException());
            }
            if (customProperties != null) {
                this.sharedState.put("com.ibm.wsspi.security.cred.propertiesObject", customProperties);
            }
        }
        if (this.debug || ltpaLoginModule.tc.isDebugEnabled()) {
            Tr.debug(ltpaLoginModule.tc, "uid = " + uid);
            Tr.debug(ltpaLoginModule.tc, "realm = " + realm);
            Tr.debug(ltpaLoginModule.tc, "password = " + (password == null ? "<null>" : "XXXXXXXX"));
            Tr.debug(ltpaLoginModule.tc, "cred token = " + Util.toString(credToken));
            Tr.debug(ltpaLoginModule.tc, "X509 cert chain = " + certChain);
            Tr.debug(ltpaLoginModule.tc, "authz token list = " + authzTokenList);
            Tr.debug(ltpaLoginModule.tc, "custom properties = " + customProperties);
            Tr.debug(ltpaLoginModule.tc, "isHTTPRequest = " + isHTTPRequest);
            Tr.debug(ltpaLoginModule.tc, "authMechOid = " + this.authMechOid);
        }
        if (credToken != null && !OID.compareOIDs(this.authMechOid, this.LTPA_OID)) {
            if (this.debug || ltpaLoginModule.tc.isEntryEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "Authentication mechanism OID passing in is not LTPA.  Handling login outside this login module.");
                Tr.exit(ltpaLoginModule.tc, "login()");
            }
            this.succeeded = true;
            return this.succeeded;
        }
        kPrincipal = (KerberosPrincipal)this.sharedState.get("javax.security.auth.kerberos.KerberosPrincipal");
        kTicket = (KerberosTicket)this.sharedState.get("javax.security.auth.kerberos.KerberosTicket");
        if (kPrincipal != null && kTicket != null) {
            this.succeeded = true;
            if (this.debug || ltpaLoginModule.tc.isEntryEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "Get Kerberos principal/ticket in a shared state. Handling login outside this login module.");
                Tr.exit(ltpaLoginModule.tc, "login()");
            }
            return this.succeeded;
        }
        if (customProperties != null && customProperties.get("com.ibm.wsspi.security.cred.uniqueId") != null && customProperties.get("com.ibm.wsspi.security.cred.userId") == null) {
            this.succeeded = true;
            if (this.debug || ltpaLoginModule.tc.isEntryEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "Custom login module passing in credential properties.  Handling login outside this login module.");
                Tr.exit(ltpaLoginModule.tc, "login()");
            }
            return this.succeeded;
        }
        if (customProperties != null && customProperties.get("com.ibm.wsspi.security.cred.userId") != null) {
            if (this.debug || ltpaLoginModule.tc.isEntryEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "Setting uid and/or password from hashtable.");
            }
            uid = (String)customProperties.get("com.ibm.wsspi.security.cred.userId");
            temp_password = (String)customProperties.get("com.ibm.wsspi.security.cred.password");
            if (temp_password != null) {
                password = temp_password.toCharArray();
            }
            if (this.debug || ltpaLoginModule.tc.isDebugEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "uid = " + uid);
                Tr.debug(ltpaLoginModule.tc, "password = " + (password == null ? "<null>" : "XXXXXXXX"));
            }
        }
        if (WSCredentialTokenMapper.isAnyPropagationEnabled() && authzTokenList != null && (credToken != null || (uid != null || certChain != null) && password == null)) {
            this.succeeded = true;
            if (this.debug || ltpaLoginModule.tc.isEntryEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "Security attribute propagation data has been received.  Handling login outside this login module.");
                Tr.exit(ltpaLoginModule.tc, "login()");
            }
            return this.succeeded;
        }
        if (certChain == null && uid == null && password == null && credToken == null) {
            e = new WSLoginFailedException("No authentication data.");
            contextManager.setRootException(e);
            throw e;
        }
        if (this.debug || ltpaLoginModule.tc.isDebugEnabled()) {
            Tr.debug(ltpaLoginModule.tc, "Successfully gathered authentication information");
        }
        if (uid != null && password != null) {
            if (this.debug || ltpaLoginModule.tc.isDebugEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "Using uid and password for authentication");
                buf = new StringBuffer("Authenticating \"");
                buf.append(realm).append('/').append(uid).append("\"");
                Tr.debug(ltpaLoginModule.tc, buf.toString());
            }
            passwd = new String(password);
            ba = new BasicAuthData(uid, passwd);
            try {
                this.credential = this.ltpaServer.authenticate(ba);
            }
            catch (WSLoginFailedException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "452", this);
                if (this.debug || ltpaLoginModule.tc.isEntryEnabled()) {
                    Tr.exit(ltpaLoginModule.tc, "login()", new Object[]{e});
                }
                contextManager.setRootException(e);
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "459", this);
                if (this.debug || ltpaLoginModule.tc.isEntryEnabled()) {
                    Tr.exit(ltpaLoginModule.tc, "login()", new Object[]{e});
                }
                contextManager.setRootException(e);
                throw new WSLoginFailedException(e.getMessage(), e);
            }
        }
        if (uid != null || certChain != null) {
            sm = System.getSecurityManager();
            if (sm != null) {
                if (ltpaLoginModule.tc.isDebugEnabled()) {
                    Tr.debug(ltpaLoginModule.tc, "Performing Java 2 Security Permission Check ...");
                    Tr.debug(ltpaLoginModule.tc, "Expecting : " + ltpaLoginModule.MAP_CREDENTIAL.toString());
                }
                sm.checkPermission(ltpaLoginModule.MAP_CREDENTIAL);
            }
            if (certChain != null) {
                cert_chain_final = certChain;
                action = new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        if (ltpaLoginModule.this.debug || tc.isDebugEnabled()) {
                            Tr.debug(tc, "Mapping X509Certificate[] to uid.");
                        }
                        return CSIUtil.getInstance().parseCert(cert_chain_final);
                    }
                };
                try {
                    uid = (String)contextManager.runAsSystem(action);
                    if (uid == null) {
                        if (ltpaLoginModule.tc.isDebugEnabled()) {
                            Tr.debug(ltpaLoginModule.tc, "Client certificate did not map to uid.");
                        }
                        throw new WSLoginFailedException("Client certificate did not map to uid.");
                    }
                }
                catch (PrivilegedActionException e) {
                    FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.server.ltpa.ltpaLoginModule.login", "675", this);
                    if (ltpaLoginModule.tc.isDebugEnabled()) {
                        Tr.debug(ltpaLoginModule.tc, "Exception parsing client certificate.", new Object[]{e.getException()});
                    }
                    throw new WSLoginFailedException(e.getException().getMessage(), e.getException());
                }
            }
            if (this.debug || ltpaLoginModule.tc.isDebugEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "Using uid to mapCredential");
                buf = new StringBuffer("Authenticating \"");
                buf.append(realm).append('/').append(uid).append("\"");
                Tr.debug(ltpaLoginModule.tc, buf.toString());
            }
            try {
                if (SecurityObjectLocator.getSecurityConfig().getActiveUserRegistry().getBoolean("com.ibm.websphere.security.registry.UseTAM") && !RegistryUtil.checkValidUserifTAM(uid, this.registry)) {
                    throw new WSLoginFailedException("User is not valid in Access Manager");
                }
                internalServerId = SecurityObjectLocator.getAdminData().getString("com.ibm.ws.security.internalServerId");
                if (internalServerId != null && contextManager.isInternalServerId(uid)) {
                    this.credential = contextManager.getServerCredential();
                    if (!ltpaLoginModule.tc.isDebugEnabled()) ** GOTO lbl326
                    Tr.debug(ltpaLoginModule.tc, "Got credential from ContextManager: " + this.credential);
                }
                mapCred = this.registry.createCredential(uid);
                this.credential = this.ltpaServer.createLTPAToken(mapCred);
            }
            catch (TokenCreationFailedException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "532", this);
                Tr.debug(ltpaLoginModule.tc, "Using uid to mapCredential");
                contextManager.setRootException(e);
                throw new WSLoginFailedException(e.getMessage(), e);
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "539", this);
                contextManager.setRootException(e);
                throw new WSLoginFailedException(e.getMessage(), e);
            }
        } else if (credToken != null) {
            if (this.debug || ltpaLoginModule.tc.isDebugEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "Using credential token for authentication");
            }
            try {
                if (isHTTPRequest) {
                    if (this.debug || ltpaLoginModule.tc.isDebugEnabled()) {
                        Tr.debug(ltpaLoginModule.tc, "Converting SSO token to authentication token.");
                    }
                    ssoLtpaToken = null;
                    ssoLtpaToken = this.ltpaServer.validateToken(credToken);
                    accessID = ssoLtpaToken.getAttributes("u");
                    authLtpaToken = null;
                    if (accessID != null && accessID[0] != null) {
                        tokenFactoryString = security.getProperty("com.ibm.wsspi.security.token.authenticationTokenFactory");
                        authLtpaToken = this.ltpaServer.createLTPAToken(accessID[0], tokenFactoryString);
                        this.credential = this.ltpaServer.validate(authLtpaToken);
                    }
                }
                if (this.credential != null) ** GOTO lbl326
                this.credential = this.ltpaServer.validate(credToken);
            }
            catch (WSLoginFailedException e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "578", this);
                contextManager.setRootException(e);
                throw e;
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "584", this);
                contextManager.setRootException(e);
                throw new WSLoginFailedException(e.getMessage(), e);
            }
        } else {
            e = new WSLoginFailedException("ltpaLoginModule: No authentication data");
            contextManager.setRootException(e);
            throw e;
        }
lbl326:
        // 6 sources

        if (this.credential == null) {
            e = new WSLoginFailedException("ltpaLoginModule: Credential returned from SAS authentication is null");
            contextManager.setRootException(e);
            throw e;
        }
        try {
            this.principal = SubjectHelper.createPrincipal(this.credential);
        }
        catch (WSSecurityException e) {
            if (ltpaLoginModule.tc.isDebugEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "Problem creating principal.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "616", this);
            contextManager.setRootException(e);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        catch (Exception e) {
            if (ltpaLoginModule.tc.isDebugEnabled()) {
                Tr.debug(ltpaLoginModule.tc, "Exception creating principal.", new Object[]{e});
            }
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.ltpaLoginModule.login", "623", this);
            contextManager.setRootException(e);
            throw new WSLoginFailedException(e.getMessage(), e);
        }
        this.sharedState.put("WSPrincipal", this.principal);
        this.sharedState.put("WSCredential", this.credential);
        this.succeeded = true;
        if (this.debug || ltpaLoginModule.tc.isEntryEnabled()) {
            Tr.exit(ltpaLoginModule.tc, "login()");
        }
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "commit()");
        }
        boolean bRet = false;
        if (!this.succeeded) {
            if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "Do not commit because of authentication failed.");
            }
            bRet = false;
        } else {
            if (!this.commitSucceeded) {
                Tr.debug(tc, "shared state contains: " + this.sharedState.keySet());
                ContextManager contextManager = ContextManagerFactory.getInstance();
                this.principal = (WSPrincipal)this.sharedState.get("WSPrincipal");
                if (this.principal == null) {
                    WSLoginFailedException e = new WSLoginFailedException("ltpaLoginModule: WSPrincipal is null in commit (phase 2) stage");
                    contextManager.setRootException(e);
                    throw e;
                }
                this.credential = (WSCredential)this.sharedState.get("WSCredential");
                if (this.credential == null) {
                    WSLoginFailedException e = new WSLoginFailedException("ltpaLoginModule: WSCredential is null in commit (phase 2) stage");
                    contextManager.setRootException(e);
                    throw e;
                }
                try {
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Start committing the changes to the Subject ...");
                    }
                    try {
                        AccessController.doPrivileged(new PrivilegedExceptionAction(){

                            public Object run() throws CredentialDestroyedException, CredentialExpiredException, WSLoginFailedException {
                                if (!ltpaLoginModule.this.subject.getPrincipals().contains(ltpaLoginModule.this.principal)) {
                                    ltpaLoginModule.this.subject.getPrincipals().add(ltpaLoginModule.this.principal);
                                }
                                if (!ltpaLoginModule.this.subject.getPublicCredentials().contains(ltpaLoginModule.this.credential)) {
                                    if (ltpaLoginModule.this.debug || tc.isDebugEnabled()) {
                                        Tr.debug(tc, "Credential: " + ltpaLoginModule.this.credential);
                                    }
                                    ltpaLoginModule.this.credential.set("wssecurity.identity_name", "ClientAuthenticationToken");
                                    ltpaLoginModule.this.credential.set("wssecurity.identity_value", StringBytesConversion.getConvertedBytes(ltpaLoginModule.this.credential.getRealmSecurityName()));
                                    ltpaLoginModule.this.subject.getPublicCredentials().add(ltpaLoginModule.this.credential);
                                }
                                if (!WSCredentialTokenMapper.isAnyPropagationEnabled()) {
                                    AuthenticationToken authTokenTemp = (AuthenticationToken)ltpaLoginModule.this.sharedState.get("com.ibm.wsspi.security.token.wsAuthenticationToken");
                                    AuthorizationToken authzTokenTemp = (AuthorizationToken)ltpaLoginModule.this.sharedState.get("com.ibm.wsspi.security.token.wsAuthorizationToken");
                                    if (ltpaLoginModule.this.credential != null && authTokenTemp == null && authzTokenTemp == null) {
                                        SingleSignonConfig sso = SecurityObjectLocator.getSecurityConfig().getActiveAuthMechanism().getSingleSignon();
                                        Boolean enabled = false;
                                        if (sso != null) {
                                            enabled = sso.getBoolean("enabled");
                                        }
                                        if (enabled != null && enabled.booleanValue()) {
                                            AuthorizationToken authzToken = WSCredentialTokenMapper.getInstance().createAuthzTokenFromWSCredential(ltpaLoginModule.this.credential);
                                            AuthenticationToken authToken = WSCredentialTokenMapper.getInstance().createAuthTokenFromWSCredential(ltpaLoginModule.this.credential);
                                            SingleSignonToken ssoToken = null;
                                            Boolean ssoEnabled = (boolean)enabled;
                                            KerberosTicket kTicket = (KerberosTicket)ltpaLoginModule.this.sharedState.get("javax.security.auth.kerberos.KerberosTicket");
                                            if (ssoEnabled != null && ssoEnabled.booleanValue()) {
                                                ssoToken = WSCredentialTokenMapper.getInstance().createSSOTokenAndSetAttributes(ltpaLoginModule.this.credential, kTicket != null);
                                            }
                                            if (authzToken != null) {
                                                if (ltpaLoginModule.this.debug || tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Adding AuthorizationToken to Subject.");
                                                }
                                                ltpaLoginModule.this.subject.getPrivateCredentials().add(authzToken);
                                            }
                                            if (authToken != null) {
                                                if (ltpaLoginModule.this.debug || tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Adding AuthenticationToken to Subject.");
                                                }
                                                ltpaLoginModule.this.subject.getPrivateCredentials().add(authToken);
                                            }
                                            if (ssoToken != null) {
                                                if (ltpaLoginModule.this.debug || tc.isDebugEnabled()) {
                                                    Tr.debug(tc, "Adding SingleSignonToken to Subject.");
                                                }
                                                ltpaLoginModule.this.subject.getPrivateCredentials().add(ssoToken);
                                            }
                                        }
                                    }
                                }
                                return null;
                            }
                        });
                    }
                    catch (PrivilegedActionException e) {
                        FFDCFilter.processException((Throwable)e.getException(), "com.ibm.ws.security.server.lm.ltpaLoginModule.commit", "725", this);
                        contextManager.setRootException(e.getException());
                        throw new WSLoginFailedException(e.getException().getMessage(), e.getException());
                    }
                    if (this.debug || tc.isDebugEnabled()) {
                        Tr.debug(tc, "Change committed!");
                    }
                    this.commitSucceeded = true;
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.ltpaLoginModule.commit", "736", this);
                    Tr.error(tc, "security.jaas.LoginModuleCommitError", new Object[]{this.getClass().getName(), e});
                    this.cleanup();
                    this.commitSucceeded = false;
                }
            } else if (this.debug || tc.isDebugEnabled()) {
                Tr.debug(tc, "It has been committed prior this call, nothing is done.");
            }
            bRet = this.commitSucceeded;
        }
        this.cleanupSharedState();
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "commit()");
        }
        return bRet;
    }

    public boolean abort() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "abort()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "abort()");
        }
        return true;
    }

    public boolean logout() throws LoginException {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "logout()");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup the Subject, removes WSPrincipal and WSCredential from the Subject, reset all internal variables.");
            Tr.debug(tc, "Start cleanup ...");
        }
        this.cleanup();
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Cleanup done.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "logout()");
        }
        return true;
    }

    private void cleanup() {
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanup()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing WSPrinciapl, WSCredential, and CORBA Credentials from the Subject.");
            Tr.debug(tc, "Start removing ...");
        }
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    if (ltpaLoginModule.this.principal != null && ltpaLoginModule.this.subject.getPrincipals().contains(ltpaLoginModule.this.principal)) {
                        ltpaLoginModule.this.subject.getPrincipals().remove(ltpaLoginModule.this.principal);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.ltpaLoginModule.run", "847", this);
                    Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), e});
                }
                try {
                    if (ltpaLoginModule.this.credential != null && ltpaLoginModule.this.subject.getPublicCredentials().contains(ltpaLoginModule.this.credential)) {
                        ltpaLoginModule.this.subject.getPublicCredentials().remove(ltpaLoginModule.this.credential);
                    }
                }
                catch (Exception e) {
                    FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.server.lm.ltpaLoginModule.run", "858", this);
                    Tr.error(tc, "security.jaas.removeCredException", new Object[]{this.getClass().getName(), e});
                }
                if (ltpaLoginModule.this.credential == null) {
                    // empty if block
                }
                return null;
            }
        });
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        this.principal = null;
        this.credential = null;
        this.cleanupSharedState();
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanup()");
        }
    }

    private void cleanupSharedState() {
        WSPrincipal tempPrincipal;
        WSCredential tempCredential;
        Callback[] tempCallbacks;
        if (this.debug || tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupSharedState()");
        }
        this.succeeded = false;
        this.commitSucceeded = false;
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Start removing Callbacks, WSPrincipal, and WSCredential from the shared state.");
        }
        if ((tempCallbacks = (Callback[])this.sharedState.get("Callback")) != null) {
            for (int i = 0; i < tempCallbacks.length; ++i) {
                char[] password;
                if (!(tempCallbacks[i] instanceof PasswordCallback) || (password = ((PasswordCallback)tempCallbacks[i]).getPassword()) == null) continue;
                ((PasswordCallback)tempCallbacks[i]).clearPassword();
            }
        }
        if (tempCallbacks != null) {
            this.sharedState.remove("Callback");
        }
        if ((tempCredential = (WSCredential)this.sharedState.get("WSCredential")) != null) {
            this.sharedState.remove("WSCredential");
        }
        if ((tempPrincipal = (WSPrincipal)this.sharedState.get("WSPrincipal")) != null) {
            this.sharedState.remove("WSPrincipal");
        }
        if (this.debug || tc.isDebugEnabled()) {
            Tr.debug(tc, "Removed.");
        }
        if (this.debug || tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanupSharedState()");
        }
    }
}

