/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.securitydomain;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.ws.security.config.securitydomain.SecDomainHelper;
import com.ibm.wsspi.management.sync.SyncFolderFilter;
import com.ibm.wsspi.runtime.config.ConfigObject;
import com.ibm.wsspi.runtime.config.ConfigScope;
import com.ibm.wsspi.runtime.config.ConfigService;
import com.ibm.wsspi.runtime.service.WsServiceRegistry;
import java.util.List;
import javax.management.ObjectName;

public class SecurityDomainFolderFilter
extends SyncFolderFilter {
    private static TraceComponent tc = Tr.register(SecurityDomainFolderFilter.class, "Security", "com.ibm.ejs.resources.security");

    public boolean accept(String parent, String folder, String node) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "accept", new Object[]{parent, folder, node});
        }
        boolean accept = false;
        Session session = null;
        com.ibm.websphere.management.configservice.ConfigService cs = null;
        try {
            session = new Session();
            CommandProviderHelper helper = CommandMgr.getCommandMgr().getCommandProviderHelper();
            cs = helper.getConfigService();
            ConfigService configService = WsServiceRegistry.getService((Object)this, ConfigService.class);
            ConfigScope scope = configService.createScope(0);
            List resourceList = configService.getDocumentObjects(scope, "../../waspolicies/default/securitydomains/" + folder + "/domain-security-map.xml");
            ConfigObject doc = (ConfigObject)resourceList.get(0);
            if (doc != null) {
                List members = doc.getObjectList("members");
                for (int i = 0; i < members.size(); ++i) {
                    ConfigObject member = (ConfigObject)members.get(i);
                    String resourceName = member.getString("resourceName", null);
                    String resourceType = member.getString("resourceType", null);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "SecurityDomainFolderFilter accept - resourceType: " + resourceType + " and resourceName: " + resourceName);
                    }
                    if (resourceType != null && resourceType.equalsIgnoreCase("Cell")) {
                        accept = true;
                    } else {
                        if (resourceType != null && resourceType.equalsIgnoreCase("Server")) {
                            String resource = SecDomainHelper.convertResource(resourceName);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "SecurityDomainFolderFilter accept - converted resourceName is: " + resource);
                            }
                            accept = resource.indexOf(node) != -1;
                        } else if (resourceType != null && (resourceType.equalsIgnoreCase("ServerCluster") || resourceType.equalsIgnoreCase("Cluster"))) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "SecurityDomainFolderFilter accept - case of a cluster");
                            }
                            String clusterName = SecDomainHelper.getClusterName(resourceName);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "SecurityDomainFolderFilter accept - clusterName is: " + clusterName);
                            }
                            if (clusterName != null && clusterName.length() > 0) {
                                ObjectName clusterObj = cs.resolve(session, "ServerCluster=" + clusterName)[0];
                                ObjectName memberPattern = ConfigServiceHelper.createObjectName(null, "ClusterMember");
                                ObjectName[] currentMemberObjs = cs.queryConfigObjects(session, clusterObj, memberPattern, null);
                                boolean j = false;
                                while (currentMemberObjs != null && i < currentMemberObjs.length) {
                                    String nodeName = (String)cs.getAttribute(session, currentMemberObjs[i], "nodeName");
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "SecurityDomainFolderFilter accept - this cluster member is: " + currentMemberObjs[i] + " its node name is: " + nodeName);
                                    }
                                    if (nodeName != null && nodeName.equalsIgnoreCase(node)) {
                                        accept = true;
                                    }
                                    if (!accept) {
                                        ++i;
                                        continue;
                                    }
                                    break;
                                }
                            }
                        } else if (resourceType != null && resourceType.equalsIgnoreCase("SIBus")) {
                            accept = true;
                        }
                        if (!accept) {
                            continue;
                        }
                    }
                    break;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SecurityDomainFolderFilter accept - no security-domain-map.xml document found -- returning true");
                }
                accept = true;
            }
            if (session != null && cs != null) {
                cs.discard(session);
            }
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "SecurityDomainFolderFilter accept - unexpected exception but will allow the sync operation to continue: " + e.getMessage());
            }
            accept = true;
            accept = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "accept: " + accept);
        }
        return accept;
    }
}

