/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.scanner;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.scanner.Controller;
import com.ibm.wsspi.security.scanner.ConfigChecker;
import com.ibm.wsspi.security.scanner.ConfigHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LDAPLinkChecker
implements ConfigChecker {
    String pathName = null;
    String profileName = null;
    String wasVersion = null;
    String status = "false";
    boolean fileFound = false;
    ArrayList report;
    int index = 0;
    private ConfigHashMap resultMap = null;
    private static final TraceComponent tc = Tr.register(LDAPLinkChecker.class, "Security", "com.ibm.ejs.resources.security");

    public int doCheck(String path, Locale locale, ArrayList output) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doCheck", new Object[]{path, locale, output, this});
        }
        this.report = output;
        this.profileName = path;
        File f = new File(path);
        this.pathName = f.getAbsolutePath();
        this.resultMap = new ConfigHashMap();
        int result = 1;
        int tempResult = this.checkInConfig(f);
        if (tempResult > result) {
            result = tempResult;
        }
        String fileName = path + File.separator + "config" + File.separator + "cells" + File.separator + Controller.getCellName() + File.separator + "security.xml";
        if (!this.fileFound) {
            Tr.error(tc, "security.scanner.error.invalid.file", new Object[]{fileName});
            this.resultMap.addItem("status", Controller.getNLSString("security.scanner.status.undetermined"));
            this.resultMap.addItem("risk", Controller.getNLSString("security.scanner.risk.undetermined"));
            this.resultMap.addItem("action", Controller.getNLSString("security.scanner.action.undetermined"));
            this.resultMap.addItem("errorMsg", Controller.getFormattedMessage("security.scanner.error.invalid.file", new Object[]{fileName}));
            this.report.add(this.index, this.resultMap);
            result = 3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doCheck", new Integer(result));
        }
        return result;
    }

    private int findSecEnabledInXMLDoc(Document d) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findSecEnabledInXMLDoc", new Object[]{d, this});
        }
        int result = 1;
        String userReg = null;
        NodeList ses = d.getElementsByTagName("security:Security");
        if (ses.getLength() == 0) {
            Tr.error(tc, Controller.getFormattedMessage("security.scanner.error.parse.xml", new Object[]{"security.xml", "No security field in security.xml file."}));
            this.resultMap.addItem("errorMsg", Controller.getFormattedMessage("security.scanner.error.parse.xml", new Object[]{"security.xml", ""}));
        } else {
            for (int i = 0; i < ses.getLength(); ++i) {
                Node serverEntry = ses.item(i);
                userReg = serverEntry.getAttributes().getNamedItem("activeUserRegistry").getNodeValue();
            }
        }
        if (userReg != null && userReg.startsWith("LDAP")) {
            NodeList ldap = d.getElementsByTagName("userRegistries");
            boolean ldapSSL = false;
            if (ldap.getLength() == 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "error: no userRegistries field in security.xml file");
                }
            } else {
                for (int i = 0; i < ldap.getLength(); ++i) {
                    String ssl2;
                    Node serverEntry = ldap.item(i);
                    String type = serverEntry.getAttributes().getNamedItem("xmi:type").getNodeValue();
                    if (!type.equals("security:LDAPUserRegistry") || !(ssl2 = serverEntry.getAttributes().getNamedItem("sslEnabled").getNodeValue()).equals("true")) continue;
                    ldapSSL = true;
                }
            }
            if (ldapSSL) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SSL between WebSphere Application Server and LDAP is enabled");
                }
                this.resultMap.addItem("status", Controller.getNLSString("security.scanner.status.ok"));
                this.resultMap.addItem("risk", Controller.getNLSString("security.scanner.risk.ldaplink.ok.used"));
                this.resultMap.addItem("action", Controller.getNLSString("security.scanner.action.none"));
                this.report.add(this.index, this.resultMap);
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "SSL between WebSphere Application Server and LDAP is disabled");
                }
                this.resultMap.addItem("status", Controller.getNLSString("security.scanner.status.improve"));
                this.resultMap.addItem("risk", Controller.getNLSString("security.scanner.risk.ldaplink.improve"));
                this.resultMap.addItem("action", Controller.getNLSString("security.scanner.action.ldaplink"));
                this.report.add(this.index, this.resultMap);
                result = 2;
            }
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "User registry being used is not LDAP");
            }
            this.resultMap.addItem("status", Controller.getNLSString("security.scanner.status.ok"));
            this.resultMap.addItem("risk", Controller.getNLSString("security.scanner.risk.ldaplink.ok.unused"));
            this.resultMap.addItem("action", Controller.getNLSString("security.scanner.action.none"));
            this.report.add(this.index, this.resultMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findSecEnabledInXMLDoc", new Integer(result));
        }
        return result;
    }

    public static void main(String[] args) {
    }

    public String getCheckName() {
        return Controller.getNLSString("security.scanner.check.ldaplink");
    }

    public String getCategory() {
        return Controller.getNLSString("security.scanner.category.ldaplink");
    }

    public String getPriority() {
        return Controller.getNLSString("security.scanner.priority.medium");
    }

    public String getProfileName() {
        return this.profileName;
    }

    public String getPathName() {
        return this.pathName;
    }

    public int getOrderNumber() {
        return 4;
    }

    public String getStatus() {
        return this.status;
    }

    public String getComponentName() {
        return Controller.getNLSString("security.scanner.component.security");
    }

    private int checkInConfig(File f) {
        int result = 1;
        File[] kiddos = f.listFiles();
        for (int i = 0; i < kiddos.length; ++i) {
            if (!kiddos[i].isDirectory() || !kiddos[i].getName().equals("config")) continue;
            String absolutePath = kiddos[i].getAbsolutePath();
            int tempResult = this.checkSecurityConfig(absolutePath);
            if (tempResult <= result) break;
            result = tempResult;
            break;
        }
        return result;
    }

    private int checkSecurityConfig(String fileName) {
        boolean result = true;
        File f = new File(fileName + "/cells");
        if (!f.isDirectory()) {
            Tr.error(tc, "security.scanner.error.invalid.file", new Object[]{f.getAbsolutePath()});
            this.resultMap.addItem("errorMsg", Controller.getFormattedMessage("security.scanner.error.invalid.file", new Object[]{f.getAbsolutePath()}));
            return 3;
        }
        return this.configCheck(f);
    }

    private int configCheck(File f) {
        int result = 1;
        File[] kiddos = f.listFiles();
        for (int i = 0; i < kiddos.length; ++i) {
            int tempResult;
            if (kiddos[i].isFile()) {
                if (!kiddos[i].getName().equals("security.xml") || (tempResult = this.configCheckInFile(kiddos[i])) <= result) continue;
                result = tempResult;
                continue;
            }
            if (!kiddos[i].isDirectory() || (tempResult = this.configCheck(kiddos[i])) <= result) continue;
            result = tempResult;
        }
        return result;
    }

    private int configCheckInFile(File file) {
        int result = 1;
        try {
            Document xmlDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            this.fileFound = true;
            int tempResult = this.findSecEnabledInXMLDoc(xmlDoc);
            if (tempResult > result) {
                result = tempResult;
            }
        }
        catch (Exception e) {
            Tr.error(tc, "security.scanner.error.parse.xml", new Object[]{file.getName(), e});
            this.resultMap.addItem("errorMsg", Controller.getFormattedMessage("security.scanner.error.parse.xml", new Object[]{file.getName(), e.getMessage()}));
            result = 3;
        }
        return result;
    }
}

