/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.scanner;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.scanner.Controller;
import com.ibm.wsspi.security.scanner.ConfigChecker;
import com.ibm.wsspi.security.scanner.ConfigHashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Locale;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DRSChecker
implements ConfigChecker {
    String pathName = null;
    String profileName = null;
    String wasVersion = null;
    String status = "false";
    boolean fileFound = false;
    ArrayList report;
    int index = 0;
    private ConfigHashMap resultMap = null;
    private static final TraceComponent tc = Tr.register(DRSChecker.class, "Security", "com.ibm.ejs.resources.security");

    public int doCheck(String path, Locale locale, ArrayList output) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "doCheck", new Object[]{path, locale, output, this});
        }
        this.report = output;
        this.profileName = path;
        File f = new File(path);
        this.pathName = f.getAbsolutePath();
        this.fileFound = false;
        this.resultMap = new ConfigHashMap();
        int result = 1;
        int tempResult = this.checkInConfig(f);
        if (tempResult > result) {
            result = tempResult;
        }
        String fileName = path + File.separator + "config" + File.separator + "cells" + File.separator + Controller.getCellName() + File.separator + "multibroker.xml";
        if (!this.fileFound) {
            Tr.error(tc, "security.scanner.error.invalid.file", new Object[]{fileName});
            this.resultMap.addItem("status", Controller.getNLSString("security.scanner.status.undetermined"));
            this.resultMap.addItem("risk", Controller.getNLSString("security.scanner.risk.undetermined"));
            this.resultMap.addItem("action", Controller.getNLSString("security.scanner.action.undetermined"));
            this.resultMap.addItem("errorMsg", Controller.getFormattedMessage("security.scanner.error.invalid.file", new Object[]{fileName}));
            this.report.add(this.index, this.resultMap);
            result = 3;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "doCheck", new Integer(result));
        }
        return result;
    }

    private int findSecEnabledInXMLDoc(Document d) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findSecEnabledInXMLDoc", new Object[]{d, this});
        }
        int result = 1;
        Node drs = d.getElementsByTagName("multibroker:DataReplicationDomain").item(0);
        if (drs == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Data Replication is not being used to exchange data among WebSphere Application servers");
            }
            this.resultMap.addItem("status", Controller.getNLSString("security.scanner.status.ok"));
            this.resultMap.addItem("risk", Controller.getNLSString("security.scanner.risk.drs.ok.unused"));
            this.resultMap.addItem("action", Controller.getNLSString("security.scanner.action.none"));
            this.report.add(this.index, this.resultMap);
            return result;
        }
        String id = drs.getAttributes().getNamedItem("xmi:id").getNodeValue();
        NodeList drsList = drs.getChildNodes();
        for (int i = 0; i < drsList.getLength(); ++i) {
            Node drsEntry = drsList.item(i);
            if (drsEntry.getNodeName().equals("#text")) continue;
            this.status = drsEntry.getAttributes().getNamedItem("encryptionType").getNodeValue();
            if (this.status == null) continue;
            if (this.status.startsWith("DES") || this.status.equals("TRIPLE_DES")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "\nEncryption is enabled on Distributed Replication Service");
                }
                this.resultMap.addItem("status", Controller.getNLSString("security.scanner.status.ok"));
                this.resultMap.addItem("risk", this.status + Controller.getNLSString("security.scanner.risk.drs.ok.used"));
                this.resultMap.addItem("action", Controller.getNLSString("security.scanner.action.none"));
                this.report.add(this.index, this.resultMap);
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "\nEncryption is disabled on Distributed Replication Service");
            }
            this.resultMap.addItem("status", Controller.getNLSString("security.scanner.status.improve"));
            this.resultMap.addItem("risk", Controller.getNLSString("security.scanner.risk.drs.improve"));
            this.resultMap.addItem("action", Controller.getNLSString("security.scanner.action.drs"));
            this.report.add(this.index, this.resultMap);
            result = 2;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findSecEnabledInXMLDoc", new Integer(result));
        }
        return result;
    }

    public static void main(String[] args) {
    }

    public String getCheckName() {
        return Controller.getNLSString("security.scanner.check.drs");
    }

    public String getCategory() {
        return Controller.getNLSString("security.scanner.category.drs");
    }

    public String getPriority() {
        return Controller.getNLSString("security.scanner.priority.medium");
    }

    public int getOrderNumber() {
        return 6;
    }

    public String getProfileName() {
        return this.pathName;
    }

    public String getPathName() {
        return this.pathName;
    }

    public String getStatus() {
        return this.status;
    }

    public String getComponentName() {
        return Controller.getNLSString("component.security");
    }

    private int checkInConfig(File f) {
        int result = 1;
        File[] kiddos = f.listFiles();
        for (int i = 0; i < kiddos.length; ++i) {
            if (!kiddos[i].isDirectory() || !kiddos[i].getName().equals("config")) continue;
            String absolutePath = kiddos[i].getAbsolutePath();
            int tempResult = this.checkSecurityConfig(absolutePath);
            if (tempResult <= result) break;
            result = tempResult;
            break;
        }
        return result;
    }

    private int checkSecurityConfig(String fileName) {
        boolean result = true;
        File f = new File(fileName + "/cells");
        if (!f.isDirectory()) {
            Tr.error(tc, "security.scanner.error.invalid.file", new Object[]{f.getAbsolutePath()});
            this.resultMap.addItem("errorMsg", Controller.getFormattedMessage("security.scanner.error.invalid.file", new Object[]{f.getAbsolutePath()}));
            return 3;
        }
        return this.configCheck(f);
    }

    private int configCheck(File f) {
        int result = 1;
        File[] kiddos = f.listFiles();
        for (int i = 0; i < kiddos.length; ++i) {
            int tempResult;
            if (kiddos[i].isFile()) {
                if (!kiddos[i].getName().equals("multibroker.xml") || (tempResult = this.configCheckInFile(kiddos[i])) <= result) continue;
                result = tempResult;
                continue;
            }
            if (!kiddos[i].isDirectory() || (tempResult = this.configCheck(kiddos[i])) <= result) continue;
            result = tempResult;
        }
        return result;
    }

    private int configCheckInFile(File file) {
        int result = 1;
        try {
            Document xmlDoc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(file);
            this.fileFound = true;
            int tempResult = this.findSecEnabledInXMLDoc(xmlDoc);
            if (tempResult > result) {
                result = tempResult;
            }
        }
        catch (Exception e) {
            Tr.error(tc, "security.scanner.error.parse.xml", new Object[]{file.getName(), e});
            this.resultMap.addItem("errorMsg", Controller.getFormattedMessage("security.scanner.error.parse.xml", new Object[]{file.getName(), e.getMessage()}));
            result = 3;
        }
        return result;
    }
}

