/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.scanner;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.management.repository.ConfigRepository;
import com.ibm.websphere.management.repository.ConfigRepositoryFactory;
import com.ibm.wsspi.extension.ExtensionRegistryFactory;
import com.ibm.wsspi.security.scanner.ConfigChecker;
import com.ibm.wsspi.security.scanner.ConfigHashMap;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Controller {
    private static String configRootPath = null;
    private List<ConfigChecker> securityChecks = null;
    private static TraceNLS nls;
    private static boolean nlsInit;
    private static final TraceComponent tc;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public String run(Locale locale, List<String> checksToRun) {
        ArrayList output = new ArrayList();
        StringBuffer resultString = new StringBuffer();
        int checkResult = 1;
        int errorCount = 0;
        int warningCount = 0;
        int successCount = 0;
        int totalChecksInRegistry = 0;
        int totalChecksToRun = 0;
        configRootPath = Controller.getConfigRoot();
        configRootPath = configRootPath.substring(0, configRootPath.indexOf(File.separator + "config"));
        resultString.append("\nScanning " + configRootPath + " for the following security configurations \n");
        if (this.securityChecks != null && !this.securityChecks.isEmpty()) {
            totalChecksInRegistry = this.securityChecks.size();
            int n = totalChecksToRun = checksToRun.isEmpty() ? totalChecksInRegistry : checksToRun.size();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Total number of checks: " + this.securityChecks.size());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Checks selected to run: " + totalChecksToRun);
            }
            ConfigChecker currentClass2222 = null;
            for (ConfigChecker currentClass2222 : this.securityChecks) {
                String errorMsg;
                ConfigHashMap outputMap2222;
                Object var15_14;
                if (!checksToRun.contains(currentClass2222.getClass().getName()) && !checksToRun.isEmpty()) continue;
                try {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Performing check: " + currentClass2222.getCheckName());
                    }
                    checkResult = currentClass2222.doCheck(configRootPath, locale, output);
                    var15_14 = null;
                    outputMap2222 = null;
                }
                catch (Throwable throwable) {
                    var15_14 = null;
                    outputMap2222 = null;
                    for (ConfigHashMap outputMap2222 : output) {
                        errorMsg = outputMap2222.getErrorMsg() == null ? "" : outputMap2222.getErrorMsg();
                        resultString.append("\n\n" + Controller.getNLSString("security.scanner.report.name") + " " + currentClass2222.getCheckName() + "\n" + Controller.getNLSString("security.scanner.report.status") + " " + outputMap2222.getStatus() + "\n" + Controller.getNLSString("security.scanner.report.risk") + " " + outputMap2222.getRisk() + "\n" + Controller.getNLSString("security.scanner.report.action") + " " + outputMap2222.getAction() + "\n" + (!errorMsg.equalsIgnoreCase("") ? Controller.getNLSString("security.scanner.report.error") + " " + outputMap2222.getErrorMsg() : ""));
                    }
                    output.clear();
                    if (checkResult == 3 || checkResult == 4) {
                        ++errorCount;
                    } else if (checkResult == 2) {
                        ++warningCount;
                        ++successCount;
                    } else {
                        ++successCount;
                    }
                    throw throwable;
                }
                for (ConfigHashMap outputMap2222 : output) {
                    errorMsg = outputMap2222.getErrorMsg() == null ? "" : outputMap2222.getErrorMsg();
                    resultString.append("\n\n" + Controller.getNLSString("security.scanner.report.name") + " " + currentClass2222.getCheckName() + "\n" + Controller.getNLSString("security.scanner.report.status") + " " + outputMap2222.getStatus() + "\n" + Controller.getNLSString("security.scanner.report.risk") + " " + outputMap2222.getRisk() + "\n" + Controller.getNLSString("security.scanner.report.action") + " " + outputMap2222.getAction() + "\n" + (!errorMsg.equalsIgnoreCase("") ? Controller.getNLSString("security.scanner.report.error") + " " + outputMap2222.getErrorMsg() : ""));
                }
                output.clear();
                if (checkResult == 3 || checkResult == 4) {
                    ++errorCount;
                    continue;
                }
                if (checkResult == 2) {
                    ++warningCount;
                    ++successCount;
                    continue;
                }
                ++successCount;
                {
                    continue;
                    catch (Exception e) {
                        Tr.error(tc, "security.scanner.error.check.exception", new Object[]{currentClass2222.getCheckName(), e});
                        checkResult = 3;
                        var15_14 = null;
                        outputMap2222 = null;
                        for (ConfigHashMap outputMap2222 : output) {
                            errorMsg = outputMap2222.getErrorMsg() == null ? "" : outputMap2222.getErrorMsg();
                            resultString.append("\n\n" + Controller.getNLSString("security.scanner.report.name") + " " + currentClass2222.getCheckName() + "\n" + Controller.getNLSString("security.scanner.report.status") + " " + outputMap2222.getStatus() + "\n" + Controller.getNLSString("security.scanner.report.risk") + " " + outputMap2222.getRisk() + "\n" + Controller.getNLSString("security.scanner.report.action") + " " + outputMap2222.getAction() + "\n" + (!errorMsg.equalsIgnoreCase("") ? Controller.getNLSString("security.scanner.report.error") + " " + outputMap2222.getErrorMsg() : ""));
                        }
                        output.clear();
                        if (checkResult == 3 || checkResult == 4) {
                            ++errorCount;
                            continue;
                        }
                        if (checkResult == 2) {
                            ++warningCount;
                            ++successCount;
                            continue;
                        }
                        ++successCount;
                    }
                }
            }
        }
        resultString.append("\n\n" + Controller.getNLSString("security.scanner.summary.title") + "\n\t" + Controller.getFormattedMessage("security.scanner.summary.total", new Object[]{totalChecksToRun}) + "\n\t" + Controller.getFormattedMessage("security.scanner.summary.success", new Object[]{successCount}) + "\n\t" + Controller.getFormattedMessage("security.scanner.summary.warning", new Object[]{warningCount}) + "\n\t" + Controller.getFormattedMessage("security.scanner.summary.error", new Object[]{errorCount}) + "\n\n" + Controller.getNLSString("security.scanner.summary.note") + "\n\n");
        return resultString.toString();
    }

    public Controller() {
        if (!nlsInit) {
            Controller.nlsInitialize();
        }
        this.securityChecks = this.loadSecurityChecks();
    }

    private List<ConfigChecker> loadSecurityChecks() {
        String epid;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadSecurityChecks");
        }
        ArrayList<ConfigChecker> securityCheckClasses = new ArrayList<ConfigChecker>();
        IExtensionRegistry registry = ExtensionRegistryFactory.instance().getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint(epid = ExtensionRegistryFactory.instance().getDefaultPluginID() + ".security-scanner-config");
        if (extensionPoint == null && tc.isDebugEnabled()) {
            Tr.debug(tc, "Extension point, " + epid + ", is null");
        }
        IExtension[] extensions = extensionPoint.getExtensions();
        for (int i = 0; i < extensions.length; ++i) {
            IExtension extension2 = extensions[i];
            IConfigurationElement[] configLocatorElements = extension2.getConfigurationElements();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The number of checks from extension reg is: " + configLocatorElements.length);
            }
            for (int j = 0; j < configLocatorElements.length; ++j) {
                IConfigurationElement element = configLocatorElements[j];
                String className = element.getAttribute("className");
                ConfigChecker checker = null;
                try {
                    checker = (ConfigChecker)element.createExecutableExtension("className");
                }
                catch (Exception ex) {
                    Tr.error(tc, "security.scanner.error.invalid.class", new Object[]{className, ex});
                }
                if (checker == null) continue;
                securityCheckClasses.add(checker);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadSecurityChecks", securityCheckClasses);
        }
        return securityCheckClasses;
    }

    private static String getConfigRoot() {
        ConfigRepository repository2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getConfigRoot");
        }
        if ((repository2 = ConfigRepositoryFactory.getConfigRepository()) != null) {
            Properties props = repository2.getConfig();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getConfigRoot");
            }
            return props.getProperty("was.repository.root");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getConfigRoot", null);
        }
        return null;
    }

    public static void nlsInitialize() {
        block2: {
            try {
                nls = TraceNLS.getTraceNLS("com.ibm.ejs.resources.security");
                nlsInit = true;
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug(tc, "Exception thrown while initializing NLS resource bundle.", e);
            }
        }
    }

    public static String getFormattedMessage(String key, Object[] args) {
        String message;
        block3: {
            message = null;
            try {
                message = nls.getString(key);
                if (message != null) {
                    message = MessageFormat.format(message, args);
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Exception thrown when formatting message.", e);
            }
        }
        return message;
    }

    public static String getNLSString(String message) {
        return nls.getString(message);
    }

    public static String getCellName() {
        return System.getProperty("local.cell");
    }

    static {
        nlsInit = false;
        tc = Tr.register(Controller.class, "Security", "com.ibm.ejs.resources.security");
    }
}

