/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.role.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.wsspi.amm.scan.rules.AnnotationRules;
import com.ibm.wsspi.amm.scan.util.info.AnnotationInfo;
import com.ibm.wsspi.amm.scan.util.info.ClassInfo;
import com.ibm.wsspi.amm.scan.util.info.MethodInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;

public class MergeRules
implements AnnotationRules {
    private static final TraceComponent tc = Tr.register(MergeRules.class, "Security");
    private static final Collection<String> SECURITY_ANNOTATIONS = Arrays.asList(DenyAll.class.getName(), PermitAll.class.getName(), RolesAllowed.class.getName());

    public boolean applyRules(ClassInfo classInfo, AnnotationInfo annotation) {
        String methodName = "applyRules(ClassInfo,AnnotationInfo)";
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "applyRules(ClassInfo,AnnotationInfo)", "class=" + classInfo.getName() + ", annotation=" + annotation.getName());
        }
        boolean result = false;
        String annotationName = annotation.getName();
        if (SECURITY_ANNOTATIONS.contains(annotationName)) {
            result = true;
            ArrayList<MethodInfo> inherited = new ArrayList<MethodInfo>();
            for (MethodInfo method2 : classInfo.getDeclaredMethods()) {
                if (this.hasSecurityAnnotations(method2)) continue;
                inherited.add(method2);
                method2.getAnnotations().add(annotation);
            }
            if (tc.isDebugEnabled()) {
                String[] msg = new String[inherited.size()];
                for (int i = 0; i < msg.length; ++i) {
                    msg[i] = this.getMethodSignature((MethodInfo)inherited.get(i));
                }
                Tr.debug(tc, annotationName + " has been inherited by the following methods:", msg);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "annotation " + annotationName + " has been ignored, it is not one of DenyAll, PermitAll or RolesAllowed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "applyRules(ClassInfo,AnnotationInfo)", "Rules successfully applied? " + result);
        }
        return result;
    }

    private boolean hasSecurityAnnotations(MethodInfo method2) {
        boolean isSecurityAnnotation = false;
        for (AnnotationInfo annotation : method2.getDeclaredAnnotations()) {
            isSecurityAnnotation = SECURITY_ANNOTATIONS.contains(annotation.getName());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "method " + this.getMethodSignature(method2) + " is annotated with " + annotation.getName() + ", isSecurityAnnotation? " + isSecurityAnnotation);
            }
            if (!isSecurityAnnotation) continue;
            break;
        }
        return isSecurityAnnotation;
    }

    private String getMethodSignature(MethodInfo methodInfo) {
        StringBuffer parmsBuf = new StringBuffer();
        List parms = methodInfo.getParameterTypes();
        int count = parms.size();
        for (int i = 0; i < count; ++i) {
            if (i < count - 1) {
                parmsBuf.append(((ClassInfo)parms.get(i)).getName() + ",");
                continue;
            }
            parmsBuf.append(((ClassInfo)parms.get(i)).getName());
        }
        return methodInfo.getQualifiedName() + '(' + parmsBuf.toString() + ')';
    }
}

