/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.role.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.role.metadata.EjbMergeAction;
import com.ibm.wsspi.amm.merge.MergeException;
import com.ibm.wsspi.amm.scan.AnnotationTarget;
import com.ibm.wsspi.amm.scan.ClassAnnotationTarget;
import com.ibm.wsspi.amm.scan.MethodAnnotationTarget;
import com.ibm.wsspi.amm.scan.util.info.Info;
import java.lang.annotation.Annotation;
import java.util.Set;
import javax.annotation.security.RolesAllowed;
import org.eclipse.jst.j2ee.ejb.EJBJar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeRolesAllowed
extends EjbMergeAction {
    private static final TraceComponent tc = Tr.register(MergeRolesAllowed.class, "Security");

    @Override
    Class<? extends Annotation> getAnnotationClass() {
        return RolesAllowed.class;
    }

    @Override
    void mergeClassAnnotation(EJBJar ejbJar, ClassAnnotationTarget classAnnotationTarget) throws MergeException {
        boolean isInDescriptor = this.isOverridenInDescriptor(ejbJar, classAnnotationTarget);
        if (!isInDescriptor) {
            Set<String> roleNames = this.manager.getSecurityRoleNames((Info)classAnnotationTarget.getApplicableClass(), this.getAnnotationClass());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Role permissions will be added to descriptor for declared methods in class " + classAnnotationTarget.getApplicableClass().getName() + " for roles " + roleNames);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "A role permission or excluded method in the descriptor overrides annotation RolesAllowed in class " + classAnnotationTarget.getApplicableClass().getName() + ", annotation is ignored.");
        }
    }

    @Override
    void mergeMethodAnnotation(EJBJar ejbJar, MethodAnnotationTarget methodAnnotationTarget) throws MergeException {
        boolean isInDescriptor = this.isOverridenInDescriptor(ejbJar, methodAnnotationTarget);
        if (!isInDescriptor) {
            Set<String> roleNames = this.manager.getSecurityRoleNames((Info)methodAnnotationTarget.getApplicableMethod(), this.getAnnotationClass());
            this.manager.prepareAddPermission(ejbJar, (AnnotationTarget)methodAnnotationTarget, roleNames);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "A permission will be added to descriptor for method " + this.manager.getMethodSignature(methodAnnotationTarget) + " and roles " + roleNames);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "A role permission or excluded method in the descriptor overrides annotation RolesAllowed in method " + this.manager.getMethodSignature(methodAnnotationTarget) + ", annotation is ignored.");
        }
    }
}

