/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.role.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.amm.AMMMetadataManagerActionRegistry;
import com.ibm.ws.amm.AbstractAMMProcessingAction;
import com.ibm.ws.amm.merge.ejb.manager.EJBDataManager;
import com.ibm.ws.amm.merge.ejb.manager.EnterpriseBeanData;
import com.ibm.wsspi.amm.merge.AMMProcessingAction;
import com.ibm.wsspi.amm.merge.MergeException;
import com.ibm.wsspi.amm.scan.AnnotationTarget;
import com.ibm.wsspi.amm.scan.MethodAnnotationTarget;
import com.ibm.wsspi.amm.scan.util.info.AnnotationInfo;
import com.ibm.wsspi.amm.scan.util.info.AnnotationValue;
import com.ibm.wsspi.amm.scan.util.info.ClassInfo;
import com.ibm.wsspi.amm.scan.util.info.Info;
import com.ibm.wsspi.amm.scan.util.info.MethodInfo;
import com.ibm.wsspi.amm.validate.ValidationException;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jst.j2ee.common.CommonFactory;
import org.eclipse.jst.j2ee.common.Identity;
import org.eclipse.jst.j2ee.common.RunAsSpecifiedIdentity;
import org.eclipse.jst.j2ee.common.SecurityRole;
import org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.MergeData;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.ejb.AssemblyDescriptor;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EjbFactory;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.ExcludeList;
import org.eclipse.jst.j2ee.ejb.MethodElement;
import org.eclipse.jst.j2ee.ejb.MethodPermission;
import org.eclipse.jst.j2ee.webapplication.Servlet;
import org.eclipse.jst.j2ee.webapplication.WebApp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeManager
extends AbstractAMMProcessingAction {
    private static final TraceComponent tc = Tr.register(MergeManager.class, "Security");
    private static final Map<String, MergeManager> managers = new HashMap<String, MergeManager>();
    private final Set<SecurityRole> ejbSecurityRoles;
    private final Set<SecurityRole> webSecurityRoles;
    private final Map<MethodElement, MethodPermission> ejbRoleMethods;
    private final Map<MethodElement, MethodPermission> ejbUncheckedMethods;
    private final List<MethodElement> ejbExcludedMethods;
    private final Map<EnterpriseBean, RunAsSpecifiedIdentity> ejbRunAsRole;
    private final Map<Servlet, RunAsSpecifiedIdentity> webRunAsRole;
    private EJBDataManager ejbDataManager;

    public MergeManager(MergeData mergeData) {
        block3: {
            this.ejbSecurityRoles = new HashSet<SecurityRole>();
            this.webSecurityRoles = new HashSet<SecurityRole>();
            this.ejbRoleMethods = new HashMap<MethodElement, MethodPermission>();
            this.ejbUncheckedMethods = new HashMap<MethodElement, MethodPermission>();
            this.ejbExcludedMethods = new ArrayList<MethodElement>();
            this.ejbRunAsRole = new HashMap<EnterpriseBean, RunAsSpecifiedIdentity>();
            this.webRunAsRole = new HashMap<Servlet, RunAsSpecifiedIdentity>();
            try {
                if (mergeData.getModuleFile().isEJBJarFile()) {
                    this.ejbDataManager = EJBDataManager.getInstance((MergeData)mergeData);
                }
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block3;
                Tr.debug(tc, "Unable to get EJBDataManager: " + e);
            }
        }
    }

    public static MergeManager getInstance(MergeData mergeData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInstance(MergeData)", new Object[]{mergeData.getModuleFile()});
        }
        MergeManager manager = null;
        ModuleFile moduleFile = mergeData.getModuleFile();
        EARFile earFile = moduleFile.getEARFile();
        String key = null;
        key = earFile != null ? earFile.getURI() + "#" + moduleFile.getURI() : moduleFile.getURI();
        manager = managers.get(key);
        if (manager == null) {
            manager = new MergeManager(mergeData);
            managers.put(key, manager);
        }
        AMMMetadataManagerActionRegistry.addProcessingAction((AMMProcessingAction)manager);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getInstance(MergeData)", managers);
        }
        return manager;
    }

    public Set<String> getSecurityRoleNames(Info target, Class<? extends Annotation> annotationClass) {
        HashSet<String> roles = new HashSet<String>();
        AnnotationValue value = this.getAnnotationValue(target, annotationClass);
        if (value != null) {
            for (AnnotationValue role : value.getArrayValue()) {
                roles.add(role.getStringValue());
            }
        }
        return roles;
    }

    public String getSecurityRoleName(Info target, Class<? extends Annotation> annotationClass) {
        return this.getAnnotationValue(target, annotationClass).getStringValue();
    }

    private AnnotationValue getAnnotationValue(Info target, Class<? extends Annotation> annotationClass) {
        AnnotationInfo annotation = target.getAnnotation(annotationClass);
        AnnotationValue value = annotation.getValue("value");
        return value;
    }

    private void addRolesToPermission(Set<String> roleNames, MethodPermission perm) {
        EList roles = perm.getRoles();
        for (String roleName : roleNames) {
            if (perm.getSecurityRole(roleName) != null) continue;
            roles.add(this.createSecurityRole(roleName));
        }
    }

    protected void prepareAddPermission(EJBJar ejbJar, AnnotationTarget target, Set<String> roleNames) throws MergeException {
        EnterpriseBean bean = this.getEnterpriseBean(ejbJar, target.getApplicableClass());
        MethodElement method2 = this.createMethodElement(bean, target);
        MethodPermission perm = this.findBeanPermission(ejbJar, bean, roleNames);
        if (perm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "A role permission was found in descriptor for method " + method2.getSignature() + " with roles " + roleNames + ", no need to create a new one.");
            }
        } else {
            perm = this.createMethodPermission(method2, false);
            perm.getMethodElements().add(method2);
            this.addRolesToPermission(roleNames, perm);
        }
        this.prepareAddEjbSecurityRoles(ejbJar, target, roleNames);
        this.ejbRoleMethods.put(method2, perm);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Role permission will be added to descriptor for method " + method2.getSignature() + " in EJB named " + method2.getEnterpriseBean().getName() + " with roles " + roleNames);
        }
    }

    protected void prepareAddUnchecked(EJBJar ejbJar, AnnotationTarget target) throws MergeException {
        EnterpriseBean bean = this.getEnterpriseBean(ejbJar, target.getApplicableClass());
        MethodElement method2 = this.createMethodElement(bean, target);
        MethodPermission perm = this.findBeanPermission(ejbJar, bean, null);
        if (perm != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "An unchecked permission was found in descriptor for method " + method2.getSignature() + ", no need to create a new one.");
            }
        } else {
            perm = this.createMethodPermission(method2, true);
            perm.getMethodElements().add(method2);
        }
        this.ejbUncheckedMethods.put(method2, perm);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "An unchecked permission will be added to descriptor for method " + method2.getSignature() + " in EJB named " + method2.getEnterpriseBean().getName());
        }
    }

    protected void prepareAddExcluded(EJBJar ejbJar, AnnotationTarget target) throws MergeException {
        EnterpriseBean bean = this.getEnterpriseBean(ejbJar, target.getApplicableClass());
        MethodElement method2 = this.createMethodElement(bean, target);
        this.ejbExcludedMethods.add(method2);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Excluded method will be added to descriptor for method " + method2.getSignature() + " in EJB named " + method2.getEnterpriseBean().getName());
        }
    }

    protected void prepareAddEjbSecurityRoles(EJBJar ejbJar, AnnotationTarget target, Set<String> roleNames) {
        AssemblyDescriptor ad = ejbJar.getAssemblyDescriptor();
        for (String roleName : roleNames) {
            if (ad == null || ad.getSecurityRoleNamed(roleName) == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, roleName + " will be added to Ejb descriptor's security roles.");
                }
                this.ejbSecurityRoles.add(this.createSecurityRole(roleName));
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, roleName + " is already defined in Ejb descriptor's security roles, no need to create one.");
        }
    }

    protected void prepareAddWebSecurityRoles(WebApp webApp, AnnotationTarget target, Set<String> roleNames) {
        for (String roleName : roleNames) {
            if (webApp.getSecurityRoleNamed(roleName) != null) continue;
            this.webSecurityRoles.add(this.createSecurityRole(roleName));
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, roleNames + " will be added to Web descriptor's security roles");
        }
    }

    protected void prepareAddWebRunAs(WebApp webApp, Servlet servlet, String roleName) {
        this.webRunAsRole.put(servlet, this.createRunAsIdentity(roleName));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RunAs role will be added for servlet named " + servlet.getServletName());
        }
    }

    protected void prepareAddEjbRunAs(EJBJar ejbJar, EnterpriseBean bean, String roleName) {
        this.ejbRunAsRole.put(bean, this.createRunAsIdentity(roleName));
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RunAs role will be added for EJB named " + bean.getName());
        }
    }

    protected EnterpriseBean getEnterpriseBean(EJBJar ejbJar, ClassInfo clzInfo) throws MergeException {
        EnterpriseBean ejb = null;
        EList beans = ejbJar.getEnterpriseBeans();
        String clzName = clzInfo.getQualifiedName();
        for (EnterpriseBean bean : beans) {
            String beanClass = bean.getEjbClassName();
            if (!beanClass.equals(clzName)) continue;
            ejb = bean;
            break;
        }
        if (ejb == null && this.ejbDataManager != null) {
            try {
                EnterpriseBeanData ejbData = this.ejbDataManager.getEnterpriseBeanData(clzInfo);
                ClassInfo ejbClassInfo = null;
                if (ejbData != null && (ejbClassInfo = ejbData.getEnterpriseBeanClass()) != null) {
                    String matchName = ejbClassInfo.getQualifiedName();
                    ejb = this.searchAncestors(ejbClassInfo, matchName, ejbData, clzName);
                }
            }
            catch (ValidationException e) {
                String msg = "Unable to get EnterpriseBeanData, exception: " + (Object)((Object)e);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, msg);
                }
                throw new MergeException(msg);
            }
        }
        if (ejb == null) {
            throw new MergeException("Unable to find EnterpriseBean for class " + clzName);
        }
        return ejb;
    }

    private EnterpriseBean searchAncestors(ClassInfo ancestorClass, String matchName, EnterpriseBeanData ejbData, String annotatedClassName) {
        if (ancestorClass != null) {
            String ancestorClassName = ancestorClass.getQualifiedName();
            if (annotatedClassName.equals(ancestorClassName)) {
                Collection beans = ejbData.getEnterpriseBeans();
                if (beans != null && !beans.isEmpty()) {
                    for (EnterpriseBean bean : beans) {
                        String ejbClassName = bean.getEjbClassName();
                        if (!matchName.equals(ejbClassName)) continue;
                        return bean;
                    }
                }
            } else {
                return this.searchAncestors(ancestorClass.getSuperclass(), matchName, ejbData, annotatedClassName);
            }
        }
        return null;
    }

    protected String getMethodSignature(MethodInfo mInfo) {
        return mInfo.getQualifiedName() + '(' + this.getParameters(mInfo) + ')';
    }

    protected String getMethodSignature(MethodAnnotationTarget target) {
        return this.getMethodSignature(target.getApplicableMethod());
    }

    protected void mergeRunAsRoles(MergeData mergeData) {
        EObject dd = mergeData.getDeploymentDescriptor();
        if (dd instanceof EJBJar && !this.ejbRunAsRole.isEmpty()) {
            for (EnterpriseBean bean : this.ejbRunAsRole.keySet()) {
                bean.setSecurityIdentity(this.ejbRunAsRole.get(bean));
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "RunAs role added for EJB named " + bean.getName());
            }
            this.ejbRunAsRole.clear();
        } else if (dd instanceof WebApp && !this.webRunAsRole.isEmpty()) {
            for (Servlet servlet : this.webRunAsRole.keySet()) {
                servlet.setRunAs(this.webRunAsRole.get(servlet));
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "RunAs role added for servlet named " + servlet.getServletName());
            }
            this.webRunAsRole.clear();
        }
    }

    protected void mergeSecurityRoles(MergeData mergeData) {
        EObject dd = mergeData.getDeploymentDescriptor();
        Iterator<SecurityRole> roleIterator = null;
        EList roles = null;
        boolean mergedEjb = false;
        boolean mergedWeb = false;
        if (dd instanceof EJBJar && !this.ejbSecurityRoles.isEmpty()) {
            roles = this.getAssemblyDescriptor((EJBJar)dd).getSecurityRoles();
            roleIterator = this.ejbSecurityRoles.iterator();
            mergedEjb = true;
        } else if (dd instanceof WebApp && !this.webSecurityRoles.isEmpty()) {
            roles = ((WebApp)dd).getSecurityRoles();
            roleIterator = this.webSecurityRoles.iterator();
            mergedWeb = true;
        } else {
            return;
        }
        while (roleIterator.hasNext()) {
            SecurityRole role = roleIterator.next();
            roles.add(role);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, role.getRoleName() + " added to descriptor's security roles");
        }
        if (mergedEjb) {
            this.ejbSecurityRoles.clear();
        }
        if (mergedWeb) {
            this.webSecurityRoles.clear();
        }
    }

    protected void mergeExcludedMethods(MergeData mergeData) {
        EObject dd;
        if (!this.ejbExcludedMethods.isEmpty() && (dd = mergeData.getDeploymentDescriptor()) instanceof EJBJar) {
            EJBJar ejbJar = (EJBJar)dd;
            EList methods = this.getExcludeList(this.getAssemblyDescriptor(ejbJar)).getMethodElements();
            for (MethodElement method2 : this.ejbExcludedMethods) {
                methods.add(method2);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, method2.getSignature() + " added to descriptor's ExcludeList");
            }
            this.ejbExcludedMethods.clear();
        }
    }

    protected void mergeRolePermissions(MergeData mergeData) {
        EObject dd = mergeData.getDeploymentDescriptor();
        if (!(!(dd instanceof EJBJar) || this.ejbUncheckedMethods.isEmpty() && this.ejbRoleMethods.isEmpty())) {
            EJBJar ejbJar = (EJBJar)dd;
            AssemblyDescriptor ad = this.getAssemblyDescriptor(ejbJar);
            this.addMethodPermissionMethodElement(this.ejbUncheckedMethods, ad);
            this.addMethodPermissionMethodElement(this.ejbRoleMethods, ad);
        }
    }

    private void addMethodPermissionMethodElement(Map<MethodElement, MethodPermission> methods, AssemblyDescriptor ad) {
        if (!methods.isEmpty()) {
            EList perms = ad.getMethodPermissions();
            for (MethodElement method2 : methods.keySet()) {
                MethodPermission perm;
                block8: {
                    perm = methods.get(method2);
                    try {
                        perm.setAssemblyDescriptor(ad);
                    }
                    catch (Exception e) {
                        if (!tc.isDebugEnabled()) break block8;
                        Tr.debug(tc, "setAssemblyDescriptor caught unexpected exception: " + e);
                    }
                }
                if (!perms.contains(perm)) {
                    perms.add(perm);
                } else {
                    perm.getMethodElements().add(method2);
                }
                if (!tc.isDebugEnabled()) continue;
                String fullName = method2.getEnterpriseBean().getEjbClassName() + '.' + method2.getSignature();
                StringBuffer msg = new StringBuffer(fullName + " added to descriptor's method ");
                if (perm.isUnchecked()) {
                    msg.append("unchecked permissions, no roles are required.");
                } else {
                    msg.append("role permissions, roles required=" + perm.getRoles());
                }
                Tr.debug(tc, msg.toString());
            }
            methods.clear();
        }
    }

    private MethodPermission findBeanPermission(EJBJar ejbJar, EnterpriseBean bean, Set<String> roleNames) {
        if (ejbJar.getAssemblyDescriptor() == null || ejbJar.getAssemblyDescriptor().getMethodPermissions() == null) {
            return null;
        }
        EList perms = ejbJar.getAssemblyDescriptor().getMethodPermissions();
        block0: for (MethodPermission perm : perms) {
            if (roleNames == null) {
                if (!perm.isUnchecked() || perm.getMethodElements(bean) == null) continue;
                return perm;
            }
            if (perm.isUnchecked() || perm.getMethodElements(bean) == null || roleNames.size() != perm.getRoles().size()) continue;
            for (String roleName : roleNames) {
                if (perm.getSecurityRole(roleName) != null) continue;
                continue block0;
            }
            return perm;
        }
        return null;
    }

    private AssemblyDescriptor getAssemblyDescriptor(EJBJar ejbJar) {
        AssemblyDescriptor ad = ejbJar.getAssemblyDescriptor();
        if (ad == null) {
            ad = EjbFactory.eINSTANCE.createAssemblyDescriptor();
            ejbJar.setAssemblyDescriptor(ad);
        }
        return ad;
    }

    private ExcludeList getExcludeList(AssemblyDescriptor ad) {
        ExcludeList exclude = ad.getExcludeList();
        if (exclude == null) {
            exclude = EjbFactory.eINSTANCE.createExcludeList();
            ad.setExcludeList(exclude);
        }
        return exclude;
    }

    private String getParameters(MethodInfo methodInfo) {
        StringBuffer parmsBuf = new StringBuffer();
        List parms = methodInfo.getParameterTypes();
        int count = parms.size();
        for (int i = 0; i < count; ++i) {
            if (i < count - 1) {
                parmsBuf.append(((ClassInfo)parms.get(i)).getName() + ",");
                continue;
            }
            parmsBuf.append(((ClassInfo)parms.get(i)).getName());
        }
        return parmsBuf.toString();
    }

    private MethodElement createMethodElement(EnterpriseBean bean, AnnotationTarget target) {
        MethodElement method2 = EjbFactory.eINSTANCE.createMethodElement();
        if (target instanceof MethodAnnotationTarget) {
            MethodInfo mInfo = ((MethodAnnotationTarget)target).getApplicableMethod();
            method2.setName(mInfo.getName());
            method2.setParms(this.getParameters(mInfo));
        } else {
            method2.setName("*");
            method2.setParms("");
        }
        method2.setEnterpriseBean(bean);
        return method2;
    }

    private MethodPermission createMethodPermission(MethodElement method2, boolean isUnchecked) {
        MethodPermission perm = EjbFactory.eINSTANCE.createMethodPermission();
        perm.setUnchecked(isUnchecked);
        return perm;
    }

    private SecurityRole createSecurityRole(String roleName) {
        SecurityRole role = CommonFactory.eINSTANCE.createSecurityRole();
        role.setRoleName(roleName);
        return role;
    }

    private RunAsSpecifiedIdentity createRunAsIdentity(String roleName) {
        Identity id = CommonFactory.eINSTANCE.createIdentity();
        id.setRoleName(roleName);
        RunAsSpecifiedIdentity runAsId = CommonFactory.eINSTANCE.createRunAsSpecifiedIdentity();
        runAsId.setIdentity(id);
        return runAsId;
    }

    public boolean isAnnotationPresent(Class<?> annotation, AnnotationTarget annotationTarget) {
        ClassInfo cInfo;
        MethodInfo mInfo;
        Collection annotations = null;
        boolean isMethod = annotationTarget instanceof MethodAnnotationTarget;
        annotations = isMethod ? ((mInfo = ((MethodAnnotationTarget)annotationTarget).getApplicableMethod()) != null ? mInfo.getAnnotations() : null) : ((cInfo = annotationTarget.getApplicableClass()) != null ? cInfo.getAnnotations() : null);
        boolean isAnnotationPresent = this.isAnnotationPresent(annotation.getName(), annotations);
        if (tc.isDebugEnabled()) {
            if (isMethod) {
                Tr.debug(tc, "Is method " + this.getMethodSignature((MethodAnnotationTarget)annotationTarget) + " annotated with " + annotation.getSimpleName() + "? " + isAnnotationPresent);
            } else {
                Tr.debug(tc, "Is class " + annotationTarget.getApplicableClass().getName() + " annotated with " + annotation.getSimpleName() + "? " + isAnnotationPresent);
            }
        }
        return isAnnotationPresent;
    }

    private boolean isAnnotationPresent(String annotationName, Collection<AnnotationInfo> annotations) {
        boolean isAnnotationPresent = false;
        if (annotations != null) {
            for (AnnotationInfo aInfo : annotations) {
                String name = aInfo.getName();
                isAnnotationPresent = annotationName != null && annotationName.equals(name);
                if (!isAnnotationPresent) continue;
                break;
            }
        }
        return isAnnotationPresent;
    }

    public boolean isEjbRoleDefinedByMergeAction(String roleName) {
        return this.isDefinedByMergeAction(roleName, this.ejbSecurityRoles);
    }

    public boolean isWebRoleDefinedByMergeAction(String roleName) {
        return this.isDefinedByMergeAction(roleName, this.webSecurityRoles);
    }

    private boolean isDefinedByMergeAction(String roleName, Set<SecurityRole> roles) {
        if (roles != null && !roles.isEmpty()) {
            for (SecurityRole role : roles) {
                if (!role.getRoleName().equals(roleName)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized void postProcess() {
        managers.clear();
    }
}

