/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.role.metadata;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.security.role.metadata.EjbMergeAction;
import com.ibm.wsspi.amm.merge.MergeException;
import com.ibm.wsspi.amm.scan.ClassAnnotationTarget;
import com.ibm.wsspi.amm.scan.util.info.ClassInfo;
import com.ibm.wsspi.amm.scan.util.info.Info;
import java.lang.annotation.Annotation;
import javax.annotation.security.RunAs;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MergeEjbRunAs
extends EjbMergeAction {
    private static final TraceComponent tc = Tr.register(MergeEjbRunAs.class, "Security");

    @Override
    Class<? extends Annotation> getAnnotationClass() {
        return RunAs.class;
    }

    @Override
    void mergeClassAnnotation(EJBJar ejbJar, ClassAnnotationTarget classAnnotationTarget) throws MergeException {
        ClassInfo clzInfo = classAnnotationTarget.getApplicableClass();
        EnterpriseBean bean = this.manager.getEnterpriseBean(ejbJar, clzInfo);
        if (bean.getSecurityIdentity() != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, this.getAnnotationClass().getSimpleName() + " annotation is overriden in ejb descriptor for EJB class " + bean.getEjbClassName() + " with identity " + bean.getSecurityIdentity());
            }
        } else {
            String roleName = this.manager.getSecurityRoleName((Info)clzInfo, this.getAnnotationClass());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "RunAs role " + roleName + " will be added to ejb descriptor for class " + clzInfo.getName());
            }
            this.manager.prepareAddEjbRunAs(ejbJar, bean, roleName);
        }
    }
}

