/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.role;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminContext;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.models.config.rolebasedauthz.AuthorizationTableExt;
import com.ibm.websphere.models.config.rolebasedauthz.GroupExt;
import com.ibm.websphere.models.config.rolebasedauthz.RoleAssignmentExt;
import com.ibm.websphere.models.config.rolebasedauthz.RolebasedauthzFactory;
import com.ibm.websphere.models.config.rolebasedauthz.RolebasedauthzPackage;
import com.ibm.websphere.models.config.rolebasedauthz.SecurityRoleExt;
import com.ibm.websphere.models.config.rolebasedauthz.UserExt;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.ContextManager;
import com.ibm.ws.security.core.ContextManagerFactory;
import com.ibm.ws.security.registry.RegistryUtil;
import com.ibm.ws.security.role.DescriptorConversionException;
import com.ibm.ws.security.role.DescriptorParseException;
import com.ibm.ws.security.role.RoleBasedAppException;
import com.ibm.ws.security.role.RoleBasedAuthorizer;
import com.ibm.ws.security.role.RoleBasedAuthorizerImpl;
import com.ibm.ws.security.role.RoleBasedAuthorizerNullImpl;
import com.ibm.ws.security.role.RoleBasedConfigurator;
import com.ibm.ws.security.role.RoleBasedModule;
import com.ibm.ws.security.role.RoleBasedSubjectMap;
import com.ibm.ws.security.role.RolePermissionDescriptorLoader;
import com.ibm.ws.security.role.RolePermissionFromMBean;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import com.ibm.ws.sm.workspace.WorkSpaceManagerFactory;
import com.ibm.wsspi.runtime.config.ConfigObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.management.modelmbean.ModelMBeanInfo;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.xml.sax.InputSource;

public class RoleBasedConfiguratorImpl
implements RoleBasedConfigurator {
    private static TraceComponent tc = Tr.register(RoleBasedConfiguratorImpl.class, null, "com.ibm.ejs.resources.security");
    private static final String CONTACT_INFO = "WebSphere Security";
    private static final String userPrefix = "user:";
    private static final String groupPrefix = "group:";
    private boolean securityEnabled = true;
    private RoleBasedAuthorizerNullImpl nullAuthorizer = null;
    private UserRegistry registry = null;
    private RolebasedauthzFactory rbaFact = null;
    private WorkSpace workspace = null;
    private String serverId = null;
    private String longServerId = null;
    private boolean ignoreCase = false;
    private boolean isLDAPRegistry = false;
    private HashMap applications = new HashMap(4);

    public RoleBasedConfiguratorImpl() {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "RoleBasedConfiguratorImpl ctor ", this);
        }
        this.InitializeFactories();
        this.InitializeServerId();
    }

    private void InitializeServerId() {
        block22: {
            SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
            Boolean secEnabled = security2.getBoolean("enabled");
            Boolean isIgnoreCase = security2.getActiveUserRegistry().getBoolean("ignoreCase");
            if (isIgnoreCase != null && isIgnoreCase.booleanValue()) {
                this.ignoreCase = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ignoreCase is set");
                }
            }
            if (security2.getActiveUserRegistry().getType().equals("LDAP")) {
                this.isLDAPRegistry = true;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "User registry type is LDAP");
                }
            }
            try {
                if (secEnabled != null && secEnabled.booleanValue()) {
                    ContextManager contextMgr = ContextManagerFactory.getInstance();
                    if (contextMgr != null) {
                        try {
                            String realm = null;
                            if (AdminContext.peek() == null) {
                                realm = contextMgr.getAdminRealm();
                            }
                            this.registry = contextMgr.getRegistry(realm);
                        }
                        catch (Exception re2) {
                            FFDCFilter.processException((Throwable)re2, "com.ibm.ws.security.role.RoleBasedConfiguratorImpl.InitializeServerid", "155", this);
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Failed to get registry from ContextManager");
                            }
                            Tr.error(tc, "security.sambean.urerr", new Object[]{re2});
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to get ContextManager");
                        }
                        Tr.error(tc, "security.sambean.nullsecserver");
                    }
                    WSCredential serverCreds = contextMgr.getServerCredential();
                    if (serverCreds != null) {
                        this.serverId = serverCreds.getRealmSecurityName();
                        if (this.serverId != null && this.ignoreCase) {
                            this.serverId = this.serverId.toLowerCase();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "serverId =  " + this.serverId);
                        }
                        this.longServerId = serverCreds.getAccessId();
                        if (this.longServerId != null && this.ignoreCase) {
                            this.longServerId = this.longServerId.toLowerCase();
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "longServerId =  " + this.longServerId);
                        }
                    } else {
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Failed to get serverCreds");
                        }
                        Tr.error(tc, "security.sambean.nullsecserver");
                    }
                } else {
                    this.securityEnabled = false;
                }
            }
            catch (Throwable t) {
                FFDCFilter.processException(t, "com.ibm.ws.security.role.RoleBasedConfiguratorImpl.setSecurityServer", "182", this);
                if (!tc.isDebugEnabled()) break block22;
                Tr.debug(tc, "failed to form serverId" + t.getMessage());
            }
        }
    }

    private void InitializeFactories() {
        RolebasedauthzPackage pkg = RolebasedauthzPackage.eINSTANCE;
        this.rbaFact = (RolebasedauthzFactory)pkg.getEFactoryInstance();
    }

    public synchronized void loadApplication(String appName, Resource authzTableExt) throws RoleBasedAppException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadApplication", appName);
        }
        if (!this.securityEnabled) {
            if (this.nullAuthorizer == null) {
                this.nullAuthorizer = new RoleBasedAuthorizerNullImpl();
            }
            return;
        }
        if (this.applications.containsKey(appName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Warning: " + appName + " already loaded");
            }
            return;
        }
        EList ext = authzTableExt.getContents();
        Iterator iter = ext.iterator();
        AuthorizationTableExt atx = null;
        while (iter.hasNext()) {
            atx = (AuthorizationTableExt)iter.next();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "AuthorizationTableExt context " + atx.getContext());
            }
            if (!atx.getContext().equals("domain")) continue;
        }
        if (atx == null || !atx.getContext().equals("domain")) {
            throw new RoleBasedAppException("cell level AuthorizationTable not found");
        }
        this.fillMissingAccessIds(atx, appName);
        EList roleList = atx.getRoles();
        RoleBasedSubjectMap subjMap = new RoleBasedSubjectMap(appName, atx.getRoles(), this.serverId, this.longServerId, true);
        EList assignList = atx.getAuthorizations();
        for (RoleAssignmentExt rax : assignList) {
            String roleName = rax.getRole().getRoleName();
            subjMap.addSpecialSubjects(roleName, rax.getSpecialSubjects(), true);
            subjMap.addSubjects(roleName, rax.getUsers(), true, null);
            subjMap.addSubjectGroups(roleName, rax.getGroups(), true, null);
        }
        subjMap.pack();
        RoleBasedAuthorizerImpl rba = new RoleBasedAuthorizerImpl(appName, this);
        RoleBasedApplication rbApp = new RoleBasedApplication(subjMap, rba);
        this.applications.put(appName, rbApp);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadApplication", appName);
        }
    }

    public synchronized void loadApplication(String appName, ConfigObject atx) throws RoleBasedAppException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadApplication1", appName);
        }
        if (!this.securityEnabled) {
            if (this.nullAuthorizer == null) {
                this.nullAuthorizer = new RoleBasedAuthorizerNullImpl();
            }
            return;
        }
        if (this.applications.containsKey(appName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Warning: " + appName + " already loaded");
            }
            return;
        }
        List roleList = atx.getObjectList("roles");
        RoleBasedSubjectMap subjMap = new RoleBasedSubjectMap(appName, atx.getObjectList("roles"), this.serverId, this.longServerId, false);
        List assignList = atx.getObjectList("authorizations");
        for (ConfigObject rax : assignList) {
            String roleName = rax.getObject("role").getString("roleName", null);
            subjMap.addSpecialSubjects(roleName, rax.getObjectList("specialSubjects"), false);
            subjMap.addSubjects(roleName, rax.getObjectList("users"), false, null);
            subjMap.addSubjectGroups(roleName, rax.getObjectList("groups"), false, null);
        }
        subjMap.pack();
        RoleBasedAuthorizerImpl rba = new RoleBasedAuthorizerImpl(appName, this);
        RoleBasedApplication rbApp = new RoleBasedApplication(subjMap, rba);
        this.applications.put(appName, rbApp);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadApplication1", appName);
        }
    }

    public synchronized void loadApplication(String appName, List authTableConfigObjects) throws RoleBasedAppException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadApplication2", appName);
        }
        HashMap modules = null;
        if (!this.securityEnabled) {
            if (this.nullAuthorizer == null) {
                this.nullAuthorizer = new RoleBasedAuthorizerNullImpl();
            }
            return;
        }
        if (this.applications.containsKey(appName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadApplication2 Warning: " + appName + " already loaded");
            }
            RoleBasedApplication app = (RoleBasedApplication)this.applications.get(appName);
            modules = app.modules;
        }
        RoleBasedSubjectMap subjMap = null;
        for (int i = 0; i < authTableConfigObjects.size(); ++i) {
            ConfigObject atx = (ConfigObject)authTableConfigObjects.get(i);
            List roleList = atx.getObjectList("roles");
            if (subjMap == null) {
                subjMap = new RoleBasedSubjectMap(appName, atx.getObjectList("roles"), this.serverId, this.longServerId, false);
            } else {
                subjMap.addRoles(atx.getObjectList("roles"));
            }
            List assignList = atx.getObjectList("authorizations");
            for (ConfigObject rax : assignList) {
                String roleName = rax.getObject("role").getString("roleName", null);
                subjMap.addSpecialSubjects(roleName, rax.getObjectList("specialSubjects"), false);
                subjMap.addSubjects(roleName, rax.getObjectList("users"), false, this);
                subjMap.addSubjectGroups(roleName, rax.getObjectList("groups"), false, this);
            }
        }
        subjMap.pack();
        RoleBasedAuthorizerImpl rba = null;
        try {
            rba = (RoleBasedAuthorizerImpl)this.getRoleBasedAuthorizer(appName, "scope");
        }
        catch (Exception e) {
            rba = null;
        }
        if (rba == null) {
            rba = new RoleBasedAuthorizerImpl(appName, this);
        }
        RoleBasedApplication rbApp = new RoleBasedApplication(subjMap, rba);
        if (modules != null) {
            rbApp.modules = modules;
        }
        this.applications.put(appName, rbApp);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadApplication2", appName);
        }
    }

    public synchronized Set getApplications() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getApplications");
        }
        if (this.applications.isEmpty()) {
            return null;
        }
        HashSet set = new HashSet(this.applications.keySet());
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getApplications");
        }
        return set;
    }

    public synchronized RoleBasedAuthorizer getRoleBasedAuthorizer(String appName, String scope) throws RoleBasedAppException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRoleBasedAuthorizer", new Object[]{appName, scope, this});
        }
        if (!this.securityEnabled) {
            return this.nullAuthorizer;
        }
        if (!this.applications.containsKey(appName)) {
            if ("admin-authz".equals(appName) || "admin-authz-merge".equals(appName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "admin-authz not loaded yet");
                }
            } else {
                Tr.error(tc, "security.roleauthz.appnoload", new Object[]{appName});
            }
            throw new RoleBasedAppException(appName + " not loaded yet");
        }
        RoleBasedAuthorizerImpl authorizer = ((RoleBasedApplication)this.applications.get(appName)).rbAuthzer;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRoleBasedAuthorizer", authorizer);
        }
        return authorizer;
    }

    public synchronized RoleBasedAuthorizer loadSecurityPolicy(String appName, ModelMBeanInfo mbInfo, InputSource rolePermissionDescriptor, String context) throws RoleBasedAppException, DescriptorConversionException, DescriptorParseException {
        Object sdr;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadSecurityPolicy - MBean " + appName);
        }
        if (!this.securityEnabled) {
            return this.nullAuthorizer;
        }
        if (!this.applications.containsKey(appName)) {
            if ("admin-authz".equals(appName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "admin-authz not loaded yet");
                }
            } else {
                Tr.error(tc, "security.roleauthz.appnoload", new Object[]{appName});
            }
            throw new RoleBasedAppException(appName + " not loaded yet");
        }
        RoleBasedModule rbMod = null;
        String moduleName = null;
        try {
            moduleName = (String)mbInfo.getMBeanDescriptor().getFieldValue("type");
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.role.RoleBasedConfiguratorImpl.loadSecurityPolicy", "246", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "loadSecurityPolicy: cannot get module name ");
            }
            throw new RoleBasedAppException("cannot get module name");
        }
        if (rolePermissionDescriptor != null) {
            try {
                sdr = new RolePermissionDescriptorLoader();
                rbMod = ((RolePermissionDescriptorLoader)sdr).loadDescriptor(rolePermissionDescriptor, moduleName, (Object)this);
            }
            catch (DescriptorParseException ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.role.RoleBasedConfiguratorImpl.loadSecurityPolicy", "240", this);
                Tr.warning(tc, "loadSecurityPolicy: cannot load " + moduleName + " ,continue with the default mbean security policy.");
            }
        }
        if (rbMod == null && mbInfo != null) {
            sdr = new RolePermissionFromMBean();
            rbMod = ((RolePermissionFromMBean)sdr).convert(mbInfo);
        }
        if (!((RoleBasedApplication)this.applications.get(appName)).modules.containsKey(rbMod.getModuleName())) {
            ((RoleBasedApplication)this.applications.get(appName)).modules.put(rbMod.getModuleName(), rbMod);
        } else {
            Tr.warning(tc, "security.roleauthz.appalreadyload", new Object[]{rbMod.getModuleName()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadSecurityPolicy - MBean", appName);
        }
        return ((RoleBasedApplication)this.applications.get(appName)).rbAuthzer;
    }

    public synchronized RoleBasedAuthorizer loadSecurityPolicy(String appName, String rolePermissionDescriptorPath, String context) throws RoleBasedAppException, DescriptorParseException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadSecurityPolicy", appName);
        }
        if (!this.securityEnabled) {
            return this.nullAuthorizer;
        }
        if (!this.applications.containsKey(appName)) {
            if ("admin-authz".equals(appName)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "admin-authz not loaded yet");
                }
            } else {
                Tr.error(tc, "security.roleauthz.appnoload", new Object[]{appName});
            }
            throw new RoleBasedAppException(appName + " not loaded yet");
        }
        RoleBasedModule rbMod = null;
        if (rolePermissionDescriptorPath != null) {
            try {
                RolePermissionDescriptorLoader sdr = new RolePermissionDescriptorLoader();
                rbMod = sdr.loadDescriptor(rolePermissionDescriptorPath, null, (Object)this);
            }
            catch (DescriptorParseException ex) {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.role.RoleBasedConfiguratorImpl.loadSecurityPolicy", "281", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "loadSecurityPolicy: cannot load " + rolePermissionDescriptorPath);
                }
                throw ex;
            }
        }
        if (!((RoleBasedApplication)this.applications.get(appName)).modules.containsKey(rbMod.getModuleName())) {
            ((RoleBasedApplication)this.applications.get(appName)).modules.put(rbMod.getModuleName(), rbMod);
        } else {
            Tr.warning(tc, "security.roleauthz.appalreadyload", new Object[]{rbMod.getModuleName()});
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadSecurityPolicy", appName);
        }
        return ((RoleBasedApplication)this.applications.get(appName)).rbAuthzer;
    }

    public AuthorizationTableExt getAuthorizationTable(String appName, String scope) throws RoleBasedAppException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthorizationTable", appName + " : " + scope);
        }
        return this.getReadWriteAuthorizationTable(appName, scope);
    }

    public AuthorizationTableExt getReadOnlyAuthorizationTable(String appName, String scope) throws RoleBasedAppException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReadOnlyAuthorizationTable", appName + " : " + scope);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationTableExt getReadWriteAuthorizationTable(String appName, String scope) throws RoleBasedAppException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getReadWriteAuthorizationTable", appName + " : " + scope);
        }
        try {
            if (this.workspace == null) {
                this.workspace = WorkSpaceManagerFactory.getManager().getWorkSpace("cyc");
                if (this.workspace == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "workspace is null");
                    }
                    return null;
                }
            }
            WorkSpace workSpace = this.workspace;
            synchronized (workSpace) {
                String defaultCellName = AdminServiceFactory.getAdminService().getCellName();
                RepositoryContext cellContext = this.workspace.findContext("cells/" + defaultCellName);
                if (cellContext == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cellContext is null");
                    }
                    return null;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding cell ResourceSet: " + cellContext.getName());
                }
                cellContext.extract(appName + ".xml", true);
                Resource resource = cellContext.getResourceSet().getResource(URI.createURI(appName + ".xml"), true);
                if (resource == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resource is null");
                    }
                    return null;
                }
                EList ext = resource.getContents();
                Iterator iter = ext.iterator();
                AuthorizationTableExt atx = null;
                while (iter.hasNext()) {
                    atx = (AuthorizationTableExt)iter.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "AuthorizationTableExt context = " + atx.getContext());
                    }
                    if (!atx.getContext().equals("domain")) continue;
                }
                if (atx == null || !atx.getContext().equals("domain")) {
                    throw new RoleBasedAppException("cell level AuthorizationTable not found");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "AuthorizationTableExt = ", new Object[]{atx});
                }
                return atx;
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.security.role.RoleBasedConfiguratorImpl.getReadWriteAuthorizationTable", "361", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught");
                t.printStackTrace();
            }
            throw new RoleBasedAppException("loading cell level AuthorizationTable failed");
        }
    }

    public synchronized RoleBasedModule getRoleBasedModule(String appName, String moduleName) throws RoleBasedAppException {
        if (!this.applications.containsKey(appName)) {
            throw new RoleBasedAppException(appName + " not found");
        }
        return (RoleBasedModule)((RoleBasedApplication)this.applications.get(appName)).modules.get(moduleName);
    }

    public synchronized RoleBasedSubjectMap getRoleBasedSubjectMap(String appName) throws RoleBasedAppException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRoleBasedSubjectMap", new Object[]{appName, this});
        }
        if (!this.applications.containsKey(appName)) {
            throw new RoleBasedAppException(appName + " not found");
        }
        RoleBasedSubjectMap map = ((RoleBasedApplication)this.applications.get(appName)).subjectMap;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRoleBasedSubjectMap", map);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAuthorizationTable(String appName, AuthorizationTableExt authTable, String scope) throws RoleBasedAppException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addAuthorizationTable", appName + " : " + scope);
        }
        if (authTable == null || scope == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Either AuthorizationTableExt = " + authTable + " or scope is not specified, scope = " + scope);
            }
            return;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "AuthorizationTableExt context = " + authTable.getContext());
            Tr.debug(tc, "adding to scope = " + scope);
        }
        if (!scope.equals("domain")) {
            throw new RoleBasedAppException("Invalid scope: " + scope);
        }
        authTable.setContext(scope);
        try {
            if (this.workspace == null) {
                this.workspace = WorkSpaceManagerFactory.getManager().getWorkSpace("cyc");
                if (this.workspace == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "workspace is null");
                    }
                    return;
                }
            }
            WorkSpace workSpace = this.workspace;
            synchronized (workSpace) {
                String defaultCellName = AdminServiceFactory.getAdminService().getCellName();
                RepositoryContext cellContext = this.workspace.findContext("cells/" + defaultCellName);
                if (cellContext == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "cellContext is null");
                    }
                    return;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding cell ResourceSet: " + cellContext.getName());
                }
                cellContext.extract(appName + ".xml", true);
                Resource resource = cellContext.getResourceSet().getResource(URI.createURI(appName + ".xml"), true);
                if (resource == null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resource is null");
                    }
                    return;
                }
                EList ext = resource.getContents();
                Iterator iter = ext.iterator();
                AuthorizationTableExt atx = null;
                while (iter.hasNext()) {
                    atx = (AuthorizationTableExt)iter.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "AuthorizationTableExt context = " + atx.getContext());
                    }
                    if (!atx.getContext().equals(authTable.getContext())) continue;
                    iter.remove();
                    break;
                }
                ((BasicEList)ext).add(authTable);
                HashMap conflictResolutions = new HashMap();
                this.workspace.synch(cellContext, conflictResolutions);
            }
        }
        catch (Throwable t) {
            FFDCFilter.processException(t, "com.ibm.ws.security.role.RoleBasedConfiguratorImpl.addAuthorizationTable", "446", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception caught");
                t.printStackTrace();
            }
            throw new RoleBasedAppException("modifying cell level AuthorizationTable failed");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addAuthorizationTable", appName + " : " + scope);
        }
    }

    public void deleteAuthorizationTable(String appName, String scope) throws RoleBasedAppException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "deleteAuthorizationTable", appName + " : " + scope);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "deleteAuthorizationTable", appName + " : " + scope);
        }
    }

    private void AddAdminSecurityRoleExt(AuthorizationTableExt atx) {
        RolebasedauthzFactory rbaFact = (RolebasedauthzFactory)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/rolebasedauthz.xmi").getEFactoryInstance();
        SecurityRoleExt sr1 = rbaFact.createSecurityRoleExt();
        sr1.setRoleName("administrator");
        atx.getRoles().add(sr1);
        SecurityRoleExt sr2 = rbaFact.createSecurityRoleExt();
        sr2.setRoleName("operator");
        atx.getRoles().add(sr2);
        SecurityRoleExt sr3 = rbaFact.createSecurityRoleExt();
        sr3.setRoleName("configurator");
        atx.getRoles().add(sr3);
        SecurityRoleExt sr4 = rbaFact.createSecurityRoleExt();
        sr4.setRoleName("monitor");
        atx.getRoles().add(sr4);
        SecurityRoleExt sr5 = rbaFact.createSecurityRoleExt();
        sr5.setRoleName("deployer");
        atx.getRoles().add(sr5);
    }

    private void AddNamingSecurityRoleExt(AuthorizationTableExt atx) {
        RolebasedauthzFactory rbaFact = (RolebasedauthzFactory)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/rolebasedauthz.xmi").getEFactoryInstance();
        SecurityRoleExt sr1 = rbaFact.createSecurityRoleExt();
        sr1.setRoleName("CosNamingRead");
        atx.getRoles().add(sr1);
        SecurityRoleExt sr2 = rbaFact.createSecurityRoleExt();
        sr2.setRoleName("CosNamingWrite");
        atx.getRoles().add(sr2);
        SecurityRoleExt sr3 = rbaFact.createSecurityRoleExt();
        sr3.setRoleName("CosNamingCreate");
        atx.getRoles().add(sr3);
        SecurityRoleExt sr4 = rbaFact.createSecurityRoleExt();
        sr4.setRoleName("CosNamingDelete");
        atx.getRoles().add(sr4);
    }

    private AuthorizationTableExt CreateAuthorizationTableExt(String appName) {
        RolebasedauthzFactory rbaFact = (RolebasedauthzFactory)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/rolebasedauthz.xmi").getEFactoryInstance();
        AuthorizationTableExt atx = rbaFact.createAuthorizationTableExt();
        atx.setContext("domain");
        if (appName.equals("admin-authz")) {
            this.AddAdminSecurityRoleExt(atx);
        } else if (appName.equals("naming-authz")) {
            this.AddNamingSecurityRoleExt(atx);
        }
        EList srs = atx.getRoles();
        for (SecurityRoleExt sr : srs) {
            RoleAssignmentExt rax = rbaFact.createRoleAssignmentExt();
            rax.setRole(sr);
            atx.getAuthorizations().add(rax);
        }
        return atx;
    }

    String getAccessId(ConfigObject ugEntry, boolean isGroup) {
        String accessId;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getAccessId", new Object[]{ugEntry});
            }
            if ((accessId = ugEntry.getString("accessId", null)) != null && accessId.length() > 0 && this.isLDAPRegistry) {
                accessId = RegistryUtil.removeDNSpace(accessId, -1);
            }
            if (accessId == null || accessId.length() == 0) {
                String name = ugEntry.getString("name", null);
                if (name != null && !name.equals("")) {
                    try {
                        if (this.registry != null) {
                            accessId = isGroup ? this.registry.getUniqueGroupId(name) : this.registry.getUniqueUserId(name);
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getAccessId cannot get accessID as the registry is null");
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getAccessId assigning user/group " + name + " accessId to " + accessId);
                        }
                        break block14;
                    }
                    catch (Exception e) {
                        FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.role.RoleBasedConfiguratorImpl.getAccessId", "892", this);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getAccessId unexpected exception", e);
                        }
                        break block14;
                    }
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getAccessId user/group from auth table has no accessId and no name");
                }
            }
        }
        if (accessId != null && this.ignoreCase) {
            accessId = accessId.toLowerCase();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAccessId " + (accessId != null ? accessId : "null"));
        }
        return accessId;
    }

    private void fillMissingAccessIds(AuthorizationTableExt table, String appName) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "fillMissingAccessIds " + table + " authz name " + appName);
        }
        for (RoleAssignmentExt ras : table.getAuthorizations()) {
            for (UserExt user : ras.getUsers()) {
                String accessId;
                block27: {
                    accessId = user.getAccessId();
                    if (accessId != null && accessId.length() > 0 && this.isLDAPRegistry) {
                        accessId = RegistryUtil.removeDNSpace(accessId, -1);
                    }
                    if (!(accessId != null && accessId.length() != 0 && accessId.startsWith(userPrefix) || user.getName() == null || user.getName().equals(""))) {
                        try {
                            if (this.registry != null) {
                                String uName = user.getName();
                                int uIndex = uName.lastIndexOf("@");
                                if (uIndex != -1) {
                                    uName = uName.substring(0, uIndex);
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "user name is: " + uName);
                                }
                                accessId = this.registry.getUniqueUserId(uName);
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "cannot get accessID as the registry is null");
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "set user " + user.getName() + " accessId to " + user.getAccessId());
                            }
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.role.RoleBasedConfiguratorImpl.fillMissingAccessIds", "542", this);
                            if (!tc.isDebugEnabled()) break block27;
                            e.printStackTrace();
                        }
                    }
                }
                if (accessId != null && this.ignoreCase) {
                    accessId = accessId.toLowerCase();
                }
                if (accessId == null || accessId.length() <= 0) continue;
                user.setAccessId(accessId);
            }
            for (GroupExt group : ras.getGroups()) {
                String accessId;
                block28: {
                    accessId = group.getAccessId();
                    if (accessId != null && accessId.length() > 0 && this.isLDAPRegistry) {
                        accessId = RegistryUtil.removeDNSpace(accessId, -1);
                    }
                    if (accessId == null || accessId.length() == 0 || !accessId.startsWith(groupPrefix)) {
                        try {
                            if (this.registry != null) {
                                String gName = group.getName();
                                int gIndex = gName.lastIndexOf("@");
                                if (gIndex != -1) {
                                    gName = gName.substring(0, gIndex);
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "group name is: " + gName);
                                }
                                accessId = this.registry.getUniqueGroupId(gName);
                            } else if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "cannot get accessID as the registry is null");
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "set group " + group.getName() + " accessId to " + group.getAccessId());
                            }
                        }
                        catch (Exception e) {
                            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.role.RoleBasedConfiguratorImpl.fillMissingAccessIds", "565", this);
                            if (!tc.isDebugEnabled()) break block28;
                            e.printStackTrace();
                        }
                    }
                }
                if (accessId != null && this.ignoreCase) {
                    accessId = accessId.toLowerCase();
                }
                if (accessId == null || accessId.length() <= 0) continue;
                group.setAccessId(accessId);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "fillMissingAccessIds");
        }
    }

    public boolean areAccessIdsMissing(ConfigObject atx) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "areAccessIdsMissing", new Object[]{atx});
        }
        boolean missingAccessId = false;
        Iterator itr = atx.getObjectList("authorizations").iterator();
        while (itr.hasNext() && !missingAccessId) {
            ConfigObject ras = (ConfigObject)itr.next();
            Iterator users = ras.getObjectList("users").iterator();
            while (users.hasNext() && !missingAccessId) {
                String userName;
                ConfigObject user = (ConfigObject)users.next();
                String accessId = user.getString("accessId", null);
                if (accessId != null && accessId.length() > 0 && this.isLDAPRegistry) {
                    accessId = RegistryUtil.removeDNSpace(accessId, -1);
                }
                if (accessId != null && accessId.length() != 0 || (userName = user.getString("name", null)) == null || userName.equals("")) continue;
                missingAccessId = true;
            }
            Iterator groups = ras.getObjectList("groups").iterator();
            while (groups.hasNext() && !missingAccessId) {
                ConfigObject group = (ConfigObject)groups.next();
                String accessId = group.getString("accessId", null);
                if (accessId != null && accessId.length() > 0 && this.isLDAPRegistry) {
                    accessId = RegistryUtil.removeDNSpace(accessId, -1);
                }
                if (accessId != null && accessId.length() != 0) continue;
                missingAccessId = true;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "areAccessIdsMissing: " + missingAccessId);
        }
        return missingAccessId;
    }

    public synchronized void loadApplication(String appName, AuthorizationTableExt atx) throws RoleBasedAppException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "loadApplication3", appName);
        }
        HashMap modules = null;
        if (!this.securityEnabled) {
            if (this.nullAuthorizer == null) {
                this.nullAuthorizer = new RoleBasedAuthorizerNullImpl();
            }
            return;
        }
        if (this.applications.containsKey(appName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Warning: " + appName + " already loaded");
            }
            RoleBasedApplication app = (RoleBasedApplication)this.applications.get(appName);
            modules = app.modules;
        }
        if (atx == null) {
            throw new RoleBasedAppException("Invalid AuthorizationTable");
        }
        this.fillMissingAccessIds(atx, appName);
        EList roleList = atx.getRoles();
        RoleBasedSubjectMap subjMap = new RoleBasedSubjectMap(appName, atx.getRoles(), this.serverId, this.longServerId, true);
        EList assignList = atx.getAuthorizations();
        for (RoleAssignmentExt rax : assignList) {
            String roleName = rax.getRole().getRoleName();
            subjMap.addSpecialSubjects(roleName, rax.getSpecialSubjects(), true);
            subjMap.addSubjects(roleName, rax.getUsers(), true, null);
            subjMap.addSubjectGroups(roleName, rax.getGroups(), true, null);
        }
        subjMap.pack();
        RoleBasedAuthorizerImpl rba = null;
        try {
            rba = (RoleBasedAuthorizerImpl)this.getRoleBasedAuthorizer(appName, "scope");
        }
        catch (Exception e) {
            rba = null;
        }
        if (rba == null) {
            rba = new RoleBasedAuthorizerImpl(appName, this);
        }
        RoleBasedApplication rbApp = new RoleBasedApplication(subjMap, rba);
        if (modules != null) {
            rbApp.modules = modules;
        }
        this.applications.put(appName, rbApp);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadApplication3", appName);
        }
    }

    class RoleBasedApplication {
        private RoleBasedSubjectMap subjectMap = null;
        private HashMap modules = new HashMap(1);
        private RoleBasedAuthorizerImpl rbAuthzer = null;

        private RoleBasedApplication(RoleBasedSubjectMap subjMap, RoleBasedAuthorizerImpl rba) {
            this.subjectMap = subjMap;
            this.rbAuthzer = rba;
        }
    }
}

