/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.role;

import com.ibm.ejs.ras.RasHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.AuthorizationTable;
import com.ibm.websphere.security.SecurityProviderException;
import com.ibm.websphere.security.auth.WSPrincipal;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.auth.SubjectHelper;
import com.ibm.ws.security.config.SecurityConfig;
import com.ibm.ws.security.config.SecurityConfigGlobals;
import com.ibm.ws.security.config.SecurityConfigManager;
import com.ibm.ws.security.config.SecurityConfigResource;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.core.AccessContext;
import java.util.HashMap;
import javax.security.auth.Subject;
import org.eclipse.jst.j2ee.common.SecurityRole;

public final class PluggableAuthorizationTableProxy {
    private static final TraceComponent tc = Tr.register(PluggableAuthorizationTableProxy.class, "Security", "com.ibm.ejs.resources.security");
    public static final String SUBJECT_KEY = "AUTHZ_SUBJECT";
    private static boolean isSingleDomain = false;
    private static SecurityConfigManager scm = null;
    private static String ADMIN_CACHE_KEY = "admin";
    private static Object lockObject = new Object();
    private static boolean isAdminAuthTableSet = false;
    private static PluggableAuthorizationTableProxy adminAuthTable = null;
    private static boolean isAppAuthTableSet = false;
    private static PluggableAuthorizationTableProxy appAuthTable = null;
    private static HashMap<String, PluggableAuthorizationTableProxy> _cache = new HashMap();
    private final boolean _isSAFAuthorization;
    private final AuthorizationTable _authTable;
    private final String _cellName;
    private final String _serverName;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized PluggableAuthorizationTableProxy getAuthorizationTableProxy() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthorizationTableProxy");
        }
        PluggableAuthorizationTableProxy instance = null;
        SecurityConfigResource currentStackEntry = null;
        boolean setAdminAuthTable = false;
        boolean setAppAuthTable = false;
        boolean setSomeAuthTable = false;
        if (isSingleDomain) {
            return adminAuthTable;
        }
        if (scm == null) {
            if (!RasHelper.isServer()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unexpected behaviour: executing inside client, this should not happen.");
                }
            } else {
                scm = SecurityObjectLocator.getSecurityConfigManager();
                boolean bl = isSingleDomain = !scm.isAdminAgent() && !scm.isMultiDomainDefined();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getAuthorizationTableProxy, SecurityConfigManager instance " + scm);
                }
            }
            if (isSingleDomain) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "isSingleDomain is true, creating one instance");
                }
                adminAuthTable = PluggableAuthorizationTableProxy.createInstance(ADMIN_CACHE_KEY);
                return adminAuthTable;
            }
        }
        if (!scm.isAdminAgent()) {
            currentStackEntry = SecurityObjectLocator.peekContext();
            if (currentStackEntry != null) {
                if (currentStackEntry.isAdmin()) {
                    if (isAdminAuthTableSet) {
                        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                            Tr.exit(tc, "getAuthorizationTableProxy returning admin PluggableAuthorizationTableProxy, ", adminAuthTable);
                        }
                        return adminAuthTable;
                    }
                    setAdminAuthTable = true;
                    setSomeAuthTable = true;
                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getAuthorizationTableProxy admin stack entry, admin PluggableAuthorizationTableProxy global null");
                    }
                } else if (currentStackEntry.isApplication()) {
                    if (isAppAuthTableSet) {
                        if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                            Tr.exit(tc, "getAuthorizationTableProxy returning application PluggableAuthorizationTableProxy and setting it in current stack entry, ", appAuthTable);
                        }
                        return appAuthTable;
                    }
                    setAppAuthTable = true;
                    setSomeAuthTable = true;
                    if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                        Tr.debug(tc, "getAuthorizationTableProxy application stack entry and application PluggableAuthorizationTableProxy global null");
                    }
                } else if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getAuthorizationTableProxy did not find valid type in current stack entry");
                }
            } else {
                if (isAdminAuthTableSet) {
                    if (SecurityConfigGlobals.enableVerbose && tc.isEntryEnabled()) {
                        Tr.exit(tc, "getAuthorizationTableProxy returning admin PluggableAuthorizationTableProxy, null stack entry", adminAuthTable);
                    }
                    return adminAuthTable;
                }
                setAdminAuthTable = true;
                setSomeAuthTable = true;
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getAuthorizationTableProxy null stack entry, admin PluggableAuthorizationTableProxy global null");
                }
            }
        }
        String domainId = null;
        domainId = currentStackEntry != null ? scm.getDomainId(currentStackEntry) : scm.getDomainId();
        if (domainId == null) {
            domainId = ADMIN_CACHE_KEY;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getAuthorizationTableProxy using domainId " + domainId);
        }
        if ((instance = _cache.get(domainId)) == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getAuthorizationTableProxy did not find PluggableAuthorizationTableProxy in cache");
            }
            Object object = lockObject;
            synchronized (object) {
                instance = _cache.get(domainId);
                if (instance == null && (instance = PluggableAuthorizationTableProxy.createInstance(domainId)) != null) {
                    _cache.put(domainId, instance);
                }
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getAuthorizationTableProxy found PluggableAuthorizationTableProxy in cache");
        }
        if (setSomeAuthTable) {
            if (setAdminAuthTable) {
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getAuthorizationTableProxy setting adminAuthTable global");
                }
                adminAuthTable = instance;
                isAdminAuthTableSet = true;
            } else if (setAppAuthTable) {
                if (SecurityConfigGlobals.enableVerbose && tc.isDebugEnabled()) {
                    Tr.debug(tc, "getAuthorizationTableProxy setting appAuthTable global");
                }
                appAuthTable = instance;
                isAppAuthTableSet = true;
            }
        }
        return instance;
    }

    private static PluggableAuthorizationTableProxy createInstance(String domainId) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createInstance, domainId=" + domainId);
        }
        PluggableAuthorizationTableProxy instance = null;
        SecurityConfig security2 = SecurityObjectLocator.getSecurityConfig();
        String authzTableName = security2.getProperty("com.ibm.websphere.security.authorizationTable");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Pluggable Authz Table name: " + authzTableName);
        }
        if (authzTableName != null && authzTableName.length() != 0) {
            try {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName(authzTableName);
                }
                catch (ClassNotFoundException cnfe) {
                    clazz = Class.forName(authzTableName, true, Thread.currentThread().getContextClassLoader());
                }
                Object authTable = clazz.newInstance();
                boolean isSAFAuthorization = "com.ibm.ws.security.zOS.authz.SAFAuthorizationTableImpl".equals(authzTableName);
                if (!isSAFAuthorization) {
                    Tr.audit(tc, "security.wsaccessmanager.classloaded", new Object[]{authzTableName});
                }
                instance = new PluggableAuthorizationTableProxy((AuthorizationTable)authTable, isSAFAuthorization);
                _cache.put(domainId, instance);
                security2.setBoolean("boolNativeAuthz", Boolean.FALSE);
            }
            catch (ClassNotFoundException cnfe) {
                FFDCFilter.processException(cnfe, "com.ibm.ws.security.core.WSAccessManager.WSAccessManager", "125");
                Tr.error(tc, "security.wsaccessmanager.classnotfound", new Object[]{authzTableName});
            }
            catch (InstantiationException ie) {
                FFDCFilter.processException(ie, "com.ibm.ws.security.core.WSAccessManager.WSAccessManager", "130");
                Tr.error(tc, "security.wsaccessmanager.instantiationerror", new Object[]{authzTableName});
            }
            catch (Exception e) {
                FFDCFilter.processException(e, "com.ibm.ws.security.core.WSAccessManager.WSAccessManager", "135");
                Tr.error(tc, "security.wsaccessmanager.classloading", new Object[]{authzTableName});
            }
            if (instance == null) {
                Tr.audit(tc, "security.wsaccessmanager.classloadingaudit", new Object[]{authzTableName});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createInstance", instance);
        }
        return instance;
    }

    private static void releaseByGetDomainId() {
        String domainId = scm.getDomainId();
        if (domainId == null) {
            domainId = ADMIN_CACHE_KEY;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "releaseByGetDomainId using domainId " + domainId);
        }
        _cache.remove(domainId);
    }

    public static void releaseInstance() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "releaseInstance");
        }
        if (scm == null) {
            return;
        }
        if (isSingleDomain) {
            scm = null;
            isSingleDomain = false;
            adminAuthTable = null;
            _cache.remove(ADMIN_CACHE_KEY);
        } else if (!scm.isAdminAgent()) {
            SecurityConfigResource currentStackEntry = SecurityObjectLocator.peekContext();
            if (currentStackEntry != null) {
                if (currentStackEntry.isAdmin()) {
                    adminAuthTable = null;
                    isAdminAuthTableSet = false;
                } else if (currentStackEntry.isApplication()) {
                    appAuthTable = null;
                    isAppAuthTableSet = false;
                }
            } else {
                adminAuthTable = null;
                isAdminAuthTableSet = false;
            }
            PluggableAuthorizationTableProxy.releaseByGetDomainId();
        } else {
            PluggableAuthorizationTableProxy.releaseByGetDomainId();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "releaseInstance");
        }
    }

    private PluggableAuthorizationTableProxy(AuthorizationTable table, boolean isSAFAuthorization) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "<init>", table);
        }
        this._authTable = table;
        this._cellName = SecurityObjectLocator.getAdminData().getString("cellname");
        this._serverName = SecurityObjectLocator.getAdminData().getString("shortservername");
        this._isSAFAuthorization = isSAFAuthorization;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "<init>", this);
        }
    }

    public boolean isSAFAuthorizationEnabled() {
        return this._isSAFAuthorization;
    }

    public AuthorizationTable getAuthorizationTable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAuthorizationTable");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAuthorizationTable", this._authTable);
        }
        return this._authTable;
    }

    public boolean isGrantedRole(AccessContext ctx, SecurityRole requiredRole, Subject subject) {
        HashMap accessContext = this.createAccessContext(ctx, subject);
        String role = requiredRole.getRoleName();
        return this.isGrantedRole(accessContext, role, subject);
    }

    public boolean isGrantedRole(HashMap accessContext, String role, Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedRole", new Object[]{accessContext, role, subject});
        }
        boolean isGranted = false;
        try {
            WSPrincipal principal = SubjectHelper.getPrincipalFromSubject(subject);
            accessContext = this.getAccessContext(accessContext, subject);
            isGranted = this._authTable.isGrantedRole(accessContext, role, principal);
        }
        catch (SecurityProviderException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.WSAccessManager.isGrantedRole", "215", this);
            Tr.error(tc, "security.wsaccessmanager.VendorAuthTableError", new Object[]{e});
            Exception e1 = e.getException();
            if (e1 != null) {
                Tr.error(tc, "security.wsaccessmanager.VendorAuthTableSpecificError", new Object[]{e1});
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.WSAccessManager.isGrantedRole", "224", this);
            Tr.error(tc, "security.wsaccessmanager.VendorAuthTableGenericError");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedRole", new Boolean(isGranted));
        }
        return isGranted;
    }

    public boolean isGrantedAnyRole(AccessContext ctx, SecurityRole[] requiredRoles, Subject subject) {
        HashMap accessContext = this.createAccessContext(ctx, subject);
        String[] roles = this.getRoleNamesFromRoles(requiredRoles);
        return this.isGrantedAnyRole(accessContext, roles, subject);
    }

    public boolean isGrantedAnyRole(HashMap accessContext, String[] roles, Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isGrantedAnyRole", new Object[]{accessContext, roles, subject});
        }
        boolean isGranted = false;
        try {
            WSPrincipal principal = SubjectHelper.getPrincipalFromSubject(subject);
            accessContext = this.getAccessContext(accessContext, subject);
            isGranted = this._authTable.isGrantedAnyRole(accessContext, roles, principal);
        }
        catch (SecurityProviderException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.WSAccessManager.isGrantedRole", "271", this);
            Tr.error(tc, "security.wsaccessmanager.VendorAuthTableError", new Object[]{e});
            Exception e1 = e.getException();
            if (e1 != null) {
                Tr.error(tc, "security.wsaccessmanager.VendorAuthTableSpecificError", new Object[]{e1});
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.WSAccessManager.isGrantedRole", "280", this);
            Tr.error(tc, "security.wsaccessmanager.VendorAuthTableGenericError");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isGrantedAnyRole", new Boolean(isGranted));
        }
        return isGranted;
    }

    public boolean isEveryoneGranted(AccessContext ctx, SecurityRole[] requiredRoles) {
        HashMap accessContext = this.createAccessContext(ctx, null);
        String[] roles = this.getRoleNamesFromRoles(requiredRoles);
        return this.isEveryoneGranted(accessContext, roles);
    }

    public boolean isEveryoneGranted(HashMap accessContext, String[] roles) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isEveryoneGranted", new Object[]{accessContext, roles});
        }
        boolean isGranted = false;
        try {
            isGranted = this._authTable.isEveryoneGranted(accessContext, roles);
        }
        catch (SecurityProviderException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.WSAccessManager.isGrantedRole", "323", this);
            Tr.error(tc, "security.wsaccessmanager.VendorAuthTableError", new Object[]{e});
            Exception e1 = e.getException();
            if (e1 != null) {
                Tr.error(tc, "security.wsaccessmanager.VendorAuthTableSpecificError", new Object[]{e1});
            }
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.core.WSAccessManager.isGrantedRole", "332", this);
            Tr.error(tc, "security.wsaccessmanager.VendorAuthTableGenericError");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isEveryoneGranted", new Boolean(isGranted));
        }
        return isGranted;
    }

    private HashMap createAccessContext(AccessContext ctx, Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createAccessContext", new Object[]{ctx, subject});
        }
        HashMap<String, Object> accessContext = new HashMap<String, Object>(4);
        accessContext.put("SERVER_NAME", this._serverName);
        accessContext.put("CELL_NAME", this._cellName);
        accessContext.put("APPLICATION_NAME", ctx.getEnterpriseAppName());
        if (this._isSAFAuthorization && subject != null) {
            accessContext.put(SUBJECT_KEY, subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createAccessContext", accessContext);
        }
        return accessContext;
    }

    private HashMap getAccessContext(HashMap context, Subject subject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAccessContext", new Object[]{context, subject});
        }
        HashMap accessContext = context;
        if (this._isSAFAuthorization && subject != null && context != null) {
            accessContext = (HashMap)context.clone();
            accessContext.put(SUBJECT_KEY, subject);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAccessContext", accessContext);
        }
        return accessContext;
    }

    private String[] getRoleNamesFromRoles(SecurityRole[] roles) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRoleNamesFromRoles", roles);
        }
        String[] names = roles != null ? new String[roles.length] : new String[]{};
        for (int i = 0; i < names.length; ++i) {
            names[i] = roles[i].getRoleName();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRoleNamesFromRoles", names);
        }
        return names;
    }
}

