/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.os400;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.config.SecurityObjectLocator;
import com.ibm.ws.security.registry.os400.OS400RegistryException;
import com.ibm.ws.security.util.RegExp;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class OS400RegistryImpl
implements UserRegistry {
    private static TraceComponent tc;
    private String realm;
    private String typeRealm = "";
    private boolean longPasswordEnabled = false;
    int maxUidSize = -1;
    int maxPWSize = -1;

    private native String[] ntv_getUsers(String var1, boolean var2) throws OS400RegistryException;

    private native String[] ntv_getGroupsForUser(String var1) throws OS400RegistryException;

    private native boolean ntv_isValid(String var1, boolean var2) throws OS400RegistryException;

    private native void ntv_authenticate(String var1, String var2) throws OS400RegistryException;

    private native String ntv_getDisplayName(String var1, boolean var2) throws OS400RegistryException;

    private native String[] ntv_getUsersForGroup(String var1) throws OS400RegistryException;

    private native boolean ntv_isLongPasswordEnabled() throws OS400RegistryException;

    public String checkPassword(String userId, String password) throws PasswordCheckFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkPassword");
        }
        if (userId.length() > this.getMaxUidSize() || password.length() > this.getMaxPWSize()) {
            Tr.error(tc, "security.registry.checkpass.failed", new Object[]{userId});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkPassword");
            }
            throw new PasswordCheckFailedException("checkPassword failed due to userid length (" + userId.length() + ") and/or password length " + password.length() + ") too large.");
        }
        String securityName = userId.toUpperCase();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Checking password for user '" + securityName + "'.");
        }
        String pwd = password.trim();
        password = null;
        try {
            if (pwd.length() == 0) {
                PasswordCheckFailedException ex = new PasswordCheckFailedException("Authentication failed for user: " + userId + " Password has zero length");
                Tr.error(tc, "security.authn.failed.foruser", new Object[]{userId, ex});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkPassword", ex);
                }
                throw ex;
            }
            if (pwd.startsWith("*")) {
                PasswordCheckFailedException ex = new PasswordCheckFailedException("Authentication failed for user: " + userId + " Password begins with *");
                Tr.error(tc, "security.authn.failed.foruser", new Object[]{userId, ex});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "checkPassword", ex);
                }
                throw ex;
            }
            if (!this.longPasswordEnabled) {
                pwd = pwd.toUpperCase();
            }
            this.ntv_authenticate(securityName, pwd);
            pwd = null;
        }
        catch (OS400RegistryException e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.checkPassword", "191", this);
            this.logErrorCode(e);
            PasswordCheckFailedException ex = null;
            switch (e.getErrorCode()) {
                case 6: {
                    ex = new PasswordCheckFailedException("Authentication failed for user: " + userId + " userID/password does not exist in the registry");
                    Tr.error(tc, "security.authn.failed.foruser", new Object[]{userId, ex});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkPassword", ex);
                    }
                    throw ex;
                }
                case 0: 
                case 1: 
                case 2: {
                    Tr.error(tc, "security.authn.error", new Object[]{userId, e});
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkPassword", e);
                    }
                    throw new CustomRegistryException(this.typeRealm + ": " + userId + ", " + e.getMessage());
                }
            }
            ex = new PasswordCheckFailedException("Authentication failed for user: " + userId + " Profile error occurred, error code: " + String.valueOf(e.getErrorCode()));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Profile error: " + this.typeRealm + ": " + userId + ", " + e.getMessage());
                Tr.debug(tc, "Error code: " + String.valueOf(e.getErrorCode()));
            }
            Tr.error(tc, "security.authn.failed.foruser", new Object[]{userId, ex});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkPassword", ex);
            }
            throw ex;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.checkPassword", "242", this);
            Tr.error(tc, "security.authn.error", new Object[]{userId, e});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkPassword", e);
            }
            throw new CustomRegistryException(e.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkPassword");
        }
        return userId;
    }

    public String mapCertificate(X509Certificate[] cert) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapCertificate");
        }
        CertificateMapNotSupportedException ex = new CertificateMapNotSupportedException("");
        Tr.error(tc, "security.registry.mapcertificate.notsupported");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapCertificate", ex);
        }
        throw ex;
    }

    public String getRealm() throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealm");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealm", this.realm);
        }
        return this.realm;
    }

    public String getGroupDisplayName(String groupName) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupDisplayName");
        }
        StringBuffer td = new StringBuffer(groupName.toUpperCase());
        td.append(": ");
        try {
            td.append(this.ntv_getDisplayName(groupName.toUpperCase(), true));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Display name for '" + groupName + "': " + td);
            }
        }
        catch (OS400RegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.getGroupDisplayName", "337", this);
            this.logErrorCode(ex);
            Tr.error(tc, "security.registry.groupdisplayname.error", new Object[]{groupName, ex});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupDisplayName", ex);
            }
            this.throwException(ex, groupName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupDisplayName");
        }
        return td.toString();
    }

    public String getUniqueGroupId(String groupName) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupId");
        }
        if (!this.isValidGroup(groupName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Group name not found: " + groupName);
            }
            EntryNotFoundException ex = new EntryNotFoundException(groupName);
            Tr.error(tc, "security.registry.uniquegrpid.error", new Object[]{groupName, ex});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUniqueGroupId", ex);
            }
            throw ex;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueGroupId", groupName.toUpperCase());
        }
        return groupName.toUpperCase();
    }

    public List getUniqueGroupIds(String uniqueUserId) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupIds");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueGroupIds");
        }
        return this.getGroupsForUser(uniqueUserId);
    }

    public Enumeration getGroups(String pattern) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups(String)");
        }
        String[] groups = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pattern: " + pattern);
            }
            groups = this.ntv_getUsers("*ALL", true);
            this.filterArray(groups, pattern.toUpperCase());
        }
        catch (OS400RegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.getGroups", "453", this);
            this.logErrorCode(ex);
            Tr.error(tc, "security.registry.getgroups.error", new Object[]{pattern, ex});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups(String)", ex);
            }
            throw new CustomRegistryException(this.typeRealm + ": " + String.valueOf(ex.getErrorCode()) + ", " + ex.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroups(String)");
        }
        return this.arrayToEnumeration(groups);
    }

    public Result getGroups(String pattern, int limit) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups", new StringBuffer(pattern).append(":").append(limit).toString());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Limit is " + limit);
        }
        int count = 0;
        Result result = new Result();
        if (limit < 0) {
            ArrayList noGroups = new ArrayList(0);
            result.setList(noGroups);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No groups searched as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups", new StringBuffer(pattern).append(":").append(limit).toString());
            }
            return result;
        }
        Enumeration e = this.getGroups(pattern);
        if (e == null) {
            ArrayList noGroups = new ArrayList(0);
            result.setList(noGroups);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no groups found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups", new StringBuffer(pattern).append(":").append(limit).toString());
            }
            return result;
        }
        ArrayList groups = new ArrayList();
        if (limit != 0) {
            groups = new ArrayList(limit);
        }
        while (e.hasMoreElements()) {
            groups.add(e.nextElement());
            if (limit == 0 || ++count != limit) continue;
        }
        result.setList(groups);
        if (e.hasMoreElements()) {
            result.setHasMore();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroups", new StringBuffer(pattern).append(":").append(limit).toString());
        }
        return result;
    }

    public List getGroupsForUser(String userName, int limit) throws EntryNotFoundException, CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupsForUser");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Limit is " + limit);
        }
        int count = 0;
        String[] groups = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieving groups for: " + userName);
            }
            groups = this.ntv_getGroupsForUser(userName.toUpperCase());
        }
        catch (OS400RegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.getGroupsForUser", "529", this);
            this.logErrorCode(ex);
            Tr.error(tc, "security.registry.getgrpsforuser.error", new Object[]{userName, ex});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupsForUser", ex);
            }
            this.throwException(ex, userName);
        }
        if (groups.length == 1 && groups[0].equals("*NONE")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No groups for user '" + userName + "'found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupsForUser");
            }
            return new ArrayList(0);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Groups for user '" + userName + "':");
        }
        ArrayList<String> grpList = new ArrayList<String>(limit);
        for (int i = 0; i < groups.length && count++ < limit; ++i) {
            grpList.add(groups[i]);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, groups[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupsForUser");
        }
        return grpList;
    }

    public String getGroupSecurityName(String privilegeAttributeId) throws CustomRegistryException, EntryNotFoundException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupSecurityName");
        }
        if (!this.isValidGroup(privilegeAttributeId)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Group name not found: " + privilegeAttributeId);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupSecurityName");
            }
            throw new EntryNotFoundException(privilegeAttributeId);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Group name found: " + privilegeAttributeId);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupSecurityName");
        }
        return privilegeAttributeId.toUpperCase();
    }

    public String getUserDisplayName(String securityName) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserDisplayName");
        }
        StringBuffer td = new StringBuffer(securityName.toUpperCase());
        td.append(": ");
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Display name for '" + securityName + "': " + td);
            }
            td.append(this.ntv_getDisplayName(securityName.toUpperCase(), false));
        }
        catch (OS400RegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.getUserDisplayName", "637", this);
            this.logErrorCode(ex);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Unable to get display name for '" + securityName + "'.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUserDisplayName");
            }
            this.throwException(ex, securityName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserDisplayName");
        }
        return td.toString();
    }

    public String getUniqueUserId(String securityName) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueUserId", securityName);
        }
        if (!this.isValidUser(securityName)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "User name not found: " + securityName);
            }
            EntryNotFoundException ex = new EntryNotFoundException(securityName);
            Tr.error(tc, "security.registry.uniqueusrid.notfound", new Object[]{securityName});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUniqueUserId", ex);
            }
            throw ex;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "User name found: " + securityName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueUserId", securityName.toUpperCase());
        }
        return securityName.toUpperCase();
    }

    public Enumeration getUsers() throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers");
        }
        String[] users = null;
        try {
            users = this.ntv_getUsers("*ALL", false);
        }
        catch (OS400RegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.getUserDisplayName", "711", this);
            this.logErrorCode(ex);
            Tr.error(tc, "security.registry.getusers.error", new Object[]{"*", ex});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsers", ex);
            }
            throw new CustomRegistryException(this.typeRealm + ": " + String.valueOf(ex.getErrorCode()) + ", " + ex.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers");
        }
        return this.arrayToEnumeration(users);
    }

    public Enumeration getUsers(String pattern) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers(String)");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Pattern: " + pattern);
        }
        String[] users = null;
        try {
            users = this.ntv_getUsers("*ALL", false);
            this.filterArray(users, pattern.toUpperCase());
        }
        catch (OS400RegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.getUserDisplayName", "756", this);
            this.logErrorCode(ex);
            Tr.error(tc, "security.registry.getusers.error", new Object[]{pattern, ex});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsers(String)", ex);
            }
            throw new CustomRegistryException(this.typeRealm + ": " + String.valueOf(ex.getErrorCode()) + ", " + ex.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers(String)");
        }
        return this.arrayToEnumeration(users);
    }

    public Result getUsers(String pattern, int limit) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers", new StringBuffer(pattern).append(":").append(limit).toString());
        }
        int count = 0;
        Result result = new Result();
        if (limit < 0) {
            ArrayList noUsers = new ArrayList(0);
            result.setList(noUsers);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No users searched as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsers", new StringBuffer(pattern).append(":").append(limit).toString());
            }
            return result;
        }
        Enumeration e = this.getUsers(pattern);
        if (e == null) {
            ArrayList noUsers = new ArrayList(0);
            result.setList(noUsers);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No users found.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsers", new StringBuffer(pattern).append(":").append(limit).toString());
            }
            return result;
        }
        ArrayList users = new ArrayList();
        if (limit != 0) {
            users = new ArrayList(limit);
        }
        while (e.hasMoreElements() && (limit == 0 || count++ < limit)) {
            users.add(e.nextElement());
        }
        result.setList(users);
        if (e.hasMoreElements()) {
            result.setHasMore();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers", new StringBuffer(pattern).append(":").append(limit).toString());
        }
        return result;
    }

    public Result getUsersForGroup(String groupName, int limit) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsersForGroup", groupName);
        }
        Result result = new Result();
        if (limit < 0) {
            ArrayList noUsers = new ArrayList(0);
            result.setList(noUsers);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No groups searched for users as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsersForGroup");
            }
            return result;
        }
        String[] users = null;
        int count = 0;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieving users for: " + groupName);
            }
            users = this.ntv_getUsersForGroup(groupName.toUpperCase());
        }
        catch (OS400RegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.getUserDisplayName", "828", this);
            this.logErrorCode(ex);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error occurred: " + String.valueOf(ex.getErrorCode()) + ", " + ex.getMessage());
            }
            Tr.error(tc, "security.registry.getusrsforgrp.error", new Object[]{groupName, ex});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsersForGroup", ex);
            }
            this.throwException(ex, groupName);
        }
        if (users.length == 1 && users[0].equals("*NONE")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No users for group '" + groupName + "'found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsersForGroup");
            }
            result.setList(new ArrayList(0));
            return result;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Users for group '" + groupName + "':");
        }
        ArrayList<String> userList = new ArrayList<String>();
        if (limit != 0) {
            userList = new ArrayList(limit);
        }
        for (int i = 0; i < users.length && (limit == 0 || count++ < limit); ++i) {
            userList.add(users[i]);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, users[i]);
        }
        result.setList(userList);
        if (users.length > limit) {
            result.setHasMore();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsersForGroup");
        }
        return result;
    }

    public String getUserSecurityName(String privilegeAttributeId) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserSecurityName");
        }
        if (!this.isValidUser(privilegeAttributeId)) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "User name not found: " + privilegeAttributeId);
            }
            EntryNotFoundException ex = new EntryNotFoundException(privilegeAttributeId);
            Tr.error(tc, "security.registry.usersecurityname.error", new Object[]{privilegeAttributeId, ex});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUserSecurityName", ex);
            }
            throw ex;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "User name found: " + privilegeAttributeId);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserSecurityName");
        }
        return privilegeAttributeId.toUpperCase();
    }

    public void initialize(Properties props) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initialize");
        }
        try {
            this.realm = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.initialize", "929", this);
            try {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to get host name.");
                }
                this.realm = InetAddress.getLocalHost().toString();
            }
            catch (UnknownHostException exc) {
                FFDCFilter.processException((Throwable)exc, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.initialize", "952", this);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Unable to get host name or IP address.");
                }
                this.realm = "UNKNOWN";
            }
        }
        this.typeRealm = this.typeRealm + "[" + this.realm + "]";
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "OS400RegistryImpl type and realm: " + this.typeRealm + ".");
        }
        try {
            this.longPasswordEnabled = this.ntv_isLongPasswordEnabled();
        }
        catch (OS400RegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.initialize", "972", this);
            this.logErrorCode(ex);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Error occurred: " + String.valueOf(ex.getErrorCode()) + ", " + ex.getMessage());
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initialize");
            }
            throw new CustomRegistryException(this.typeRealm + ": " + String.valueOf(ex.getErrorCode()) + ", " + ex.getMessage());
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "OS400RegistryImpl longPasswordEnabled: " + this.longPasswordEnabled + ".");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize");
        }
    }

    public boolean isValidGroup(String securityName) throws CustomRegistryException {
        boolean bl;
        block8: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isValidGroup");
            }
            if (securityName != null && !securityName.equals("")) break block8;
            boolean bl2 = false;
            Object var4_5 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidGroup");
            }
            return bl2;
        }
        try {
            bl = this.ntv_isValid(securityName.toUpperCase(), true);
            Object var4_6 = null;
        }
        catch (OS400RegistryException ex) {
            try {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.initialize", "1013", this);
                this.logErrorCode(ex);
                Tr.error(tc, "security.registry.isvalidgroup.error", new Object[]{securityName, ex});
                throw new CustomRegistryException(this.typeRealm + ": " + String.valueOf(ex.getErrorCode()) + ", " + ex.getMessage());
            }
            catch (Throwable throwable) {
                block9: {
                    Object var4_7 = null;
                    if (!tc.isEntryEnabled()) break block9;
                    Tr.exit(tc, "isValidGroup");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidGroup");
        }
        return bl;
    }

    public boolean isValidUser(String securityName) throws CustomRegistryException {
        boolean bl;
        block10: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "isValidUser");
            }
            if (securityName != null && !securityName.equals("")) break block10;
            boolean bl2 = false;
            Object var4_5 = null;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidUser");
            }
            return bl2;
        }
        try {
            bl = this.ntv_isValid(securityName.toUpperCase(), false);
            Object var4_6 = null;
        }
        catch (OS400RegistryException ex) {
            try {
                FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.initialize", "1055", this);
                this.logErrorCode(ex);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Error occurred: " + String.valueOf(ex.getErrorCode()) + ", " + ex.getMessage());
                }
                Tr.error(tc, "security.registry.isvaliduser.error", new Object[]{securityName, ex});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isValidUser", ex);
                }
                throw new CustomRegistryException(this.typeRealm + ": " + String.valueOf(ex.getErrorCode()) + ", " + ex.getMessage());
            }
            catch (Throwable throwable) {
                block11: {
                    Object var4_7 = null;
                    if (!tc.isEntryEnabled()) break block11;
                    Tr.exit(tc, "isValidUser");
                }
                throw throwable;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidUser");
        }
        return bl;
    }

    public WSCredential createCredential(String name) throws CustomRegistryException, NotImplementedException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCredential", name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCredential", name);
        }
        return null;
    }

    public List getGroupsForUser(String securityName) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupsForUser", securityName);
        }
        String[] groups = null;
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Retrieving groups for: " + securityName);
            }
            groups = this.ntv_getGroupsForUser(securityName.toUpperCase());
        }
        catch (OS400RegistryException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.getGroupsForUser", "1175", this);
            this.logErrorCode(ex);
            Tr.error(tc, "security.registry.getgrpsforuser.error", new Object[]{securityName, ex});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupsForUser", ex);
            }
            this.throwException(ex, securityName);
        }
        if (groups.length == 1 && groups[0].trim().equals("*NONE")) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No groups for user '" + securityName + "'found");
            }
            return new ArrayList(0);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Groups for user '" + securityName + "':");
        }
        ArrayList<String> grps = new ArrayList<String>(groups.length);
        for (int i = 0; i < groups.length; ++i) {
            grps.add(groups[i]);
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, groups[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupsForUser");
        }
        return grps;
    }

    private Enumeration arrayToEnumeration(String[] array) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "arrayToEnumeration");
        }
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "element[" + String.valueOf(i) + "]: " + array[i]);
                }
                v.addElement(array[i]);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "element[" + String.valueOf(i) + "]: null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "arrayToEnumeration");
        }
        return v.elements();
    }

    private void filterArray(String[] array, String pattern) {
        RegExp filter;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "filterArray");
        }
        try {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Pattern: " + pattern);
            }
            filter = new RegExp(pattern);
        }
        catch (IllegalArgumentException ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.os400.OS400RegistryImpl.filterArray", "1184", this);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "IllegalArgumentException: " + ex.getMessage());
            }
            for (int i = 0; i < array.length; ++i) {
                array[i] = null;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "filterArray");
            }
            return;
        }
        for (int i = 0; i < array.length; ++i) {
            if (!filter.match(array[i])) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Not a match: " + array[i]);
                }
                array[i] = null;
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "A match: " + array[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "filterArray");
        }
    }

    private void throwException(OS400RegistryException ex, String name) throws CustomRegistryException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "throwException");
        }
        switch (ex.getErrorCode()) {
            case 0: 
            case 1: 
            case 2: {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "throwException");
                }
                throw new CustomRegistryException(this.typeRealm + ": " + String.valueOf(ex.getErrorCode()) + ", " + ex.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "throwException");
        }
        throw new EntryNotFoundException(this.typeRealm + ": " + name + ", " + ex.getMessage());
    }

    private int getMaxUidSize() {
        if (this.maxUidSize == -1) {
            String maxUidString = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.websphere.security.registry.maxUseridSize");
            this.maxUidSize = maxUidString != null ? Integer.parseInt(maxUidString) : Integer.parseInt("256");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getMaxUidSize: " + this.maxUidSize);
            }
        }
        return this.maxUidSize;
    }

    private int getMaxPWSize() {
        if (this.maxPWSize == -1) {
            String maxPWString = SecurityObjectLocator.getSecurityConfig().getProperty("com.ibm.websphere.security.registry.maxPasswordSize");
            this.maxPWSize = maxPWString != null ? Integer.parseInt(maxPWString) : Integer.parseInt("256");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getMaxPWSize: " + this.maxPWSize);
            }
        }
        return this.maxPWSize;
    }

    private void logErrorCode(OS400RegistryException re2) {
        StringBuffer sb = new StringBuffer("Native error code = ");
        sb.append(re2.getErrorCode());
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, sb.toString());
        }
    }

    static {
        String lib = System.getProperty("was.install.library");
        System.load("/QSYS.LIB/" + lib + ".LIB/QWASUREG.SRVPGM");
        tc = Tr.register(OS400RegistryImpl.class, null, "com.ibm.ejs.resources.security");
    }
}

