/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.nt;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.security.CertificateMapFailedException;
import com.ibm.websphere.security.CertificateMapNotSupportedException;
import com.ibm.websphere.security.CustomRegistryException;
import com.ibm.websphere.security.EntryNotFoundException;
import com.ibm.websphere.security.NotImplementedException;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.websphere.security.UserRegistry;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.cred.WSCredential;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.registry.RegistryErrorException;
import com.ibm.ws.security.registry.nt.GroupEnumeration;
import com.ibm.ws.security.registry.nt.MultiEnumeration;
import com.ibm.ws.security.registry.nt.NTRegistryImpl;
import com.ibm.ws.security.registry.nt.UserEnumeration;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;

public class NTLocalDomainRegistryImpl
implements UserRegistry {
    private static TraceComponent tc = Tr.register(NTLocalDomainRegistryImpl.class, null, "com.ibm.ejs.resources.security");
    private NTRegistryImpl[] registries;
    private static final String realmSeparator = "/";
    private static final String typeSeparator = ":";
    private boolean isLocalOrDomain = false;
    private String realm;

    public String checkPassword(String userId, String passwd) throws PasswordCheckFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkPassword");
        }
        String name = null;
        NTRegistryImpl ntreg = this.getRegistryForRealm(userId);
        if (ntreg != null) {
            name = ntreg.checkPassword(this.stripRealm(userId), passwd);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkPassword", name);
            }
            return name;
        }
        PasswordCheckFailedException caughtException = null;
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                name = this.registries[i].checkPassword(userId, passwd);
            }
            catch (PasswordCheckFailedException ex) {
                caughtException = ex;
            }
            if (name == null) continue;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkPassword", name);
            }
            return name;
        }
        if (caughtException != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "checkPassword", caughtException);
            }
            FFDCFilter.processException((Throwable)caughtException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.checkPassword", "83", this);
            throw caughtException;
        }
        Tr.error(tc, "security.authn.failed.foruser", new Object[]{name});
        throw new CustomRegistryException("Authentication failed for user" + name);
    }

    public String mapCertificate(X509Certificate[] cert) throws CertificateMapNotSupportedException, CertificateMapFailedException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "mapCertificate");
        }
        CertificateMapNotSupportedException ex = new CertificateMapNotSupportedException("Certificate mapping not supported");
        Tr.error(tc, "security.registry.mapcertificate.notsupported");
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mapCertificate", ex);
        }
        throw ex;
    }

    public String getGroupDisplayName(String securityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupDisplayName", securityName);
        }
        String displayName = null;
        NTRegistryImpl ntreg = this.getRegistryForRealm(securityName);
        WSSecurityException caughtException = null;
        if (ntreg != null) {
            displayName = ntreg.getGroupDisplayName(securityName);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroupDisplayName", displayName);
            }
            return displayName;
        }
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                displayName = this.registries[i].getGroupDisplayName(securityName);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getGroupDisplayName", displayName);
                }
                return displayName;
            }
            catch (CustomRegistryException rex) {
                caughtException = rex;
                continue;
            }
            catch (EntryNotFoundException ex) {
                caughtException = ex;
            }
        }
        if (caughtException != null) {
            if (caughtException instanceof EntryNotFoundException) {
                FFDCFilter.processException((Throwable)caughtException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getGroupDisplayName", "151", this);
                Tr.error(tc, "security.registry.groupdisplayname.error", new Object[]{securityName, caughtException});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getGroupDisplayName", caughtException);
                }
                throw (EntryNotFoundException)caughtException;
            }
            if (caughtException instanceof CustomRegistryException) {
                FFDCFilter.processException((Throwable)caughtException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getGroupDisplayName", "157", this);
                Tr.error(tc, "security.registry.groupdisplayname.error", new Object[]{securityName, caughtException});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getGroupDisplayName", caughtException);
                }
                throw caughtException;
            }
        }
        Tr.error(tc, "security.registry.groupdisplayname.notfound", new Object[]{securityName});
        throw new CustomRegistryException("Could not obtain groupDisplayName for group: " + securityName);
    }

    public String getUniqueGroupId(String securityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupId", securityName);
        }
        NTRegistryImpl ntreg = this.getRegistryForRealm(securityName);
        String uid = null;
        if (ntreg != null) {
            uid = ntreg.getUniqueGroupId(this.stripRealm(securityName));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUniqueGroupId", uid);
            }
            return uid;
        }
        WSSecurityException caughtException = null;
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                uid = this.registries[i].getUniqueGroupId(securityName);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUniqueGroupId", uid);
                }
                return uid;
            }
            catch (CustomRegistryException rex) {
                caughtException = rex;
                continue;
            }
            catch (EntryNotFoundException ex) {
                caughtException = ex;
            }
        }
        if (caughtException != null) {
            if (caughtException instanceof EntryNotFoundException) {
                FFDCFilter.processException((Throwable)caughtException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUniqueGroupId", "208", this);
                Tr.error(tc, "security.registry.uniquegrpid.notfound", new Object[]{securityName});
                throw (EntryNotFoundException)caughtException;
            }
            if (caughtException instanceof CustomRegistryException) {
                FFDCFilter.processException((Throwable)caughtException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUniqueGroupId", "214", this);
                Tr.error(tc, "security.registry.uniquegrpid.notfound", new Object[]{securityName});
                throw caughtException;
            }
        }
        Tr.error(tc, "security.registry.uniquegrpid.notfound", new Object[]{securityName});
        throw new CustomRegistryException();
    }

    public Result getGroups(String pattern, int limit) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups", new StringBuffer(pattern).append(typeSeparator).append(limit).toString());
        }
        Result result = new Result();
        int count = 0;
        if (limit < 0) {
            ArrayList noGroups = new ArrayList(0);
            result.setList(noGroups);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No groups searched as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups", new StringBuffer(pattern).append(typeSeparator).append(limit).toString());
            }
            return result;
        }
        Enumeration e = this.getGroups(pattern);
        if (e == null) {
            ArrayList noGroups = new ArrayList(0);
            result.setList(noGroups);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "no groups found");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups", new StringBuffer(pattern).append(typeSeparator).append(limit).toString());
            }
            return result;
        }
        ArrayList groups = new ArrayList();
        if (limit != 0) {
            groups = new ArrayList(limit);
        }
        while (e.hasMoreElements()) {
            groups.add(e.nextElement());
            if (limit == 0 || ++count != limit) continue;
        }
        result.setList(groups);
        if (e.hasMoreElements()) {
            result.setHasMore();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroups", new StringBuffer(pattern).append(typeSeparator).append(limit).toString());
        }
        return result;
    }

    public Enumeration getGroups(String pattern) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroups", pattern);
        }
        try {
            Enumeration[] groups = new Enumeration[this.registries.length];
            if (pattern.indexOf("\\") == -1) {
                pattern = "*\\\\" + pattern;
            } else {
                int index = pattern.indexOf("\\");
                StringBuffer sb = new StringBuffer(pattern);
                pattern = sb.insert(index, "\\").toString();
            }
            for (int i = 0; i < this.registries.length; ++i) {
                groups[i] = new GroupEnumeration(this.registries[i], pattern, true);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups");
            }
            return new MultiEnumeration(groups);
        }
        catch (Exception ex) {
            FFDCFilter.processException((Throwable)ex, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getGroups", "265", this);
            Tr.error(tc, "security.registry.getgroups.error", new Object[]{pattern, ex});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getGroups");
            }
            throw new CustomRegistryException(ex.getMessage());
        }
    }

    public List getGroupsForUser(String userName) throws EntryNotFoundException, CustomRegistryException {
        String[] grps;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupsForUser", userName);
        }
        if ((grps = this.getGroupsForUser1(userName)) == null || grps.length == 0) {
            return new ArrayList(0);
        }
        ArrayList<String> groups = new ArrayList<String>();
        for (int i = 0; i < grps.length; ++i) {
            groups.add(grps[i]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Number of groups returned = " + groups.size());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupsForUser", userName);
        }
        return groups;
    }

    public String[] getGroupsForUser1(String securityName) throws EntryNotFoundException, CustomRegistryException {
        NTRegistryImpl ntreg;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupsForUser1", securityName);
        }
        if ((ntreg = this.getRegistryForRealm(securityName)) != null) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getGroupsForUser1", securityName);
            }
            return ntreg.getGroupsForUser(this.stripRealm(securityName));
        }
        WSSecurityException caughtException = null;
        String[] groups = new String[]{};
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                String[] newgroups = this.registries[i].getGroupsForUser(securityName);
                String[] t = new String[newgroups.length + groups.length];
                System.arraycopy(groups, 0, t, 0, groups.length);
                System.arraycopy(newgroups, 0, t, groups.length, newgroups.length);
                groups = t;
                continue;
            }
            catch (CustomRegistryException rex) {
                caughtException = rex;
                continue;
            }
            catch (EntryNotFoundException ex) {
                caughtException = ex;
            }
        }
        if (groups.length <= 0 && caughtException != null) {
            if (caughtException instanceof EntryNotFoundException) {
                FFDCFilter.processException((Throwable)caughtException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getGroupsForUser1", "362", this);
                Tr.error(tc, "security.registry.getgrpsforuser.error", new Object[]{securityName, caughtException});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getGroupsForUser1", caughtException);
                }
                throw (EntryNotFoundException)caughtException;
            }
            if (caughtException instanceof CustomRegistryException) {
                FFDCFilter.processException((Throwable)caughtException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getGroupsForUser1", "368", this);
                Tr.error(tc, "security.registry.getgrpsforuser.error", new Object[]{securityName, caughtException});
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getGroupsForUser1", caughtException);
                }
                throw caughtException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupsForUser1");
        }
        return groups;
    }

    public Result getUsersForGroup(String groupName, int limit) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsersForGroup");
        }
        int count = 0;
        Result result = new Result();
        if (limit < 0) {
            ArrayList noUsers = new ArrayList(0);
            result.setList(noUsers);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No groups searched for users as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsersForGroup");
            }
            return result;
        }
        ArrayList<String> users = new ArrayList<String>();
        if (limit != 0 && limit < Integer.MAX_VALUE) {
            users = new ArrayList(limit + 1);
        } else if (limit == Integer.MAX_VALUE) {
            users = new ArrayList(limit);
        }
        int index = groupName.indexOf("\\");
        try {
            Enumeration eUsers = this.getUsers();
            block2: while (eUsers.hasMoreElements()) {
                String user = (String)eUsers.nextElement();
                List groups = this.getGroupsForUser(user);
                if (groups == null || groups.size() <= 0) continue;
                for (int i = 0; i < groups.size(); ++i) {
                    String grpName = (String)groups.get(i);
                    int index1 = grpName.indexOf("\\");
                    if (index == -1 && index1 != -1) {
                        grpName = grpName.substring(index1 + 1);
                    }
                    if (!grpName.equals(groupName)) continue;
                    int index2 = user.indexOf("\\");
                    user = user.substring(index2 + 1);
                    users.add(user);
                    if (limit >= Integer.MAX_VALUE || limit == 0 || ++count != limit + 1) continue;
                    result.setHasMore();
                    users.remove(user);
                    continue block2;
                }
            }
            result.setList(users);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsersForGroup");
            }
            return result;
        }
        catch (RegistryErrorException re2) {
            FFDCFilter.processException((Throwable)re2, "com.ibm.ws.security.registry.unix.NTLocalDomainRegistryImpl.getUsersForGroup", "388", this);
            Tr.error(tc, "security.registry.getusrsforgrp.error", new Object[]{groupName, re2});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsersForGroup", re2);
            }
            throw new CustomRegistryException(re2.getMessage());
        }
    }

    public String getGroupSecurityName(String privilegeAttributeId) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupSecurityName", privilegeAttributeId);
        }
        WSSecurityException caughtException = null;
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                String securityName = this.registries[i].getGroupSecurityName(privilegeAttributeId);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getGroupSecurityName", securityName);
                }
                return securityName;
            }
            catch (CustomRegistryException cre) {
                caughtException = cre;
                continue;
            }
            catch (EntryNotFoundException ex) {
                caughtException = ex;
            }
        }
        if (caughtException != null) {
            if (caughtException instanceof EntryNotFoundException) {
                FFDCFilter.processException((Throwable)caughtException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getGroupSecurityName", "461", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getGroupSecurityName");
                }
                Tr.error(tc, "security.registry.nosecurityname", new Object[]{privilegeAttributeId, caughtException});
                throw (EntryNotFoundException)caughtException;
            }
            if (caughtException instanceof CustomRegistryException) {
                FFDCFilter.processException((Throwable)caughtException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getGroupSecurityName", "467", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getGroupSecurityName");
                }
                Tr.error(tc, "security.registry.nosecurityname", new Object[]{privilegeAttributeId, caughtException});
                throw caughtException;
            }
        }
        Tr.error(tc, "security.registry.groupsecurityname.notfound", new Object[]{privilegeAttributeId});
        throw new CustomRegistryException("Could not get the groupSecurityName for group whose uniqueId is : " + privilegeAttributeId);
    }

    public String getUserDisplayName(String securityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserDisplayName", securityName);
        }
        NTRegistryImpl ntreg = this.getRegistryForRealm(securityName);
        String displayName = null;
        if (ntreg != null) {
            displayName = ntreg.getUserDisplayName(this.stripRealm(securityName));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUserDisplayName", displayName);
            }
            return displayName;
        }
        WSSecurityException caughtException = null;
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                displayName = this.registries[i].getUserDisplayName(securityName);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUserDisplayName", displayName);
                }
                return displayName;
            }
            catch (CustomRegistryException cre) {
                caughtException = cre;
                continue;
            }
            catch (EntryNotFoundException ex) {
                caughtException = ex;
            }
        }
        if (caughtException != null) {
            if (caughtException instanceof EntryNotFoundException) {
                FFDCFilter.processException((Throwable)caughtException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUserDisplayName", "516", this);
                Tr.error(tc, "security.registry.userdisplayname.error", new Object[]{securityName, caughtException});
                throw (EntryNotFoundException)caughtException;
            }
            if (caughtException instanceof CustomRegistryException) {
                FFDCFilter.processException((Throwable)caughtException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUserDisplayName", "522", this);
                Tr.error(tc, "security.registry.userdisplayname.error", new Object[]{securityName, caughtException});
                throw caughtException;
            }
        }
        Tr.error(tc, "security.registry.userdisplayname.notfound", new Object[]{securityName});
        throw new CustomRegistryException("Cannot get DisplayName for user: " + securityName);
    }

    public String getUniqueUserId(String securityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueUserId", securityName);
        }
        NTRegistryImpl ntreg = this.getRegistryForRealm(securityName);
        String uid = null;
        if (ntreg != null) {
            uid = ntreg.getUniqueUserId(this.stripRealm(securityName));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUniqueUserId", uid);
            }
            return uid;
        }
        WSSecurityException caughtException = null;
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                String attributeId = this.registries[i].getUniqueUserId(securityName);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUniqueUserId");
                }
                return attributeId;
            }
            catch (CustomRegistryException cre) {
                caughtException = cre;
                continue;
            }
            catch (EntryNotFoundException ex) {
                caughtException = ex;
            }
        }
        if (caughtException != null) {
            if (caughtException instanceof EntryNotFoundException) {
                FFDCFilter.processException((Throwable)caughtException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUniqueUserId", "568", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUniqueUserId", securityName);
                }
                Tr.error(tc, "security.registry.uniqueusrid.notfound", new Object[]{securityName});
                throw (EntryNotFoundException)caughtException;
            }
            if (caughtException instanceof CustomRegistryException) {
                FFDCFilter.processException((Throwable)caughtException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUniqueUserId", "574", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUniqueUserId", securityName);
                }
                Tr.error(tc, "security.registry.uniqueusrid.notfound", new Object[]{securityName});
                throw caughtException;
            }
        }
        Tr.error(tc, "security.registry.uniqueusrid.notfound", new Object[]{securityName});
        throw new CustomRegistryException();
    }

    public Result getUsers(String pattern, int limit) throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers", new StringBuffer(pattern).append(typeSeparator).append(limit).toString());
        }
        int count = 0;
        Result result = new Result();
        String realm = null;
        String username = null;
        int realmIdx = 0;
        if (limit < 0) {
            ArrayList noUsers = new ArrayList(0);
            result.setList(noUsers);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No users searched as the limit is a negative number.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsers", new StringBuffer(pattern).append(typeSeparator).append(limit).toString());
            }
            return result;
        }
        if (limit == 1 && pattern.indexOf("*") < 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "One user is specified. Calling getOneUser instead of getUsers for better performance");
            }
            NTRegistryImpl ntreg = this.getRegistryForRealm(pattern);
            CustomRegistryException caughtException = null;
            realmIdx = pattern.indexOf("\\");
            if (realmIdx > 0) {
                realm = pattern.substring(0, realmIdx);
                username = pattern.substring(realmIdx + 1);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "domain=" + realm + " username=" + username);
                }
            } else {
                username = pattern;
            }
            if (ntreg != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NTRegistry is non-null. reaml=" + ntreg.getRealm());
                }
                try {
                    if (realm != null && ntreg.getRealm().compareToIgnoreCase(realm) == 0 || realm == null) {
                        ArrayList oneUser = ntreg.getOneUser(username);
                        result.setList(oneUser);
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Skip search - input realm:" + realm + " registry's realm:" + ntreg.getRealm());
                    }
                }
                catch (CustomRegistryException rex) {
                    caughtException = rex;
                    Tr.debug(tc, "CustomRegistryException - This exception is expected when no user is found" + rex.getMessage());
                    result.setList(new ArrayList(0));
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "NTRegistry is null - check other registries");
                }
                ArrayList oneUser = new ArrayList(1);
                for (int i = 0; i < this.registries.length; ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Realm=" + this.registries[i].getRealm());
                    }
                    try {
                        if (realm != null && this.registries[i].getRealm().compareToIgnoreCase(realm) == 0 || realm == null) {
                            oneUser = this.registries[i].getOneUser(username);
                            result.setList(oneUser);
                            Tr.debug(tc, "User found in registries[" + i + "]");
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Skip search - input realm:" + realm + " registry's realm:" + this.registries[i].getRealm());
                        continue;
                    }
                    catch (CustomRegistryException rex) {
                        caughtException = rex;
                        Tr.debug(tc, "CustomRegistryException from registry: " + i + ". This exception is expected when no user is found" + rex.getMessage() + " Number of registry is " + this.registries.length);
                    }
                }
                if (result.getList() == null) {
                    Tr.debug(tc, "After going through all registries, no user was found.");
                    result.setList(new ArrayList(0));
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsers", new StringBuffer(pattern).append(typeSeparator).append(limit).toString());
            }
            return result;
        }
        Enumeration e = this.getUsers(pattern);
        if (e == null) {
            ArrayList noUsers = new ArrayList(0);
            result.setList(noUsers);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "No users found.");
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsers", new StringBuffer(pattern).append(typeSeparator).append(limit).toString());
            }
            return result;
        }
        ArrayList users = new ArrayList();
        if (limit != 0) {
            users = new ArrayList(limit);
        }
        while (e.hasMoreElements()) {
            users.add(e.nextElement());
            if (limit == 0 || ++count != limit) continue;
        }
        result.setList(users);
        if (e.hasMoreElements()) {
            result.setHasMore();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers", new StringBuffer(pattern).append(typeSeparator).append(limit).toString());
        }
        return result;
    }

    public Enumeration getUsers(String pattern) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers", pattern);
        }
        try {
            Enumeration[] users = new Enumeration[this.registries.length];
            if (pattern.indexOf("\\") == -1) {
                pattern = "*\\\\" + pattern;
            } else {
                int index = pattern.indexOf("\\");
                StringBuffer sb = new StringBuffer(pattern);
                pattern = sb.insert(index, "\\").toString();
            }
            for (int i = 0; i < this.registries.length; ++i) {
                users[i] = new UserEnumeration(this.registries[i], pattern, true);
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsers");
            }
            return new MultiEnumeration(users);
        }
        catch (RegistryErrorException re2) {
            FFDCFilter.processException((Throwable)re2, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUsers", "554", this);
            Tr.error(tc, "security.registry.getusers.error", new Object[]{pattern, re2});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getUsers");
            }
            throw new CustomRegistryException(re2.getMessage());
        }
    }

    public Enumeration getUsers() throws RegistryErrorException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUsers");
        }
        Enumeration[] users = new Enumeration[this.registries.length];
        for (int i = 0; i < this.registries.length; ++i) {
            users[i] = new UserEnumeration(this.registries[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUsers");
        }
        return new MultiEnumeration(users);
    }

    public String getUserSecurityName(String privilegeAttributeId) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserSecurityName", privilegeAttributeId);
        }
        WSSecurityException caughtException = null;
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                String securityName = this.registries[i].getUserSecurityName(privilegeAttributeId);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUserSecurityName");
                }
                return this.stripRealm(securityName);
            }
            catch (CustomRegistryException cre) {
                caughtException = cre;
                continue;
            }
            catch (EntryNotFoundException ex) {
                caughtException = ex;
            }
        }
        if (caughtException != null) {
            if (caughtException instanceof EntryNotFoundException) {
                FFDCFilter.processException((Throwable)caughtException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUserSecurityName", "706", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUserSecurityName");
                }
                Tr.error(tc, "security.registry.nosecurityname", new Object[]{privilegeAttributeId, caughtException});
                throw (EntryNotFoundException)caughtException;
            }
            if (caughtException instanceof CustomRegistryException) {
                FFDCFilter.processException((Throwable)caughtException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUserSecurityName", "712", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUserSecurityName");
                }
                Tr.error(tc, "security.registry.nosecurityname", new Object[]{privilegeAttributeId, caughtException});
                throw caughtException;
            }
        }
        Tr.error(tc, "security.registry.usersecurityname.notfound", new Object[]{privilegeAttributeId});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserSecurityName");
        }
        throw new EntryNotFoundException("Cannot get security name for user whose uniqueid is " + privilegeAttributeId);
    }

    public String getUserSecurityNameWithRealm(String privilegeAttributeId) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUserSecurityNameWithRealm", privilegeAttributeId);
        }
        WSSecurityException caughtException = null;
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                String securityName = this.registries[i].getUserSecurityName(privilegeAttributeId);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUserSecurityNameWithRealm", securityName);
                }
                return securityName;
            }
            catch (CustomRegistryException cre) {
                caughtException = cre;
                continue;
            }
            catch (EntryNotFoundException ex) {
                caughtException = ex;
            }
        }
        if (caughtException != null) {
            if (caughtException instanceof EntryNotFoundException) {
                FFDCFilter.processException((Throwable)caughtException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUserSecurityName", "751", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUserSecurityNameWithRealm");
                }
                Tr.error(tc, "security.registry.nosecurityname", new Object[]{privilegeAttributeId, caughtException});
                throw (EntryNotFoundException)caughtException;
            }
            if (caughtException instanceof CustomRegistryException) {
                FFDCFilter.processException((Throwable)caughtException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.getUserSecurityName", "757", this);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getUserSecurityNameWithRealm");
                }
                Tr.error(tc, "security.registry.nosecurityname", new Object[]{privilegeAttributeId, caughtException});
                throw caughtException;
            }
        }
        Tr.error(tc, "security.registry.usersecurityname.notfound", new Object[]{privilegeAttributeId});
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUserSecurityNameWithRealm");
        }
        throw new EntryNotFoundException("Cannot get security name for user whose uniqueid is " + privilegeAttributeId);
    }

    public void initialize(Properties props) throws CustomRegistryException {
        block15: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "initialize");
            }
            String useLocalOrDomain = null;
            if (props != null) {
                useLocalOrDomain = props.getProperty("com.ibm.websphere.registry.UseRegistry");
            }
            if (useLocalOrDomain != null && (useLocalOrDomain.equalsIgnoreCase("Domain") || useLocalOrDomain.equalsIgnoreCase("Local"))) {
                this.isLocalOrDomain = true;
                this.registries = new NTRegistryImpl[1];
                this.registries[0] = useLocalOrDomain.equalsIgnoreCase("Local") ? new NTRegistryImpl(true) : new NTRegistryImpl(false);
                this.registries[0].initialize(props);
                this.realm = this.registries[0].getRealm();
                if (tc.isDebugEnabled()) {
                    if (useLocalOrDomain.equalsIgnoreCase("Local")) {
                        if (this.realm == null || this.realm.trim().length() <= 0) {
                            Tr.debug(tc, "Creation of local registry failed");
                        } else {
                            Tr.debug(tc, "Creation of local registry succeeded");
                        }
                    } else if (this.realm == null || this.realm.trim().length() <= 0) {
                        Tr.debug(tc, "Creation of domain registry failed");
                    } else {
                        Tr.debug(tc, "Creation of domain registry succeeded");
                    }
                }
            } else {
                this.registries = new NTRegistryImpl[2];
                this.registries[0] = new NTRegistryImpl(true);
                this.registries[0].initialize(props);
                this.realm = this.registries[0].getRealm();
                try {
                    this.registries[1] = new NTRegistryImpl(false);
                    this.registries[1].initialize(props);
                    this.realm = this.registries[1].getRealm();
                    NTRegistryImpl tReg = this.registries[0];
                    this.registries[0] = this.registries[1];
                    this.registries[1] = tReg;
                }
                catch (CustomRegistryException ex) {
                    NTRegistryImpl[] newRegArray = new NTRegistryImpl[]{this.registries[0]};
                    this.registries = newRegArray;
                    if (!tc.isDebugEnabled()) break block15;
                    Tr.debug(tc, "Creation of domain registry failed, using local registry only");
                }
            }
        }
        if (this.realm == null || this.realm.trim().length() <= 0) {
            Tr.error(tc, "security.registry.nullrealm");
            throw new CustomRegistryException("Cannot get the realm");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initialize", this.realm);
        }
    }

    public boolean isValidGroup(String securityName) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidGroup", securityName);
        }
        boolean validGroup = false;
        NTRegistryImpl ntreg = this.getRegistryForRealm(securityName);
        if (ntreg != null) {
            validGroup = ntreg.isValidGroup(this.stripRealm(securityName));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidGroup", String.valueOf(validGroup));
            }
            return validGroup;
        }
        CustomRegistryException caughtException = null;
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                validGroup = this.registries[i].isValidGroup(securityName);
                if (!validGroup) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isValidGroup", String.valueOf(validGroup));
                }
                return validGroup;
            }
            catch (CustomRegistryException cre) {
                caughtException = cre;
            }
        }
        if (caughtException != null) {
            FFDCFilter.processException((Throwable)caughtException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.isValidGroup", "840", this);
            Tr.error(tc, "security.registry.isvalidgroup.error", new Object[]{securityName, caughtException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidGroup", String.valueOf(validGroup));
            }
            throw caughtException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidGroup", String.valueOf(validGroup));
        }
        return false;
    }

    public boolean isValidUser(String securityName) throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isValidUser", securityName);
        }
        boolean validUser = false;
        NTRegistryImpl ntreg = this.getRegistryForRealm(securityName);
        if (ntreg != null) {
            validUser = ntreg.isValidUser(this.stripRealm(securityName));
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidUser", String.valueOf(validUser));
            }
            return validUser;
        }
        CustomRegistryException caughtException = null;
        for (int i = 0; i < this.registries.length; ++i) {
            try {
                validUser = this.registries[i].isValidUser(securityName);
                if (!validUser) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "isValidUser", String.valueOf(validUser));
                }
                return validUser;
            }
            catch (CustomRegistryException cre) {
                caughtException = cre;
            }
        }
        if (caughtException != null) {
            FFDCFilter.processException((Throwable)caughtException, "com.ibm.ws.security.registry.nt.NTLocalDomainRegistryImpl.isValidUser", "881", this);
            Tr.error(tc, "security.registry.isvaliduser.error", new Object[]{securityName, caughtException});
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "isValidUser", String.valueOf(validUser));
            }
            throw caughtException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isValidUser", String.valueOf(validUser));
        }
        return false;
    }

    private NTRegistryImpl getRegistryForRealm(String userid) throws CustomRegistryException {
        int index = userid.indexOf(92);
        if (index == -1) {
            return null;
        }
        String realm = userid.substring(0, index);
        for (int i = 0; i < this.registries.length; ++i) {
            if (!this.registries[i].getRealm().equalsIgnoreCase(realm)) continue;
            return this.registries[i];
        }
        if (this.isLocalOrDomain) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "The realm: " + realm + " does not match the registries realm: " + this.registries[0].getRealm());
            }
            throw new CustomRegistryException("The realm: " + realm + " does not match the registries realm: " + this.registries[0].getRealm());
        }
        return null;
    }

    private String stripRealm(String userid) {
        int index = userid.indexOf(92);
        if (index == -1) {
            return userid;
        }
        return userid.substring(index + 1);
    }

    protected String getRelativeName(String name) throws CustomRegistryException {
        int realmIdx = name.indexOf(realmSeparator);
        String retVal = name;
        if (realmIdx >= 0) {
            int typeIdx = name.indexOf(typeSeparator);
            String realm = name.substring(typeIdx + 1, realmIdx);
            for (int i = 0; i < this.registries.length; ++i) {
                if (!realm.equals(this.registries[i].getRealm())) continue;
                return name.substring(realmIdx + 1);
            }
            throw new CustomRegistryException();
        }
        return retVal;
    }

    public WSCredential createCredential(String name) throws CustomRegistryException, NotImplementedException, EntryNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createCredential", name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createCredential");
        }
        return null;
    }

    public String getRealm() throws CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getRealm");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getRealm", this.realm);
        }
        return this.realm;
    }

    public String[] getGroupIDsForUser(String securityName) throws EntryNotFoundException, CustomRegistryException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getGroupIDsForUser", securityName);
        }
        NTRegistryImpl ntreg = this.getRegistryForRealm(securityName);
        String[] groups = new String[]{};
        if (ntreg != null) {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getGroupIDsForUser", securityName);
            }
            groups = ntreg.getGroupIDsForUser(this.stripRealm(securityName));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getGroupIDsForUser");
        }
        return groups;
    }

    public List getUniqueGroupIds(String uniqueUserId) throws EntryNotFoundException, CustomRegistryException {
        String name;
        String[] groups;
        ArrayList<String> groupIds = new ArrayList<String>();
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getUniqueGroupIds", uniqueUserId);
        }
        if ((groups = this.getGroupIDsForUser(name = this.getUserSecurityNameWithRealm(uniqueUserId))) != null && groups.length > 0) {
            for (int i = 0; i < groups.length; ++i) {
                groupIds.add(groups[i]);
            }
        } else {
            groupIds = new ArrayList(0);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getUniqueGroupIds", String.valueOf(groupIds.size()));
        }
        return groupIds;
    }

    public ArrayList getOneUser(String securityName) throws CustomRegistryException, RemoteException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getOneUser", securityName);
        }
        NTRegistryImpl ntreg = this.getRegistryForRealm(securityName);
        ArrayList oneUserList = new ArrayList(1);
        if (ntreg != null) {
            oneUserList = ntreg.getOneUser(securityName);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getOneUser");
        }
        return oneUserList;
    }
}

